/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.TypecastFont;
import jogamp.graph.font.typecast.ot.table.KernSubtable;
import jogamp.graph.font.typecast.ot.table.KerningPair;
import jogamp.graph.font.typecast.ot.table.PostTable;

public final class TypecastGlyph
implements Font.Glyph {
    public static final short INVALID_ID = -1;
    public static final short MAX_ID = -2;
    private final int id;
    private final String name;
    private final boolean isWhiteSpace;
    private final TypecastFont font;
    private final AABBox bbox;
    private final int advance;
    private final int leftSideBearings;
    private final int[][] kerning;
    private final boolean kerning_horizontal;
    private final boolean kerning_crossstream;
    private final OutlineShape shape;

    private static int[][] growPairArray(int[][] nArray) {
        int n = nArray.length;
        int n2 = n * 2;
        int[][] nArray2 = new int[n2][2];
        for (int i = 0; i < n; ++i) {
            nArray2[i][0] = nArray[i][0];
            nArray2[i][1] = nArray[i][1];
        }
        return nArray2;
    }

    private static int[][] trimPairArray(int[][] nArray, int n) {
        int n2 = nArray.length;
        if (n >= n2) {
            return nArray;
        }
        int[][] nArray2 = new int[n][2];
        for (int i = 0; i < n; ++i) {
            nArray2[i][0] = nArray[i][0];
            nArray2[i][1] = nArray[i][1];
        }
        return nArray2;
    }

    protected TypecastGlyph(TypecastFont typecastFont, int n, String string, AABBox aABBox, int n2, int n3, KernSubtable kernSubtable, OutlineShape outlineShape, boolean bl) {
        this.id = n;
        this.name = string;
        this.isWhiteSpace = bl;
        this.font = typecastFont;
        this.bbox = aABBox;
        this.advance = n2;
        this.leftSideBearings = n3;
        if (null != kernSubtable && kernSubtable.areKerningValues()) {
            int n4 = 64;
            int n5 = 0;
            int[][] nArray = new int[n4][2];
            for (int i = 0; i < kernSubtable.getKerningPairCount(); ++i) {
                KerningPair kerningPair = kernSubtable.getKerningPair(i);
                if (kerningPair.getLeft() == n) {
                    if (n5 == n4) {
                        nArray = TypecastGlyph.growPairArray(nArray);
                        n4 = nArray.length;
                    }
                    nArray[n5][0] = kerningPair.getRight();
                    nArray[n5][1] = kerningPair.getValue();
                    ++n5;
                    continue;
                }
                if (kerningPair.getLeft() > n) break;
            }
            this.kerning = TypecastGlyph.trimPairArray(nArray, n5);
            this.kerning_horizontal = kernSubtable.isHorizontal();
            this.kerning_crossstream = kernSubtable.isCrossstream();
        } else {
            this.kerning = new int[0][0];
            this.kerning_horizontal = true;
            this.kerning_crossstream = true;
        }
        this.shape = outlineShape;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public final int getID() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isWhiteSpace() {
        return this.isWhiteSpace;
    }

    @Override
    public final boolean isUndefined() {
        return this.name == ".notdef";
    }

    @Override
    public final AABBox getBoundsFU() {
        return this.bbox;
    }

    @Override
    public final AABBox getBoundsFU(AABBox aABBox) {
        return aABBox.copy(this.bbox);
    }

    @Override
    public final AABBox getBounds(AABBox aABBox) {
        return aABBox.copy(this.bbox).scale2(1.0f / (float)this.font.getMetrics().getUnitsPerEM());
    }

    @Override
    public final AABBox getBounds() {
        AABBox aABBox = new AABBox(this.bbox);
        return aABBox.scale2(1.0f / (float)this.font.getMetrics().getUnitsPerEM());
    }

    @Override
    public final int getAdvanceFU() {
        return this.advance;
    }

    @Override
    public float getAdvance() {
        return this.font.getMetrics().getScale(this.advance);
    }

    @Override
    public final int getLeftSideBearingsFU() {
        return this.leftSideBearings;
    }

    @Override
    public final float getLeftSideBearings() {
        return this.font.getMetrics().getScale(this.leftSideBearings);
    }

    @Override
    public final boolean isKerningHorizontal() {
        return this.kerning_horizontal;
    }

    @Override
    public final boolean isKerningCrossstream() {
        return this.kerning_crossstream;
    }

    @Override
    public final int getKerningPairCount() {
        return this.kerning.length;
    }

    @Override
    public final int getKerningFU(int n) {
        int n2 = 0;
        int n3 = this.kerning.length - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.kerning[n4][0];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return this.kerning[n4][1];
        }
        return 0;
    }

    @Override
    public final float getKerning(int n) {
        return this.font.getMetrics().getScale(this.getKerningFU(n));
    }

    @Override
    public final OutlineShape getShape() {
        return this.shape;
    }

    @Override
    public final int hashCode() {
        int n = 31 + this.font.getName(3).hashCode();
        return (n << 5) - n + this.id;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TypecastGlyph) {
            TypecastGlyph typecastGlyph = (TypecastGlyph)object;
            return typecastGlyph.font.getName(3).equals(this.font.getName(3)) && typecastGlyph.id == this.id;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.isWhiteSpace() ? ", ws" : "";
        stringBuilder.append("Glyph[id ").append(this.id).append(" '").append(this.name).append("'").append(string).append(", advance ").append(this.getAdvanceFU()).append(", leftSideBearings ").append(this.getLeftSideBearingsFU()).append(", kerning[size ").append(this.kerning.length).append(", horiz ").append(this.isKerningHorizontal()).append(", cross ").append(this.isKerningCrossstream()).append("]").append(", shape ").append(null != this.shape).append("]");
        return stringBuilder.toString();
    }

    @Override
    public String fullString() {
        PostTable postTable = this.font.getPostTable();
        String string = null != postTable ? postTable.getGlyphName(this.id) : "n/a";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Glyph id ").append(this.id).append(" '").append(string).append("'").append(", advance ").append(this.getAdvanceFU()).append(", leftSideBearings ").append(this.getLeftSideBearingsFU()).append(", ").append(this.getBoundsFU());
        stringBuilder.append("\n    Kerning: size ").append(this.kerning.length).append(", horiz ").append(this.isKerningHorizontal()).append(", cross ").append(this.isKerningCrossstream());
        int n = this.getID();
        for (int i = 0; i < this.kerning.length; ++i) {
            String string2;
            String string3;
            int n2 = this.kerning[i][0];
            int n3 = this.kerning[i][1];
            if (null == postTable) {
                string3 = String.valueOf(n);
                string2 = String.valueOf(n);
            } else {
                string3 = postTable.getGlyphName(n) + "/" + String.valueOf(n);
                string2 = postTable.getGlyphName(n2) + "/" + String.valueOf(n2);
            }
            stringBuilder.append("\n      kp[").append(i).append("]: ").append(string3).append(" -> ").append(string2).append(" = ").append(n3);
        }
        return stringBuilder.toString();
    }
}

