/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LightRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

class DirectionalLightRetained
extends LightRetained {
    static final int DIRECTION_CHANGED = 128;
    Vector3f direction = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);

    DirectionalLightRetained() {
        this.nodeType = 6;
        this.lightType = 2;
        this.localBounds = new BoundingBox((Bounds)null);
    }

    void initDirection(Vector3f direction) {
        this.direction.set((Tuple3f)direction);
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(Vector3f direction) {
        this.initDirection(direction);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 19;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(128);
        createMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        createMessage.args[3] = this.mirrorLights.clone();
        createMessage.args[4] = new Vector3f(direction);
        VirtualUniverse.mc.processMessage(createMessage);
    }

    void initDirection(float x, float y, float z) {
        this.direction.x = x;
        this.direction.y = y;
        this.direction.z = z;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(float x, float y, float z) {
        this.setDirection(new Vector3f(x, y, z));
    }

    void getDirection(Vector3f direction) {
        direction.set((Tuple3f)this.direction);
        if (this.staticTransform != null) {
            Transform3D invTransform = this.staticTransform.getInvTransform();
            invTransform.transform(direction, direction);
        }
    }

    @Override
    void setLive(SetLiveState s) {
        super.setLive(s);
        J3dMessage createMessage = super.initMessage(8);
        Object[] objs = (Object[])createMessage.args[4];
        objs[7] = new Vector3f(this.direction);
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        DirectionalLightRetained ml;
        int i;
        int component = (Integer)objs[1];
        int numLgts = (Integer)objs[2];
        LightRetained[] mLgts = (LightRetained[])objs[3];
        if ((component & 0x80) != 0) {
            for (i = 0; i < numLgts; ++i) {
                if (mLgts[i].nodeType != 6) continue;
                ml = (DirectionalLightRetained)mLgts[i];
                ml.direction = (Vector3f)objs[4];
                ml.getLastLocalToVworld().transform(ml.direction, ml.xformDirection);
                ml.xformDirection.normalize();
            }
        }
        if ((component & 0x20) != 0) {
            for (i = 0; i < numLgts; ++i) {
                if (mLgts[i].nodeType != 6) continue;
                ml = (DirectionalLightRetained)mLgts[i];
                ml.direction = (Vector3f)((Object[])objs[4])[7];
                ml.getLastLocalToVworld().transform(ml.direction, ml.xformDirection);
                ml.xformDirection.normalize();
            }
        }
        super.updateMirrorObject(objs);
    }

    @Override
    void update(Context ctx, int lightSlot, double scale) {
        Pipeline.getPipeline().updateDirectionalLight(ctx, lightSlot, this.color.x, this.color.y, this.color.z, this.xformDirection.x, this.xformDirection.y, this.xformDirection.z);
    }

    @Override
    protected Object clone() {
        DirectionalLightRetained dr = (DirectionalLightRetained)super.clone();
        dr.direction = new Vector3f(this.direction);
        dr.xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        return dr;
    }

    @Override
    void updateTransformChange() {
        super.updateTransformChange();
        this.getLastLocalToVworld().transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        xform.transform.transform(this.direction, this.direction);
    }
}

