/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.retained;

import java.io.IOException;
import java.io.OutputStream;
import org.jogamp.java3d.utils.scenegraph.io.retained.SGIORuntimeException;

class PositionOutputStream
extends OutputStream {
    private long pos = 0L;
    private OutputStream stream;

    public PositionOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    @Override
    public void write(int p1) throws IOException {
        ++this.pos;
        this.stream.write(p1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.pos += (long)b.length;
        this.stream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.pos += (long)len;
        this.stream.write(b, off, len);
    }

    public void seekForward(long position) throws IOException {
        if (this.pos > position) {
            throw new SGIORuntimeException("Seeking Backward " + this.pos + "  " + position);
        }
        int i = 0;
        while (i < (int)(position - this.pos)) {
            this.stream.write(0);
            ++i;
        }
        this.pos = position;
    }

    public long getFilePointer() {
        return this.pos;
    }
}

