/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry.compression;

import java.util.ArrayList;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.LineStripArray;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.PointArray;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.geometry.compression.CompressedGeometryRetained;
import org.jogamp.java3d.utils.geometry.compression.GeneralizedVertexList;
import org.jogamp.java3d.utils.geometry.compression.GeometryDecompressor;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Vector3f;

class GeometryDecompressorShape3D
extends GeometryDecompressor {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    private static final boolean statistics = false;
    private static final boolean printInfo = false;
    private int bufferDataType;
    private int dataPresent;
    private GeneralizedVertexList vlist;
    private ArrayList shapes;
    private Color4f curColor;
    private Vector3f curNormal;
    private int origVertexCount;
    private int stripCount;
    private int vertexCount;
    private int triangleCount;
    private long startTime;
    private long endTime;
    private int triOutputType;
    private static final int TRI_SET = 0;
    private static final int TRI_STRIP_SET = 1;
    private static final int TRI_STRIP_AND_FAN_SET = 2;
    private static final int TRI_STRIP_AND_TRI_SET = 3;
    private static final int TYPE_POINT = 1;
    private static final int TYPE_LINE = 2;
    private static final int TYPE_TRIANGLE = 4;
    private static final int FRONTFACE_CCW = 1;

    GeometryDecompressorShape3D() {
    }

    Shape3D[] toTriangleArrays(CompressedGeometryRetained cgr) {
        return this.decompress(cgr, 0);
    }

    Shape3D[] toTriangleStripArrays(CompressedGeometryRetained cgr) {
        return this.decompress(cgr, 1);
    }

    Shape3D[] toStripAndFanArrays(CompressedGeometryRetained cgr) {
        return this.decompress(cgr, 2);
    }

    Shape3D[] toStripAndTriangleArrays(CompressedGeometryRetained cgr) {
        return this.decompress(cgr, 3);
    }

    private Shape3D[] decompress(CompressedGeometryRetained cgr, int triOutputType) {
        if (!this.checkVersion(cgr.majorVersionNumber, cgr.minorVersionNumber)) {
            return null;
        }
        this.vlist = null;
        this.curColor = null;
        this.curNormal = null;
        this.bufferDataType = cgr.bufferType;
        this.dataPresent = cgr.bufferContents;
        this.triOutputType = triOutputType;
        this.shapes = new ArrayList();
        super.decompress(cgr.offset, cgr.size, cgr.compressedGeometry);
        this.addShape3D();
        Shape3D[] shapeArray = new Shape3D[this.shapes.size()];
        return this.shapes.toArray(shapeArray);
    }

    @Override
    void outputVertexFormat(boolean bundlingNorm, boolean bundlingColor, boolean doingAlpha) {
        if (this.vlist != null) {
            this.addShape3D();
        }
        int vertexFormat = 1;
        if (bundlingNorm) {
            vertexFormat |= 2;
        }
        if (bundlingColor) {
            vertexFormat = doingAlpha ? (vertexFormat |= 0xC) : (vertexFormat |= 4);
        }
        this.vlist = new GeneralizedVertexList(vertexFormat, 1);
    }

    @Override
    void outputVertex(Point3f position, Vector3f normal, Color4f color, int vertexReplaceCode) {
        if (this.curNormal != null) {
            normal = this.curNormal;
        }
        this.vlist.addVertex(position, normal, color, vertexReplaceCode);
    }

    @Override
    void outputColor(Color4f color) {
        if (this.vlist.size() > 0) {
            this.addShape3D();
            this.vlist = new GeneralizedVertexList(this.vlist.vertexFormat, 1);
        }
        if (this.curColor == null) {
            this.curColor = new Color4f();
        }
        this.curColor.set((Tuple4f)color);
    }

    @Override
    void outputNormal(Vector3f normal) {
        if ((this.vlist.vertexFormat & 2) == 0) {
            if (this.vlist.size() > 0) {
                this.addShape3D();
            }
            this.vlist = new GeneralizedVertexList(this.vlist.vertexFormat | 2, 1);
        }
        if (this.curNormal == null) {
            this.curNormal = new Vector3f();
        }
        this.curNormal.set((Tuple3f)normal);
    }

    private void addShape3D() {
        Material m = new Material();
        if (this.curColor != null) {
            if ((this.vlist.vertexFormat & 0xC) != 12) {
                m.setAmbientColor(this.curColor.x, this.curColor.y, this.curColor.z);
                m.setDiffuseColor(this.curColor.x, this.curColor.y, this.curColor.z);
            } else {
                m.setAmbientColor(this.curColor.x, this.curColor.y, this.curColor.z);
                m.setDiffuseColor(this.curColor.x, this.curColor.y, this.curColor.z, this.curColor.w);
            }
        }
        if ((this.vlist.vertexFormat & 2) == 0) {
            m.setLightingEnable(false);
        } else {
            m.setLightingEnable(true);
        }
        Appearance a = new Appearance();
        a.setMaterial(m);
        block0 : switch (this.bufferDataType) {
            case 4: {
                switch (this.triOutputType) {
                    case 0: {
                        TriangleArray ta = this.vlist.toTriangleArray();
                        if (ta == null) break block0;
                        this.shapes.add(new Shape3D((Geometry)ta, a));
                        break block0;
                    }
                    case 1: {
                        TriangleStripArray tsa = this.vlist.toTriangleStripArray();
                        if (tsa == null) break block0;
                        this.shapes.add(new Shape3D((Geometry)tsa, a));
                        break block0;
                    }
                    case 2: {
                        GeometryStripArray[] gsa = this.vlist.toStripAndFanArrays();
                        if (gsa[0] != null) {
                            this.shapes.add(new Shape3D((Geometry)gsa[0], a));
                        }
                        if (gsa[1] == null) break block0;
                        this.shapes.add(new Shape3D((Geometry)gsa[1], a));
                        break block0;
                    }
                    case 3: {
                        GeometryArray[] ga = this.vlist.toStripAndTriangleArrays();
                        if (ga[0] != null) {
                            this.shapes.add(new Shape3D((Geometry)ga[0], a));
                        }
                        if (ga[1] == null) break block0;
                        this.shapes.add(new Shape3D((Geometry)ga[1], a));
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryDecompressorShape3D0"));
                    }
                }
            }
            case 2: {
                LineStripArray lsa = this.vlist.toLineStripArray();
                if (lsa == null) break;
                this.shapes.add(new Shape3D((Geometry)lsa, a));
                break;
            }
            case 1: {
                PointArray pa = this.vlist.toPointArray();
                if (pa == null) break;
                this.shapes.add(new Shape3D((Geometry)pa, a));
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryDecompressorShape3D1"));
            }
        }
    }

    private void beginPrint() {
        System.out.println("\nGeometryDecompressorShape3D");
        switch (this.bufferDataType) {
            case 4: {
                System.out.println(" buffer TYPE_TRIANGLE");
                break;
            }
            case 2: {
                System.out.println(" buffer TYPE_LINE");
                break;
            }
            case 1: {
                System.out.println(" buffer TYPE_POINT");
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryDecompressorShape3D1"));
            }
        }
        System.out.print(" buffer data present: coords");
        if ((this.dataPresent & 1) != 0) {
            System.out.print(" normals");
        }
        if ((this.dataPresent & 2) != 0) {
            System.out.print(" colors");
        }
        if ((this.dataPresent & 4) != 0) {
            System.out.print(" alpha");
        }
        System.out.println();
        this.stripCount = 0;
        this.vertexCount = 0;
        this.triangleCount = 0;
        this.origVertexCount = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void endPrint() {
        this.endTime = System.currentTimeMillis();
    }

    private void printBench() {
        float t = (float)(this.endTime - this.startTime) / 1000.0f;
        System.out.println(" decompression + strip conversion took " + t + " sec.");
        switch (this.bufferDataType) {
            case 1: {
                System.out.println(" points decompressed: " + this.vertexCount + "\n" + " net decompression rate: " + (float)this.vertexCount / t + " points/sec.\n");
                break;
            }
            case 2: {
                System.out.println(" lines decompressed: " + (this.vertexCount - this.stripCount) + "\n" + " net decompression rate: " + (float)(this.vertexCount - this.stripCount) / t + " lines/sec.\n");
                break;
            }
            case 4: {
                System.out.println(" triangles decompressed: " + (this.vertexCount - 2 * this.stripCount) + "\n" + " net decompression rate: " + (float)(this.vertexCount - 2 * this.stripCount) / t + " triangles/sec.\n");
            }
        }
    }

    private void printStats() {
        boolean color3;
        switch (this.triOutputType) {
            case 0: {
                System.out.println(" using individual triangle output");
                break;
            }
            case 1: {
                System.out.println(" using strip output");
                break;
            }
            case 2: {
                System.out.println(" using strips and fans for output");
                break;
            }
            case 3: {
                System.out.println(" using strips and triangles for output");
            }
        }
        System.out.print(" number of Shape3D objects: " + this.shapes.size() + "\n number of Shape3D decompressed vertices: ");
        if (this.triOutputType == 0 || this.bufferDataType == 1) {
            System.out.println(this.vertexCount);
        } else if (this.triOutputType == 3) {
            System.out.println(String.valueOf(this.vertexCount + this.triangleCount * 3) + "\n number of strips: " + this.stripCount + "\n number of individual triangles: " + this.triangleCount);
            if (this.stripCount > 0) {
                System.out.println(" vertices/strip: " + (float)this.vertexCount / (float)this.stripCount + "\n triangles represented in strips: " + (this.vertexCount - 2 * this.stripCount));
            }
        } else {
            System.out.println(String.valueOf(this.vertexCount) + "\n number of strips: " + this.stripCount);
            if (this.stripCount > 0) {
                System.out.println(" vertices/strip: " + (float)this.vertexCount / (float)this.stripCount);
            }
        }
        System.out.print(" vertex data present in last Shape3D: coords");
        if ((this.vlist.vertexFormat & 2) != 0) {
            System.out.print(" normals");
        }
        boolean color4 = (this.vlist.vertexFormat & 0xC) == 12;
        boolean bl = color3 = !color4 && (this.vlist.vertexFormat & 4) == 4;
        if (color3 || color4) {
            System.out.print(" colors");
            if (color4) {
                System.out.print(" alpha");
            }
        }
        System.out.println();
    }
}

