/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.PointArray;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.loaders.IncorrectFormatException;
import org.jogamp.java3d.loaders.lw3d.LwoParser;
import org.jogamp.java3d.loaders.lw3d.LwoSurface;
import org.jogamp.java3d.loaders.lw3d.LwoTexture;
import org.jogamp.java3d.loaders.lw3d.ShapeHolder;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.java3d.utils.geometry.NormalGenerator;
import org.jogamp.java3d.utils.geometry.Stripifier;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Vector3f;

class J3dLwoParser
extends LwoParser {
    float[] normalCoordsArray;
    int[] normalIndicesArray;
    Shape3D objectShape;
    Color3f color;
    Color3f diffuseColor;
    Color3f specularColor;
    Color3f emissiveColor;
    float shininess;
    Vector objectShapeList = new Vector();

    J3dLwoParser(String fileName, int debugVals) throws FileNotFoundException {
        super(fileName, debugVals);
    }

    J3dLwoParser(URL url, int debugVals) throws FileNotFoundException {
        super(url, debugVals);
    }

    @Override
    void getSurf(int length) throws FileNotFoundException {
        super.getSurf(length);
    }

    void createJava3dGeometry() throws IncorrectFormatException {
        Iterator e = this.shapeList.iterator();
        while (e.hasNext()) {
            ColoringAttributes colorAtt;
            PointArray object;
            int vertexFormat = 1;
            ShapeHolder shape = (ShapeHolder)e.next();
            this.debugOutputLn(8, "about to create Arrays for Shape");
            this.debugOutputLn(2, "shape = " + shape);
            shape.createArrays(true);
            int vertexCount = shape.coordsArray.length / 3;
            int indexCount = 0;
            if (shape.facetIndices != null) {
                indexCount = shape.facetIndices.length;
            }
            this.debugOutputLn(2, "numSurf = " + shape.numSurf);
            String surfName = (String)this.surfNameList.elementAt(shape.numSurf - 1);
            LwoSurface surf = null;
            int surfNum = 0;
            while (surfNum < this.surfaceList.size()) {
                LwoSurface tempSurf = (LwoSurface)this.surfaceList.elementAt(surfNum);
                String tempSurfName = tempSurf.surfName;
                if (surfName.equals(tempSurfName)) {
                    surf = tempSurf;
                    break;
                }
                ++surfNum;
            }
            if (surf == null) {
                throw new IncorrectFormatException("bad surf for surfnum/name = " + shape.numSurf + ", " + surfName);
            }
            this.debugOutputLn(2, "surf = " + surf);
            LwoTexture texture = surf.getTexture();
            Appearance appearance = new Appearance();
            if (shape.facetSizes[0] == 1) {
                object = new PointArray(vertexCount, vertexFormat);
                object.setCoordinates(0, shape.coordsArray);
                colorAtt = new ColoringAttributes(surf.getColor(), 0);
                PointAttributes pointStyle = new PointAttributes();
                pointStyle.setPointSize(1.0f);
                appearance.setColoringAttributes(colorAtt);
                appearance.setPointAttributes(pointStyle);
            } else if (shape.facetSizes[0] == 2) {
                this.debugOutputLn(8, "Creating IndexedLineArray");
                object = new LineArray(vertexCount, vertexFormat);
                object.setCoordinates(0, shape.coordsArray);
                colorAtt = new ColoringAttributes(surf.getColor(), 0);
                appearance.setColoringAttributes(colorAtt);
            } else {
                this.debugOutputLn(8, "Creating IndexedTriFanArray");
                vertexFormat |= 2;
                this.debugOutputLn(8, "about to process vertices/indices, facetIndices = " + shape.facetIndices);
                if (shape.facetIndices != null) {
                    float[] textureCoords = null;
                    int[] textureIndices = null;
                    this.debugOutputLn(8, "setting vertexCount, normind = " + shape.normalIndices);
                    this.debugOutputLn(8, "vtxcount, format, indcount = " + vertexCount + ", " + vertexFormat + ", " + indexCount);
                    if (texture != null) {
                        vertexFormat |= 0x20;
                        textureCoords = new float[vertexCount * 2];
                        textureIndices = new int[shape.facetIndices.length];
                        this.calculateTextureCoords(texture, shape.coordsArray, shape.facetIndices, textureCoords, textureIndices);
                        this.debugOutputLn(8, "textureCoords:");
                        this.debugOutputLn(8, "texture Coords, Indices.length = " + textureCoords.length + ", " + textureIndices.length);
                    }
                    this.debugOutputLn(8, "about to create GeometryInfo");
                    GeometryInfo gi = new GeometryInfo(3);
                    gi.setCoordinates(shape.coordsArray);
                    gi.setCoordinateIndices(shape.facetIndices);
                    gi.setStripCounts(shape.facetSizes);
                    if (texture != null) {
                        gi.setTextureCoordinateParams(1, 2);
                        gi.setTextureCoordinates(0, textureCoords);
                        gi.setTextureCoordinateIndices(0, textureIndices);
                    }
                    gi.recomputeIndices();
                    NormalGenerator ng = new NormalGenerator(surf.getCreaseAngle());
                    ng.generateNormals(gi);
                    Stripifier st = new Stripifier();
                    st.stripify(gi);
                    object = gi.getGeometryArray(true, false, true);
                    this.debugOutputLn(8, "done.");
                } else {
                    this.debugOutputLn(8, "about to create trifanarray with vertexCount, facetSizes.len = " + vertexCount + ", " + shape.facetSizes.length);
                    object = new TriangleFanArray(vertexCount, vertexFormat, shape.facetSizes);
                    object.setCoordinates(0, shape.coordsArray);
                    object.setNormals(0, shape.normalCoords);
                    this.debugOutputLn(2, "passed in normalCoords, length = " + shape.normalCoords.length);
                }
                this.debugOutputLn(8, "created fan array");
                Material material = new Material(surf.getColor(), surf.getEmissiveColor(), surf.getDiffuseColor(), surf.getSpecularColor(), surf.getShininess());
                material.setLightingEnable(true);
                appearance.setMaterial(material);
                if (surf.getTransparency() != 0.0f) {
                    TransparencyAttributes ta = new TransparencyAttributes();
                    ta.setTransparency(surf.getTransparency());
                    ta.setTransparencyMode(2);
                    appearance.setTransparencyAttributes(ta);
                }
                if (texture != null) {
                    this.debugOutputLn(8, "texture != null, enable texturing");
                    Texture tex = texture.getTexture();
                    tex.setEnable(true);
                    appearance.setTexture(tex);
                    TextureAttributes ta = new TextureAttributes();
                    if (texture.getType().equals("DTEX")) {
                        ta.setTextureMode(2);
                    } else if (texture.getType().equals("CTEX")) {
                        ta.setTextureMode(3);
                    }
                    appearance.setTextureAttributes(ta);
                } else {
                    this.debugOutputLn(8, "texture == null, no texture to use");
                }
            }
            this.debugOutputLn(8, "done creating object");
            shape.nullify();
            this.objectShape = new Shape3D((Geometry)object);
            this.objectShape.setAppearance(appearance);
            this.objectShapeList.addElement(this.objectShape);
        }
    }

    void calculateTextureCoords(LwoTexture texture, float[] verts, int[] indices, float[] textureCoords, int[] textureIndices) {
        this.debugOutputLn(1, "calculateTextureCoords()");
        float sx = 0.0f;
        float sz = 0.0f;
        float ty = 0.0f;
        float tz = 0.0f;
        int textureAxis = texture.getTextureAxis();
        Vector3f textureSize = texture.getTextureSize();
        Vector3f textureCenter = texture.getTextureCenter();
        String mappingType = texture.getMappingType();
        if (mappingType.startsWith("Cylindrical")) {
            this.calculateCylindricalTextureCoords(textureAxis, textureSize, textureCenter, textureCoords, textureIndices, verts, indices);
        } else if (mappingType.startsWith("Spherical")) {
            this.calculateSphericalTextureCoords(textureAxis, textureCenter, textureCoords, textureIndices, verts, indices);
        } else if (mappingType.startsWith("Planar")) {
            this.calculatePlanarTextureCoords(textureAxis, textureSize, textureCenter, textureCoords, textureIndices, verts, indices);
        }
    }

    double xyztoh(float x, float y, float z) {
        if ((double)x == 0.0 && (double)z == 0.0) {
            return 0.0;
        }
        if ((double)z == 0.0) {
            return (double)x < 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if ((double)z < 0.0) {
            return -Math.atan(x / z) + Math.PI;
        }
        return -Math.atan(x / z);
    }

    double xyztop(float x, float y, float z) {
        double p = (double)x == 0.0 && (double)z == 0.0 ? ((double)y != 0.0 ? ((double)y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : 0.0) : ((double)(x = (float)Math.sqrt(x * x + z * z)) == 0.0 ? ((double)y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.atan(y / x));
        return p;
    }

    void calculateSphericalTextureCoords(int textureAxis, Vector3f textureCenter, float[] textureCoords, int[] textureIndices, float[] verts, int[] indices) {
        this.debugOutputLn(1, "calculateSphericalTextureCoords");
        int i = 0;
        while (i < indices.length) {
            double t;
            double s;
            float x = verts[3 * indices[i]] - textureCenter.x;
            float y = verts[3 * indices[i] + 1] - textureCenter.y;
            float z = -(verts[3 * indices[i] + 2] + textureCenter.z);
            if (textureAxis == 1) {
                s = this.xyztoh(z, x, -y);
                t = this.xyztop(z, x, -y);
            } else if (textureAxis == 2) {
                s = this.xyztoh(-x, y, z);
                t = this.xyztop(-x, y, z);
            } else {
                s = this.xyztoh(-x, z, -y);
                t = this.xyztop(-x, z, -y);
            }
            s = 1.0 - s / (Math.PI * 2);
            t = -(0.5 - t / Math.PI);
            textureCoords[indices[i] * 2] = (float)s;
            textureCoords[indices[i] * 2 + 1] = (float)t;
            textureIndices[i] = indices[i];
            ++i;
        }
    }

    void calculateCylindricalTextureCoords(int textureAxis, Vector3f textureSize, Vector3f textureCenter, float[] textureCoords, int[] textureIndices, float[] verts, int[] indices) {
        this.debugOutputLn(1, "calculateCylindricalTextureCoords");
        this.debugOutputLn(2, "axis, size, center, tc, ti, v, i = " + textureAxis + ", " + textureSize + ", " + textureCenter + ", " + textureCoords + ", " + textureIndices + ", " + verts + ", " + indices);
        this.debugOutputLn(2, "Cyl Texture Coords:");
        int i = 0;
        while (i < indices.length) {
            double t;
            double s;
            float x = verts[3 * indices[i]] - textureCenter.x;
            float y = verts[3 * indices[i] + 1] - textureCenter.y;
            float z = -(verts[3 * indices[i] + 2] + textureCenter.z);
            if (textureAxis == 1) {
                s = this.xyztoh(z, x, -y);
                t = (double)(x / textureSize.x) + 0.5;
            } else if (textureAxis == 2) {
                s = this.xyztoh(-x, y, z);
                t = (double)(y / textureSize.y) + 0.5;
            } else {
                s = this.xyztoh(-x, z, -y);
                t = (double)(z / textureSize.z) + 0.5;
            }
            s = 1.0 - s / (Math.PI * 2);
            textureCoords[indices[i] * 2] = (float)s;
            textureCoords[indices[i] * 2 + 1] = (float)t;
            textureIndices[i] = indices[i];
            this.debugOutputLn(2, "x, y, z = " + x + ", " + y + ", " + z + "    " + "s, t = " + s + ", " + t);
            ++i;
        }
    }

    void calculatePlanarTextureCoords(int textureAxis, Vector3f textureSize, Vector3f textureCenter, float[] textureCoords, int[] textureIndices, float[] verts, int[] indices) {
        this.debugOutputLn(1, "calculatePlanarTextureCoords");
        this.debugOutputLn(2, "size, center, axis = " + textureSize + textureCenter + ", " + textureAxis);
        float sx = 0.0f;
        float sz = 0.0f;
        float ty = 0.0f;
        float tz = 0.0f;
        if (textureAxis == 1) {
            sz = -1.0f / textureSize.z;
            ty = 1.0f / textureSize.y;
        } else if (textureAxis == 2) {
            sx = 1.0f / textureSize.x;
            tz = -1.0f / textureSize.z;
        } else {
            sx = 1.0f / textureSize.x;
            ty = 1.0f / textureSize.y;
        }
        this.debugOutputLn(2, "Planar Texture Coords:");
        int i = 0;
        while (i < indices.length) {
            float x = verts[3 * indices[i]] - textureCenter.x;
            float y = verts[3 * indices[i] + 1] - textureCenter.y;
            float z = verts[3 * indices[i] + 2] + textureCenter.z;
            double s = (double)(x * sx + z * sz) + 0.5;
            double t = (double)(y * ty + z * tz) + 0.5;
            textureCoords[indices[i] * 2] = (float)s;
            textureCoords[indices[i] * 2 + 1] = (float)t;
            textureIndices[i] = indices[i];
            this.debugOutputLn(2, "x, y, z = " + x + ", " + y + ", " + z + "    " + "s, t = " + s + ", " + t);
            ++i;
        }
    }

    Shape3D getJava3dShape() {
        return this.objectShape;
    }

    Vector getJava3dShapeList() {
        return this.objectShapeList;
    }
}

