/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.errors;

import de.isas.mztab2.model.ValidationMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.utils.MZTabProperties;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorOverflowException;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorType;

public class MZTabErrorList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MZTabErrorList.class);
    private int maxErrorCount;
    private List<MZTabError> errorList;
    private MZTabErrorType.Level level;

    public MZTabErrorList() {
        this(MZTabErrorType.Level.Error);
    }

    public MZTabErrorList(MZTabErrorType.Level level) {
        this(level, MZTabProperties.MAX_ERROR_COUNT);
    }

    public MZTabErrorList(MZTabErrorType.Level level, int maxErrorCount) {
        this.level = level == null ? MZTabErrorType.Level.Error : level;
        this.maxErrorCount = maxErrorCount >= 0 ? maxErrorCount : 0;
        this.errorList = new ArrayList<MZTabError>(this.maxErrorCount);
    }

    public List<MZTabError> getErrorList() {
        return Collections.unmodifiableList(this.errorList);
    }

    public boolean add(MZTabError error) throws MZTabErrorOverflowException {
        if (error == null) {
            throw new NullPointerException("Can not add a null error into list.");
        }
        switch (error.getType().getLevel()) {
            case Info: {
                if (this.level != MZTabErrorType.Level.Warn && this.level != MZTabErrorType.Level.Error) break;
                return false;
            }
            case Warn: {
                if (this.level != MZTabErrorType.Level.Error) break;
                return false;
            }
        }
        if (this.errorList.size() >= this.maxErrorCount) {
            LOGGER.error("Max error count of {} reached!", (Object)this.maxErrorCount);
            LOGGER.error("{}", (Object)this.toString());
            throw new MZTabErrorOverflowException();
        }
        return this.errorList.add(error);
    }

    public boolean addAll(List<MZTabError> errors) throws MZTabErrorOverflowException {
        if (errors == null) {
            throw new NullPointerException("Can not add a null list of errors.");
        }
        return errors.stream().map(t -> this.errorList.add((MZTabError)t)).collect(Collectors.reducing((t, u) -> t != false || u != false)).orElse(Boolean.FALSE);
    }

    public int getMaxErrorCount() {
        return this.maxErrorCount;
    }

    public void setMaxErrorCount(int maxErrorCount) {
        this.maxErrorCount = maxErrorCount >= 0 ? maxErrorCount : 0;
    }

    public MZTabErrorType.Level getLevel() {
        return this.level;
    }

    public void setLevel(MZTabErrorType.Level level) {
        this.level = level;
    }

    public void clear() {
        this.errorList.clear();
    }

    public int size() {
        return this.errorList.size();
    }

    public MZTabError getError(int index) {
        return this.errorList.get(index);
    }

    public boolean isEmpty() {
        return this.errorList.isEmpty();
    }

    public void print(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("Output stream should be set first.");
        }
        for (MZTabError e : this.errorList) {
            out.write(e.toString().getBytes());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MZTabError error : this.errorList) {
            sb.append(error).append("\r\n");
        }
        return sb.toString();
    }

    public static List<ValidationMessage> convertToValidationMessages(MZTabErrorList errorList) throws IllegalStateException {
        ArrayList<ValidationMessage> validationResults = new ArrayList<ValidationMessage>(errorList.size());
        for (MZTabError error : errorList.getErrorList()) {
            ValidationMessage vr = error.toValidationMessage();
            LOGGER.debug(vr.toString());
            validationResults.add(vr);
        }
        return validationResults;
    }

    public List<ValidationMessage> convertToValidationMessages() throws IllegalStateException {
        return MZTabErrorList.convertToValidationMessages(this);
    }
}

