/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorType;

public final class MZTabProperties {
    private static Logger LOGGER = LoggerFactory.getLogger(MZTabProperties.class);
    private static final Properties properties = new Properties();
    public static final String MZTAB_EXCEPTION_MESSAGE = "There exist errors in the metadata section or protein/peptide/small_molecule/small_molecule_feature/small_molecule_evidence header section! Validation will stop, and ignore data table check!\r\n";
    public static final String MZTAB_ERROR_OVERFLOW_EXCEPTION_MESSAGE = "System error queue overflow!\r\n";
    public static final String ENCODE;
    public static final int MAX_ERROR_COUNT;
    public static final MZTabErrorType.Level LEVEL;

    private MZTabProperties() {
    }

    private static void loadProperties(String path) {
        try {
            properties.load(MZTabProperties.class.getResourceAsStream(path));
        }
        catch (IOException e) {
            LOGGER.error("Could not load properties from classpath location: " + path, (Object)e.getMessage());
        }
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    static {
        MZTabProperties.loadProperties("/conf1_1/mztab.properties");
        MZTabProperties.loadProperties("/conf1_1/mztab_format_error.properties");
        MZTabProperties.loadProperties("/conf1_1/mztab_logical_error.properties");
        MZTabProperties.loadProperties("/conf1_1/mztab_crosscheck_error.properties");
        ENCODE = MZTabProperties.getProperty("mztab.encode");
        MAX_ERROR_COUNT = Integer.parseInt(MZTabProperties.getProperty("mztab.max_error_count"));
        LEVEL = MZTabErrorType.findLevel(MZTabProperties.getProperty("mztab.level"));
    }
}

