/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import jlk.GridBagConstraintsD;
import jlk.LicenseHandler;

public class LicenseDialog
extends JDialog {
    boolean oked = true;
    boolean setInitialFocus = true;
    ActionListener escapeListener;
    boolean frameSizeAdjusted = false;
    JPanel bottomPanel = new JPanel();
    JButton okButton = new JButton();
    JButton relicenseButton = new JButton();
    JPanel topPanel = new JPanel();
    JLabel titleLabel = new JLabel();
    JPanel midPanel = new JPanel();
    JPanel midTopPanel = new JPanel();
    JLabel userIDTitle = new JLabel();
    JTextField userIDField = new JTextField();
    JLabel hostIDTitle = new JLabel();
    JTextField hostIDField = new JTextField();
    JLabel ownerTitle = new JLabel();
    JTextField ownerField = new JTextField();
    JLabel typeTitle = new JLabel();
    JTextField typeField = new JTextField();
    JPanel midMidPanel = new JPanel();
    JTextField modulesTitle = new JTextField();
    JScrollPane modulesScrollPane = new JScrollPane();
    JTextArea modulesTextArea = new JTextArea();

    public LicenseDialog(Frame parent) {
        super(parent, true);
        this.setVisible(false);
        this.jbInit();
    }

    private void jbInit() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(400, 360);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.getContentPane().add("South", this.bottomPanel);
        this.okButton.setText("OK");
        this.okButton.setActionCommand("Register Application");
        this.bottomPanel.add((Component)this.okButton, new GridBagConstraintsD(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(16, 16, 16, 16), 0, 0));
        this.relicenseButton.setText("Re-license Application");
        this.relicenseButton.setActionCommand("Cancel");
        this.bottomPanel.add((Component)this.relicenseButton, new GridBagConstraintsD(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(16, 0, 16, 16), 0, 0));
        this.topPanel.setLayout(new GridBagLayout());
        this.getContentPane().add("North", this.topPanel);
        this.titleLabel.setText(" License");
        try {
            this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("appIcon.gif")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.topPanel.add((Component)this.titleLabel, new GridBagConstraintsD(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(16, 16, 8, 16), 0, 0));
        this.titleLabel.setFont(new Font("Dialog", 1, 24));
        this.midPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("Center", this.midPanel);
        this.midTopPanel.setLayout(new GridBagLayout());
        this.midPanel.add("North", this.midTopPanel);
        this.userIDTitle.setHorizontalAlignment(4);
        this.userIDTitle.setText("Serial Number:");
        this.midTopPanel.add((Component)this.userIDTitle, new GridBagConstraintsD(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 16, 0, 8), 8, 0));
        this.userIDField.setRequestFocusEnabled(false);
        this.userIDField.setText("cq0037");
        this.userIDField.setEditable(false);
        this.midTopPanel.add((Component)this.userIDField, new GridBagConstraintsD(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(6, 0, 0, 8), 12, 4));
        this.hostIDTitle.setHorizontalAlignment(4);
        this.hostIDTitle.setText("Host ID:");
        this.midTopPanel.add((Component)this.hostIDTitle, new GridBagConstraintsD(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 16, 0, 8), 12, 0));
        this.hostIDField.setRequestFocusEnabled(false);
        this.hostIDField.setText("PR2315");
        this.hostIDField.setEditable(false);
        this.midTopPanel.add((Component)this.hostIDField, new GridBagConstraintsD(3, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 0, 0, 16), 12, 4));
        this.ownerTitle.setHorizontalAlignment(4);
        this.ownerTitle.setText("License Owner:");
        this.midTopPanel.add((Component)this.ownerTitle, new GridBagConstraintsD(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 16, 0, 8), 8, 0));
        this.ownerField.setRequestFocusEnabled(false);
        this.ownerField.setText("ACME Inc.");
        this.ownerField.setEditable(false);
        this.midTopPanel.add((Component)this.ownerField, new GridBagConstraintsD(1, 1, 3, 1, 1.0, 1.0, 10, 2, new Insets(6, 0, 0, 16), 12, 4));
        this.typeTitle.setHorizontalAlignment(4);
        this.typeTitle.setText("License Type:");
        this.midTopPanel.add((Component)this.typeTitle, new GridBagConstraintsD(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 16, 16, 8), 8, 0));
        this.typeField.setRequestFocusEnabled(false);
        this.typeField.setText("Network License for 5 Users");
        this.typeField.setEditable(false);
        this.midTopPanel.add((Component)this.typeField, new GridBagConstraintsD(1, 2, 3, 1, 1.0, 1.0, 10, 2, new Insets(6, 0, 16, 16), 12, 4));
        this.midMidPanel.setLayout(new GridBagLayout());
        this.midPanel.add("Center", this.midMidPanel);
        this.modulesTitle.setRequestFocusEnabled(false);
        this.modulesTitle.setText(" Module                Licensed   Expires");
        this.modulesTitle.setEditable(false);
        this.midMidPanel.add((Component)this.modulesTitle, new GridBagConstraintsD(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 16, 0, 16), 0, 4));
        this.modulesTitle.setBackground(Color.gray);
        this.modulesTitle.setForeground(Color.white);
        this.modulesTitle.setFont(new Font("MonoSpaced", 0, 12));
        this.modulesScrollPane.setRequestFocusEnabled(false);
        this.modulesScrollPane.setHorizontalScrollBarPolicy(31);
        this.modulesScrollPane.setOpaque(true);
        this.modulesScrollPane.setDoubleBuffered(true);
        this.midMidPanel.add((Component)this.modulesScrollPane, new GridBagConstraintsD(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 16, 0, 16), 0, 0));
        this.modulesTextArea.setRows(6);
        this.modulesTextArea.setRequestFocusEnabled(false);
        this.modulesTextArea.setEditable(false);
        this.modulesScrollPane.getViewport().add(this.modulesTextArea);
        this.modulesTextArea.setFont(new Font("MonoSpaced", 0, 12));
        SymAction lSymAction = new SymAction();
        this.relicenseButton.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        ResourceBundle b = LicenseHandler.getLicenseStrings();
        this.titleLabel.setText(b.getString("LICENSE_TITLE"));
        this.userIDTitle.setText(b.getString("LICENSE_SERIAL"));
        this.hostIDTitle.setText(b.getString("LICENSE_HOST_ID"));
        this.ownerTitle.setText(b.getString("LICENSE_OWNER"));
        this.typeTitle.setText(b.getString("LICENSE_TYPE"));
        this.okButton.setText(b.getString("LICENSE_OK"));
        this.relicenseButton.setText(b.getString("LICENSE_RELICENSE"));
        if (!LicenseHandler.isRegistrationEnabled()) {
            this.relicenseButton.setEnabled(false);
            this.bottomPanel.remove(this.relicenseButton);
        }
    }

    public LicenseDialog() {
        this((Frame)null);
    }

    public void runModal() {
        this.pack();
        Dimension size = this.getSize();
        this.setSize(size.width + 8, size.height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - this.getSize().width) / 2;
        int y = (int)((double)(screenSize.height - this.getSize().height) / 2.5);
        this.setLocation(x, y);
        this.oked = true;
        this.setInitialFocus = true;
        this.setVisible(true);
    }

    protected JRootPane createRootPane() {
        this.escapeListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseDialog.this.setVisible(false);
            }
        };
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(this.escapeListener, KeyStroke.getKeyStroke(27, 0), 2);
        return rootPane;
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
    }

    void relicenseButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.oked = false;
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    public void setUserID(String aString) {
        this.userIDField.setText(aString);
    }

    public void setHostID(String aString) {
        this.hostIDField.setText(aString);
    }

    public void setOwner(String aString) {
        this.ownerField.setText(aString);
    }

    public void setType(String aString) {
        this.typeField.setText(aString);
    }

    public void setModules(String[] moduleArray, String[] licensedArray, String[] expiresArray) {
        int count = moduleArray.length;
        if (count > licensedArray.length) {
            count = licensedArray.length;
        }
        if (count > expiresArray.length) {
            count = expiresArray.length;
        }
        ResourceBundle b = LicenseHandler.getLicenseStrings();
        int pre_module_spaces = 1;
        String module_header = b.getString("COL_MODULE");
        int pre_licensed_spaces = 3;
        String licensed_header = b.getString("COL_MODE");
        int pre_expires_spaces = 3;
        String expires_header = b.getString("COL_EXPDATE");
        int module_width = module_header.length();
        int licensed_width = licensed_header.length();
        int i = 0;
        while (i < count) {
            if (module_width < moduleArray[i].length()) {
                module_width = moduleArray[i].length();
            }
            if (licensed_width < licensedArray[i].length()) {
                licensed_width = licensedArray[i].length();
            }
            ++i;
        }
        String spaces = "                                                                                                        ";
        String string = String.valueOf(spaces.substring(0, pre_module_spaces)) + module_header + spaces.substring(0, module_width - module_header.length()) + spaces.substring(0, pre_licensed_spaces) + licensed_header + spaces.substring(0, licensed_width - licensed_header.length()) + spaces.substring(0, pre_expires_spaces) + expires_header;
        this.modulesTitle.setText(string);
        string = "";
        i = 0;
        while (i < count) {
            string = String.valueOf(string) + spaces.substring(0, pre_module_spaces) + moduleArray[i] + spaces.substring(0, module_width - moduleArray[i].length()) + spaces.substring(0, pre_licensed_spaces) + licensedArray[i] + spaces.substring(0, licensed_width - licensedArray[i].length()) + spaces.substring(0, pre_expires_spaces) + expiresArray[i];
            if (i < count - 1) {
                string = String.valueOf(string) + "\n";
            }
            ++i;
        }
        this.modulesTextArea.setText(string);
    }

    public boolean wasOKed() {
        return this.oked;
    }

    void LicenseDialog_windowOpened(WindowEvent event) {
        this.okButton.requestFocus();
    }

    void LicenseDialog_windowActivated(WindowEvent event) {
        this.okButton.requestFocus();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == LicenseDialog.this.relicenseButton) {
                LicenseDialog.this.relicenseButton_actionPerformed(event);
            } else if (object == LicenseDialog.this.okButton) {
                LicenseDialog.this.okButton_actionPerformed(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowActivated(WindowEvent event) {
            Object object = event.getSource();
            if (object == LicenseDialog.this) {
                LicenseDialog.this.LicenseDialog_windowActivated(event);
            }
        }

        public void windowOpened(WindowEvent event) {
            Object object = event.getSource();
            if (object == LicenseDialog.this) {
                LicenseDialog.this.LicenseDialog_windowOpened(event);
            }
        }
    }
}

