/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.text.DecimalFormat;
import jlk.ExpDate;
import jlk.HostID;
import jlk.LicenseMatrix;

public class LicenseDef {
    private static LicenseMatrix license_array_ = null;
    static final int ML_NO = 0;
    static final int ML_YES = 1;
    static final int ML_FREE = 2;
    static final int ML_DEMO = 3;
    private ExpDate[] ed = new ExpDate[]{new ExpDate(), new ExpDate(), new ExpDate()};
    private ModuleLicense[] ml = new ModuleLicense[]{new ModuleLicense(), new ModuleLicense(), new ModuleLicense(), new ModuleLicense(), new ModuleLicense(), new ModuleLicense()};
    private char[] serial_char = new char[]{'A', 'A'};
    private int serial_number = 1;
    private int version = 0;
    private int aux_A = 0;
    private int aux_B = 0;
    private int aux_C = 0;

    LicenseDef() {
    }

    public void setLicenseArray(LicenseMatrix license_matrix) {
        license_array_ = license_matrix;
    }

    int getMode(int index) {
        return this.ml[index].mode;
    }

    void setMode(int index, int licenseMode) throws NumberFormatException {
        if (licenseMode < 0 || licenseMode > 3) {
            throw new NumberFormatException("illegal license mode");
        }
        this.ml[index].mode = licenseMode;
    }

    int[] getMode() {
        int[] mode = new int[6];
        int i = 0;
        while (i < 6) {
            mode[i] = this.ml[i].mode;
            ++i;
        }
        return mode;
    }

    void setMode(int[] licenseMode) throws NumberFormatException {
        int i = 0;
        while (i < 6) {
            if (i < licenseMode.length) {
                if (licenseMode[i] < 0 || licenseMode[i] > 3) {
                    throw new NumberFormatException("illegal license mode");
                }
                this.ml[i].mode = licenseMode[i];
            } else {
                this.ml[i].mode = 0;
            }
            ++i;
        }
    }

    int getExpDateIndex(int index) {
        return this.ml[index].exp_date_index;
    }

    void setExpDateIndex(int index, int expDateIndex) throws NumberFormatException {
        if (expDateIndex < -1 || expDateIndex > 2) {
            throw new NumberFormatException("illegal exp date index");
        }
        this.ml[index].exp_date_index = expDateIndex;
    }

    int[] getExpDateIndex() {
        int[] exp_date_index = new int[6];
        int i = 0;
        while (i < 6) {
            exp_date_index[i] = this.ml[i].exp_date_index;
            ++i;
        }
        return exp_date_index;
    }

    void setExpDateIndex(int[] expDateIndex) throws NumberFormatException {
        int i = 0;
        while (i < 6) {
            if (i < expDateIndex.length) {
                if (expDateIndex[i] < -1 || expDateIndex[i] > 2) {
                    throw new NumberFormatException("illegal exp date index");
                }
                this.ml[i].exp_date_index = expDateIndex[i];
            } else {
                this.ml[i].exp_date_index = -1;
            }
            ++i;
        }
    }

    ExpDate getExpDate(int index) {
        return new ExpDate(this.ed[index].year(), this.ed[index].month(), this.ed[index].day());
    }

    void setExpDate(int index, ExpDate expDate) {
        this.ed[index] = new ExpDate(expDate.year(), expDate.month(), expDate.day());
    }

    ExpDate[] getExpDate() {
        ExpDate[] reted = new ExpDate[6];
        int i = 0;
        while (i < 6) {
            reted[i] = new ExpDate(this.ed[i].year(), this.ed[i].month(), this.ed[i].day());
            ++i;
        }
        return reted;
    }

    void setExpDate(ExpDate[] expDate) {
        int i = 0;
        while (i < 6) {
            this.ed[i] = i < expDate.length ? new ExpDate(expDate[i].year(), expDate[i].month(), expDate[i].day()) : new ExpDate();
            ++i;
        }
    }

    public void validateUserID(String userID) throws NumberFormatException {
        if (userID == null || userID.length() < 1) {
            throw new NumberFormatException("string is null of lenght < 1");
        }
        if (userID.length() < 3) {
            throw new NumberFormatException("number part is missing");
        }
        char c0 = userID.charAt(0);
        char c1 = userID.charAt(1);
        int n = Integer.parseInt(userID.substring(2));
        if (!(c0 >= 'A' && c0 <= 'Z' || c0 >= 'a' && c0 <= 'z')) {
            throw new NumberFormatException("illegal 1st char");
        }
        if (!(c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z')) {
            throw new NumberFormatException("illegal 2nd char");
        }
        if (n < 1 || n > 9999) {
            throw new NumberFormatException("illegal number part");
        }
    }

    String getUserID() {
        String string = new String(this.serial_char);
        DecimalFormat df = new DecimalFormat("0000");
        string = String.valueOf(string) + df.format(this.serial_number);
        return string;
    }

    void setUserID(String string) throws NumberFormatException {
        this.validateUserID(string);
        char c0 = string.charAt(0);
        char c1 = string.charAt(1);
        int n = Integer.parseInt(string.substring(2));
        this.serial_char[0] = c0;
        this.serial_char[1] = c1;
        this.serial_number = n;
    }

    int getVersion() {
        return this.version;
    }

    void setVersion(int value) throws NumberFormatException {
        if (value < 0 || value > 255) {
            throw new NumberFormatException("illegal version number");
        }
        this.version = value;
    }

    int getMaxUsers() throws NumberFormatException {
        int maxUsers = (this.aux_A & 0x7F) - 13;
        if (maxUsers < 0 || maxUsers > 101) {
            throw new NumberFormatException("illegal maxUsers");
        }
        return maxUsers;
    }

    void setMaxUsers(int maxUsers) throws NumberFormatException {
        if (maxUsers < 0 || maxUsers > 101) {
            throw new NumberFormatException("illegal maxUsers");
        }
        this.aux_A = maxUsers + 13;
        int r = (int)(System.currentTimeMillis() / 1000L);
        this.aux_A += (r & 1) << 7 & 0x80;
    }

    public void validateHostID(String hostID) throws NumberFormatException {
        int aHostID = HostID.decodeHostID(hostID);
        this.validateHostID(aHostID);
    }

    void validateHostID(int aHostID) throws NumberFormatException {
        if (aHostID < 0 || aHostID > 1023) {
            throw new NumberFormatException("illegal HostID");
        }
    }

    int getHostID() throws NumberFormatException {
        int aHostID = this.aux_B + ((this.aux_C & 3) << 8);
        this.validateHostID(aHostID);
        return aHostID;
    }

    void setHostID(int aHostID) throws NumberFormatException {
        this.validateHostID(aHostID);
        this.aux_B = aHostID & 0xFF;
        this.aux_C = aHostID >>> 8 & 3;
        int r = (int)(System.currentTimeMillis() / 1000L);
        this.aux_C += (r & 1) << 2 & 4;
    }

    void decode(String aLicenseString) throws NumberFormatException {
        InternalLicenseDef ild = new InternalLicenseDef(aLicenseString);
        ild.convertToLicenseDef(this);
    }

    static String scrambleLicenseString(String aLicenseString) throws NumberFormatException {
        if (aLicenseString.length() != 39 || aLicenseString.charAt(4) != '-' || aLicenseString.charAt(9) != '-' || aLicenseString.charAt(14) != '-' || aLicenseString.charAt(19) != '-' || aLicenseString.charAt(24) != '-' || aLicenseString.charAt(29) != '-' || aLicenseString.charAt(34) != '-') {
            throw new NumberFormatException("malformed string");
        }
        String string = "";
        int i = 0;
        while (i < 32) {
            int j = license_array_.getHexArray()[31 - i];
            string = String.valueOf(string) + aLicenseString.charAt(j + j / 4);
            if (i == 31) break;
            if (i % 4 == 3) {
                string = String.valueOf(string) + '-';
            }
            ++i;
        }
        return string;
    }

    static String unscrambleLicenseString(String aLicenseString) throws NumberFormatException {
        if (aLicenseString.length() != 39 || aLicenseString.charAt(4) != '-' || aLicenseString.charAt(9) != '-' || aLicenseString.charAt(14) != '-' || aLicenseString.charAt(19) != '-' || aLicenseString.charAt(24) != '-' || aLicenseString.charAt(29) != '-' || aLicenseString.charAt(34) != '-') {
            throw new NumberFormatException("malformed string");
        }
        String string = "";
        int i = 0;
        while (i < 32) {
            int j = 0;
            while (j < 32) {
                if (i == license_array_.getHexArray()[31 - j]) {
                    string = String.valueOf(string) + aLicenseString.charAt(j + j / 4);
                    break;
                }
                ++j;
            }
            if (i == 31) break;
            if (i % 4 == 3) {
                string = String.valueOf(string) + '-';
            }
            ++i;
        }
        return string;
    }

    class InternalLicenseDef {
        InternalExpDate[] ied = new InternalExpDate[]{new InternalExpDate(), new InternalExpDate(), new InternalExpDate()};
        InternalModuleLicense[] iml = new InternalModuleLicense[]{new InternalModuleLicense(), new InternalModuleLicense(), new InternalModuleLicense(), new InternalModuleLicense(), new InternalModuleLicense(), new InternalModuleLicense()};
        int serchar0;
        int serchar1;
        int sernum;
        int version;
        int auxA;
        int auxB;
        int auxC;
        int na;
        int nb;
        int nc;
        transient int[] val = new int[32];

        InternalLicenseDef(LicenseDef ld) {
            int i = 0;
            while (i < 3) {
                if (ld.ed[i].isDefined()) {
                    this.ied[i].day = 31 - (ld.ed[i].day() - 1);
                    this.ied[i].month = ld.ed[i].month() - 1;
                    this.ied[i].year = ld.ed[i].year() - 1999;
                } else {
                    int r = (int)(System.currentTimeMillis() / 1000L);
                    this.ied[i].day = r & 0x1F;
                    this.ied[i].month = 13;
                    this.ied[i].year = ~this.ied[i].day & 0x1F;
                }
                this.ied[i].check = (this.ied[i].day << 1 ^ this.ied[i].year | ~this.ied[i].month) & 0x3F;
                ++i;
            }
            i = 0;
            while (i < 6) {
                this.iml[i].mode = ((LicenseDef)ld).ml[i].mode;
                this.iml[i].index = ((LicenseDef)ld).ml[i].exp_date_index == -1 ? 3 : ((LicenseDef)ld).ml[i].exp_date_index;
                this.iml[i].nm = ~this.iml[i].mode & 3;
                this.iml[i].ni = ~this.iml[i].index & 3;
                this.iml[i].mxi = (this.iml[i].mode ^ this.iml[i].index) & 3;
                ++i;
            }
            this.serchar0 = ld.serial_char[0] >= 'A' && ld.serial_char[0] <= 'Z' ? ld.serial_char[0] - 65 : ld.serial_char[0] - 97 + 38;
            this.serchar1 = ld.serial_char[1] >= 'A' && ld.serial_char[1] <= 'Z' ? ld.serial_char[1] - 65 : ld.serial_char[1] - 97 + 38;
            this.sernum = ld.serial_number;
            this.version = ld.version;
            this.auxA = ld.aux_A;
            this.auxB = ld.aux_B;
            this.auxC = ld.aux_C;
            this.na = ~this.auxA & 0xFF;
            this.nb = ~this.auxB & 0xFF;
            this.nc = ~this.auxC & 7;
        }

        String convertToString() {
            this.val[0] = this.ied[2].check >>> 3 & 7;
            this.val[0] = this.val[0] + ((this.ied[1].check & 7) << 3);
            this.val[1] = this.ied[0].month & 3;
            this.val[1] = this.val[1] + (this.iml[5].mode << 2 & 0xC);
            this.val[1] = this.val[1] + (this.iml[1].nm << 4 & 0x30);
            this.val[2] = this.serchar0 >>> 3 & 7;
            this.val[2] = this.val[2] + ((this.ied[0].year & 7) << 3);
            this.val[3] = (this.version & 0xC) >>> 2;
            this.val[3] = this.val[3] + ((this.iml[0].mode & 3) << 2);
            this.val[3] = this.val[3] + ((this.iml[3].index & 3) << 4);
            this.val[4] = this.iml[2].mode & 3;
            this.val[4] = this.val[4] + ((this.iml[3].ni & 3) << 2);
            this.val[4] = this.val[4] + ((this.ied[0].day & 0x18) << 1);
            this.val[5] = this.sernum & 0xF;
            this.val[5] = this.val[5] + ((this.iml[5].index & 3) << 4);
            this.val[6] = this.iml[4].mode & 3;
            this.val[6] = this.val[6] + (this.ied[1].month & 0xC);
            this.val[6] = this.val[6] + ((this.iml[2].nm & 3) << 4);
            this.val[7] = this.iml[1].ni & 3;
            this.val[7] = this.val[7] + ((this.ied[2].day & 0x18) >>> 1);
            this.val[7] = this.val[7] + (this.version & 0x30);
            this.val[8] = this.ied[1].month & 3;
            this.val[8] = this.val[8] + ((this.iml[5].ni & 3) << 2);
            this.val[8] = this.val[8] + ((this.iml[0].nm & 3) << 4);
            this.val[9] = this.serchar0 & 7;
            this.val[9] = this.val[9] + ((this.ied[2].year & 7) << 3);
            this.val[10] = this.iml[4].ni & 3;
            this.val[10] = this.val[10] + ((this.iml[1].mxi & 3) << 2);
            this.val[10] = this.val[10] + ((this.iml[3].mode & 3) << 4);
            this.val[11] = this.ied[1].year & 7;
            this.val[11] = this.val[11] + ((this.ied[0].day & 7) << 3);
            this.val[12] = this.ied[0].check & 7;
            this.val[12] = this.val[12] + ((this.ied[1].day & 7) << 3);
            this.val[13] = this.iml[1].mode & 3;
            this.val[13] = this.val[13] + ((this.ied[2].year & 0x18) >>> 1);
            this.val[13] = this.val[13] + ((this.iml[4].mxi & 3) << 4);
            this.val[14] = this.iml[3].mxi & 3;
            this.val[14] = this.val[14] + ((this.iml[0].ni & 3) << 2);
            this.val[14] = this.val[14] + ((this.ied[2].month & 3) << 4);
            this.val[15] = this.iml[2].ni & 3;
            this.val[15] = this.val[15] + ((this.version & 3) << 2);
            this.val[15] = this.val[15] + ((this.sernum & 0x300) >>> 4);
            this.val[16] = this.iml[0].mxi & 3;
            this.val[16] = this.val[16] + ((this.ied[1].day & 0x18) >>> 1);
            this.val[16] = this.val[16] + ((this.iml[4].nm & 3) << 4);
            this.val[17] = this.iml[5].nm & 3;
            this.val[17] = this.val[17] + ((this.iml[2].index & 3) << 2);
            this.val[17] = this.val[17] + ((this.ied[0].year & 0x18) << 1);
            this.val[18] = this.iml[0].index & 3;
            this.val[18] = this.val[18] + ((this.iml[5].mxi & 3) << 2);
            this.val[18] = this.val[18] + ((this.ied[0].month & 0xC) << 2);
            this.val[19] = (this.version & 0xC0) >>> 6;
            this.val[19] = this.val[19] + ((this.ied[1].year & 0x18) >>> 1);
            this.val[19] = this.val[19] + ((this.iml[1].index & 3) << 4);
            this.val[20] = this.iml[3].nm & 3;
            this.val[20] = this.val[20] + ((this.sernum & 0xF0) >>> 2);
            this.val[21] = (this.ied[2].month & 0xC) >>> 2;
            this.val[21] = this.val[21] + ((this.iml[4].index & 3) << 2);
            this.val[21] = this.val[21] + ((this.iml[2].mxi & 3) << 4);
            this.val[22] = this.ied[0].check >>> 3 & 7;
            this.val[22] = this.val[22] + ((this.ied[2].day & 7) << 3);
            this.val[23] = this.ied[1].check >>> 3 & 7;
            this.val[23] = this.val[23] + ((this.ied[2].check & 7) << 3);
            this.val[24] = (this.auxB & 0xC0) >>> 6;
            this.val[24] = this.val[24] + ((this.auxA & 0xF0) >>> 2);
            this.val[25] = this.nc & 7;
            this.val[25] = this.val[25] + ((this.serchar1 & 7) << 3);
            this.val[26] = this.auxA & 3;
            this.val[26] = this.val[26] + ((this.nb & 0xF) << 2);
            this.val[27] = this.serchar1 >>> 3 & 7;
            this.val[27] = this.val[27] + ((this.auxC & 7) << 3);
            this.val[28] = (this.na & 0x3C) >>> 2;
            this.val[28] = this.val[28] + (this.auxB & 0x30);
            this.val[29] = this.sernum >>> 10 & 0xF;
            this.val[29] = this.val[29] + ((this.na & 0xC0) >>> 2);
            this.val[30] = this.na & 3;
            this.val[30] = this.val[30] + ((this.auxB & 0xF) << 2);
            this.val[31] = (this.auxA & 0xC) >>> 2;
            this.val[31] = this.val[31] + ((this.nb & 0xF0) >>> 2);
            String string = "";
            int i = 0;
            while (i < 32) {
                String perm = license_array_.getPermArray()[i];
                string = String.valueOf(string) + perm.charAt(((this.val[license_array_.getHexArray()[i]] & 0x3F) + license_array_.getRollPermArray()) % 64);
                if (i == 31) break;
                if (i % 4 == 3) {
                    string = String.valueOf(string) + '-';
                }
                ++i;
            }
            return string;
        }

        int LOW3(int i) {
            return this.val[i] & 7;
        }

        int HIGH3(int i) {
            return (this.val[i] & 0x38) >>> 3 & 7;
        }

        int LOW2(int i) {
            return this.val[i] & 3;
        }

        int MID2(int i) {
            return (this.val[i] & 0xC) >>> 2 & 3;
        }

        int HIGH2(int i) {
            return (this.val[i] & 0x30) >>> 4 & 3;
        }

        int LOW4(int i) {
            return this.val[i] & 0xF;
        }

        int MIDHIGH4(int i) {
            return (this.val[i] & 0x3C) >>> 2 & 0xF;
        }

        InternalLicenseDef(String aLicenseString) throws NumberFormatException {
            String perm;
            int sum = 0;
            int i = 0;
            while (i < 32) {
                perm = license_array_.getPermArray()[i];
                int j = 0;
                while (j < 64) {
                    sum += perm.charAt(j);
                    ++j;
                }
                ++i;
            }
            if (sum != license_array_.getPermArrayChecksum()) {
                throw new NumberFormatException("checksum error");
            }
            if (aLicenseString == null) {
                throw new NumberFormatException("invalid string");
            }
            if (aLicenseString.length() != 39 || aLicenseString.charAt(4) != '-' || aLicenseString.charAt(9) != '-' || aLicenseString.charAt(14) != '-' || aLicenseString.charAt(19) != '-' || aLicenseString.charAt(24) != '-' || aLicenseString.charAt(29) != '-' || aLicenseString.charAt(34) != '-') {
                throw new NumberFormatException("malformed string");
            }
            int si = 0;
            i = 0;
            while (i < 32) {
                int pi;
                perm = license_array_.getPermArray()[i];
                char sc = aLicenseString.charAt(si);
                if (sc == '-') {
                    sc = aLicenseString.charAt(++si);
                }
                if ((pi = perm.indexOf(sc)) == -1) {
                    throw new NumberFormatException("invalid string");
                }
                this.val[license_array_.getHexArray()[i]] = (pi - license_array_.getRollPermArray()) % 64;
                ++i;
                ++si;
            }
            this.ied[0].day = this.HIGH3(11) + (this.HIGH2(4) << 3);
            this.ied[0].month = this.LOW2(1) + (this.HIGH2(18) << 2);
            this.ied[0].year = this.HIGH3(2) + (this.HIGH2(17) << 3);
            this.ied[0].check = this.LOW3(12) + (this.LOW3(22) << 3);
            this.ied[1].day = this.HIGH3(12) + (this.MID2(16) << 3);
            this.ied[1].month = this.LOW2(8) + (this.MID2(6) << 2);
            this.ied[1].year = this.LOW3(11) + (this.MID2(19) << 3);
            this.ied[1].check = this.HIGH3(0) + (this.LOW3(23) << 3);
            this.ied[2].day = this.HIGH3(22) + (this.MID2(7) << 3);
            this.ied[2].month = this.HIGH2(14) + (this.LOW2(21) << 2);
            this.ied[2].year = this.HIGH3(9) + (this.MID2(13) << 3);
            this.ied[2].check = this.HIGH3(23) + (this.LOW3(0) << 3);
            this.iml[0].mode = this.MID2(3);
            this.iml[0].index = this.LOW2(18);
            this.iml[0].nm = this.HIGH2(8);
            this.iml[0].ni = this.MID2(14);
            this.iml[0].mxi = this.LOW2(16);
            this.iml[1].mode = this.LOW2(13);
            this.iml[1].index = this.HIGH2(19);
            this.iml[1].nm = this.HIGH2(1);
            this.iml[1].ni = this.LOW2(7);
            this.iml[1].mxi = this.MID2(10);
            this.iml[2].mode = this.LOW2(4);
            this.iml[2].index = this.MID2(17);
            this.iml[2].nm = this.HIGH2(6);
            this.iml[2].ni = this.LOW2(15);
            this.iml[2].mxi = this.HIGH2(21);
            this.iml[3].mode = this.HIGH2(10);
            this.iml[3].index = this.HIGH2(3);
            this.iml[3].nm = this.LOW2(20);
            this.iml[3].ni = this.MID2(4);
            this.iml[3].mxi = this.LOW2(14);
            this.iml[4].mode = this.LOW2(6);
            this.iml[4].index = this.MID2(21);
            this.iml[4].nm = this.HIGH2(16);
            this.iml[4].ni = this.LOW2(10);
            this.iml[4].mxi = this.HIGH2(13);
            this.iml[5].mode = this.MID2(1);
            this.iml[5].index = this.HIGH2(5);
            this.iml[5].nm = this.LOW2(17);
            this.iml[5].ni = this.MID2(8);
            this.iml[5].mxi = this.MID2(18);
            this.serchar0 = this.LOW3(9) + (this.LOW3(2) << 3);
            this.serchar1 = this.HIGH3(25) + (this.LOW3(27) << 3);
            this.sernum = this.LOW4(5) + (this.MIDHIGH4(20) << 4) + (this.HIGH2(15) << 8);
            this.sernum += this.LOW4(29) << 10;
            this.version = this.MID2(15) + (this.LOW2(3) << 2) + (this.HIGH2(7) << 4) + (this.LOW2(19) << 6);
            this.auxA = this.LOW2(26) + (this.LOW2(31) << 2) + (this.MIDHIGH4(24) << 4);
            this.auxB = this.MIDHIGH4(30) + (this.HIGH2(28) << 4) + (this.LOW2(24) << 6);
            this.auxC = this.HIGH3(27);
            this.na = this.LOW2(30) + (this.LOW4(28) << 2) + (this.HIGH2(29) << 6);
            this.nb = this.MIDHIGH4(26) + (this.MIDHIGH4(31) << 4);
            this.nc = this.LOW3(25);
            boolean error = false;
            i = 0;
            while (i < 3) {
                if (this.ied[i].month == 13) {
                    if (this.ied[i].year != (~this.ied[i].day & 0x1F)) {
                        error = true;
                        break;
                    }
                } else {
                    if (this.ied[i].day == 0) {
                        error = true;
                        break;
                    }
                    if (this.ied[i].month > 11) {
                        error = true;
                        break;
                    }
                }
                if (this.ied[i].check != ((this.ied[i].day << 1 ^ this.ied[i].year | ~this.ied[i].month) & 0x3F)) {
                    error = true;
                    break;
                }
                ++i;
            }
            if (error) {
                throw new NumberFormatException("invalid exp date");
            }
            i = 0;
            while (i < 6) {
                if (this.iml[i].nm != (~this.iml[i].mode & 3)) {
                    error = true;
                    break;
                }
                if (this.iml[i].ni != (~this.iml[i].index & 3)) {
                    error = true;
                    break;
                }
                if (this.iml[i].mxi != ((this.iml[i].mode ^ this.iml[i].index) & 3)) {
                    error = true;
                    break;
                }
                ++i;
            }
            if (error) {
                throw new NumberFormatException("invalid module license");
            }
            if (this.serchar0 > 25 && this.serchar0 < 38) {
                error = true;
            } else if (this.serchar1 > 25 && this.serchar1 < 38) {
                error = true;
            } else if (this.sernum < 1 || this.sernum > 9999) {
                error = true;
            }
            if (error) {
                throw new NumberFormatException("invalid serial number");
            }
            if (this.na != (~this.auxA & 0xFF)) {
                error = true;
            } else if (this.nb != (~this.auxB & 0xFF)) {
                error = true;
            } else if (this.nc != (~this.auxC & 7)) {
                error = true;
            }
            if (error) {
                throw new NumberFormatException("invalid aux values");
            }
        }

        void convertToLicenseDef(LicenseDef ld) {
            int i = 0;
            while (i < 3) {
                ((LicenseDef)ld).ed[i] = this.ied[i].month == 13 ? new ExpDate() : new ExpDate(this.ied[i].year + 1999, this.ied[i].month + 1, 31 - this.ied[i].day + 1);
                ++i;
            }
            i = 0;
            while (i < 6) {
                ((LicenseDef)ld).ml[i].mode = this.iml[i].mode;
                ((LicenseDef)ld).ml[i].exp_date_index = this.iml[i].index == 3 ? -1 : this.iml[i].index;
                ++i;
            }
            ((LicenseDef)ld).serial_char[0] = this.serchar0 <= 25 ? (char)(this.serchar0 + 65) : (char)(this.serchar0 - 38 + 97);
            ((LicenseDef)ld).serial_char[1] = this.serchar1 <= 25 ? (char)(this.serchar1 + 65) : (char)(this.serchar1 - 38 + 97);
            ld.serial_number = this.sernum;
            ld.version = this.version;
            ld.aux_A = this.auxA;
            ld.aux_B = this.auxB;
            ld.aux_C = this.auxC;
        }

        class InternalExpDate {
            int day;
            int month;
            int year;
            int check;

            InternalExpDate() {
            }
        }

        class InternalModuleLicense {
            int mode;
            int index;
            int nm;
            int ni;
            int mxi;

            InternalModuleLicense() {
            }
        }
    }

    class ModuleLicense {
        int mode = 0;
        int exp_date_index = -1;

        ModuleLicense() {
        }
    }
}

