/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import jlk.AlertDialog;
import jlk.FloatingLicenseAddHostDelegate;
import jlk.GridBagConstraintsD;
import jlk.LicenseHandler;
import jlk.LicenseHandlerExitDelegate;

public class FloatingDialog
extends JDialog
implements FloatingLicenseAddHostDelegate {
    JPanel topPanel;
    JLabel titleLabel;
    JPanel midPanel;
    JScrollPane hostsScrollPane;
    JTextArea hostsTextArea;
    JPanel bottomPanel;
    JTextArea msgTextArea;
    JButton demoButton;
    JButton quitButton;
    EmptyBorder msgBorder;
    Frame parent;
    boolean cancelled = true;
    boolean setInitialFocus = false;
    boolean firstHostname = true;
    boolean showDemoButton = false;
    ActionListener escapeListener;
    boolean frameSizeAdjusted = false;

    public FloatingDialog() {
        this((Frame)null, false);
    }

    public FloatingDialog(Frame aFrame, boolean modal) {
        super(aFrame, modal);
        this.parent = aFrame;
        this.topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.midPanel = new JPanel();
        this.hostsScrollPane = new JScrollPane();
        this.hostsTextArea = new JTextArea();
        this.bottomPanel = new JPanel();
        this.msgTextArea = new JTextArea();
        this.demoButton = new JButton();
        this.quitButton = new JButton();
        this.msgBorder = new EmptyBorder(0, 0, 0, 0);
        this.setVisible(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(400, modal ? 230 : 160);
        this.topPanel.setLayout(new GridBagLayout());
        this.getContentPane().add("North", this.topPanel);
        this.titleLabel.setText(" Checking Network...");
        try {
            this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("appIcon.gif")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.topPanel.add((Component)this.titleLabel, new GridBagConstraintsD(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(16, 16, 8, 16), 0, 0));
        this.titleLabel.setFont(new Font("Dialog", 1, 24));
        this.midPanel.setLayout(new GridBagLayout());
        this.getContentPane().add("Center", this.midPanel);
        this.hostsScrollPane.setHorizontalScrollBarPolicy(31);
        this.hostsScrollPane.setVerticalScrollBarPolicy(22);
        this.hostsScrollPane.setOpaque(true);
        this.midPanel.add((Component)this.hostsScrollPane, new GridBagConstraintsD(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 16, 16, 16), 0, 32));
        this.hostsTextArea.setLineWrap(true);
        this.hostsTextArea.setWrapStyleWord(true);
        this.hostsTextArea.setEditable(false);
        this.hostsScrollPane.getViewport().add(this.hostsTextArea);
        this.hostsTextArea.setFont(new Font("SansSerif", 3, 12));
        if (modal) {
            this.showDemoButton = LicenseHandler.isDemoModeEnabled();
            this.bottomPanel.setLayout(new GridBagLayout());
            this.getContentPane().add("South", this.bottomPanel);
            this.msgTextArea.setRows(2);
            this.msgTextArea.setText("All 5 available licenses are currently being used on the hosts listed above. Please try again later.");
            this.msgTextArea.setLineWrap(true);
            this.msgTextArea.setWrapStyleWord(true);
            this.msgTextArea.setOpaque(false);
            this.msgTextArea.setBorder(this.msgBorder);
            this.msgTextArea.setEditable(false);
            this.bottomPanel.add((Component)this.msgTextArea, new GridBagConstraintsD(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 20, 0, 12), 0, 12));
            this.msgTextArea.setFont(new Font("SansSerif", 1, 12));
            if (this.showDemoButton) {
                this.demoButton.setText("Demo");
                this.demoButton.setActionCommand("Demo");
                this.bottomPanel.add((Component)this.demoButton, new GridBagConstraintsD(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(8, 0, 8, 2), 12, 0));
                this.quitButton.setText("Quit");
                this.quitButton.setActionCommand("Quit");
                this.bottomPanel.add((Component)this.quitButton, new GridBagConstraintsD(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 2, 8, 0), 12, 0));
            } else {
                this.quitButton.setText("Quit");
                this.quitButton.setActionCommand("Quit");
                this.bottomPanel.add((Component)this.quitButton, new GridBagConstraintsD(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(8, 2, 8, 0), 12, 0));
            }
        }
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        if (modal) {
            SymAction lSymAction = new SymAction();
            if (this.showDemoButton) {
                this.demoButton.addActionListener(lSymAction);
            }
            this.quitButton.addActionListener(lSymAction);
            SymFocus aSymFocus = new SymFocus();
            this.hostsTextArea.addFocusListener(aSymFocus);
        }
        ResourceBundle b = LicenseHandler.getLicenseStrings();
        this.titleLabel.setText(b.getString("NETWORK_TITLE"));
        if (modal) {
            if (this.showDemoButton) {
                this.demoButton.setText(b.getString("NETWORK_DEMO"));
            }
            this.quitButton.setText(b.getString("NETWORK_QUIT"));
        }
    }

    public void runNonModal() {
        this.pack();
        Dimension size = this.getSize();
        if (size.width < 400) {
            size.width = 400;
            this.setSize(400, size.height);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - size.width) / 2;
        int y = (screenSize.height - size.height) / 3;
        this.setLocation(x, y);
        this.firstHostname = true;
        this.hostsTextArea.setText("");
        this.setVisible(true);
    }

    private void interruptNonModal() {
        ResourceBundle b = LicenseHandler.getLicenseStrings();
        String[] options = new String[]{b.getString("NETWORK_NM_QUIT"), b.getString("NETWORK_NM_CONTINUE")};
        if (AlertDialog.runModalDialog(null, LicenseHandler.getAppName(), b.getString("NETWORK_NM_MSG"), 2, options) == 0) {
            try {
                LicenseHandlerExitDelegate ed = LicenseHandler.getExitDelegate();
                if (ed != null) {
                    ed.exitApplication();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    public void addHost(String aHostname) {
        if (this.firstHostname) {
            this.firstHostname = false;
        } else {
            this.hostsTextArea.append(" ...");
        }
        this.hostsTextArea.append(aHostname);
        this.show();
    }

    public void runModal(String msgText) {
        FloatingDialog mfd = new FloatingDialog(this.parent, true);
        mfd.setTitle(this.getTitle());
        mfd.setLocation(this.getLocation());
        mfd.cancelled = true;
        this.cancelled = true;
        mfd.msgTextArea.setText(msgText);
        mfd.pack();
        Dimension size = mfd.getSize();
        if (size.width < 400) {
            size.width = 400;
            mfd.setSize(400, size.height);
        }
        mfd.hostsTextArea.append(this.hostsTextArea.getText());
        mfd.setInitialFocus = true;
        this.setVisible(false);
        Toolkit.getDefaultToolkit().beep();
        mfd.setVisible(true);
        this.cancelled = mfd.cancelled;
        mfd.setVisible(false);
        mfd.dispose();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    protected JRootPane createRootPane() {
        this.escapeListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FloatingDialog.this.isModal()) {
                    FloatingDialog.this.setVisible(false);
                } else {
                    FloatingDialog.this.interruptNonModal();
                }
            }
        };
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(this.escapeListener, KeyStroke.getKeyStroke(27, 0), 2);
        return rootPane;
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
    }

    void demoButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.cancelled = false;
    }

    void quitButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
    }

    void FloatingDialog_windowOpened(WindowEvent event) {
        if (this.setInitialFocus) {
            if (this.showDemoButton) {
                this.demoButton.requestFocus();
            } else {
                this.quitButton.requestFocus();
            }
            this.setInitialFocus = false;
        }
    }

    void FloatingDialog_windowActivated(WindowEvent event) {
        if (this.setInitialFocus) {
            if (this.showDemoButton) {
                this.demoButton.requestFocus();
            } else {
                this.quitButton.requestFocus();
            }
            this.setInitialFocus = false;
        }
    }

    void FloatingDialog_windowClosing(WindowEvent event) {
        if (this.isModal()) {
            this.setVisible(false);
        } else {
            this.interruptNonModal();
        }
    }

    void hostsTextArea_FocusGained(FocusEvent event) {
        if (this.showDemoButton) {
            this.demoButton.requestFocus();
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == FloatingDialog.this.demoButton) {
                FloatingDialog.this.demoButton_actionPerformed(event);
            } else if (object == FloatingDialog.this.quitButton) {
                FloatingDialog.this.quitButton_actionPerformed(event);
            }
        }
    }

    class SymFocus
    extends FocusAdapter {
        SymFocus() {
        }

        public void focusGained(FocusEvent event) {
            Object object = event.getSource();
            if (object == FloatingDialog.this.hostsTextArea) {
                FloatingDialog.this.hostsTextArea_FocusGained(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == FloatingDialog.this) {
                FloatingDialog.this.FloatingDialog_windowClosing(event);
            }
        }

        public void windowActivated(WindowEvent event) {
            Object object = event.getSource();
            if (object == FloatingDialog.this) {
                FloatingDialog.this.FloatingDialog_windowActivated(event);
            }
        }

        public void windowOpened(WindowEvent event) {
            Object object = event.getSource();
            if (object == FloatingDialog.this) {
                FloatingDialog.this.FloatingDialog_windowOpened(event);
            }
        }
    }
}

