/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class ExpDate {
    public static final int BASE_YEAR = 1999;
    private int day;
    private int month;
    private int year;

    public ExpDate() {
    }

    public ExpDate(int aYear, int aMonth, int aDay) throws NumberFormatException {
        this();
        if (aYear == 0 && aMonth == 0 && aDay == 0) {
            return;
        }
        this.setValues(aYear, aMonth, aDay);
    }

    public ExpDate(String yearMonthDayString) throws NumberFormatException {
        this();
        if (yearMonthDayString.equals("-")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(yearMonthDayString);
        this.setValues(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
    }

    private void setValues(int aYear, int aMonth, int aDay) throws NumberFormatException {
        if (aYear < 1999 || aYear > 2030) {
            throw new NumberFormatException("illegal year");
        }
        if (aMonth < 1 || aMonth > 12) {
            throw new NumberFormatException("illegal month");
        }
        if (aDay < 1 || aDay > 31) {
            throw new NumberFormatException("illegal day");
        }
        this.year = aYear;
        this.month = aMonth;
        this.day = aDay;
    }

    public String toString() {
        if (this.isDefined()) {
            DecimalFormat df = new DecimalFormat("0");
            DecimalFormat df2 = new DecimalFormat("00");
            return String.valueOf(df.format(this.year)) + " " + df2.format(this.month) + " " + df2.format(this.day);
        }
        return "-";
    }

    public boolean isDefined() {
        return this.day != 0 && this.month != 0 && this.year != 0;
    }

    public int year() {
        return this.year;
    }

    public int month() {
        return this.month;
    }

    public int day() {
        return this.day;
    }
}

