/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import uk.ac.ebi.pride.jmztab2.model.Section;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorList;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class MZTabLineParser {
    protected int lineNumber;
    protected Section section;
    protected String line;
    protected String[] items;
    protected final MZTabParserContext context;
    protected MZTabErrorList errorList;

    protected MZTabLineParser(MZTabParserContext context) {
        if (context == null) {
            throw new NullPointerException("Parser context should be created first!");
        }
        this.context = context;
    }

    protected void parse(int lineNumber, String line, MZTabErrorList errorList) throws MZTabException {
        this.lineNumber = lineNumber;
        this.line = line;
        this.errorList = errorList == null ? new MZTabErrorList() : errorList;
        this.items = line.split("\\s*\t\\s*");
        this.items[0] = this.items[0].trim();
        this.items[this.items.length - 1] = this.items[this.items.length - 1].trim();
        this.section = Section.findSection(this.items[0]);
        if (this.section == null) {
            MZTabError error = new MZTabError(FormatErrorType.LinePrefix, lineNumber, new String[]{this.items[0]});
            this.errorList.add(error);
        }
    }
}

