/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.io.serialization.ParameterConverter;
import de.isas.mztab2.io.validators.SpectraRefValidator;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.SpectraRef;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.MZBoolean;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.MZTabUtils;
import uk.ac.ebi.pride.jmztab2.model.SplitList;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorList;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;
import uk.ac.ebi.pride.jmztab2.utils.parser.PositionMapping;

public abstract class MZTabDataLineParser<T>
extends MZTabLineParser {
    private static final Logger log = LoggerFactory.getLogger(MZTabDataLineParser.class);
    protected MZTabColumnFactory factory;
    protected PositionMapping positionMapping;
    protected SortedMap<String, Integer> exchangeMapping;
    protected SortedMap<Integer, IMZTabColumn> mapping;
    protected Metadata metadata;

    protected MZTabDataLineParser(MZTabParserContext context) {
        super(context);
    }

    protected MZTabDataLineParser(MZTabParserContext context, MZTabColumnFactory factory, PositionMapping positionMapping, Metadata metadata, MZTabErrorList errorList) {
        this(context);
        if (factory == null) {
            throw new NullPointerException("Column header factory should be created first.");
        }
        this.factory = factory;
        this.positionMapping = positionMapping;
        this.exchangeMapping = positionMapping.reverse();
        this.mapping = factory.getOffsetColumnsMap();
        if (metadata == null) {
            throw new NullPointerException("Metadata should be parsed first.");
        }
        this.metadata = metadata;
        this.errorList = errorList == null ? new MZTabErrorList() : errorList;
    }

    @Override
    public void parse(int lineNumber, String line, MZTabErrorList errorList) throws MZTabException {
        super.parse(lineNumber, line, errorList);
        this.checkCount();
        int offset = this.checkData();
        if (offset != this.items.length) {
            log.error("Number of expected items after parsing header is: {} but data line has: {} items!", (Object)offset, (Object)this.items.length);
            log.error("Current mapping is: {}", this.mapping);
            log.error("Items given: {} expected: {}", (Object)Arrays.toString(this.items), (Object)Arrays.toString(line.split("\\t")));
            this.errorList.add(new MZTabError(FormatErrorType.CountMatch, lineNumber, new String[]{"" + offset, "" + this.items.length}));
        }
    }

    private void checkCount() {
        int dataCount;
        int headerCount = this.mapping.size();
        if (headerCount != (dataCount = this.items.length - 1)) {
            log.error("Number of expected items after parsing header is: {} but data line has: {} items!", (Object)headerCount, (Object)dataCount);
            log.error("Current mapping is: {}", this.mapping);
            log.error("Items given: {} expected: {}", (Object)Arrays.toString(this.items), (Object)Arrays.toString(this.line.split("\\t")));
            this.errorList.add(new MZTabError(FormatErrorType.CountMatch, this.lineNumber, new String[]{"" + dataCount, "" + headerCount}));
        }
    }

    public abstract T getRecord();

    protected abstract int checkData();

    protected Integer loadBestSearchEngineScoreId(String bestSearchEngineScoreLabel) {
        Pattern pattern = Pattern.compile("search_engine_score\\[(\\d+)\\](\\w+)?");
        Matcher matcher = pattern.matcher(bestSearchEngineScoreLabel);
        if (matcher.find()) {
            return new Integer(matcher.group(1));
        }
        return null;
    }

    protected Integer loadSearchEngineScoreId(String searchEngineLabel) {
        Pattern pattern = Pattern.compile("search_engine_score\\[(\\d+)\\]\\w*");
        Matcher matcher = pattern.matcher(searchEngineLabel);
        if (matcher.find()) {
            return new Integer(matcher.group(1));
        }
        return null;
    }

    protected String checkData(IMZTabColumn column, String target, boolean allowNull) {
        if (target == null && allowNull) {
            return null;
        }
        if (target == null) {
            this.errorList.add(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{column.getHeader()}));
            return null;
        }
        if ((target = target.trim()).isEmpty()) {
            this.errorList.add(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{column.getHeader()}));
            return null;
        }
        if ("null".equals(target) && !allowNull) {
            this.errorList.add(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{column.getHeader()}));
            return null;
        }
        return target;
    }

    protected String checkString(IMZTabColumn column, String target) {
        return this.checkData(column, target, true);
    }

    protected String checkString(IMZTabColumn column, String target, boolean allowNull) {
        return this.checkData(column, target, allowNull);
    }

    protected Integer checkInteger(IMZTabColumn column, String target) {
        return this.checkInteger(column, target, true);
    }

    protected Integer checkInteger(IMZTabColumn column, String target, boolean allowNull) {
        String result = this.checkData(column, target, allowNull);
        if (result == null || result.equalsIgnoreCase("null")) {
            return null;
        }
        Integer value = MZTabUtils.parseInteger(result);
        if (value == null) {
            this.errorList.add(new MZTabError(FormatErrorType.Integer, this.lineNumber, new String[]{column.getHeader(), target}));
        }
        return value;
    }

    protected Double checkDouble(IMZTabColumn column, String target) {
        return this.checkDouble(column, target, true);
    }

    protected Double checkDouble(IMZTabColumn column, String target, boolean allowNull) {
        String result = this.checkData(column, target, allowNull);
        if (result == null || result.equalsIgnoreCase("null")) {
            return null;
        }
        Double value = MZTabUtils.parseDouble(result);
        if (value == null) {
            this.errorList.add(new MZTabError(FormatErrorType.Double, this.lineNumber, new String[]{column.getHeader(), target}));
            return null;
        }
        if (value.equals(Double.NaN) || value.equals(Double.POSITIVE_INFINITY)) {
            return value;
        }
        return value;
    }

    protected List<Parameter> checkParamList(IMZTabColumn column, String target) {
        String result = this.checkData(column, target, true);
        if (result == null || result.equalsIgnoreCase("null")) {
            return new ArrayList<Parameter>(124);
        }
        List<Parameter> paramList = MZTabUtils.parseParamList(result);
        if (paramList.isEmpty()) {
            this.errorList.add(new MZTabError(FormatErrorType.ParamList, this.lineNumber, new String[]{"Column " + column.getHeader(), target}));
        }
        for (Parameter param : paramList) {
            if (param == null || param.getCvAccession() == null || param.getCvAccession().isEmpty() || param.getCvAccession().contains(":")) continue;
            this.errorList.add(new MZTabError(FormatErrorType.ParamAccessionNotNamespaced, this.lineNumber, new String[]{column.getHeader(), param.getCvAccession(), new ParameterConverter().convert(param)}));
        }
        return paramList;
    }

    protected Parameter checkParameter(IMZTabColumn column, String target, boolean allowNull) {
        Parameter param;
        String result = this.checkData(column, target, true);
        if (result == null || result.equalsIgnoreCase("null") && !allowNull) {
            this.errorList.add(new MZTabError(FormatErrorType.Param, this.lineNumber, new String[]{"Column " + column.getHeader(), target}));
        }
        if ((param = MZTabUtils.parseParam(target)) != null && param.getCvAccession() != null && !param.getCvAccession().isEmpty()) {
            if (!param.getCvAccession().contains(":")) {
                this.errorList.add(new MZTabError(FormatErrorType.ParamAccessionNotNamespaced, this.lineNumber, new String[]{column.getHeader(), param.getCvAccession(), new ParameterConverter().convert(param)}));
            }
        } else if (param == null && result != null && !result.isEmpty() && !result.equalsIgnoreCase("null")) {
            this.errorList.add(new MZTabError(FormatErrorType.Param, this.lineNumber, new String[]{"Column " + column.getHeader(), target}));
        }
        return param;
    }

    protected List<String> checkStringList(IMZTabColumn column, String target, char splitChar) {
        String result = this.checkData(column, target, true);
        if (result == null || result.equalsIgnoreCase("null")) {
            return new ArrayList<String>(splitChar);
        }
        List<String> stringList = MZTabUtils.parseStringList(splitChar, result);
        if (stringList.isEmpty()) {
            this.errorList.add(new MZTabError(FormatErrorType.StringList, this.lineNumber, new String[]{column.getHeader(), result, "" + splitChar}));
        }
        return stringList;
    }

    protected List<Integer> checkIntegerList(IMZTabColumn column, String target, char splitChar) {
        return this.checkIntegerList(column, target, splitChar, true);
    }

    protected List<Integer> checkIntegerList(IMZTabColumn column, String target, char splitChar, boolean allowNull) {
        String result = this.checkData(column, target, allowNull);
        if (result == null || result.equalsIgnoreCase("null")) {
            return new ArrayList<Integer>(splitChar);
        }
        List<Integer> stringList = MZTabUtils.parseIntegerList(result);
        if (stringList.isEmpty()) {
            this.errorList.add(new MZTabError(FormatErrorType.IntegerList, this.lineNumber, new String[]{column.getHeader(), result, "" + splitChar}));
        }
        return stringList;
    }

    protected List<Double> checkDoubleList(IMZTabColumn column, String target) {
        String result = this.checkData(column, target, true);
        if (result == null || result.equalsIgnoreCase("null")) {
            return new ArrayList<Double>(124);
        }
        List<Double> doubleList = MZTabUtils.parseDoubleList(target);
        if (doubleList.isEmpty()) {
            this.errorList.add(new MZTabError(FormatErrorType.DoubleList, this.lineNumber, new String[]{column.getHeader(), result, "|"}));
        }
        return doubleList;
    }

    protected MZBoolean checkMZBoolean(IMZTabColumn column, String target) {
        String result = this.checkData(column, target, true);
        if (result == null || result.equalsIgnoreCase("null")) {
            return null;
        }
        MZBoolean value = MZBoolean.findBoolean(result);
        if (value == null) {
            this.errorList.add(new MZTabError(FormatErrorType.MZBoolean, this.lineNumber, new String[]{column.getHeader(), result}));
        }
        return value;
    }

    protected String checkDescription(IMZTabColumn column, String description) {
        return this.checkData(column, description, true);
    }

    protected Integer checkTaxid(IMZTabColumn column, String taxid) {
        return this.checkInteger(column, taxid);
    }

    protected String checkSpecies(IMZTabColumn column, String species) {
        return this.checkData(column, species, true);
    }

    protected String checkDatabase(IMZTabColumn column, String database) {
        return this.checkData(column, database, true);
    }

    protected String checkDatabaseVersion(IMZTabColumn column, String databaseVersion) {
        return this.checkData(column, databaseVersion, true);
    }

    protected List<Parameter> checkSearchEngine(IMZTabColumn column, String searchEngine) {
        return this.checkParamList(column, searchEngine);
    }

    protected Double checkBestSearchEngineScore(IMZTabColumn column, String bestSearchEngineScore) {
        return this.checkDouble(column, bestSearchEngineScore);
    }

    protected Double checkSearchEngineScore(IMZTabColumn column, String searchEngineScore) {
        return this.checkDouble(column, searchEngineScore);
    }

    protected Integer checkNumPSMs(IMZTabColumn column, String numPSMs) {
        return this.checkInteger(column, numPSMs);
    }

    protected Integer checkNumPeptidesDistinct(IMZTabColumn column, String numPeptidesDistinct) {
        return this.checkInteger(column, numPeptidesDistinct);
    }

    protected Integer checkNumPeptidesUnique(IMZTabColumn column, String numPeptidesUnique) {
        return this.checkInteger(column, numPeptidesUnique);
    }

    protected List<String> checkAmbiguityMembers(IMZTabColumn column, String ambiguityMembers) {
        return this.checkStringList(column, ambiguityMembers, ',');
    }

    protected String checkURI(IMZTabColumn column, String uri) {
        String result_uri = this.checkData(column, uri, true);
        if (result_uri == null || result_uri.equalsIgnoreCase("null")) {
            return null;
        }
        URI result = MZTabUtils.parseURI(result_uri);
        if (result == null) {
            this.errorList.add(new MZTabError(FormatErrorType.URI, this.lineNumber, new String[]{"Column " + column.getHeader(), result_uri}));
            return null;
        }
        return result.toASCIIString();
    }

    protected List<SpectraRef> checkSpectraRef(MZTabParserContext context, IMZTabColumn column, String spectraRef, boolean allowNull) {
        String result_spectraRef = this.checkData(column, spectraRef, allowNull);
        if (result_spectraRef == null || result_spectraRef.equalsIgnoreCase("null")) {
            return new SplitList<SpectraRef>('|');
        }
        List<SpectraRef> refList = MZTabUtils.parseSpectraRefList(context, this.metadata, result_spectraRef);
        SpectraRefValidator validator = new SpectraRefValidator();
        this.errorList.addAll(validator.validateLine(this.lineNumber, context, column, result_spectraRef, refList));
        return refList;
    }

    protected String checkPre(IMZTabColumn column, String pre) {
        return this.checkData(column, pre, true);
    }

    protected String checkPost(IMZTabColumn column, String post) {
        return this.checkData(column, post, true);
    }

    protected String checkStart(IMZTabColumn column, String start) {
        return this.checkData(column, start, true);
    }

    protected String checkEnd(IMZTabColumn column, String end) {
        return this.checkData(column, end, true);
    }

    protected List<String> checkGOTerms(IMZTabColumn column, String go_terms) {
        String result_go_terms = this.checkData(column, go_terms, true);
        if (result_go_terms == null || result_go_terms.equalsIgnoreCase("null")) {
            return new ArrayList<String>(44);
        }
        List<String> stringList = MZTabUtils.parseGOTermList(result_go_terms);
        if (stringList.isEmpty()) {
            this.errorList.add(new MZTabError(FormatErrorType.GOTermList, this.lineNumber, new String[]{column.getHeader(), result_go_terms}));
        }
        return stringList;
    }

    protected Double checkProteinCoverage(IMZTabColumn column, String protein_coverage) {
        Double result = this.checkDouble(column, protein_coverage);
        if (result == null) {
            return null;
        }
        if (result < 0.0 || result > 1.0) {
            this.errorList.add(new MZTabError(LogicalErrorType.ProteinCoverage, this.lineNumber, new String[]{column.getHeader(), MZTabUtils.printDouble(result)}));
            return null;
        }
        return result;
    }

    protected String checkSequence(IMZTabColumn column, String sequence) {
        String result = this.checkData(column, sequence, true);
        if (result == null) {
            return null;
        }
        result = result.toUpperCase();
        Pattern pattern = Pattern.compile("[OU]");
        Matcher matcher = pattern.matcher(result);
        if (matcher.find()) {
            this.errorList.add(new MZTabError(FormatErrorType.Sequence, this.lineNumber, new String[]{column.getHeader(), sequence}));
        }
        return result;
    }

    protected Integer checkPSMID(IMZTabColumn column, String psm_id) {
        return this.checkInteger(column, psm_id);
    }

    protected MZBoolean checkUnique(IMZTabColumn column, String unique) {
        return this.checkMZBoolean(column, unique);
    }

    protected Integer checkCharge(IMZTabColumn column, String charge) {
        return this.checkInteger(column, charge);
    }

    protected Double checkMassToCharge(IMZTabColumn column, String mass_to_charge) {
        return this.checkDouble(column, mass_to_charge);
    }

    protected Double checkExpMassToCharge(IMZTabColumn column, String exp_mass_to_charge) {
        return this.checkDouble(column, exp_mass_to_charge);
    }

    protected Double checkCalcMassToCharge(IMZTabColumn column, String calc_mass_to_charge) {
        return this.checkDouble(column, calc_mass_to_charge);
    }

    protected List<String> checkIdentifier(IMZTabColumn column, String identifier) {
        return this.checkStringList(column, identifier, '|');
    }

    protected String checkChemicalFormula(IMZTabColumn column, String chemical_formula) {
        return this.checkData(column, chemical_formula, true);
    }

    protected List<String> checkSmiles(IMZTabColumn column, String smiles) {
        return this.checkStringList(column, smiles, '|');
    }

    protected List<String> checkInchiKey(IMZTabColumn column, String inchi_key) {
        return this.checkStringList(column, inchi_key, '|');
    }

    protected List<Double> checkRetentionTime(IMZTabColumn column, String retention_time) {
        String result = this.checkData(column, retention_time, true);
        if (result == null || result.equalsIgnoreCase("null")) {
            return new SplitList<Double>('|');
        }
        List<Double> valueList = MZTabUtils.parseDoubleList(result);
        if (valueList.isEmpty()) {
            this.errorList.add(new MZTabError(FormatErrorType.DoubleList, this.lineNumber, new String[]{column.getHeader(), result, "|"}));
        }
        return valueList;
    }

    protected List<Double> checkRetentionTimeWindow(IMZTabColumn column, String retention_time_window) {
        String result = this.checkData(column, retention_time_window, true);
        if (result == null || result.equalsIgnoreCase("null")) {
            return new SplitList<Double>('|');
        }
        List<Double> valueList = MZTabUtils.parseDoubleList(result);
        if (valueList.isEmpty()) {
            this.errorList.add(new MZTabError(FormatErrorType.DoubleList, this.lineNumber, new String[]{column.getHeader(), result, "|"}));
        }
        return valueList;
    }
}

