/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.io.validators.AssayValidator;
import de.isas.mztab2.io.validators.CvValidator;
import de.isas.mztab2.io.validators.DatabaseValidator;
import de.isas.mztab2.io.validators.MsRunValidator;
import de.isas.mztab2.io.validators.MzTabIdValidator;
import de.isas.mztab2.io.validators.MzTabVersionValidator;
import de.isas.mztab2.io.validators.QuantificationMethodValidator;
import de.isas.mztab2.io.validators.RefiningValidator;
import de.isas.mztab2.io.validators.SmallMoleculeFeatureQuantificationUnitValidator;
import de.isas.mztab2.io.validators.SmallMoleculeQuantificationUnitValidator;
import de.isas.mztab2.io.validators.SoftwareValidator;
import de.isas.mztab2.io.validators.StudyVariableValidator;
import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.CV;
import de.isas.mztab2.model.Contact;
import de.isas.mztab2.model.Database;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Instrument;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.Publication;
import de.isas.mztab2.model.Sample;
import de.isas.mztab2.model.SampleProcessing;
import de.isas.mztab2.model.Software;
import de.isas.mztab2.model.StudyVariable;
import de.isas.mztab2.model.Uri;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import uk.ac.ebi.pride.jmztab2.model.MZTabStringUtils;
import uk.ac.ebi.pride.jmztab2.model.MZTabUtils;
import uk.ac.ebi.pride.jmztab2.model.MetadataElement;
import uk.ac.ebi.pride.jmztab2.model.MetadataProperty;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorList;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorOverflowException;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class MTDLineParser
extends MZTabLineParser {
    private static final String Error_Header = Metadata.PrefixEnum.MTD.getValue() + "\t";
    private final Metadata metadata = new Metadata();

    public MTDLineParser(MZTabParserContext context) {
        super(context);
    }

    @Override
    public void parse(int lineNumber, String mtdLine, MZTabErrorList errorList) throws MZTabException {
        super.parse(lineNumber, mtdLine, errorList);
        if (this.items.length != 3) {
            MZTabError error = new MZTabError(FormatErrorType.MTDLine, lineNumber, new String[]{mtdLine});
            throw new MZTabException(error);
        }
        String defineLabel = this.items[1].trim().toLowerCase();
        String valueLabel = this.items[2].trim();
        this.parseNormalMetadata(defineLabel, valueLabel);
    }

    private String checkEmail(String defineLabel, String valueLabel) {
        String email = MZTabUtils.parseEmail(valueLabel);
        if (email == null) {
            this.errorList.add(new MZTabError(FormatErrorType.Email, this.lineNumber, new String[]{Error_Header + defineLabel, valueLabel}));
        }
        return email;
    }

    private MetadataProperty checkProperty(MetadataElement element, String propertyName) throws MZTabException {
        if (MZTabStringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        Optional<MetadataProperty> property = MetadataProperty.findProperty(element, propertyName);
        if (!property.isPresent()) {
            MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{element.getName() + "-" + propertyName});
            throw new MZTabException(error);
        }
        return property.get();
    }

    private Parameter checkParameter(String defineLabel, String valueLabel) {
        Parameter param = MZTabUtils.parseParam(valueLabel);
        if (param == null) {
            this.errorList.add(new MZTabError(FormatErrorType.Param, this.lineNumber, new String[]{Error_Header + defineLabel, valueLabel}));
        }
        return param;
    }

    private List<Parameter> checkParameterList(String defineLabel, String valueLabel) {
        List<Parameter> paramList = MZTabUtils.parseParamList(valueLabel);
        if (paramList.isEmpty()) {
            this.errorList.add(new MZTabError(FormatErrorType.ParamList, this.lineNumber, new String[]{Error_Header + defineLabel, valueLabel}));
        }
        return paramList;
    }

    private Publication checkPublication(Integer id, String defineLabel, String valueLabel) throws MZTabException {
        if (!this.context.getPublicationMap().containsKey(id)) {
            this.context.addPublication(this.metadata, new Publication().id(id));
        }
        Publication publications = null;
        try {
            publications = MZTabUtils.parsePublicationItems((Publication)this.context.getPublicationMap().get(id), this.lineNumber, valueLabel);
            if (publications == null || publications.getPublicationItems() == null || publications.getPublicationItems().isEmpty()) {
                this.errorList.add(new MZTabError(FormatErrorType.Publication, this.lineNumber, new String[]{Error_Header + defineLabel, valueLabel}));
            }
        }
        catch (MZTabException ex) {
            this.errorList.add(ex.getError());
        }
        return publications;
    }

    private URI checkURI(String defineLabel, String valueLabel, boolean mandatory) {
        if (null == MZTabStringUtils.parseString((String)valueLabel)) {
            if (mandatory) {
                this.errorList.add(new MZTabError(LogicalErrorType.NotNULL, this.lineNumber, new String[]{Error_Header + defineLabel, valueLabel}));
            }
            return null;
        }
        URI uri = MZTabUtils.parseURI(valueLabel);
        if (uri == null) {
            this.errorList.add(new MZTabError(FormatErrorType.URI, this.lineNumber, new String[]{Error_Header + defineLabel, valueLabel}));
        }
        return uri;
    }

    private int checkIndex(String defineLabel, String id) throws MZTabException {
        try {
            Integer index = Integer.parseInt(id);
            if (index < 1) {
                throw new NumberFormatException();
            }
            return index;
        }
        catch (NumberFormatException e) {
            MZTabError error = new MZTabError(LogicalErrorType.IdNumber, this.lineNumber, new String[]{Error_Header + defineLabel, id});
            throw new MZTabException(error);
        }
    }

    private IndexedElement checkIndexedElement(String defineLabel, String valueLabel, MetadataElement element) throws MZTabException {
        IndexedElement indexedElement = MZTabUtils.parseIndexedElement(valueLabel, element);
        if (indexedElement == null) {
            MZTabError error = new MZTabError(FormatErrorType.IndexedElement, this.lineNumber, new String[]{Error_Header + defineLabel, valueLabel});
            throw new MZTabException(error);
        }
        return indexedElement;
    }

    private List<IndexedElement> checkIndexedElementList(String defineLabel, String valueLabel, MetadataElement element) throws MZTabException {
        List<IndexedElement> indexedElementList = MZTabUtils.parseRefList(valueLabel, element);
        if (indexedElementList == null || indexedElementList.isEmpty()) {
            MZTabError error = new MZTabError(FormatErrorType.IndexedElement, this.lineNumber, new String[]{Error_Header + defineLabel, valueLabel});
            throw new MZTabException(error);
        }
        return indexedElementList;
    }

    private void parseNormalMetadata(String defineLabel, String valueLabel) throws MZTabException {
        Pattern pattern = Pattern.compile("(\\w+)(\\[(\\w+)\\])?(-(\\w+)(\\[(\\w+)\\])?)?(-(\\w+))?");
        Matcher matcher = pattern.matcher(defineLabel);
        if (matcher.find()) {
            MetadataElement element = MetadataElement.findElement(matcher.group(1));
            if (element == null) {
                throw new MZTabException(new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel}));
            }
            switch (element) {
                case MZTAB: {
                    this.handleMzTab(element, matcher, defineLabel, valueLabel);
                    break;
                }
                case TITLE: {
                    this.handleTitle(defineLabel, valueLabel);
                    break;
                }
                case DESCRIPTION: {
                    this.handleDescription(defineLabel, valueLabel);
                    break;
                }
                case SAMPLE_PROCESSING: {
                    this.handleSampleProcessing(defineLabel, matcher, valueLabel);
                    break;
                }
                case INSTRUMENT: {
                    this.handleInstrument(defineLabel, matcher, element, valueLabel);
                    break;
                }
                case SOFTWARE: {
                    this.handleSoftware(defineLabel, matcher, element, valueLabel);
                    break;
                }
                case PUBLICATION: {
                    this.handlePublication(defineLabel, matcher, valueLabel);
                    break;
                }
                case CONTACT: {
                    this.handleContact(defineLabel, matcher, element, valueLabel);
                    break;
                }
                case URI: {
                    this.handleUri(defineLabel, matcher, valueLabel, false);
                    break;
                }
                case EXTERNAL_STUDY_URI: {
                    this.handleExternalStudyUri(defineLabel, matcher, valueLabel);
                    break;
                }
                case QUANTIFICATION_METHOD: {
                    this.handleQuantificationMethod(defineLabel, valueLabel);
                    break;
                }
                case SMALL_MOLECULE: {
                    this.handleSmallMolecule(element, matcher, defineLabel, valueLabel);
                    break;
                }
                case SMALL_MOLECULE_FEATURE: {
                    this.handleSmallMoleculeFeature(element, matcher, defineLabel, valueLabel);
                    break;
                }
                case MS_RUN: {
                    this.handleMsRun(defineLabel, matcher, element, valueLabel);
                    break;
                }
                case SAMPLE: {
                    this.handleSample(defineLabel, matcher, element, valueLabel);
                    break;
                }
                case ASSAY: {
                    this.handleAssay(matcher, defineLabel, element, valueLabel);
                    break;
                }
                case STUDY_VARIABLE: {
                    this.handleStudyVariable(defineLabel, matcher, element, valueLabel);
                    break;
                }
                case CUSTOM: {
                    this.handleCustom(defineLabel, matcher, valueLabel);
                    break;
                }
                case CV: {
                    this.handleCv(defineLabel, matcher, element, valueLabel);
                    break;
                }
                case DATABASE: {
                    this.handleDatabase(defineLabel, matcher, element, valueLabel);
                    break;
                }
                case DERIVATIZATION_AGENT: {
                    this.handleDerivatizationAgent(defineLabel, matcher, valueLabel);
                    break;
                }
                case COLUNIT: 
                case COLUNIT_SMALL_MOLECULE: 
                case COLUNIT_SMALL_MOLECULE_FEATURE: 
                case COLUNIT_SMALL_MOLECULE_EVIDENCE: {
                    this.handleColunit(defineLabel, valueLabel);
                    break;
                }
                case ID_CONFIDENCE_MEASURE: {
                    this.handleIdConfidenceMeasure(defineLabel, matcher, valueLabel);
                }
            }
        } else {
            throw new MZTabException(new MZTabError(FormatErrorType.MTDLine, this.lineNumber, new String[]{this.line}));
        }
    }

    protected void handleIdConfidenceMeasure(String defineLabel, Matcher matcher, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        this.context.addIdConfidenceMeasure(this.metadata, id, this.checkParameter(defineLabel, valueLabel));
    }

    protected void handleColunit(String defineLabel, String valueLabel) throws MZTabErrorOverflowException {
        if (!(defineLabel.equals("colunit-protein") || defineLabel.equals("colunit-peptide") || defineLabel.equals("colunit-psm") || defineLabel.equals(Metadata.Properties.colunitSmallMolecule.getPropertyName()) || defineLabel.equals(Metadata.Properties.colunitSmallMoleculeEvidence.getPropertyName()) || defineLabel.equals(Metadata.Properties.colunitSmallMoleculeFeature.getPropertyName()))) {
            this.errorList.add(new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel}));
        } else {
            String[] colunitDef = valueLabel.split("=");
            if (colunitDef.length != 2) {
                this.errorList.add(new MZTabError(FormatErrorType.InvalidColunitFormat, this.lineNumber, new String[]{valueLabel}));
            }
            Parameter p = this.checkParameter(defineLabel, colunitDef[1]);
            String columnName = colunitDef[0];
            if (columnName == null) {
                this.errorList.add(new MZTabError(FormatErrorType.InvalidColunitFormat, this.lineNumber, new String[]{valueLabel}));
            } else if (defineLabel.equals(Metadata.Properties.colunitSmallMolecule.getPropertyName())) {
                this.context.addSmallMoleculeColUnit(this.metadata, columnName, p);
            } else if (defineLabel.equals(Metadata.Properties.colunitSmallMoleculeFeature.getPropertyName())) {
                this.context.addSmallMoleculeFeatureColUnit(this.metadata, columnName, p);
            } else if (defineLabel.equals(Metadata.Properties.colunitSmallMoleculeEvidence.getPropertyName())) {
                this.context.addSmallMoleculeEvidenceColUnit(this.metadata, columnName, p);
            } else {
                this.errorList.add(new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel}));
            }
        }
    }

    protected void handleDatabase(String defineLabel, Matcher matcher, MetadataElement element, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        this.addDatabase(this.context, this.metadata, property, id, defineLabel, valueLabel);
    }

    protected void handleCv(String defineLabel, Matcher matcher, MetadataElement element, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        this.addCv(this.context, this.metadata, property, id, valueLabel);
    }

    protected void handleStudyVariable(String defineLabel, Matcher matcher, MetadataElement element, String valueLabel) throws MZTabException, MZTabErrorOverflowException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        this.addStudyVariable(this.context, this.metadata, property, defineLabel, valueLabel, id);
    }

    protected void handleAssay(Matcher matcher, String defineLabel, MetadataElement element, String valueLabel) throws MZTabException {
        if (!MZTabStringUtils.isEmpty((String)matcher.group(6))) {
            throw new MZTabException("assay does not support quantification modification!");
        }
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        this.addAssay(this.context, this.metadata, property, defineLabel, valueLabel, id);
    }

    protected void handleSample(String defineLabel, Matcher matcher, MetadataElement element, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        this.addSample(this.context, this.metadata, property, id, defineLabel, valueLabel);
    }

    protected void handleCustom(String defineLabel, Matcher matcher, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        this.context.addCustomItem(this.metadata, id, this.checkParameter(defineLabel, valueLabel));
    }

    protected void handleDerivatizationAgent(String defineLabel, Matcher matcher, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        this.context.addDerivatizationAgentItem(this.metadata, id, this.checkParameter(defineLabel, valueLabel));
    }

    protected void handleMsRun(String defineLabel, Matcher matcher, MetadataElement element, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        this.addMsRun(this.context, this.metadata, property, id, defineLabel, valueLabel);
    }

    protected void handleSmallMoleculeFeature(MetadataElement element, Matcher matcher, String defineLabel, String valueLabel) throws MZTabException {
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        if (property == null) {
            MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
            throw new MZTabException(error);
        }
        if (property == MetadataProperty.SMALL_MOLECULE_FEATURE_QUANTIFICATION_UNIT) {
            if (this.metadata.getSmallMoleculeFeatureQuantificationUnit() != null) {
                throw new MZTabException(new MZTabError(LogicalErrorType.DuplicationDefine, this.lineNumber, new String[]{defineLabel}));
            }
            this.metadata.setSmallMoleculeFeatureQuantificationUnit(this.checkParameter(defineLabel, valueLabel));
        }
    }

    protected void handleSmallMolecule(MetadataElement element, Matcher matcher, String defineLabel, String valueLabel) throws MZTabException {
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        if (property == null) {
            MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
            throw new MZTabException(error);
        }
        if (property == MetadataProperty.SMALL_MOLECULE_QUANTIFICATION_UNIT) {
            if (this.metadata.getSmallMoleculeQuantificationUnit() != null) {
                throw new MZTabException(new MZTabError(LogicalErrorType.DuplicationDefine, this.lineNumber, new String[]{defineLabel}));
            }
            this.metadata.setSmallMoleculeQuantificationUnit(this.checkParameter(defineLabel, valueLabel));
        } else if (property == MetadataProperty.SMALL_MOLECULE_IDENTIFICATION_RELIABILITY) {
            if (this.metadata.getSmallMoleculeIdentificationReliability() != null) {
                throw new MZTabException(new MZTabError(LogicalErrorType.DuplicationDefine, this.lineNumber, new String[]{defineLabel}));
            }
            this.metadata.setSmallMoleculeIdentificationReliability(this.checkParameter(defineLabel, valueLabel));
        }
    }

    protected void handleQuantificationMethod(String defineLabel, String valueLabel) throws MZTabException {
        if (this.metadata.getQuantificationMethod() != null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.DuplicationDefine, this.lineNumber, new String[]{defineLabel}));
        }
        this.metadata.setQuantificationMethod(this.checkParameter(defineLabel, valueLabel));
    }

    protected void handleExternalStudyUri(String defineLabel, Matcher matcher, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        URI uri = this.checkURI(defineLabel, valueLabel, false);
        this.metadata.addExternalStudyUriItem(new Uri().id(id).value(uri == null ? "null" : uri.toASCIIString()));
    }

    protected void handleUri(String defineLabel, Matcher matcher, String valueLabel, boolean mandatory) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        URI uri = this.checkURI(defineLabel, valueLabel, mandatory);
        this.metadata.addUriItem(new Uri().id(id).value(uri == null ? "null" : uri.toASCIIString()));
    }

    protected void handleContact(String defineLabel, Matcher matcher, MetadataElement element, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        this.addContact(this.context, this.metadata, property, id, valueLabel, defineLabel);
    }

    protected void handlePublication(String defineLabel, Matcher matcher, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        this.checkPublication(id, defineLabel, valueLabel);
    }

    protected void handleSoftware(String defineLabel, Matcher matcher, MetadataElement element, String valueLabel) throws MZTabErrorOverflowException, MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        this.addSoftware(this.context, this.metadata, property, defineLabel, valueLabel, id);
    }

    protected void handleInstrument(String defineLabel, Matcher matcher, MetadataElement element, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        Parameter param = this.checkParameter(defineLabel, valueLabel);
        this.addInstrument(this.context, this.metadata, property, id, param);
    }

    protected void handleSampleProcessing(String defineLabel, Matcher matcher, String valueLabel) throws MZTabException {
        Integer id = this.checkIndex(defineLabel, matcher.group(3));
        this.addSampleProcessing(this.context, this.metadata, id, this.checkParameterList(defineLabel, valueLabel));
    }

    protected void handleDescription(String defineLabel, String valueLabel) throws MZTabException {
        if (this.metadata.getDescription() != null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.DuplicationDefine, this.lineNumber, new String[]{defineLabel}));
        }
        this.metadata.setDescription(valueLabel);
    }

    protected void handleTitle(String defineLabel, String valueLabel) throws MZTabException {
        if (this.metadata.getTitle() != null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.DuplicationDefine, this.lineNumber, new String[]{defineLabel}));
        }
        this.metadata.setTitle(valueLabel);
    }

    protected void handleMzTab(MetadataElement element, Matcher matcher, String defineLabel, String valueLabel) throws MZTabException {
        MetadataProperty property = this.checkProperty(element, matcher.group(5));
        if (property == null) {
            MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
            throw new MZTabException(error);
        }
        switch (property) {
            case MZTAB_VERSION: {
                if (this.metadata.getMzTabVersion() != null) {
                    throw new MZTabException(new MZTabError(LogicalErrorType.DuplicationDefine, this.lineNumber, new String[]{defineLabel}));
                }
                if (MZTabUtils.parseMzTabVersion(valueLabel) == null) {
                    throw new MZTabException(new MZTabError(FormatErrorType.MZTabVersion, this.lineNumber, new String[]{defineLabel, valueLabel}));
                }
                this.metadata.mzTabVersion(valueLabel);
                break;
            }
            case MZTAB_ID: {
                if (this.metadata.getMzTabID() != null) {
                    throw new MZTabException(new MZTabError(LogicalErrorType.DuplicationDefine, this.lineNumber, new String[]{defineLabel}));
                }
                if (MZTabStringUtils.parseString((String)valueLabel) == null) {
                    throw new MZTabException(new MZTabError(FormatErrorType.MZTabId, this.lineNumber, new String[]{defineLabel, valueLabel}));
                }
                this.metadata.mzTabID(MZTabStringUtils.parseString((String)valueLabel));
                break;
            }
            default: {
                MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
                throw new MZTabException(error);
            }
        }
    }

    private <T> void validate(T t, RefiningValidator<T> validator, MZTabParserContext context, MZTabErrorList errorList) {
        validator.validateRefine(t, context).forEach(error -> errorList.add(error));
    }

    public void refineNormalMetadata() throws MZTabException {
        this.validate(this.metadata, new MzTabVersionValidator(), this.context, this.errorList);
        this.validate(this.metadata, new MzTabIdValidator(), this.context, this.errorList);
        this.validate(this.metadata, new SoftwareValidator(), this.context, this.errorList);
        this.validate(this.metadata, new QuantificationMethodValidator(), this.context, this.errorList);
        this.validate(this.metadata, new AssayValidator(), this.context, this.errorList);
        this.validate(this.metadata, new StudyVariableValidator(), this.context, this.errorList);
        this.validate(this.metadata, new MsRunValidator(), this.context, this.errorList);
        this.validate(this.metadata, new CvValidator(), this.context, this.errorList);
        this.validate(this.metadata, new DatabaseValidator(), this.context, this.errorList);
        this.validate(this.metadata, new SmallMoleculeQuantificationUnitValidator(), this.context, this.errorList);
        this.validate(this.metadata, new SmallMoleculeFeatureQuantificationUnitValidator(), this.context, this.errorList);
        this.validate(this.metadata, new SmallMoleculeQuantificationUnitValidator(), this.context, this.errorList);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private void addSampleProcessing(MZTabParserContext context, Metadata metadata, Integer id, List<Parameter> checkParameterList) throws MZTabException {
        SampleProcessing sp = context.addSampleProcessing(metadata, id, checkParameterList);
        if (sp == null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{Metadata.Properties.sampleProcessing + "[" + id + "]"}));
        }
    }

    public void handleParam(String defineLabel, String valueLabel, MZTabErrorType errorType, int lineNumber, Consumer<Parameter> consumer) throws MZTabErrorOverflowException {
        Parameter param = this.checkParameter(defineLabel, valueLabel);
        if (param != null && (param.getValue() == null || param.getValue().trim().length() == 0)) {
            this.errorList.add(new MZTabError(errorType, lineNumber, new String[]{valueLabel}));
        } else {
            consumer.accept(param);
        }
    }

    private void addInstrument(MZTabParserContext context, Metadata metadata, MetadataProperty property, Integer id, Parameter param) throws MZTabException {
        Instrument instrument = null;
        if (property == null) {
            MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{Metadata.Properties.instrument + "[" + id + "]-" + (Object)((Object)property)});
            throw new MZTabException(error);
        }
        switch (property) {
            case INSTRUMENT_NAME: {
                instrument = context.addInstrumentName(metadata, id, param);
                break;
            }
            case INSTRUMENT_SOURCE: {
                instrument = context.addInstrumentSource(metadata, id, param);
                break;
            }
            case INSTRUMENT_ANALYZER: {
                instrument = context.addInstrumentAnalyzer(metadata, id, param);
                break;
            }
            case INSTRUMENT_DETECTOR: {
                instrument = context.addInstrumentDetector(metadata, id, param);
                break;
            }
            default: {
                MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{Metadata.Properties.instrument + "[" + id + "]-" + (Object)((Object)property)});
                throw new MZTabException(error);
            }
        }
        if (instrument == null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{Metadata.Properties.instrument + "[" + id + "]"}));
        }
    }

    private void addSoftware(MZTabParserContext context, Metadata metadata, MetadataProperty property, String defineLabel, String valueLabel, Integer id) throws MZTabErrorOverflowException, MZTabException {
        Software software = null;
        if (property == null) {
            Parameter param = this.checkParameter(defineLabel, valueLabel);
            if (param != null && (param.getValue() == null || param.getValue().trim().length() == 0)) {
                this.errorList.add(new MZTabError(LogicalErrorType.SoftwareVersion, this.lineNumber, new String[]{valueLabel}));
            }
            software = context.addSoftwareParameter(metadata, id, param);
        } else {
            switch (property) {
                case SOFTWARE_SETTING: {
                    software = context.addSoftwareSetting(metadata, id, valueLabel);
                    break;
                }
                default: {
                    MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
                    throw new MZTabException(error);
                }
            }
        }
        if (software == null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{Metadata.Properties.software + "[" + id + "]"}));
        }
    }

    private void addContact(MZTabParserContext context, Metadata metadata, MetadataProperty property, Integer id, String valueLabel, String defineLabel) throws MZTabException {
        Contact contact = null;
        if (property == null) {
            MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
            throw new MZTabException(error);
        }
        switch (property) {
            case CONTACT_NAME: {
                contact = context.addContactName(metadata, id, valueLabel);
                break;
            }
            case CONTACT_AFFILIATION: {
                contact = context.addContactAffiliation(metadata, id, valueLabel);
                break;
            }
            case CONTACT_EMAIL: {
                this.checkEmail(defineLabel, valueLabel);
                contact = context.addContactEmail(metadata, id, valueLabel);
                break;
            }
            default: {
                MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
                throw new MZTabException(error);
            }
        }
        if (contact == null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{Metadata.Properties.contact + "[" + id + "]"}));
        }
    }

    private void addMsRun(MZTabParserContext context, Metadata metadata, MetadataProperty property, Integer id, String defineLabel, String valueLabel) throws MZTabException {
        MsRun msRun = null;
        if (property == null) {
            msRun = context.addMsRun(metadata, new MsRun().id(id).name(valueLabel));
        } else {
            switch (property) {
                case MS_RUN_LOCATION: {
                    msRun = context.addMsRunLocation(metadata, id, this.checkURI(defineLabel, valueLabel, true));
                    break;
                }
                case MS_RUN_INSTRUMENT_REF: {
                    List<IndexedElement> indexedElements = this.checkIndexedElementList(defineLabel, valueLabel, MetadataElement.INSTRUMENT);
                    if (indexedElements == null || indexedElements.isEmpty() || indexedElements.size() != 1) break;
                    Instrument instrument = (Instrument)context.getInstrumentMap().get(indexedElements.get(0).getId());
                    if (instrument == null) {
                        throw new MZTabException(new MZTabError(LogicalErrorType.NotDefineInMetadata, this.lineNumber, new String[]{valueLabel, valueLabel}));
                    }
                    msRun = context.addMsRunInstrumentRef(metadata, id, instrument);
                    break;
                }
                case MS_RUN_FORMAT: {
                    msRun = context.addMsRunFormat(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case MS_RUN_ID_FORMAT: {
                    msRun = context.addMsRunIdFormat(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case MS_RUN_FRAGMENTATION_METHOD: {
                    msRun = context.addMsRunFragmentationMethod(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case MS_RUN_SCAN_POLARITY: {
                    msRun = context.addMsRunScanPolarity(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case MS_RUN_HASH: {
                    msRun = context.addMsRunHash(metadata, id, valueLabel);
                    break;
                }
                case MS_RUN_HASH_METHOD: {
                    msRun = context.addMsRunHashMethod(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                default: {
                    MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
                    throw new MZTabException(error);
                }
            }
        }
        if (msRun == null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{Metadata.Properties.msRun + "[" + id + "]"}));
        }
    }

    private void addDatabase(MZTabParserContext context, Metadata metadata, MetadataProperty property, Integer id, String defineLabel, String valueLabel) throws MZTabException {
        Database database = null;
        if (property == null) {
            database = context.addDatabase(metadata, new Database().id(id).param(this.checkParameter(defineLabel, valueLabel)));
        } else {
            switch (property) {
                case DATABASE_PREFIX: {
                    database = context.addDatabasePrefix(metadata, id, valueLabel);
                    break;
                }
                case DATABASE_VERSION: {
                    database = context.addDatabaseVersion(metadata, id, valueLabel);
                    break;
                }
                case DATABASE_URI: {
                    database = context.addDatabaseUri(metadata, id, this.checkURI(defineLabel, valueLabel, false));
                    break;
                }
                default: {
                    MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
                    throw new MZTabException(error);
                }
            }
        }
        if (database == null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.NULL, this.lineNumber, new String[]{Metadata.Properties.database + "[" + id + "]"}));
        }
    }

    private void addSample(MZTabParserContext context, Metadata metadata, MetadataProperty property, Integer id, String defineLabel, String valueLabel) throws MZTabException {
        if (property == null) {
            context.addSample(metadata, new Sample().id(id).name(valueLabel));
        } else {
            switch (property) {
                case SAMPLE_SPECIES: {
                    context.addSampleSpecies(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case SAMPLE_TISSUE: {
                    context.addSampleTissue(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case SAMPLE_CELL_TYPE: {
                    context.addSampleCellType(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case SAMPLE_DISEASE: {
                    context.addSampleDisease(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case SAMPLE_DESCRIPTION: {
                    context.addSampleDescription(metadata, id, valueLabel);
                    break;
                }
                case SAMPLE_CUSTOM: {
                    context.addSampleCustom(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                default: {
                    MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
                    throw new MZTabException(error);
                }
            }
        }
    }

    private void addAssay(MZTabParserContext context, Metadata metadata, MetadataProperty property, String defineLabel, String valueLabel, Integer id) throws MZTabException {
        if (property == null) {
            context.addAssay(metadata, new Assay().id(id).name(valueLabel));
        } else {
            switch (property) {
                case ASSAY_CUSTOM: {
                    context.addAssayCustom(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case ASSAY_EXTERNAL_URI: {
                    context.addAssayExternalUri(metadata, id, this.checkURI(defineLabel, valueLabel, false));
                    break;
                }
                case ASSAY_SAMPLE_REF: {
                    IndexedElement indexedElement = this.checkIndexedElement(defineLabel, valueLabel, MetadataElement.SAMPLE);
                    if (indexedElement == null) break;
                    Sample sample = (Sample)context.getSampleMap().get(indexedElement.getId());
                    if (sample == null) {
                        throw new MZTabException(new MZTabError(LogicalErrorType.NotDefineInMetadata, this.lineNumber, new String[]{valueLabel, valueLabel}));
                    }
                    context.addAssaySample(metadata, id, sample);
                    break;
                }
                case ASSAY_MS_RUN_REF: {
                    IndexedElement indexedElement = this.checkIndexedElement(defineLabel, valueLabel, MetadataElement.MS_RUN);
                    if (indexedElement == null) break;
                    MsRun msRun = (MsRun)context.getMsRunMap().get(indexedElement.getId());
                    if (msRun == null) {
                        throw new MZTabException(new MZTabError(LogicalErrorType.NotDefineInMetadata, this.lineNumber, new String[]{valueLabel}));
                    }
                    context.addAssayMsRun(metadata, id, msRun);
                    break;
                }
                default: {
                    MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
                    throw new MZTabException(error);
                }
            }
        }
    }

    private void addStudyVariable(MZTabParserContext context, Metadata metadata, MetadataProperty property, String defineLabel, String valueLabel, Integer id) throws MZTabErrorOverflowException, MZTabException {
        if (property == null) {
            context.addStudyVariable(metadata, new StudyVariable().id(id).name(valueLabel));
        } else {
            switch (property) {
                case STUDY_VARIABLE_ASSAY_REFS: {
                    List<IndexedElement> indexedElementList = this.checkIndexedElementList(defineLabel, valueLabel, MetadataElement.ASSAY);
                    indexedElementList.stream().filter(i -> Collections.frequency(indexedElementList, i) > 1).collect(Collectors.toSet()).forEach(indexedElement -> this.errorList.add(new MZTabError(LogicalErrorType.DuplicationID, this.lineNumber, new String[]{valueLabel})));
                    for (IndexedElement e : indexedElementList) {
                        if (!context.getAssayMap().containsKey(e.getId())) {
                            throw new MZTabException(new MZTabError(LogicalErrorType.NotDefineInMetadata, this.lineNumber, new String[]{valueLabel}));
                        }
                        context.addStudyVariableAssay(metadata, id, (Assay)context.getAssayMap().get(e.getId()));
                    }
                    break;
                }
                case STUDY_VARIABLE_AVERAGE_FUNCTION: {
                    context.addStudyVariableAverageFunction(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case STUDY_VARIABLE_VARIATION_FUNCTION: {
                    context.addStudyVariableVariationFunction(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                case STUDY_VARIABLE_DESCRIPTION: {
                    context.addStudyVariableDescription(metadata, id, valueLabel);
                    break;
                }
                case STUDY_VARIABLE_FACTORS: {
                    context.addStudyVariableFactors(metadata, id, this.checkParameter(defineLabel, valueLabel));
                    break;
                }
                default: {
                    MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{defineLabel + "-" + valueLabel});
                    throw new MZTabException(error);
                }
            }
        }
    }

    private void addCv(MZTabParserContext context, Metadata metadata, MetadataProperty property, Integer id, String valueLabel) throws MZTabException {
        if (property == null) {
            context.addCV(metadata, new CV().id(id));
        } else {
            switch (property) {
                case CV_LABEL: {
                    context.addCVLabel(metadata, id, valueLabel);
                    break;
                }
                case CV_FULL_NAME: {
                    context.addCVFullName(metadata, id, valueLabel);
                    break;
                }
                case CV_VERSION: {
                    context.addCVVersion(metadata, id, valueLabel);
                    break;
                }
                case CV_URI: {
                    context.addCVURI(metadata, id, valueLabel);
                    break;
                }
                default: {
                    MZTabError error = new MZTabError(FormatErrorType.MTDDefineLabel, this.lineNumber, new String[]{(Object)((Object)property) + "[" + id + "]-" + valueLabel});
                    throw new MZTabException(error);
                }
            }
        }
    }
}

