/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.model;

import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.Publication;
import de.isas.mztab2.model.PublicationItem;
import de.isas.mztab2.model.SpectraRef;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.MZTabStringUtils;
import uk.ac.ebi.pride.jmztab2.model.MetadataElement;
import uk.ac.ebi.pride.jmztab2.model.SplitList;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class MZTabUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MZTabUtils.class);

    public static String printDouble(Double value) {
        if (value == null) {
            return "null";
        }
        if (value.equals(Double.NaN)) {
            return "NaN";
        }
        if (value.equals(Double.POSITIVE_INFINITY)) {
            return "INF";
        }
        return value.toString();
    }

    public static String parseEmail(String target) {
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return null;
        }
        String regexp = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-']+)*@[A-Za-z0-9]+(?:[-.][A-Za-z0-9]+)*(\\.[A-Za-z]{2,})";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(target);
        return matcher.find() ? target : null;
    }

    public static String parseMzTabVersion(String target) {
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return null;
        }
        Pattern versionPattern = Pattern.compile("(?<major>[2]{1})\\.(?<minor>\\d{1})\\.(?<micro>\\d{1})-(?<profile>[M]{1})");
        Matcher m = versionPattern.matcher(target);
        if (m.matches()) {
            Integer major = Integer.parseInt(m.group("major"));
            Integer minor = Integer.parseInt(m.group("minor"));
            Integer micro = Integer.parseInt(m.group("micro"));
            if (major != 2) {
                return null;
            }
            if (!"M".equals(m.group("profile"))) {
                return null;
            }
            return target;
        }
        return null;
    }

    public static Parameter parseParam(String target) {
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return null;
        }
        try {
            target = target.substring(target.indexOf("[") + 1, target.lastIndexOf("]"));
            String[] tokens = target.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1);
            if (tokens.length == 4) {
                String cvLabel = tokens[0].trim();
                String accession = tokens[1].trim();
                String name = tokens[2].trim();
                if (name.contains("\"")) {
                    name = MZTabUtils.removeDoubleQuotes(name);
                }
                if (MZTabStringUtils.isEmpty((String)name)) {
                    return null;
                }
                String value = tokens[3].trim();
                if (value.contains("\"")) {
                    value = MZTabUtils.removeDoubleQuotes(value);
                }
                if (MZTabStringUtils.isEmpty((String)value)) {
                    value = null;
                }
                if (MZTabStringUtils.isEmpty((String)cvLabel) && MZTabStringUtils.isEmpty((String)accession)) {
                    return new Parameter().name(name).value(value);
                }
                return new Parameter().cvLabel(cvLabel).cvAccession(accession).name(name).value(value);
            }
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return null;
    }

    public static List<String> parseStringList(char splitChar, String target) {
        ArrayList<String> list = new ArrayList<String>(splitChar);
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return list;
        }
        StringBuilder sb = new StringBuilder();
        switch (splitChar) {
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                sb.append("\\").append(splitChar);
                break;
            }
            default: {
                sb.append(splitChar);
            }
        }
        String[] items = target.split(sb.toString());
        Collections.addAll(list, items);
        return list.stream().map(value -> value.trim()).collect(Collectors.toList());
    }

    public static IndexedElement parseIndexedElement(String target, MetadataElement element) {
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return null;
        }
        Pattern pattern = Pattern.compile((Object)((Object)element) + "\\[(\\d+)\\]");
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            Integer id = new Integer(matcher.group(1));
            IndexedElement p = new IndexedElement().id(id);
            p.elementType(element.getName());
            return p;
        }
        return null;
    }

    public static List<IndexedElement> parseRefList(String target, MetadataElement element) {
        List<String> list = MZTabUtils.parseStringList(',', target);
        ArrayList<IndexedElement> indexedElementList = new ArrayList<IndexedElement>();
        for (String item : list) {
            IndexedElement indexedElement = MZTabUtils.parseIndexedElement(item, element);
            if (indexedElement == null) {
                indexedElementList.clear();
                return indexedElementList;
            }
            indexedElementList.add(indexedElement);
        }
        return indexedElementList;
    }

    public static List<Parameter> parseParamList(String target) {
        List<String> list = MZTabUtils.parseStringList('|', target);
        SplitList<Parameter> paramList = new SplitList<Parameter>('|');
        for (String item : list) {
            Parameter param = MZTabUtils.parseParam(item);
            if (param == null) {
                paramList.clear();
                return paramList;
            }
            paramList.add(param);
        }
        return paramList;
    }

    public static List<String> parseGOTermList(String target) {
        List<String> list = MZTabUtils.parseStringList(',', target);
        SplitList<String> goList = new SplitList<String>(',');
        for (String item : list) {
            if ((item = MZTabStringUtils.parseString((String)item)).startsWith("GO:")) {
                goList.add(item);
                continue;
            }
            goList.clear();
            break;
        }
        return goList;
    }

    public static Integer parseInteger(String target) {
        Integer integer;
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return null;
        }
        try {
            integer = new Integer(target);
        }
        catch (NumberFormatException e) {
            integer = null;
        }
        return integer;
    }

    public static Double parseDouble(String target) {
        Double value;
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return null;
        }
        try {
            value = new Double(target);
        }
        catch (NumberFormatException e) {
            switch (target) {
                case "NaN": {
                    value = Double.NaN;
                    break;
                }
                case "INF": {
                    value = Double.POSITIVE_INFINITY;
                    break;
                }
                default: {
                    value = null;
                }
            }
        }
        return value;
    }

    public static Long parseLong(String target) {
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return null;
        }
        try {
            return new Long(target);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static List<Double> parseDoubleList(String target) {
        List<String> list = MZTabUtils.parseStringList('|', target);
        ArrayList<Double> valueList = new ArrayList<Double>(124);
        for (String item : list) {
            Double value = MZTabUtils.parseDouble(item);
            if (value == null) {
                valueList.clear();
                break;
            }
            valueList.add(value);
        }
        return valueList;
    }

    public static List<Integer> parseIntegerList(String target) {
        List<String> list = MZTabUtils.parseStringList('|', target);
        ArrayList<Integer> valueList = new ArrayList<Integer>(124);
        for (String item : list) {
            Integer value = MZTabUtils.parseInteger(item);
            if (value == null) {
                valueList.clear();
                break;
            }
            valueList.add(value);
        }
        return valueList;
    }

    public static URI parseURI(String target) {
        URI uri;
        if ((target = MZTabStringUtils.parseString((String)target)) == null) {
            return null;
        }
        try {
            uri = new URI(target);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        return uri;
    }

    public static Publication parsePublicationItems(Publication publication, int lineNumber, String target) throws MZTabException {
        List<String> list = MZTabUtils.parseStringList('|', target);
        for (String pub : list) {
            if ((pub = MZTabStringUtils.parseString((String)pub).toLowerCase()) == null) {
                publication.getPublicationItems().clear();
                return publication;
            }
            String[] items = pub.split(":");
            if (items.length == 2) {
                PublicationItem.TypeEnum type = PublicationItem.TypeEnum.fromValue((String)items[0]);
                if (type == null) {
                    throw new MZTabException(new MZTabError(FormatErrorType.Publication, lineNumber, new String[]{target, pub}));
                }
                String accession = items[1].trim();
                PublicationItem item = new PublicationItem().type(type).accession(accession);
                publication.addPublicationItemsItem(item);
                continue;
            }
            throw new MZTabException(new MZTabError(FormatErrorType.Publication, lineNumber, new String[]{target, pub}));
        }
        return publication;
    }

    public static List<SpectraRef> parseSpectraRefList(MZTabParserContext context, Metadata metadata, String target) {
        List<String> list = MZTabUtils.parseStringList('|', target);
        ArrayList<SpectraRef> refList = new ArrayList<SpectraRef>();
        Pattern pattern = Pattern.compile("ms_run\\[(\\d+)\\]:(.*)");
        for (String item : list) {
            Matcher matcher = pattern.matcher(item.trim());
            if (!matcher.find()) continue;
            Integer ms_file_id = new Integer(matcher.group(1));
            String reference = matcher.group(2);
            MsRun msRun = (MsRun)context.getMsRunMap().get(ms_file_id);
            SpectraRef ref = msRun == null ? null : new SpectraRef().msRun(msRun).reference(reference);
            if (ref == null) {
                refList.clear();
                break;
            }
            refList.add(ref);
        }
        return refList;
    }

    public static String translateMinusToUnicode(String target) {
        Pattern pattern = Pattern.compile("(CHEMMOD:.*)(-)(.*)");
        Matcher matcher = pattern.matcher(target);
        StringBuilder sb = new StringBuilder();
        if (matcher.find()) {
            sb.append(matcher.group(1));
            sb.append("&minus;");
            sb.append(matcher.group(3));
        } else {
            sb.append(target);
        }
        return sb.toString();
    }

    public static String translateMinusInCVtoUnicode(String target) {
        Pattern pattern = Pattern.compile("\\[([^\\[\\]]+)\\]");
        Matcher matcher = pattern.matcher(target);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start(1);
            sb.append(target.substring(start, end));
            sb.append(matcher.group(1).replaceAll("-", "&minus;"));
            start = matcher.end(1);
        }
        sb.append(target.substring(start, target.length()));
        return sb.toString();
    }

    public static String translateUnicodeCVTermMinus(String target) {
        return target.replaceAll("&minus;", "-");
    }

    public static String translateUnicodeToMinus(String target) {
        Pattern pattern = Pattern.compile("(.*CHEMMOD:.*)(&minus;)(.*)");
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            StringBuilder sb = new StringBuilder();
            sb.append(matcher.group(1));
            sb.append("-");
            sb.append(matcher.group(3));
            return sb.toString();
        }
        return target;
    }

    public static String translateCommaToTab(String target) {
        Pattern pattern = Pattern.compile("\\[([^\\[\\]]+)\\]");
        Matcher matcher = pattern.matcher(target);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start(1);
            sb.append(target.substring(start, end));
            sb.append(matcher.group(1).replaceAll(",", "\t"));
            start = matcher.end(1);
        }
        sb.append(target.substring(start, target.length()));
        return sb.toString();
    }

    public static String translateTabToComma(String target) {
        Pattern pattern = Pattern.compile("\\[([^\\[\\]]+)\\]");
        Matcher matcher = pattern.matcher(target);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start(1);
            sb.append(target.substring(start, end));
            sb.append(matcher.group(1).replaceAll("\t", ","));
            start = matcher.end(1);
        }
        sb.append(target.substring(start, target.length()));
        return sb.toString();
    }

    public static String translateMinusToTab(String target) {
        Pattern pattern = Pattern.compile("\\[([^\\[\\]]+)\\]");
        Matcher matcher = pattern.matcher(target);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start(1);
            sb.append(target.substring(start, end));
            sb.append(matcher.group(1).replaceAll("-", "\t"));
            start = matcher.end(1);
        }
        sb.append(target.substring(start, target.length()));
        return sb.toString();
    }

    private static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }

    public static String translateLastToTab(String target) {
        Pattern pattern = Pattern.compile("\\[([^\\[\\]]+)\\]");
        Matcher matcher = pattern.matcher(target);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start(1);
            sb.append(target.substring(start, end));
            sb.append(MZTabUtils.replaceLast(matcher.group(1), "-", "\t"));
            start = matcher.end(1);
        }
        sb.append(target.substring(start, target.length()));
        return sb.toString();
    }

    public static String translateTabToMinus(String target) {
        Pattern pattern = Pattern.compile("\\[([^\\[\\]]+)\\]");
        Matcher matcher = pattern.matcher(target);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start(1);
            sb.append(target.substring(start, end));
            sb.append(matcher.group(1).replaceAll("\t", "-"));
            start = matcher.end(1);
        }
        sb.append(target.substring(start, target.length()));
        return sb.toString();
    }

    public static String removeDoubleQuotes(String value) {
        if (value != null) {
            value = value.trim();
            int length = value.length();
            value = value.replace("\"", "");
            int count = length - value.length();
            if (MZTabStringUtils.isEmpty((String)value)) {
                value = null;
            }
            if (count > 2) {
                LOGGER.warn("Nested double quotes in value, " + count + " occurrences have been replaced.");
            }
        }
        return value;
    }
}

