/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.SmallMoleculeSummary;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.AbundanceColumn;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeColumn;

public class SmallMoleculeSummarySerializer
extends StdSerializer<SmallMoleculeSummary> {
    private static final Logger log = LoggerFactory.getLogger(SmallMoleculeSummarySerializer.class);

    public SmallMoleculeSummarySerializer() {
        this(null);
    }

    public SmallMoleculeSummarySerializer(Class<SmallMoleculeSummary> t) {
        super(t);
    }

    public void serializeWithType(SmallMoleculeSummary value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(SmallMoleculeSummary smallMoleculeSummary, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (smallMoleculeSummary != null) {
            jg.writeStartObject();
            Serializers.writeString(SmallMoleculeSummary.HeaderPrefixEnum.SMH.getValue(), jg, SmallMoleculeSummary.PrefixEnum.SML.getValue());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.SML_ID), jg, smallMoleculeSummary.getSmlId());
            Serializers.writeAsNumberArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.SMF_ID_REFS), jg, Optional.ofNullable(smallMoleculeSummary.getSmfIdRefs()).orElse(Collections.emptyList()));
            Serializers.writeAsStringArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.DATABASE_IDENTIFIER), jg, (List<String>)smallMoleculeSummary.getDatabaseIdentifier());
            Serializers.writeAsStringArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.CHEMICAL_FORMULA), jg, (List<String>)smallMoleculeSummary.getChemicalFormula());
            Serializers.writeAsStringArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.SMILES), jg, (List<String>)smallMoleculeSummary.getSmiles());
            Serializers.writeAsStringArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.INCHI), jg, (List<String>)smallMoleculeSummary.getInchi());
            Serializers.writeAsStringArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.CHEMICAL_NAME), jg, (List<String>)smallMoleculeSummary.getChemicalName());
            Serializers.writeAsStringArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.URI), jg, (List<String>)smallMoleculeSummary.getUri());
            Serializers.writeAsNumberArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.THEOR_NEUTRAL_MASS), jg, (List<? extends Number>)smallMoleculeSummary.getTheoreticalNeutralMass());
            Serializers.writeAsStringArray(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.ADDUCT_IONS), jg, (List<String>)smallMoleculeSummary.getAdductIons());
            Serializers.writeString(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.RELIABILITY), jg, smallMoleculeSummary.getReliability());
            Serializers.writeObject(SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.BEST_ID_CONFIDENCE_MEASURE), jg, sp, (Object)smallMoleculeSummary.getBestIdConfidenceMeasure());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeColumn.Stable.columnFor(SmallMoleculeColumn.Stable.BEST_ID_CONFIDENCE_VALUE), jg, smallMoleculeSummary.getBestIdConfidenceValue());
            Serializers.writeIndexedDoubles(AbundanceColumn.Field.ABUNDANCE_ASSAY.toString(), jg, Optional.ofNullable(smallMoleculeSummary.getAbundanceAssay()).orElse(Collections.emptyList()));
            Serializers.writeIndexedDoubles(AbundanceColumn.Field.ABUNDANCE_STUDY_VARIABLE.toString(), jg, Optional.ofNullable(smallMoleculeSummary.getAbundanceStudyVariable()).orElse(Collections.emptyList()));
            Serializers.writeIndexedDoubles(AbundanceColumn.Field.ABUNDANCE_VARIATION_STUDY_VARIABLE.toString(), jg, Optional.ofNullable(smallMoleculeSummary.getAbundanceVariationStudyVariable()).orElse(Collections.emptyList()));
            Serializers.writeOptColumnMappings(smallMoleculeSummary.getOpt(), jg, sp);
            jg.writeEndObject();
        } else {
            log.debug(SmallMoleculeSummary.class.getSimpleName() + " is null!");
        }
    }
}

