/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Sample;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class SampleSerializer
extends StdSerializer<Sample> {
    private static final Logger log = LoggerFactory.getLogger(SampleSerializer.class);

    public SampleSerializer() {
        this(null);
    }

    public SampleSerializer(Class<Sample> t) {
        super(t);
    }

    public void serializeWithType(Sample value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(Sample sample, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (sample != null) {
            Serializers.checkIndexedElement((IndexedElement)sample);
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), null, sample, sample.getName());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Sample.Properties.description.getPropertyName(), sample, sample.getDescription());
            Serializers.addSubElementParameters(jg, Section.Metadata.getPrefix(), sample, Sample.Properties.species.getPropertyName(), sample.getSpecies(), false);
            Serializers.addSubElementParameters(jg, Section.Metadata.getPrefix(), sample, Sample.Properties.cellType.getPropertyName(), sample.getCellType(), false);
            Serializers.addSubElementParameters(jg, Section.Metadata.getPrefix(), sample, Sample.Properties.disease.getPropertyName(), sample.getDisease(), false);
            Serializers.addSubElementParameters(jg, Section.Metadata.getPrefix(), sample, Sample.Properties.tissue.getPropertyName(), sample.getTissue(), false);
            Serializers.addSubElementParameters(jg, Section.Metadata.getPrefix(), sample, Sample.Properties.custom.getPropertyName(), sample.getCustom(), false);
        } else {
            log.debug(Sample.class.getSimpleName() + " is null!");
        }
    }
}

