/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.Sample;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class AssaySerializer
extends StdSerializer<Assay> {
    private static final Logger log = LoggerFactory.getLogger(AssaySerializer.class);

    public AssaySerializer() {
        this(null);
    }

    public AssaySerializer(Class<Assay> t) {
        super(t);
    }

    public void serializeWithType(Assay value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(Assay assay, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (assay != null) {
            Sample sampleRef;
            Serializers.checkIndexedElement((IndexedElement)assay);
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), null, assay, assay.getName());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Assay.Properties.externalUri.getPropertyName(), assay, assay.getExternalUri());
            Serializers.addSubElementStrings(jg, Section.Metadata.getPrefix(), assay, Assay.Properties.custom.getPropertyName(), assay.getCustom(), false);
            List msRunRef = assay.getMsRunRef();
            if (msRunRef != null) {
                Serializers.addSubElementStrings(jg, Section.Metadata.getPrefix(), assay, Assay.Properties.msRunRef.getPropertyName(), msRunRef.stream().sorted(Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder()))).map(mref -> Metadata.Properties.msRun.getPropertyName() + "[" + mref.getId() + "]").collect(Collectors.toList()), true);
            }
            if ((sampleRef = assay.getSampleRef()) != null) {
                Serializers.addSubElementStrings(jg, Section.Metadata.getPrefix(), assay, Assay.Properties.sampleRef.getPropertyName(), Arrays.asList(sampleRef).stream().sorted(Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder()))).map(sref -> Metadata.Properties.sample.getPropertyName() + "[" + sref.getId() + "]").collect(Collectors.toList()), true);
            }
        } else {
            log.debug(Assay.class.getSimpleName() + " is null!");
        }
    }
}

