/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io;

import de.isas.lipidomics.mztab2.validation.Validator;
import de.isas.mztab2.io.MzTabFileParser;
import de.isas.mztab2.io.MzTabNonValidatingWriter;
import de.isas.mztab2.io.MzTabWriter;
import de.isas.mztab2.io.MzTabWriterDefaults;
import de.isas.mztab2.model.MzTab;
import de.isas.mztab2.model.ValidationMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorType;

public class MzTabValidatingWriter
implements MzTabWriter<List<ValidationMessage>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MzTabValidatingWriter.class);
    private final Validator<MzTab> validator;
    private final boolean skipWriteOnValidationFailure;
    private final MzTabWriterDefaults writerDefaults;
    private List<ValidationMessage> validationMessages = null;

    public MzTabValidatingWriter() {
        this(new WriteAndParseValidator(System.out, MZTabErrorType.Level.Info, 100), new MzTabWriterDefaults(), true);
    }

    public MzTabValidatingWriter(Validator<MzTab> validator, boolean skipWriteOnValidationFailure) {
        this(validator, new MzTabWriterDefaults(), skipWriteOnValidationFailure);
    }

    public MzTabValidatingWriter(Validator<MzTab> validator, MzTabWriterDefaults writerDefaults, boolean skipWriteOnValidationFailure) {
        this.validator = validator;
        this.writerDefaults = writerDefaults;
        this.skipWriteOnValidationFailure = skipWriteOnValidationFailure;
    }

    @Override
    public Optional<List<ValidationMessage>> write(OutputStreamWriter writer, MzTab mzTab) throws IOException {
        this.validationMessages = Optional.ofNullable(this.validator.validate((Object)mzTab)).orElse(Collections.emptyList());
        if (this.skipWriteOnValidationFailure && !this.validationMessages.isEmpty()) {
            return Optional.of(this.validationMessages);
        }
        new MzTabNonValidatingWriter(this.writerDefaults).write(writer, mzTab);
        return Optional.of(this.validationMessages);
    }

    @Override
    public Optional<List<ValidationMessage>> write(Path path, MzTab mzTab) throws IOException {
        this.validationMessages = Optional.ofNullable(this.validator.validate((Object)mzTab)).orElse(Collections.emptyList());
        if (this.skipWriteOnValidationFailure && !this.validationMessages.isEmpty()) {
            return Optional.of(this.validationMessages);
        }
        new MzTabNonValidatingWriter(this.writerDefaults).write(path, mzTab);
        return Optional.of(this.validationMessages);
    }

    public static List<ValidationMessage> getValidationMessagesForLevel(Optional<List<ValidationMessage>> validationMessages, ValidationMessage.MessageTypeEnum level) {
        return validationMessages.orElse(Collections.emptyList()).stream().filter(message -> message.getMessageType() == level).collect(Collectors.toList());
    }

    public static class WriteAndParseValidator
    implements Validator<MzTab> {
        private static final Logger LOGGER = LoggerFactory.getLogger(WriteAndParseValidator.class);
        private final OutputStream outputStream;
        private final MZTabErrorType.Level level;
        private final int maxErrorCount;

        public WriteAndParseValidator(OutputStream outputStream, MZTabErrorType.Level level, int maxErrorCount) {
            this.outputStream = outputStream;
            this.level = level;
            this.maxErrorCount = maxErrorCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public List<ValidationMessage> validate(MzTab mzTab) {
            List list;
            OutputStreamWriter osw;
            File mzTabFile;
            block11: {
                MzTabNonValidatingWriter writer = new MzTabNonValidatingWriter();
                mzTabFile = null;
                mzTabFile = File.createTempFile(UUID.randomUUID().toString(), ".mztab");
                osw = new OutputStreamWriter((OutputStream)new FileOutputStream(mzTabFile), StandardCharsets.UTF_8);
                writer.write(osw, mzTab);
                MzTabFileParser parser = new MzTabFileParser(mzTabFile);
                parser.parse(this.outputStream, this.level, this.maxErrorCount);
                list = parser.getErrorList().convertToValidationMessages();
                osw.close();
                if (mzTabFile == null || !mzTabFile.exists() || mzTabFile.delete()) break block11;
                LOGGER.warn("Deletion of " + mzTabFile + " failed!");
            }
            return list;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                osw.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            LOGGER.error("Caught exception while trying to parse " + mzTabFile, (Throwable)ex);
                            if (mzTabFile != null && mzTabFile.exists() && !mzTabFile.delete()) {
                                LOGGER.warn("Deletion of " + mzTabFile + " failed!");
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (mzTabFile != null && mzTabFile.exists() && !mzTabFile.delete()) {
                            LOGGER.warn("Deletion of " + mzTabFile + " failed!");
                        }
                        throw throwable3;
                    }
                }
            }
            return Collections.emptyList();
        }
    }
}

