/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.dbutilities.Base64;
import at.tugraz.genome.lda.xml.AddScan;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgScan;
import at.tugraz.genome.maspectras.quantification.CgScanHeader;
import at.tugraz.genome.maspectras.quantification.MsMsScan;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.maspectras.utils.StringUtils;
import at.tugraz.genome.voutils.GeneralComparator;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class RawToChromThread
extends Thread
implements AddScan {
    private boolean finished_ = false;
    private String errorString_ = null;
    private String[] directories_;
    private Integer lowerThreshInt_;
    private Integer upperThreshInt_;
    private Float lowerThresholdTol_;
    private Float upperThresholdTol_;
    private Hashtable<String, Integer> m_scanCount_;
    private Hashtable<String, Hashtable<Integer, Integer>> polarity_scanCount_;
    private Hashtable<String, CgScanHeader> headerHash_;
    private Hashtable<String, CgScan[]> scanHash_;
    private Hashtable<String, Hashtable<Integer, CgScan[]>> polarityScans_;
    private int elementsForBatchCalculation_;
    private boolean msms_ = false;
    private boolean msmsInSeveralFiles_;
    private int multiplicationFactorForInt_;
    private int lowestResolution_;
    private int lowestMz_;
    private int highestMz_;
    private int highestMsLevel_;
    private Hashtable<String, Hashtable<Integer, Integer>> msMsExclusionList_ = new Hashtable();
    private Hashtable<String, Hashtable<Integer, Hashtable<Integer, Integer>>> numberOfMs2Scans_;
    private String currentFileName_;
    private static final String NO_NAME_PLACEHOLDER = "";
    private static final float ALLOWED_OVERLAP = 1.0f;
    private Hashtable<String, String[]> chromFileName_ = new Hashtable();
    private Hashtable<String, String[]> indexFileName_ = new Hashtable();
    private Hashtable<String, String[]> retentionTimeFileName_ = new Hashtable();
    private CgScan positiveDummyMS1Scan_ = null;
    private CgScan negativeDummyMS1Scan_ = null;
    public static final String FILE_SUFFIX_POLARITY_POSITIVE = "_positive";
    public static final String FILE_SUFFIX_POLARITY_NEGATIVE = "_negative";

    private RawToChromThread() {
    }

    public RawToChromThread(boolean msms, int multiplicationFactorForInt, int lowestResolution, int highestMsLevel) {
        this();
        this.msms_ = msms;
        this.multiplicationFactorForInt_ = multiplicationFactorForInt;
        this.lowestResolution_ = lowestResolution;
        this.highestMsLevel_ = highestMsLevel;
    }

    public RawToChromThread(RawToChromThread otherThread) {
        this();
        this.chromFileName_ = otherThread.chromFileName_;
        this.indexFileName_ = otherThread.indexFileName_;
        this.retentionTimeFileName_ = otherThread.retentionTimeFileName_;
        this.elementsForBatchCalculation_ = otherThread.elementsForBatchCalculation_;
        this.msms_ = otherThread.msms_;
        this.msmsInSeveralFiles_ = otherThread.msmsInSeveralFiles_;
        this.multiplicationFactorForInt_ = otherThread.multiplicationFactorForInt_;
        this.lowestResolution_ = otherThread.lowestResolution_;
        this.lowestMz_ = otherThread.lowestMz_;
        this.highestMz_ = otherThread.highestMz_;
        this.highestMsLevel_ = otherThread.highestMsLevel_;
    }

    @Override
    public void run() {
        try {
            this.writeToChrom();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorString_ = ex.toString();
        }
        this.finished_ = true;
    }

    public void setRequiredInformation(String[] directories, Integer lowerThreshold, Integer upperThreshold) {
        this.directories_ = directories;
        this.lowerThreshInt_ = lowerThreshold;
        this.lowerThresholdTol_ = Float.valueOf(lowerThreshold.floatValue() / (float)this.multiplicationFactorForInt_ - 1.0f);
        int lowerThreshIntTol = RawToChromThread.getCorrespondingIntValue(this.lowerThresholdTol_.floatValue(), this.multiplicationFactorForInt_);
        if (lowerThreshIntTol < this.lowestMz_) {
            this.lowerThresholdTol_ = Float.valueOf((float)this.lowestMz_ / (float)this.multiplicationFactorForInt_);
        }
        this.upperThreshInt_ = upperThreshold;
        this.upperThresholdTol_ = Float.valueOf(upperThreshold.floatValue() / (float)this.multiplicationFactorForInt_ + 1.0f);
        int upperThreshIntTol = RawToChromThread.getCorrespondingIntValue(this.upperThresholdTol_.floatValue(), this.multiplicationFactorForInt_);
        if (upperThreshIntTol > this.highestMz_) {
            this.upperThresholdTol_ = Float.valueOf((float)(this.highestMz_ + 1) / (float)this.multiplicationFactorForInt_);
        }
        this.initStoreHashes();
    }

    @Override
    public void AddScan(CgScan sx) throws CgException {
        if (!this.scanHash_.containsKey(this.currentFileName_)) {
            throw new CgException("m_scans Array not allocated");
        }
        if (this.scanHash_.get(this.currentFileName_).length == this.m_scanCount_.get(this.currentFileName_)) {
            return;
        }
        this.scanHash_.get((Object)this.currentFileName_)[this.m_scanCount_.get((Object)this.currentFileName_).intValue()] = sx;
        this.m_scanCount_.put(this.currentFileName_, this.m_scanCount_.get(this.currentFileName_) + 1);
        this.polarity_scanCount_.get(this.currentFileName_).put(sx.getPolarity(), this.polarity_scanCount_.get(this.currentFileName_).get(sx.getPolarity()) + 1);
    }

    @Override
    public void AddHeader(CgScanHeader hx) throws CgException {
        this.currentFileName_ = NO_NAME_PLACEHOLDER;
        if (hx.fileName != null) {
            this.currentFileName_ = hx.fileName;
        }
        this.headerHash_.put(this.currentFileName_, hx);
        this.scanHash_.put(this.currentFileName_, new CgScan[hx.ScanCount]);
        this.m_scanCount_.put(this.currentFileName_, 0);
        Hashtable<Integer, Integer> polarityScans = new Hashtable<Integer, Integer>();
        polarityScans.put(0, 0);
        polarityScans.put(1, 0);
        polarityScans.put(2, 0);
        this.polarity_scanCount_.put(this.currentFileName_, polarityScans);
    }

    @Override
    public void setStartStopHeader(CgScanHeader hx) throws CgException {
        if (!this.headerHash_.containsKey(this.currentFileName_)) {
            throw new CgException("No header defined");
        }
        this.headerHash_.get((Object)this.currentFileName_).StartTime = hx.StartTime;
        this.headerHash_.get((Object)this.currentFileName_).EndTime = hx.EndTime;
    }

    @Override
    public CgScan getLastBaseScan() {
        for (int i = this.m_scanCount_.get(this.currentFileName_) - 1; i > -1; --i) {
            if (!this.scanHash_.containsKey(this.currentFileName_) || this.scanHash_.get((Object)this.currentFileName_)[i].MsLevel != 1) continue;
            return this.scanHash_.get(this.currentFileName_)[i];
        }
        return null;
    }

    @Override
    public void addParentFileName(String fileName) throws CgException {
        if (this.currentFileName_.equalsIgnoreCase(NO_NAME_PLACEHOLDER)) {
            CgScanHeader header = this.headerHash_.get(this.currentFileName_);
            header.fileName = fileName;
            this.headerHash_.remove(this.currentFileName_);
            CgScan[] scans = this.scanHash_.get(this.currentFileName_);
            this.scanHash_.remove(this.currentFileName_);
            Integer count = this.m_scanCount_.get(this.currentFileName_);
            this.m_scanCount_.remove(this.currentFileName_);
            Hashtable<Integer, Integer> polarityCount = this.polarity_scanCount_.get(this.currentFileName_);
            this.polarity_scanCount_.remove(this.currentFileName_);
            this.currentFileName_ = fileName;
            header.fileName = fileName;
            this.headerHash_.put(this.currentFileName_, header);
            this.scanHash_.put(this.currentFileName_, scans);
            this.m_scanCount_.put(this.currentFileName_, count);
            this.polarity_scanCount_.put(this.currentFileName_, polarityCount);
        }
    }

    @Override
    public float getLowerThreshold() {
        return this.lowerThresholdTol_.floatValue();
    }

    @Override
    public float getUpperThreshold() {
        return this.upperThresholdTol_.floatValue();
    }

    private void initStoreHashes() {
        this.m_scanCount_ = new Hashtable();
        this.scanHash_ = new Hashtable();
        this.headerHash_ = new Hashtable();
        this.polarity_scanCount_ = new Hashtable();
    }

    public void writeToChrom() throws IOException {
        if (this.directories_[1] == null) {
            this.writeToChrom(this.directories_[0], 0);
        } else {
            this.sortPolaritySwitchedScans();
            this.writeToChrom(this.directories_[0], 1);
            this.writeToChrom(this.directories_[1], 2);
        }
    }

    private void writeToChrom(String dir, int polarity) throws IOException {
        int filePosition = 0;
        if (polarity == 2) {
            filePosition = 1;
        }
        Hashtable<String, Vector<Hashtable<Integer, Float>>> msmsRetentionTimes = this.buildHeaderInformation();
        Hashtable<String, Vector<LinkedHashMap<String, Vector<MsMsScan>>>> msmsScans = this.groupTheMsMsScans(msmsRetentionTimes, polarity);
        Hashtable<String, BufferedOutputStream> stream = new Hashtable<String, BufferedOutputStream>();
        Hashtable<String, DataOutputStream> streamIndex = new Hashtable<String, DataOutputStream>();
        Hashtable<String, float[][]> intensityValuesSection = new Hashtable<String, float[][]>();
        Hashtable<String, Vector<BufferedOutputStream>> msmsChromStreams = new Hashtable<String, Vector<BufferedOutputStream>>();
        Hashtable<String, Vector<DataOutputStream>> msmsIndexStreams = new Hashtable<String, Vector<DataOutputStream>>();
        Hashtable<String, Hashtable<Integer, Integer>> mzIndizes = new Hashtable<String, Hashtable<Integer, Integer>>();
        Hashtable<String, Hashtable<Integer, Long>> bytesIndices = new Hashtable<String, Hashtable<Integer, Long>>();
        float floatOfLowerMz = 0.0f;
        float floatOfUpperMz = 100000.0f;
        if (this.lowerThreshInt_ != null && this.lowerThreshInt_ > 0) {
            floatOfLowerMz = this.lowerThreshInt_.floatValue() / (float)this.multiplicationFactorForInt_;
            floatOfUpperMz = this.upperThreshInt_.floatValue() / (float)this.multiplicationFactorForInt_;
        }
        for (String string : this.headerHash_.keySet()) {
            stream.put(string, new BufferedOutputStream(new FileOutputStream(dir + this.chromFileName_.get(string)[filePosition])));
            streamIndex.put(string, new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dir + this.indexFileName_.get(string)[filePosition]))));
            msmsChromStreams.put(string, new Vector());
            msmsIndexStreams.put(string, new Vector());
            mzIndizes.put(string, new Hashtable());
            bytesIndices.put(string, new Hashtable());
            if (!this.msms_ || this.msmsInSeveralFiles_) continue;
            for (int i = 2; i <= this.highestMsLevel_; ++i) {
                BufferedOutputStream streamChrom2 = new BufferedOutputStream(new FileOutputStream(dir + this.chromFileName_.get(string)[filePosition] + String.valueOf(i)));
                msmsChromStreams.get(string).add(streamChrom2);
                DataOutputStream streamIndex2 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dir + this.indexFileName_.get(string)[filePosition] + String.valueOf(i))));
                msmsIndexStreams.get(string).add(streamIndex2);
                int currentResDiffToLowest = 0;
                if (this.lowerThreshInt_ != null && this.lowerThreshInt_ > 0) {
                    currentResDiffToLowest = (this.lowerThreshInt_ - this.lowestMz_) / this.lowestResolution_;
                    boolean isFullMultiplicationFactor = true;
                    if (currentResDiffToLowest % (this.elementsForBatchCalculation_ * this.lowestResolution_) != 0) {
                        isFullMultiplicationFactor = false;
                    }
                    currentResDiffToLowest = currentResDiffToLowest / (this.elementsForBatchCalculation_ * this.lowestResolution_) * (this.elementsForBatchCalculation_ * this.lowestResolution_);
                    if (!isFullMultiplicationFactor) {
                        currentResDiffToLowest += this.elementsForBatchCalculation_ * this.lowestResolution_;
                    }
                }
                mzIndizes.get(string).put(i - 2, currentResDiffToLowest);
                bytesIndices.get(string).put(i - 2, 0L);
            }
        }
        this.writeChrom2(msmsChromStreams, msmsIndexStreams, msmsScans, mzIndizes, bytesIndices, Float.valueOf(floatOfLowerMz), Float.valueOf(floatOfUpperMz));
        Hashtable<String, Long> bytesIndex = new Hashtable<String, Long>();
        for (String key : this.headerHash_.keySet()) {
            bytesIndex.put(key, 0L);
            intensityValuesSection.put(key, this.createIntensityArray(this.getCorrectScanCount(key, polarity), this.elementsForBatchCalculation_));
        }
        if ((this.lowerThreshInt_ - this.lowestMz_) / this.lowestResolution_ % this.elementsForBatchCalculation_ != 0) {
            int startValue = this.lowerThreshInt_ - (this.lowerThreshInt_ - this.lowestMz_) % (this.elementsForBatchCalculation_ * this.lowestResolution_);
            for (String key : this.headerHash_.keySet()) {
                CgScan[] scans = this.getCorrectScans(key, polarity);
                for (int j = 0; j < this.getCorrectScanCount(key, polarity); ++j) {
                    scans[j].fillIntensitiyArray(((float[][])intensityValuesSection.get(key))[j], Float.parseFloat(String.valueOf(startValue)) / (float)this.multiplicationFactorForInt_, Float.parseFloat(String.valueOf(startValue + this.elementsForBatchCalculation_ * this.lowestResolution_)) / (float)this.multiplicationFactorForInt_, this.elementsForBatchCalculation_);
                }
            }
        }
        for (int i = this.lowerThreshInt_.intValue(); i < this.upperThreshInt_; i += this.lowestResolution_) {
            if ((i - this.lowestMz_) / this.lowestResolution_ % this.elementsForBatchCalculation_ == 0) {
                for (String key : this.headerHash_.keySet()) {
                    CgScan[] scans = this.getCorrectScans(key, polarity);
                    for (int j = 0; j < this.getCorrectScanCount(key, polarity); ++j) {
                        scans[j].fillIntensitiyArray(((float[][])intensityValuesSection.get(key))[j], Float.parseFloat(String.valueOf(i)) / (float)this.multiplicationFactorForInt_, Float.parseFloat(String.valueOf(i + this.elementsForBatchCalculation_ * this.lowestResolution_)) / (float)this.multiplicationFactorForInt_, this.elementsForBatchCalculation_);
                    }
                }
            }
            for (String key : this.headerHash_.keySet()) {
                Vector<Integer> scanNumbers = new Vector<Integer>();
                Vector<Float> intensities = new Vector<Float>();
                for (int j = 0; j < this.getCorrectScanCount(key, polarity); ++j) {
                    float f = ((float[][])intensityValuesSection.get(key))[j][(i - this.lowestMz_) / this.lowestResolution_ % this.elementsForBatchCalculation_];
                    if (!(f > 0.0f)) continue;
                    scanNumbers.add(new Integer(j));
                    intensities.add(Float.valueOf(f));
                }
                String chromString = NO_NAME_PLACEHOLDER;
                if (scanNumbers.size() > 0) {
                    ByteBuffer buffer = ByteBuffer.allocate(scanNumbers.size() * 2 * 4);
                    for (int j = 0; j != scanNumbers.size(); ++j) {
                        buffer.putInt((Integer)scanNumbers.get(j));
                        buffer.putFloat(((Float)intensities.get(j)).floatValue());
                    }
                    chromString = String.valueOf(Base64.encode(buffer.array()));
                }
                byte[] bytesToWrite = (chromString + "\n").getBytes();
                ((BufferedOutputStream)stream.get(key)).write(bytesToWrite);
                long bytesIdx = (Long)bytesIndex.get(key);
                if ((i - this.lowestMz_) / this.lowestResolution_ % 1000 == 0) {
                    ((DataOutputStream)streamIndex.get(key)).writeInt((i - this.lowestMz_) / this.lowestResolution_);
                    ((DataOutputStream)streamIndex.get(key)).writeLong(bytesIdx);
                }
                bytesIndex.put(key, bytesIdx += (long)bytesToWrite.length);
            }
        }
        if (this.numberOfMs2Scans_ == null) {
            this.numberOfMs2Scans_ = new Hashtable();
        }
        for (String key : this.headerHash_.keySet()) {
            ((BufferedOutputStream)stream.get(key)).close();
            ((BufferedOutputStream)stream.get(key)).flush();
            ((DataOutputStream)streamIndex.get(key)).close();
            ((DataOutputStream)streamIndex.get(key)).flush();
            if (!this.msms_ || this.msmsInSeveralFiles_) continue;
            if (!this.numberOfMs2Scans_.containsKey(key)) {
                this.numberOfMs2Scans_.put(key, new Hashtable());
            }
            this.numberOfMs2Scans_.get(key).put(filePosition, new Hashtable());
            this.writeMs2RetentionTimes(dir, msmsRetentionTimes.get(key), this.numberOfMs2Scans_.get(key).get(filePosition), key, filePosition);
            for (int i = 0; i < this.highestMsLevel_ - 1; ++i) {
                BufferedOutputStream streamChrom2 = msmsChromStreams.get(key).get(i);
                streamChrom2.close();
                streamChrom2.flush();
                DataOutputStream streamIndex2 = msmsIndexStreams.get(key).get(i);
                streamIndex2.close();
                streamIndex2.flush();
            }
        }
        intensityValuesSection = null;
    }

    private CgScan[] getCorrectScans(String key, int polarity) {
        if (polarity == 1 || polarity == 2) {
            return this.polarityScans_.get(key).get(polarity);
        }
        return this.scanHash_.get(key);
    }

    private int getCorrectScanCount(String key, int polarity) {
        if (polarity == 1 || polarity == 2) {
            return this.polarity_scanCount_.get(key).get(polarity);
        }
        return this.m_scanCount_.get(key);
    }

    private Hashtable<String, Vector<Hashtable<Integer, Float>>> buildHeaderInformation() {
        for (String fileName : this.headerHash_.keySet()) {
            this.msMsExclusionList_.put(fileName, new Hashtable());
        }
        Hashtable<String, Vector<Hashtable<Integer, Float>>> msmsRetentionTimes = new Hashtable<String, Vector<Hashtable<Integer, Float>>>();
        for (String key : this.headerHash_.keySet()) {
            Vector retsOneMzxml = new Vector();
            for (int i = 2; i <= this.highestMsLevel_; ++i) {
                retsOneMzxml.add(new Hashtable());
            }
            msmsRetentionTimes.put(key, retsOneMzxml);
        }
        return msmsRetentionTimes;
    }

    private Hashtable<String, Vector<LinkedHashMap<String, Vector<MsMsScan>>>> groupTheMsMsScans(Hashtable<String, Vector<Hashtable<Integer, Float>>> retentionTimes, int polarity) {
        Hashtable<String, Vector<LinkedHashMap<String, Vector<MsMsScan>>>> msmsScans = new Hashtable<String, Vector<LinkedHashMap<String, Vector<MsMsScan>>>>();
        for (String key : this.headerHash_.keySet()) {
            Vector scansOfOneMzXML = new Vector();
            Hashtable<Integer, Integer> exclusionList = this.msMsExclusionList_.get(key);
            for (int i = 2; i <= this.highestMsLevel_; ++i) {
                ArrayList<MsMsScan> scansOfOneLevel = new ArrayList<MsMsScan>();
                Hashtable<Integer, Float> rets = retentionTimes.get(key).get(i - 2);
                CgScan[] scans = null;
                if (polarity == 1) {
                    scans = this.polarityScans_.get(key).get(1);
                    if (this.positiveDummyMS1Scan_ != null) {
                        this.addSubScansToLists(this.positiveDummyMS1Scan_, i, scansOfOneLevel, rets, exclusionList);
                    }
                } else if (polarity == 2) {
                    scans = this.polarityScans_.get(key).get(2);
                    if (this.negativeDummyMS1Scan_ != null) {
                        this.addSubScansToLists(this.negativeDummyMS1Scan_, i, scansOfOneLevel, rets, exclusionList);
                    }
                } else {
                    scans = this.scanHash_.get(key);
                }
                for (CgScan msScan : scans) {
                    this.addSubScansToLists(msScan, i, scansOfOneLevel, rets, exclusionList);
                }
                Collections.sort(scansOfOneLevel, new GeneralComparator("at.tugraz.genome.maspectras.quantification.MsMsScan", "getMs1PrecursorMz", "java.lang.Float"));
                LinkedHashMap<String, Vector> sortedScans = new LinkedHashMap<String, Vector>();
                for (MsMsScan scan : scansOfOneLevel) {
                    Vector samePrecursorMass = new Vector();
                    if (sortedScans.containsKey(scan.getPrecursorMzAsString())) {
                        samePrecursorMass = (Vector)sortedScans.get(scan.getPrecursorMzAsString());
                    }
                    samePrecursorMass.add(scan);
                    if (samePrecursorMass.size() > 1) {
                        Collections.sort(samePrecursorMass, new GeneralComparator("at.tugraz.genome.maspectras.quantification.MsMsScan", "getNum", "java.lang.Integer"));
                    }
                    sortedScans.put(scan.getPrecursorMzAsString(), samePrecursorMass);
                }
                scansOfOneMzXML.add(sortedScans);
            }
            msmsScans.put(key, scansOfOneMzXML);
        }
        return msmsScans;
    }

    private void addSubScansToLists(CgScan msScan, int msLevel, List<MsMsScan> scansOfOneLevel, Hashtable<Integer, Float> rets, Hashtable<Integer, Integer> exclusionList) {
        if (msScan == null) {
            return;
        }
        for (CgScan subScan : msScan.getFullSubScans()) {
            if (subScan.MsLevel != msLevel || exclusionList.containsKey(subScan.Num)) continue;
            scansOfOneLevel.add((MsMsScan)subScan);
            rets.put(subScan.Num, Float.valueOf(subScan.RetentionTime));
            exclusionList.put(subScan.Num, subScan.Num);
        }
    }

    private float[][] createIntensityArray(int x, int y) {
        float[][] array = new float[x][y];
        return array;
    }

    private void writeChrom2(Hashtable<String, Vector<BufferedOutputStream>> msmsChromStreams, Hashtable<String, Vector<DataOutputStream>> msmsIndexStreams, Hashtable<String, Vector<LinkedHashMap<String, Vector<MsMsScan>>>> msmsScans, Hashtable<String, Hashtable<Integer, Integer>> mzIndices, Hashtable<String, Hashtable<Integer, Long>> bytesIndices, Float lowerThreshold, Float upperThreshold) throws IOException {
        String ms1PrecMzString = null;
        for (String key : this.headerHash_.keySet()) {
            Hashtable<Integer, Integer> mzIndicesOneMzxml = mzIndices.get(key);
            Hashtable<Integer, Long> byteIndicesOneMzxml = bytesIndices.get(key);
            for (int i = 0; i != msmsChromStreams.get(key).size(); ++i) {
                BufferedOutputStream stream = msmsChromStreams.get(key).get(i);
                DataOutputStream streamIndex = msmsIndexStreams.get(key).get(i);
                LinkedHashMap<String, Vector<MsMsScan>> scans = msmsScans.get(key).get(i);
                int mzIndex = mzIndices.get(key).get(i);
                long bytesIndex = bytesIndices.get(key).get(i);
                Iterator<String> iterator = scans.keySet().iterator();
                while (iterator.hasNext()) {
                    String scanKey;
                    ms1PrecMzString = scanKey = iterator.next();
                    if (scanKey.indexOf(" ") != -1) {
                        ms1PrecMzString = scanKey.substring(0, scanKey.indexOf(" "));
                    }
                    Float mzValue = new Float(ms1PrecMzString);
                    if (lowerThreshold != null && mzValue.floatValue() < lowerThreshold.floatValue()) continue;
                    int currentResDiffToLowest = (Math.round(Calculator.roundFloat(Float.parseFloat(ms1PrecMzString) * (float)this.multiplicationFactorForInt_, 0, 0)) - this.lowestMz_) / this.lowestResolution_;
                    while (currentResDiffToLowest >= mzIndex && mzIndex * this.lowestResolution_ < this.upperThreshInt_ - this.lowestMz_) {
                        streamIndex.writeInt(mzIndex);
                        streamIndex.writeLong(bytesIndex);
                        mzIndex += 1000;
                    }
                    if (upperThreshold != null && mzValue.floatValue() >= upperThreshold.floatValue()) continue;
                    boolean foundOneScan = false;
                    String toWrite = ">" + scanKey + "\n";
                    for (MsMsScan scan : scans.get(scanKey)) {
                        ByteBuffer buffer = ByteBuffer.allocate(scan.Scan.length * 2 * 4);
                        for (int j = 0; j < scan.Scan.length; ++j) {
                            buffer.putFloat(scan.Scan[j][0]);
                            buffer.putFloat(scan.Scan[j][1]);
                        }
                        if (scan.Scan.length <= 0) continue;
                        toWrite = toWrite + scan.Num + " " + String.valueOf(Base64.encode(buffer.array())) + "\n";
                        foundOneScan = true;
                    }
                    if (!foundOneScan) continue;
                    byte[] bytesToWrite = toWrite.getBytes();
                    stream.write(bytesToWrite);
                    bytesIndex += (long)bytesToWrite.length;
                }
                if (this.msms_ && scans.size() == 0) {
                    int currentResDiffToLowest = this.upperThreshInt_ - this.lowestMz_;
                    while (currentResDiffToLowest >= mzIndex && mzIndex * this.lowestResolution_ < this.upperThreshInt_ - this.lowestMz_) {
                        streamIndex.writeInt(mzIndex);
                        streamIndex.writeLong(bytesIndex);
                        mzIndex += 1000;
                    }
                }
                byteIndicesOneMzxml.put(i, bytesIndex);
                mzIndicesOneMzxml.put(i, mzIndex);
            }
            mzIndices.put(key, mzIndicesOneMzxml);
            bytesIndices.put(key, byteIndicesOneMzxml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMs2RetentionTimes(String directory, Vector<Hashtable<Integer, Float>> msmsRetentionTimes, Hashtable<Integer, Integer> numberOfMs2Scans, String fileName, int filePosition) throws IOException {
        for (int i = 2; i <= this.highestMsLevel_; ++i) {
            Hashtable<Integer, Float> rets = msmsRetentionTimes.get(i - 2);
            FilterOutputStream streamRetTime = null;
            ArrayList<Integer> scans = new ArrayList<Integer>();
            Set<Integer> keys = rets.keySet();
            for (Integer key : keys) {
                scans.add(key);
            }
            Collections.sort(scans);
            try {
                int count = 0;
                streamRetTime = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(directory + this.retentionTimeFileName_.get(fileName)[filePosition] + String.valueOf(i))));
                for (Integer key : scans) {
                    ((DataOutputStream)streamRetTime).writeInt(key);
                    ((DataOutputStream)streamRetTime).writeFloat(rets.get(key).floatValue());
                    ++count;
                }
                numberOfMs2Scans.put(i, count);
                continue;
            }
            catch (IOException iox) {
                iox.printStackTrace();
                continue;
            }
            finally {
                if (streamRetTime != null) {
                    streamRetTime.close();
                    ((DataOutputStream)streamRetTime).flush();
                }
            }
        }
    }

    public void setStaticInformation(int elementsForBatchCalculation, int lowestMz, int highestMz, Hashtable<String, String[]> chromFileName, Hashtable<String, String[]> indexFileName, Hashtable<String, String[]> retentionTimeFileName) {
        this.elementsForBatchCalculation_ = elementsForBatchCalculation;
        this.lowestMz_ = lowestMz;
        this.highestMz_ = highestMz;
        for (String key : chromFileName.keySet()) {
            String[] chromFiles = new String[2];
            chromFiles[0] = StringUtils.getJustFileName(chromFileName.get(key)[0]);
            if (chromFileName.get(key)[1] != null) {
                chromFiles[1] = StringUtils.getJustFileName(chromFileName.get(key)[1]);
            }
            this.chromFileName_.put(key, chromFiles);
            String[] indexFiles = new String[2];
            indexFiles[0] = StringUtils.getJustFileName(indexFileName.get(key)[0]);
            if (indexFileName.get(key)[1] != null) {
                indexFiles[1] = StringUtils.getJustFileName(indexFileName.get(key)[1]);
            }
            this.indexFileName_.put(key, indexFiles);
            String[] retentionTimeFiles = new String[2];
            retentionTimeFiles[0] = StringUtils.getJustFileName(retentionTimeFileName.get(key)[0]);
            if (retentionTimeFileName.get(key)[1] != null) {
                retentionTimeFiles[1] = StringUtils.getJustFileName(retentionTimeFileName.get(key)[1]);
            }
            this.retentionTimeFileName_.put(key, retentionTimeFiles);
        }
    }

    public void setReadXmlContent(Hashtable<String, CgScanHeader> headerHash, Hashtable<String, CgScan[]> scanHash, Hashtable<String, Integer> m_scanCount, Hashtable<String, Hashtable<Integer, Integer>> polarity_scanCount) {
        this.headerHash_ = headerHash;
        this.scanHash_ = scanHash;
        this.m_scanCount_ = m_scanCount;
        this.polarity_scanCount_ = polarity_scanCount;
    }

    public Hashtable<String, Integer> getm_scanCount() {
        return this.m_scanCount_;
    }

    public void writeRetentionTimeFile(Hashtable<String, String[]> retentionTimeFileName, boolean polaritySwitching) throws IOException {
        for (String key : retentionTimeFileName.keySet()) {
            if (polaritySwitching) {
                this.writeRetentionTimeFile(retentionTimeFileName.get(key)[0], this.getCorrectScanCount(key, 1), this.getCorrectScans(key, 1));
                this.writeRetentionTimeFile(retentionTimeFileName.get(key)[1], this.getCorrectScanCount(key, 2), this.getCorrectScans(key, 2));
                continue;
            }
            this.writeRetentionTimeFile(retentionTimeFileName.get(key)[0], this.getCorrectScanCount(key, 0), this.getCorrectScans(key, 0));
        }
    }

    public Hashtable<String, Hashtable<Integer, Hashtable<Integer, Integer>>> getNumberOfMs2Scans() {
        return this.numberOfMs2Scans_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRetentionTimeFile(String retFile, int scanCount, CgScan[] scans) throws IOException {
        FilterOutputStream streamRetTime = null;
        try {
            streamRetTime = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(retFile)));
            for (int i = 0; i < scanCount; ++i) {
                ((DataOutputStream)streamRetTime).writeInt(scans[i].Num);
                ((DataOutputStream)streamRetTime).writeFloat(scans[i].RetentionTime);
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        finally {
            if (streamRetTime != null) {
                streamRetTime.close();
                ((DataOutputStream)streamRetTime).flush();
            }
        }
    }

    public boolean finished() {
        return this.finished_;
    }

    public String getErrorString() {
        return this.errorString_;
    }

    public void cleanUp() {
        for (String key : this.headerHash_.keySet()) {
            CgScan[] scans;
            for (CgScan scan : scans = this.scanHash_.get(key)) {
                scan = null;
            }
            CgScanHeader header = this.headerHash_.get(key);
            header = null;
            Hashtable<Integer, Integer> exclusion = this.msMsExclusionList_.get(key);
            exclusion = null;
            Hashtable<Integer, Hashtable<Integer, Integer>> numberOfMs2 = this.numberOfMs2Scans_.get(key);
            if (numberOfMs2 != null) {
                for (Integer fileId : numberOfMs2.keySet()) {
                    Hashtable<Integer, Integer> ms2Ids = numberOfMs2.get(fileId);
                    ms2Ids = null;
                }
            }
            numberOfMs2 = null;
        }
        this.scanHash_ = null;
        this.headerHash_ = null;
        this.msMsExclusionList_ = null;
        this.numberOfMs2Scans_ = null;
    }

    private static int getCorrespondingIntValue(float mzValue, int multiplicationFactorForInt) {
        return (int)Calculator.roundFloat(mzValue * (float)multiplicationFactorForInt, 0, 1);
    }

    private void sortPolaritySwitchedScans() {
        this.polarityScans_ = new Hashtable();
        for (String key : this.scanHash_.keySet()) {
            int nrOfScans = this.m_scanCount_.get(key);
            CgScan[] allScans = this.scanHash_.get(key);
            Hashtable<Integer, CgScan[]> polarities = new Hashtable<Integer, CgScan[]>();
            CgScan lastPositiveMS1Scan = null;
            CgScan lastNegativeMS1Scan = null;
            CgScan[] positives = new CgScan[this.polarity_scanCount_.get(key).get(1).intValue()];
            CgScan[] negatives = new CgScan[this.polarity_scanCount_.get(key).get(2).intValue()];
            int currentPolarity = allScans[0].getPolarity();
            int scanCount = 0;
            boolean requiresDummyScan = false;
            while (currentPolarity == allScans[scanCount].getPolarity()) {
                CgScan scan = allScans[scanCount];
                for (CgScan subScan : scan.getFullSubScans()) {
                    if (subScan.getPolarity() == currentPolarity) continue;
                    requiresDummyScan = true;
                    break;
                }
                ++scanCount;
            }
            if (requiresDummyScan) {
                CgScan dummyScan = new CgScan(0);
                dummyScan.setDummyScan(true);
                if (currentPolarity == 1) {
                    dummyScan.setPolarity(2);
                    lastNegativeMS1Scan = dummyScan;
                    this.negativeDummyMS1Scan_ = dummyScan;
                } else if (currentPolarity == 2) {
                    dummyScan.setPolarity(1);
                    lastPositiveMS1Scan = dummyScan;
                    this.positiveDummyMS1Scan_ = dummyScan;
                }
            }
            int positiveCount = 0;
            int negativeCount = 0;
            for (int i = 0; i != nrOfScans; ++i) {
                CgScan scan = allScans[i];
                if (scan.getPolarity() == 1) {
                    positives[positiveCount] = scan;
                    lastPositiveMS1Scan = scan;
                    ++positiveCount;
                } else if (scan.getPolarity() == 2) {
                    negatives[negativeCount] = scan;
                    lastNegativeMS1Scan = scan;
                    ++negativeCount;
                }
                ArrayList<CgScan> subScans = new ArrayList<CgScan>(scan.getFullSubScans());
                scan.cleanSubscans();
                for (CgScan subScan : subScans) {
                    if (subScan.getPolarity() == 1) {
                        lastPositiveMS1Scan.AddSubscan(subScan);
                        continue;
                    }
                    if (subScan.getPolarity() != 2) continue;
                    lastNegativeMS1Scan.AddSubscan(subScan);
                }
            }
            polarities.put(1, positives);
            polarities.put(2, negatives);
            this.polarityScans_.put(key, polarities);
        }
    }

    public Hashtable<String, Hashtable<Integer, Integer>> getPolarityScanCount() {
        return this.polarity_scanCount_;
    }
}

