/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.vos;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class ResultAreaVO {
    private Set<LipidParameterSet> lipidParameterSets_ = ConcurrentHashMap.newKeySet();
    private String name_;
    private Integer dbs_;
    private String expName_;
    private String rt_;
    private Hashtable<String, Integer> chemicalFormula_;
    private Hashtable<String, Hashtable<String, Integer>> modFormulas_;
    private Double neutralMass_;
    private Hashtable<String, Double> mass_;
    private Hashtable<String, Double> expMass_;
    private Hashtable<String, Integer> charge_;
    private Hashtable<String, Double> retentionTime_;
    private Hashtable<String, Vector<Double>> areas_;
    private Hashtable<String, Set<MolecularSpeciesAreaVO>> areaContributions_;
    private Set<String> allMolecularSpeciesNamesHumanReadable_;
    private Hashtable<String, Vector<Boolean>> moreThanOnePeak_;
    private float percentalSplit_;
    private boolean internalStandard_;
    private boolean externalStandard_;
    private String oxState_;

    public ResultAreaVO(LipidParameterSet lipidParameterSet, String rt, String expName, String chemicalFormula, double neutralMass, boolean internalStandard, boolean externalStandard) throws ChemicalFormulaException {
        this.lipidParameterSets_.add(lipidParameterSet);
        this.name_ = lipidParameterSet.getName();
        this.dbs_ = lipidParameterSet.getDoubleBonds();
        this.expName_ = expName;
        this.chemicalFormula_ = StaticUtils.categorizeFormula(chemicalFormula);
        this.modFormulas_ = new Hashtable();
        this.neutralMass_ = neutralMass;
        this.mass_ = new Hashtable();
        this.expMass_ = new Hashtable();
        this.charge_ = new Hashtable();
        this.retentionTime_ = new Hashtable();
        this.areas_ = new Hashtable();
        this.areaContributions_ = new Hashtable();
        this.allMolecularSpeciesNamesHumanReadable_ = ConcurrentHashMap.newKeySet();
        this.moreThanOnePeak_ = new Hashtable();
        this.percentalSplit_ = 1.0f;
        if (lipidParameterSet.getPercentalSplit() >= 1.0f) {
            this.percentalSplit_ = lipidParameterSet.getPercentalSplit() / 100.0f;
        }
        this.internalStandard_ = internalStandard;
        this.externalStandard_ = externalStandard;
        this.rt_ = rt;
        this.oxState_ = lipidParameterSet.getOxState();
    }

    public void addResultPart(String modName, String modFormula, double mass, double expMass, int charge, String rt) throws ChemicalFormulaException {
        String modToAdd = this.getNotNullName(modName);
        if (!this.modFormulas_.containsKey(modToAdd)) {
            this.modFormulas_.put(modToAdd, StaticUtils.categorizeFormula(this.getNotNullName(modFormula)));
            this.mass_.put(modToAdd, mass);
            this.expMass_.put(modToAdd, expMass);
            this.charge_.put(modToAdd, charge);
            this.areas_.put(modToAdd, new Vector());
            this.areaContributions_.put(modToAdd, ConcurrentHashMap.newKeySet());
            this.moreThanOnePeak_.put(modToAdd, new Vector());
        }
    }

    public Hashtable<Integer, Boolean> addArea(String modificationName, int iso, double area) {
        String modName = this.getNotNullName(modificationName);
        Vector<Double> areas = this.areas_.get(modName);
        Vector<Boolean> moreThanOnePeak = this.moreThanOnePeak_.get(modName);
        boolean isAdditionalPeak = false;
        int isotope = iso;
        if (isotope < 0) {
            isotope *= -1;
        }
        if (areas.size() <= isotope) {
            areas.add(area * (double)this.percentalSplit_);
            moreThanOnePeak.add(false);
        } else {
            double totalArea = areas.get(isotope) + area * (double)this.percentalSplit_;
            areas.remove(isotope);
            areas.add(isotope, totalArea);
            moreThanOnePeak.remove(isotope);
            moreThanOnePeak.add(isotope, true);
            isAdditionalPeak = true;
        }
        this.areas_.put(modName, areas);
        this.moreThanOnePeak_.put(modName, moreThanOnePeak);
        if (isAdditionalPeak) {
            Hashtable<Integer, Boolean> mtp = new Hashtable<Integer, Boolean>();
            for (int i = 0; i != moreThanOnePeak.size(); ++i) {
                mtp.put(i, moreThanOnePeak.get(i));
            }
            return mtp;
        }
        return null;
    }

    private void addMolecularSpeciesContribution(String modificationName, double totalAreaBefore, Set<LipidParameterSet> sets) {
        for (LipidParameterSet set : sets) {
            this.addMolecularSpeciesContribution(modificationName, totalAreaBefore, set);
        }
    }

    public void addMolecularSpeciesContribution(String modificationName, double totalAreaBefore, LipidParameterSet set) {
        block5: {
            double diff;
            double totalArea;
            block4: {
                totalArea = this.getTotalArea(modificationName);
                diff = this.getTotalArea(modificationName) - totalAreaBefore;
                if (!(set instanceof LipidomicsMSnSet)) break block4;
                LipidomicsMSnSet setMSn = (LipidomicsMSnSet)set;
                if (setMSn.getStatus() <= 2 || !(diff > 0.0)) break block5;
                Vector<String> humanReadableNames = setMSn.getMSnIdentificationNamesWithSNPositions();
                Hashtable<String, DoubleBondPositionVO> assignedPositions = new Hashtable<String, DoubleBondPositionVO>();
                for (DoubleBondPositionVO assigned : StaticUtils.getAssignedDoubleBondPositions(setMSn.getOmegaInformation())) {
                    assignedPositions.put(assigned.getMolecularSpecies(), assigned);
                }
                for (String humanReadable : humanReadableNames) {
                    String identifier = assignedPositions.containsKey(humanReadable) ? ((DoubleBondPositionVO)assignedPositions.get(humanReadable)).getDoubleBondPositionsHumanReadable() : humanReadable;
                    MolecularSpeciesAreaVO molSpeciesAreaVO = this.getVOOfHumanReadable(identifier, modificationName);
                    double absoluteIntensity = molSpeciesAreaVO.getAreaContribution() * totalAreaBefore + setMSn.getRelativeIntensity(humanReadable) * diff;
                    double relativeIntensity = totalArea / absoluteIntensity;
                    molSpeciesAreaVO.setAreaContribution(relativeIntensity);
                    this.areaContributions_.get(modificationName).add(molSpeciesAreaVO);
                    this.allMolecularSpeciesNamesHumanReadable_.add(identifier);
                }
                break block5;
            }
            if (set.hasOmegaInformation()) {
                for (DoubleBondPositionVO assigned : StaticUtils.getAssignedDoubleBondPositions(set.getOmegaInformation())) {
                    MolecularSpeciesAreaVO molSpeciesAreaVO = this.getVOOfHumanReadable(assigned.getDoubleBondPositionsHumanReadable(), modificationName);
                    double absoluteIntensity = molSpeciesAreaVO.getAreaContribution() * totalAreaBefore + 1.0 * diff;
                    double relativeIntensity = totalArea / absoluteIntensity;
                    molSpeciesAreaVO.setAreaContribution(relativeIntensity);
                    this.areaContributions_.get(modificationName).add(molSpeciesAreaVO);
                    this.allMolecularSpeciesNamesHumanReadable_.add(assigned.getDoubleBondPositionsHumanReadable());
                }
            }
        }
    }

    private MolecularSpeciesAreaVO getVOOfHumanReadable(String humanReadable, String modification) {
        Set<MolecularSpeciesAreaVO> contributions = this.areaContributions_.get(modification);
        for (MolecularSpeciesAreaVO contribution : contributions) {
            if (!contribution.getHumanReadable().equals(humanReadable) || !contribution.getModification().equals(modification)) continue;
            return contribution;
        }
        return new MolecularSpeciesAreaVO(humanReadable, modification, 0.0);
    }

    public void combineVOs(ResultAreaVO other) {
        double highestArea = 0.0;
        for (String mod : this.areas_.keySet()) {
            if (this.areas_.get(mod).size() <= 0 || !(this.areas_.get(mod).get(0) > highestArea)) continue;
            highestArea = this.areas_.get(mod).get(0);
        }
        for (String mod : other.mass_.keySet()) {
            double totalAreaBefore = this.getTotalArea(mod);
            float highestZeroArea = this.getHighestZeroIsoArea(mod);
            if (!this.mass_.containsKey(mod)) {
                try {
                    this.addResultPart(mod, other.getChemicalFormula(mod), other.mass_.get(mod), other.expMass_.get(mod), other.charge_.get(mod), null);
                }
                catch (ChemicalFormulaException e) {
                    e.printStackTrace();
                }
            }
            Vector<Double> areas = other.areas_.get(mod);
            Hashtable<Integer, Boolean> moreThanOnePeak = new Hashtable();
            for (int i = 0; i != areas.size(); ++i) {
                Hashtable<Integer, Boolean> mtp = this.addArea(mod, i, areas.get(i));
                if (mtp != null) {
                    moreThanOnePeak = mtp;
                }
                if (moreThanOnePeak.containsKey(i)) {
                    mtp.put(i, true);
                } else {
                    moreThanOnePeak.put(i, false);
                }
                if (i != 0 || !(areas.get(i) > (double)highestZeroArea)) continue;
                this.setRetentionTime(mod, other.getRetentionTime(mod));
            }
            this.addMolecularSpeciesContribution(mod, totalAreaBefore, other.getLipidParameterSets(mod));
            this.addLipidParameterSets(other.getLipidParameterSets(mod));
            this.setMoreThanOnePeak(mod, moreThanOnePeak);
        }
    }

    public void addLipidParameterSet(LipidParameterSet set) {
        this.lipidParameterSets_.add(set);
    }

    public void addLipidParameterSets(Set<LipidParameterSet> sets) {
        this.lipidParameterSets_.addAll(sets);
    }

    private String getNotNullName(String name) {
        if (name != null && name.length() > 0) {
            return name;
        }
        return "";
    }

    public String getMoleculeName() {
        return StaticUtils.generateLipidNameString(this.name_, this.dbs_, this.rt_, this.oxState_);
    }

    public String getMoleculeNameWoRT() {
        return StaticUtils.generateLipidNameString(this.name_, this.dbs_, -1, this.oxState_);
    }

    public String getExpName() {
        return this.expName_;
    }

    private String getChemicalFormula(String modString) {
        String formula = "";
        Hashtable<Object, Object> modFormula = new Hashtable();
        if (this.modFormulas_.containsKey(modString)) {
            modFormula = this.modFormulas_.get(modString);
        }
        Vector<String> elementsOrder = new Vector<String>();
        for (String string : this.chemicalFormula_.keySet()) {
            if (string.equalsIgnoreCase("C")) {
                elementsOrder.add(0, string);
                continue;
            }
            elementsOrder.add(string);
        }
        for (String string : elementsOrder) {
            if (formula.length() > 0) {
                formula = formula + " ";
            }
            int amount = this.chemicalFormula_.get(string);
            if (modFormula.containsKey(string)) {
                amount += ((Integer)modFormula.get(string)).intValue();
            }
            formula = formula + string + String.valueOf(amount);
        }
        for (String string : modFormula.keySet()) {
            if (this.chemicalFormula_.containsKey(string)) continue;
            if (formula.length() > 0) {
                formula = formula + " ";
            }
            formula = formula + string + String.valueOf(modFormula.get(string));
        }
        return formula;
    }

    public String getChemicalFormulaBase() {
        return this.getChemicalFormula("");
    }

    public Hashtable<String, Integer> getChemicalFormulaElements() {
        return this.chemicalFormula_;
    }

    public Vector<Double> getWeightedNeutralMass() {
        int maxIsotpe = this.getMaxIsotope();
        Vector<Double> weightedMasses = new Vector<Double>();
        for (int i = 0; i != maxIsotpe; ++i) {
            double totalArea = 0.0;
            double totalMassArea = 0.0;
            for (String modName : this.areas_.keySet()) {
                Vector<Double> areas = this.areas_.get(modName);
                for (int j = 0; j != i + 1 && j != areas.size(); ++j) {
                    double area = areas.get(j);
                    double mass = this.neutralMass_ + (double)(LipidomicsConstants.getNeutronMass() * (float)j);
                    totalArea += area;
                    totalMassArea += area * mass;
                }
            }
            weightedMasses.add(totalMassArea / totalArea);
        }
        return weightedMasses;
    }

    public double getTheoreticalIsotopeValue(ElementConfigParser elementParser, int isosDesired) {
        double result = 0.0;
        for (String modString : this.areas_.keySet()) {
            String chemicalFormula = this.getChemicalFormula(modString);
            try {
                Vector<Double> distris = StaticUtils.calculateChemicalFormulaIntensityDistribution(elementParser, chemicalFormula, isosDesired, false);
                Vector<Double> areas = this.areas_.get(modString);
                Vector<Double> isoValues = new Vector<Double>();
                for (int i = 0; i != isosDesired; ++i) {
                    if (i < areas.size()) {
                        isoValues.add(areas.get(i));
                        continue;
                    }
                    isoValues.add(isoValues.get(0) * distris.get(i));
                }
                result += this.getTotalArea(isoValues, isosDesired);
            }
            catch (SpectrummillParserException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public double getTotalArea(String mod) {
        return this.getTotalAreaOfModification(mod, Integer.MAX_VALUE);
    }

    public double getTotalArea(int amountOfIsotopes) {
        double totalArea = 0.0;
        for (Vector<Double> areas : this.areas_.values()) {
            totalArea += this.getTotalArea(areas, amountOfIsotopes);
        }
        return totalArea;
    }

    private double getTotalArea(Vector<Double> areas, int amountOfIsotopes) {
        double totalArea = 0.0;
        if (areas != null) {
            for (int i = 0; i != areas.size() && i < amountOfIsotopes; ++i) {
                totalArea += areas.get(i).doubleValue();
            }
        }
        return totalArea;
    }

    public double getTotalAreaOfModification(String mod, int amountOfIsotopes) {
        return this.getTotalArea(this.areas_.get(mod), amountOfIsotopes);
    }

    public double getRetentionTime(String modificationName) {
        return this.retentionTime_.get(this.getNotNullName(modificationName));
    }

    public void setRetentionTime(String modificationName, double retentionTime) {
        this.retentionTime_.put(this.getNotNullName(modificationName), retentionTime);
    }

    public Hashtable<String, Double> getRetentionTimes() {
        return this.retentionTime_;
    }

    public Hashtable<String, Boolean> getMoreThanOnePeak(int amountOfIsotopes) {
        Hashtable<String, Boolean> moreThanOnePeakHash = new Hashtable<String, Boolean>();
        for (String modName : this.moreThanOnePeak_.keySet()) {
            boolean moreThanOnePeak = false;
            Vector<Boolean> moreThanOnePeaks = this.moreThanOnePeak_.get(modName);
            for (int i = 0; i != moreThanOnePeaks.size() && i < amountOfIsotopes; ++i) {
                if (!moreThanOnePeaks.get(i).booleanValue()) continue;
                moreThanOnePeak = true;
            }
            moreThanOnePeakHash.put(modName, moreThanOnePeak);
        }
        return moreThanOnePeakHash;
    }

    public void setMoreThanOnePeak(String modificationName, Hashtable<Integer, Boolean> moreThanOnePeak) {
        ArrayList<Integer> isotopes = new ArrayList<Integer>(moreThanOnePeak.keySet());
        Vector<Boolean> moreThanOnePeaks = new Vector<Boolean>();
        Collections.sort(isotopes);
        for (int i = 0; i != isotopes.size(); ++i) {
            moreThanOnePeaks.add(moreThanOnePeak.get(isotopes.get(i)));
        }
        this.moreThanOnePeak_.put(modificationName, moreThanOnePeaks);
    }

    public int getMaxIsotope() {
        int maxIsotope = 0;
        for (Vector<Double> areas : this.areas_.values()) {
            int size = areas.size();
            if (maxIsotope >= size) continue;
            maxIsotope = size;
        }
        return maxIsotope;
    }

    public void setRt(String rt) {
        this.rt_ = rt;
    }

    public String getRt() {
        return this.rt_;
    }

    public float getHighestZeroIsoArea(String modification) {
        if (this.areas_.get(modification) != null && this.areas_.get(modification).get(0) != null) {
            return this.areas_.get(modification).get(0).floatValue();
        }
        return 0.0f;
    }

    public boolean hasModification(String mod) {
        return this.modFormulas_.containsKey(mod);
    }

    public String getModificationFormula(String mod) {
        String modFormula = "";
        if (this.hasModification(mod)) {
            Hashtable<String, Integer> formula = this.modFormulas_.get(mod);
            for (String element : formula.keySet()) {
                String amount = String.valueOf(formula.get(element));
                if (amount.startsWith("-")) {
                    amount = amount.substring(1);
                    modFormula = modFormula + "-";
                }
                modFormula = modFormula + element + amount;
            }
        }
        return modFormula;
    }

    public Integer getCharge(String modification) {
        if (this.hasModification(modification)) {
            return this.charge_.get(modification);
        }
        return null;
    }

    public Double getTheoreticalMass(String modification) {
        if (this.hasModification(modification)) {
            return this.mass_.get(modification);
        }
        return null;
    }

    public Double getExperimentalMass(String modification) {
        if (this.hasModification(modification)) {
            return this.expMass_.get(modification);
        }
        return null;
    }

    public boolean containsAllModifications(Hashtable<String, String> mods) {
        boolean all = true;
        for (String mod : mods.keySet()) {
            if (this.areas_.containsKey(mod)) continue;
            all = false;
            break;
        }
        return all;
    }

    public boolean belongsRtToThisAreaVO(String rt, String mod) {
        try {
            Double.parseDouble(rt);
        }
        catch (NullPointerException | NumberFormatException ex) {
            rt = null;
        }
        for (LipidParameterSet param : this.lipidParameterSets_) {
            if (mod != null && !param.getModificationName().equals(mod)) continue;
            if (rt != null && param.getRt().equals(rt)) {
                return true;
            }
            if (rt != null || param.getRt() != null) continue;
            return true;
        }
        return false;
    }

    public boolean isAStandard() {
        return this.internalStandard_ || this.externalStandard_;
    }

    public Set<LipidParameterSet> getLipidParameterSets(String modification) {
        ConcurrentHashMap.KeySetView sets = ConcurrentHashMap.newKeySet();
        for (LipidParameterSet set : this.lipidParameterSets_) {
            if (!set.getModificationName().equals(modification)) continue;
            sets.add(set);
        }
        return sets;
    }

    public boolean isMSnVerified() {
        for (LipidParameterSet set : this.lipidParameterSets_) {
            if (!(set instanceof LipidomicsMSnSet)) continue;
            return true;
        }
        return false;
    }

    public void removeMolecularSpeciesFromParams(String humanReadable, String modification) {
        for (LipidParameterSet set : this.lipidParameterSets_) {
            if (!set.getModificationName().equals(modification) || !(set instanceof LipidomicsMSnSet)) continue;
            LipidomicsMSnSet mSnSet = (LipidomicsMSnSet)set;
            mSnSet.removeMolecularSpecies(humanReadable);
        }
    }

    public Set<String> getAllMolecularSpeciesNamesHumanReadable() {
        return this.allMolecularSpeciesNamesHumanReadable_;
    }

    public Double getMolecularSpeciesContributionOfAllMods(String humanReadable) {
        double totalArea = 0.0;
        double relativeArea = 0.0;
        for (String modification : this.areaContributions_.keySet()) {
            double totalAreaMod = this.getTotalArea(modification);
            totalArea += totalAreaMod;
            for (MolecularSpeciesAreaVO contribution : this.areaContributions_.get(modification)) {
                if (!contribution.getHumanReadable().equals(humanReadable)) continue;
                double relativeAreaMod = totalAreaMod * contribution.getAreaContribution();
                relativeArea += relativeAreaMod;
            }
        }
        return totalArea / relativeArea;
    }

    private class MolecularSpeciesAreaVO {
        private String humanReadable_;
        private String modification_;
        private String humanReadableOmega_;
        private Double areaContribution_;

        private MolecularSpeciesAreaVO(String humanReadable, String modification, String humanReadableOmega, Double areaContribution) {
            this.humanReadable_ = humanReadable;
            this.modification_ = modification;
            this.humanReadableOmega_ = humanReadableOmega;
            this.areaContribution_ = areaContribution;
        }

        private MolecularSpeciesAreaVO(String humanReadable, String modification, Double areaContribution) {
            this(humanReadable, modification, "", areaContribution);
        }

        public String getHumanReadable() {
            return this.humanReadable_;
        }

        public String getModification() {
            return this.modification_;
        }

        public Double getAreaContribution() {
            return this.areaContribution_;
        }

        public void setAreaContribution(double areaContribution) {
            this.areaContribution_ = areaContribution;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hash(this.areaContribution_, this.humanReadableOmega_, this.humanReadable_, this.modification_);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MolecularSpeciesAreaVO other = (MolecularSpeciesAreaVO)obj;
            return Objects.equals(this.areaContribution_, other.areaContribution_) && Objects.equals(this.humanReadableOmega_, other.humanReadableOmega_) && Objects.equals(this.humanReadable_, other.humanReadable_) && Objects.equals(this.modification_, other.modification_);
        }
    }
}

