/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.verifier;

import at.tugraz.genome.lda.WarningMessage;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class StringVerifier
extends InputVerifier {
    private int minimumTextLength_;
    private int maximumTextLength_;
    private String fieldName_;

    public StringVerifier(int min, int max, String fieldName) {
        this.maximumTextLength_ = max;
        this.minimumTextLength_ = min;
        this.fieldName_ = fieldName;
    }

    @Override
    public boolean verify(JComponent input) {
        String text = ((JTextField)input).getText();
        if (text.length() < this.minimumTextLength_) {
            new WarningMessage(new JFrame(), "Error", String.format("The text entered in field '%s' has to be at least %s characters long.", this.fieldName_, this.minimumTextLength_));
            return false;
        }
        if (text.length() > this.maximumTextLength_) {
            new WarningMessage(new JFrame(), "Error", String.format("The text entered in field '%s' has to be at most %s characters long.", this.fieldName_, this.maximumTextLength_));
            return false;
        }
        return true;
    }
}

