/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.utils;

import at.tugraz.genome.lda.exception.LMException;
import at.tugraz.genome.lda.utils.LevenbergMarquardtOptimizer;
import at.tugraz.genome.util.FloatMatrix;

public class LMLinearFaCombination
extends LevenbergMarquardtOptimizer {
    private float[][] values_;
    private float[][] observations_;
    private float totalInt_;

    public LMLinearFaCombination(float[][] values, float[] observations) {
        this.values_ = values;
        this.observations_ = new float[observations.length][1];
        this.totalInt_ = 0.0f;
        for (int i = 0; i != observations.length; ++i) {
            this.observations_[i][0] = observations[i];
            this.totalInt_ += this.observations_[i][0];
        }
        this.totalInt_ /= 3.0f;
    }

    @Override
    protected FloatMatrix calculateEquationResults(float[][] values, FloatMatrix paramsVector) {
        float[][] results = new float[values.length][1];
        for (int i = 0; i != values.length; ++i) {
            float equationResult = 0.0f;
            for (int j = 0; j != values[i].length; ++j) {
                equationResult += paramsVector.A[j][0] * values[i][j];
            }
            results[i][0] = equationResult;
        }
        return new FloatMatrix(results);
    }

    @Override
    protected FloatMatrix calculateJacobianMatrix(float[][] values, float[][] parameters) {
        float[][] jacobian = new float[values.length][values[0].length];
        for (int i = 0; i != values.length; ++i) {
            for (int j = 0; j != values[i].length; ++j) {
                jacobian[i][j] = values[i][j];
            }
        }
        return new FloatMatrix(jacobian);
    }

    @Override
    protected float[][] getValues() {
        return this.values_;
    }

    @Override
    protected float[][] getObservations() {
        return this.observations_;
    }

    @Override
    public void fit() throws LMException {
        float[][] parameters = null;
        if (this.resultParams_ == null) {
            int parametersNumber = this.values_[0].length;
            parameters = new float[parametersNumber][1];
            float relativeShare = this.totalInt_ / (float)parametersNumber;
            for (int i = 0; i != parametersNumber; ++i) {
                parameters[i][0] = relativeShare;
            }
        } else {
            parameters = this.resultParams_.A;
        }
        this.fit(parameters);
    }

    @Override
    public float calculateFitValue(float[] input) throws LMException {
        float[][] values = new float[1][input.length];
        for (int i = 0; i != input.length; ++i) {
            values[0][i] = input[i];
        }
        float result = this.calculateEquationResults((float[][])values, (FloatMatrix)this.resultParams_).A[0][0];
        return result;
    }
}

