/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.exception.AbsoluteSettingsInputException;
import at.tugraz.genome.lda.swing.ApplyButton;
import at.tugraz.genome.lda.swing.PhysicalUnitInput;
import at.tugraz.genome.lda.swing.StandardsSettingsListener;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import at.tugraz.genome.lda.vos.VolumeConcVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class StandardsSettingsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String expName_;
    private Vector<String> isNames_;
    private Vector<String> esNames_;
    private StandardsSettingsListener listener_;
    private JPanel generalInputPanel_;
    private JPanel specificInputPanel_;
    private JTextField dilutionFactor_;
    private PhysicalUnitInput generalExtVolume_;
    private PhysicalUnitInput generalExtConc_;
    private PhysicalUnitInput generalIntVolume_;
    private PhysicalUnitInput generalIntConc_;
    private Hashtable<String, PhysicalUnitInput> extVolumeSettings_;
    private Hashtable<String, PhysicalUnitInput> extConcSettings_;
    private Hashtable<String, PhysicalUnitInput> intVolumeSettings_;
    private Hashtable<String, PhysicalUnitInput> intConcSettings_;

    public StandardsSettingsPanel(String expName, Vector<String> isNames, Vector<String> esNames, StandardsSettingsListener listener) {
        this.expName_ = expName;
        this.isNames_ = isNames;
        this.esNames_ = esNames;
        this.listener_ = listener;
        this.initComponents();
    }

    private void initComponents() {
        ApplyButton button;
        this.generalInputPanel_ = new JPanel();
        this.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel();
        JLabel label = new JLabel("Dilution factor: ");
        label.setToolTipText("<html>Dillution from the time point where the external standard has been added to the internal standard</br>This option is additionally useful for the comparison of differntly dilluted experiments.</html>");
        topPanel.add(label);
        this.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.dilutionFactor_ = new JTextField(3);
        this.dilutionFactor_.setHorizontalAlignment(4);
        this.dilutionFactor_.setInputVerifier(new DoubleVerifier());
        this.dilutionFactor_.setToolTipText("<html>Dillution from the time point where the external standard has been added to the internal standard</br>This option is additionally useful for the comparison of differntly dilluted experiments.</html>");
        topPanel.add(this.dilutionFactor_);
        if (this.expName_ != null && this.expName_.length() > 0) {
            button = new ApplyButton("Apply to all", "applySettingsAll;dilution");
            button.addActionListener(this);
            button.setToolTipText("<html>Apply this value to all input fields of this kind.</html>");
            topPanel.add(button);
            button = new ApplyButton("Apply to group", "applySettingsGroup;dilution");
            button.addActionListener(this);
            button.setToolTipText("<html>Apply this value to all group members this experiment belongs to.</html>");
            topPanel.add(button);
        }
        this.add((Component)this.generalInputPanel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.generalInputPanel_.setVisible(true);
        this.generalInputPanel_.setLayout(new GridBagLayout());
        label = new JLabel("Ext volume: ");
        label.setToolTipText("<html>Volume of external standard</html>");
        this.generalInputPanel_.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.generalExtVolume_ = new PhysicalUnitInput("\u03bc", "<html>Volume of external standard</html>");
        this.generalInputPanel_.add((Component)this.generalExtVolume_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("L");
        label.setToolTipText("<html>Volume of external standard</html>");
        this.generalInputPanel_.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        label = new JLabel("Ext conc.: ");
        label.setToolTipText("<html>Concentration of external standard</html>");
        this.generalInputPanel_.add((Component)label, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.generalExtConc_ = new PhysicalUnitInput("\u03bc", "<html>Concentration of external standard</html>");
        this.generalInputPanel_.add((Component)this.generalExtConc_, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("mol/L");
        label.setToolTipText("<html>Concentration of external standard</html>");
        this.generalInputPanel_.add((Component)label, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        label = new JLabel("Int volume: ");
        label.setToolTipText("<html>Volume of internal standard</html>");
        this.generalInputPanel_.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.generalIntVolume_ = new PhysicalUnitInput("\u03bc", "<html>Volume of internal standard</html>");
        this.generalInputPanel_.add((Component)this.generalIntVolume_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("L");
        label.setToolTipText("<html>Volume of internal standard</html>");
        this.generalInputPanel_.add((Component)label, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        label = new JLabel("Int conc.: ");
        label.setToolTipText("<html>Concentration of internal standard</html>");
        this.generalInputPanel_.add((Component)label, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.generalIntConc_ = new PhysicalUnitInput("\u03bc", "<html>Concentration of internal standard</html>");
        this.generalInputPanel_.add((Component)this.generalIntConc_, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("mol/L");
        label.setToolTipText("<html>Concentration of internal standard</html>");
        this.generalInputPanel_.add((Component)label, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.extVolumeSettings_ = new Hashtable();
        this.extConcSettings_ = new Hashtable();
        this.intVolumeSettings_ = new Hashtable();
        this.intConcSettings_ = new Hashtable();
        if (this.expName_ != null && this.expName_.length() > 0) {
            button = new ApplyButton("Apply to all", "applySettingsAll;generalES");
            button.addActionListener(this);
            button.setToolTipText("<html>Apply this value to all input fields of this kind.</html>");
            this.generalInputPanel_.add((Component)button, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
            button = new ApplyButton("Apply to group", "applySettingsGroup;generalES");
            button.setToolTipText("<html>Apply this value to all group members this experiment belongs to.</html>");
            button.addActionListener(this);
            this.generalInputPanel_.add((Component)button, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
            button = new ApplyButton("Apply to all", "applySettingsAll;generalIS");
            button.setToolTipText("<html>Apply this value to all input fields of this kind.</html>");
            button.addActionListener(this);
            this.generalInputPanel_.add((Component)button, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
            button = new ApplyButton("Apply to group", "applySettingsGroup;generalIS");
            button.setToolTipText("<html>Apply this value to all group members this experiment belongs to.</html>");
            button.addActionListener(this);
            this.generalInputPanel_.add((Component)button, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        }
        this.specificInputPanel_ = new JPanel();
        this.add((Component)this.specificInputPanel_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        JPanel panelToAdd = this.specificInputPanel_;
        if (this.esNames_.size() + this.isNames_.size() > 2) {
            panelToAdd = new JPanel();
            panelToAdd.setLayout(new GridBagLayout());
            panelToAdd.setPreferredSize(new Dimension(350, 30 * (this.esNames_.size() + this.isNames_.size())));
        } else {
            this.specificInputPanel_.setLayout(new GridBagLayout());
        }
        this.specificInputPanel_.setVisible(false);
        for (int i = 0; i != this.esNames_.size(); ++i) {
            String esName = this.esNames_.get(i);
            label = new JLabel("Ext " + esName + "-vol");
            label.setToolTipText("<html>Volume of external standard</html>");
            panelToAdd.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
            PhysicalUnitInput volumeSetting = new PhysicalUnitInput("\u03bc", "<html>Volume of external standard</html>");
            panelToAdd.add((Component)volumeSetting, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            label = new JLabel("L");
            label.setToolTipText("<html>Volume of external standard</html>");
            panelToAdd.add((Component)label, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
            this.extVolumeSettings_.put(esName, volumeSetting);
            label = new JLabel("Ext " + esName + "-conc");
            label.setToolTipText("<html>Concentration of external standard</html>");
            panelToAdd.add((Component)label, new GridBagConstraints(3, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
            PhysicalUnitInput concSetting = new PhysicalUnitInput("\u03bc", "<html>Concentration of external standard</html>");
            panelToAdd.add((Component)concSetting, new GridBagConstraints(4, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            label = new JLabel("mol/L");
            label.setToolTipText("<html>Concentration of external standard</html>");
            panelToAdd.add((Component)label, new GridBagConstraints(5, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
            this.extConcSettings_.put(esName, concSetting);
            if (this.expName_ == null || this.expName_.length() <= 0) continue;
            ApplyButton button2 = new ApplyButton("Apply to all", "applySettingsAll;" + esName);
            button2.addActionListener(this);
            button2.setToolTipText("<html>Apply this value to all input fields of this kind.</html>");
            panelToAdd.add((Component)button2, new GridBagConstraints(6, i, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
            button2 = new ApplyButton("Apply to group", "applySettingsGroup;" + esName);
            button2.addActionListener(this);
            button2.setToolTipText("<html>Apply this value to all group members this experiment belongs to.</html>");
            panelToAdd.add((Component)button2, new GridBagConstraints(7, i, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        }
        int rowAdd = this.esNames_.size();
        for (int i = 0; i != this.isNames_.size(); ++i) {
            String isName = this.isNames_.get(i);
            label = new JLabel("Int " + isName + "-vol");
            label.setToolTipText("<html>Volume of internal standard</html>");
            panelToAdd.add((Component)label, new GridBagConstraints(0, i + rowAdd, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
            PhysicalUnitInput volumeSetting = new PhysicalUnitInput("\u03bc", "<html>Volume of internal standard</html>");
            panelToAdd.add((Component)volumeSetting, new GridBagConstraints(1, i + rowAdd, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            label.setToolTipText("<html>Volume of internal standard</html>");
            label = new JLabel("L");
            panelToAdd.add((Component)label, new GridBagConstraints(2, i + rowAdd, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
            this.intVolumeSettings_.put(isName, volumeSetting);
            label = new JLabel("Int " + isName + "-conc");
            label.setToolTipText("<html>Concentration of internal standard</html>");
            panelToAdd.add((Component)label, new GridBagConstraints(3, i + rowAdd, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
            PhysicalUnitInput concSetting = new PhysicalUnitInput("\u03bc", "<html>Concentration of internal standard</html>");
            panelToAdd.add((Component)concSetting, new GridBagConstraints(4, i + rowAdd, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            label = new JLabel("mol/L");
            label.setToolTipText("<html>Concentration of internal standard</html>");
            panelToAdd.add((Component)label, new GridBagConstraints(5, i + rowAdd, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
            this.intConcSettings_.put(isName, concSetting);
            if (this.expName_ == null || this.expName_.length() <= 0) continue;
            ApplyButton button3 = new ApplyButton("Apply to all", "applySettingsAll;" + isName);
            button3.addActionListener(this);
            button3.setToolTipText("<html>Apply this value to all input fields of this kind.</html>");
            panelToAdd.add((Component)button3, new GridBagConstraints(6, i + rowAdd, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
            button3 = new ApplyButton("Apply to group", "applySettingsGroup;" + isName);
            button3.addActionListener(this);
            button3.setToolTipText("<html>Apply this value to all group members this experiment belongs to.</html>");
            panelToAdd.add((Component)button3, new GridBagConstraints(7, i + rowAdd, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        }
        if (this.esNames_.size() + this.isNames_.size() > 2) {
            JScrollPane scrollPane = new JScrollPane(panelToAdd);
            scrollPane.setPreferredSize(new Dimension(700, 65));
            this.specificInputPanel_.add(scrollPane);
        }
    }

    public void showSpecific(boolean specific) {
        this.generalInputPanel_.setVisible(!specific);
        this.specificInputPanel_.setVisible(specific);
    }

    public void takeOverValues(StandardsSettingsPanel otherPanel, boolean general) {
        this.dilutionFactor_.setText(otherPanel.dilutionFactor_.getText());
        if (general) {
            this.generalExtVolume_.setInputValue(otherPanel.generalExtVolume_);
            this.generalExtConc_.setInputValue(otherPanel.generalExtConc_);
            this.generalIntVolume_.setInputValue(otherPanel.generalIntVolume_);
            this.generalIntConc_.setInputValue(otherPanel.generalIntConc_);
        } else {
            for (String esName : this.esNames_) {
                this.extVolumeSettings_.get(esName).setInputValue(otherPanel.extVolumeSettings_.get(esName));
                this.extConcSettings_.get(esName).setInputValue(otherPanel.extConcSettings_.get(esName));
            }
            for (String isName : this.isNames_) {
                this.intVolumeSettings_.get(isName).setInputValue(otherPanel.intVolumeSettings_.get(isName));
                this.intConcSettings_.get(isName).setInputValue(otherPanel.intConcSettings_.get(isName));
            }
        }
    }

    public void copyGeneralSettingsToStandards() {
        for (String esName : this.esNames_) {
            this.extVolumeSettings_.get(esName).setInputValue(this.generalExtVolume_);
            this.extConcSettings_.get(esName).setInputValue(this.generalExtConc_);
        }
        for (String isName : this.isNames_) {
            this.intVolumeSettings_.get(isName).setInputValue(this.generalIntVolume_);
            this.intConcSettings_.get(isName).setInputValue(this.generalIntConc_);
        }
    }

    public void setInputValues(String molName, StandardsSettingsPanel copyFrom) {
        if (molName.equalsIgnoreCase("dilution")) {
            this.dilutionFactor_.setText(copyFrom.dilutionFactor_.getText());
        } else if (molName.equalsIgnoreCase("generalES")) {
            this.generalExtVolume_.setInputValue(copyFrom.generalExtVolume_);
            this.generalExtConc_.setInputValue(copyFrom.generalExtConc_);
        } else if (molName.equalsIgnoreCase("generalIS")) {
            this.generalIntVolume_.setInputValue(copyFrom.generalIntVolume_);
            this.generalIntConc_.setInputValue(copyFrom.generalIntConc_);
        } else {
            if (this.extVolumeSettings_.containsKey(molName)) {
                this.extVolumeSettings_.get(molName).setInputValue(copyFrom.extVolumeSettings_.get(molName));
                this.extConcSettings_.get(molName).setInputValue(copyFrom.extConcSettings_.get(molName));
            }
            if (this.intVolumeSettings_.containsKey(molName)) {
                this.intVolumeSettings_.get(molName).setInputValue(copyFrom.intVolumeSettings_.get(molName));
                this.intConcSettings_.get(molName).setInputValue(copyFrom.intConcSettings_.get(molName));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.indexOf(";") != -1) {
            String command = actionCommand.substring(0, actionCommand.indexOf(";"));
            System.out.println("command: " + actionCommand);
            String molecule = actionCommand.substring(actionCommand.indexOf(";") + 1);
            if (command.equalsIgnoreCase("applySettingsAll")) {
                this.listener_.applySettingsToAll(this.expName_, molecule);
            } else if (command.equalsIgnoreCase("applySettingsGroup")) {
                this.listener_.applySettingsToGroup(this.expName_, molecule);
            }
        }
    }

    public PhysicalUnitInput getGeneralExtVolume() {
        return this.generalExtVolume_;
    }

    public PhysicalUnitInput getGeneralExtConc() {
        return this.generalExtConc_;
    }

    public PhysicalUnitInput getGeneralIntVolume() {
        return this.generalIntVolume_;
    }

    public PhysicalUnitInput getGeneralIntConc() {
        return this.generalIntConc_;
    }

    public Hashtable<String, PhysicalUnitInput> getExtVolumeSettings() {
        return this.extVolumeSettings_;
    }

    public Hashtable<String, PhysicalUnitInput> getExtConcSettings() {
        return this.extConcSettings_;
    }

    public Hashtable<String, PhysicalUnitInput> getIntVolumeSettings() {
        return this.intVolumeSettings_;
    }

    public Hashtable<String, PhysicalUnitInput> getIntConcSettings() {
        return this.intConcSettings_;
    }

    public JTextField getDilutionFactor() {
        return this.dilutionFactor_;
    }

    public void cleanSettings() {
        this.generalInputPanel_.setVisible(true);
        this.specificInputPanel_.setVisible(false);
        this.dilutionFactor_.setText("");
        this.generalExtVolume_.setDefault();
        this.generalExtConc_.setDefault();
        this.generalIntVolume_.setDefault();
        this.generalIntConc_.setDefault();
        for (PhysicalUnitInput input : this.extVolumeSettings_.values()) {
            input.setDefault();
        }
        for (PhysicalUnitInput input : this.extConcSettings_.values()) {
            input.setDefault();
        }
        for (PhysicalUnitInput input : this.intVolumeSettings_.values()) {
            input.setDefault();
        }
        for (PhysicalUnitInput input : this.intConcSettings_.values()) {
            input.setDefault();
        }
    }

    public VolumeConcVO getSettings(boolean isIS) throws AbsoluteSettingsInputException {
        return this.getSettings("general", isIS);
    }

    public VolumeConcVO getSettings(String standName, boolean isIS) throws AbsoluteSettingsInputException {
        VolumeConcVO volVO = null;
        try {
            volVO = standName.equalsIgnoreCase("general") ? (isIS ? this.getSettings(this.generalIntVolume_, this.generalIntConc_) : this.getSettings(this.generalExtVolume_, this.generalExtConc_)) : (isIS ? this.getSettings(this.intVolumeSettings_.get(standName), this.intConcSettings_.get(standName)) : this.getSettings(this.extVolumeSettings_.get(standName), this.extConcSettings_.get(standName)));
        }
        catch (AbsoluteSettingsInputException ex) {
            String standString = "external";
            if (isIS) {
                standString = "internal";
            }
            if (!standName.equalsIgnoreCase("general")) {
                standString = "standName";
            }
            throw new AbsoluteSettingsInputException("You have to enter values for the " + standString + " standard!");
        }
        return volVO;
    }

    private VolumeConcVO getSettings(PhysicalUnitInput volume, PhysicalUnitInput conc) throws AbsoluteSettingsInputException {
        Double volVal = volume.getInputValue();
        if (volVal == null || volVal <= 0.0) {
            throw new AbsoluteSettingsInputException("The volume is not set");
        }
        Double concVal = conc.getInputValue();
        if (concVal == null || concVal <= 0.0) {
            throw new AbsoluteSettingsInputException("The concentration is not set");
        }
        return new VolumeConcVO(volVal, concVal);
    }
}

