/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PhysicalUnitInput
extends JPanel {
    private static final long serialVersionUID = 2647998092139418279L;
    private String preSelected_;
    private JTextField value_;
    private JComboBox<String> unitMagnitude_;
    private String tooltipText_;

    public PhysicalUnitInput() {
        this.initComponents();
    }

    public PhysicalUnitInput(String preSelected, String tooltipText) {
        this.tooltipText_ = tooltipText;
        this.initComponents();
        this.preSelected_ = preSelected;
        this.unitMagnitude_.setSelectedItem(preSelected);
    }

    private void initComponents() {
        this.value_ = new JTextField(3);
        this.value_.setHorizontalAlignment(4);
        this.value_.setInputVerifier(new DoubleVerifier());
        if (this.tooltipText_ != null && this.tooltipText_.length() > 0) {
            this.value_.setToolTipText(this.tooltipText_);
        }
        this.add(this.value_);
        this.unitMagnitude_ = new JComboBox<String>(StaticUtils.physicalMagnitudes_);
        this.unitMagnitude_.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.unitMagnitude_.setPreferredSize(new Dimension(42, 18));
        if (this.tooltipText_ != null && this.tooltipText_.length() > 0) {
            this.unitMagnitude_.setToolTipText(this.tooltipText_);
        }
        this.add(this.unitMagnitude_);
    }

    public Double getInputValue() {
        Double value = null;
        if (this.value_.getText() != null && this.value_.getText().length() > 0) {
            try {
                value = new Double(this.value_.getText());
                String selectedMagnifier = (String)this.unitMagnitude_.getSelectedItem();
                value = StaticUtils.getValueDividedByUnit(value, selectedMagnifier);
            }
            catch (NumberFormatException nfx) {
                nfx.printStackTrace();
            }
        }
        return value;
    }

    public void setInputValue(PhysicalUnitInput otherInput) {
        this.setInputValue(otherInput.value_.getText(), (String)otherInput.unitMagnitude_.getSelectedItem());
    }

    public void setInputValue(String value, String magnitude) {
        this.value_.setText(value);
        this.unitMagnitude_.setSelectedItem(magnitude);
    }

    public JTextField getValue() {
        return this.value_;
    }

    public JComboBox<String> getUnitMagnitude() {
        return this.unitMagnitude_;
    }

    public void setDefault() {
        this.value_.setText("");
        this.unitMagnitude_.setSelectedItem(this.preSelected_);
    }
}

