/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.AnalyteAddRemoveListener;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.swing.AddAnalyteDialog;
import at.tugraz.genome.lda.swing.LipidomicsTableModel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

public class LipidomicsJTable
extends JTable
implements ActionListener {
    private static final long serialVersionUID = 1924361162765772777L;
    public static final int ORDER_TYPE_AS_IS = 0;
    public static final int ORDER_TYPE_MZ = 1;
    public static final int ORDER_TYPE_INTENSITY = 2;
    private TableCellRenderer renderer;
    private JPopupMenu addItemPopup_;
    private AnalyteAddRemoveListener parentListener_;
    private JMenuItem showMS2_;
    private JMenuItem showMS1_;
    private boolean showRt_;
    private boolean controlDown_;
    private boolean shiftDown_;
    private int lastSelectedIndex_;
    private static final String LABEL_ADD_ANALYTE_BEFORE = "Add analyte before";
    private static final String LABEL_ADD_ANALYTE_AFTER = "Add analyte after";
    private static final String LABEL_DELETE_ANALYTE = "Delete analyte";
    private static final String LABEL_SHOW_MSMS = "Show MS/MS";
    private static final String LABEL_SHOW_MS1 = "Show MS1";
    private static final String LABEL_SORT_BY_ORDER = "Sort by order";
    private static final String LABEL_SORT_BY_MASS = "Sort by mass";
    private static final String LABEL_SORT_BY_INTENSITY = "Sort by intensity";
    private static final String LABEL_EDIT_RULES = "Edit MSn rule";
    private static final String LABEL_RECALCULATE_MSN = "Recalculate MSn";
    private static final String LABEL_EDIT_RT = "Edit Rt";
    private static final String LABEL_EDIT_OMEGA_ASSIGNMENT = "Edit \u03c9-DB Assignment";
    private static final String LABEL_DELETE_MOLECULAR_SPECIES = "Delete molecular species";
    private boolean hasOh_;

    public LipidomicsJTable(LipidomicsTableModel model, TableCellRenderer renderer, boolean showMs2, int orderType, boolean showRtInAddDialog, AnalyteAddRemoveListener parentListener) {
        super(model);
        this.parentListener_ = parentListener;
        this.renderer = renderer;
        this.showRt_ = showRtInAddDialog;
        this.addItemPopup_ = new JPopupMenu("Apply Peak-RT to double peaks");
        JMenuItem item = new JMenuItem(LABEL_ADD_ANALYTE_BEFORE);
        item.addActionListener(this);
        item.setVisible(orderType == 0);
        this.addItemPopup_.add(item);
        item = new JMenuItem(LABEL_ADD_ANALYTE_AFTER);
        item.addActionListener(this);
        item.setVisible(orderType == 0);
        this.addItemPopup_.add(item);
        item = new JMenuItem(LABEL_DELETE_ANALYTE);
        item.addActionListener(this);
        this.addItemPopup_.add(item);
        if (model.isShowMSn()) {
            item = new JMenuItem(LABEL_DELETE_MOLECULAR_SPECIES);
            item.addActionListener(this);
            this.addItemPopup_.add(item);
        }
        this.showMS2_ = new JMenuItem(LABEL_SHOW_MSMS);
        this.showMS2_.addActionListener(this);
        this.showMS2_.setVisible(showMs2);
        this.addItemPopup_.add(this.showMS2_);
        this.showMS1_ = new JMenuItem(LABEL_SHOW_MS1);
        this.showMS1_.addActionListener(this);
        this.showMS1_.setVisible(false);
        this.addItemPopup_.add(this.showMS1_);
        item = new JMenuItem(LABEL_SORT_BY_ORDER);
        item.addActionListener(this);
        item.setVisible(orderType != 0);
        this.addItemPopup_.add(item);
        item = new JMenuItem(LABEL_SORT_BY_MASS);
        item.addActionListener(this);
        item.setVisible(orderType != 1);
        this.addItemPopup_.add(item);
        item = new JMenuItem(LABEL_SORT_BY_INTENSITY);
        item.addActionListener(this);
        item.setVisible(orderType != 2);
        this.addItemPopup_.add(item);
        item = new JMenuItem(LABEL_EDIT_RULES);
        item.addActionListener(this);
        this.addItemPopup_.add(item);
        if (!model.isShowMSn() && !model.isShowOmega()) {
            item = new JMenuItem(LABEL_RECALCULATE_MSN);
            item.addActionListener(this);
            this.addItemPopup_.add(item);
            item = new JMenuItem(LABEL_EDIT_RT);
            item.addActionListener(this);
            this.addItemPopup_.add(item);
        }
        item = new JMenuItem(LABEL_EDIT_OMEGA_ASSIGNMENT);
        item.addActionListener(this);
        this.addItemPopup_.add(item);
        this.add(this.addItemPopup_);
        this.controlDown_ = false;
        this.shiftDown_ = false;
        this.lastSelectedIndex_ = 0;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                    Point p = e.getPoint();
                    ListSelectionModel model = LipidomicsJTable.this.getSelectionModel();
                    int rowNumber = LipidomicsJTable.this.rowAtPoint(p);
                    if (e.isControlDown() || e.isShiftDown()) {
                        if (e.isControlDown()) {
                            LipidomicsJTable.this.controlDown_ = true;
                        }
                        if (e.isShiftDown()) {
                            LipidomicsJTable.this.shiftDown_ = true;
                        }
                        if (SwingUtilities.isRightMouseButton(e)) {
                            if (e.isShiftDown()) {
                                model.setAnchorSelectionIndex(LipidomicsJTable.this.lastSelectedIndex_);
                                model.setLeadSelectionIndex(rowNumber);
                            }
                            if (e.isControlDown()) {
                                model.addSelectionInterval(rowNumber, rowNumber);
                            }
                            LipidomicsJTable.this.showMs2OrMs1Selection();
                            LipidomicsJTable.this.addItemPopup_.show(e.getComponent(), e.getX(), e.getY());
                        }
                        LipidomicsJTable.this.lastSelectedIndex_ = rowNumber;
                    } else {
                        LipidomicsJTable.this.controlDown_ = false;
                        LipidomicsJTable.this.shiftDown_ = false;
                        LipidomicsJTable.this.parentListener_.listSelectionChanged(rowNumber);
                        if (SwingUtilities.isRightMouseButton(e)) {
                            model.setSelectionInterval(rowNumber, rowNumber);
                            LipidomicsJTable.this.showMs2OrMs1Selection();
                            LipidomicsJTable.this.addItemPopup_.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (LipidomicsJTable.this.controlDown_ && !e.isControlDown() || LipidomicsJTable.this.shiftDown_ && !e.isShiftDown()) {
                    LipidomicsJTable.this.controlDown_ = false;
                    LipidomicsJTable.this.shiftDown_ = false;
                    LipidomicsJTable.this.parentListener_.listSelectionChanged(LipidomicsJTable.this.lastSelectedIndex_);
                }
            }
        });
        this.setToolTipText("<html>Click left mouse button to select an analyte and display it.<br/>Click right mouse button to add analyte before or after, or delete it.</html>");
        this.hasOh_ = model.hasOhInfo();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.renderer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(e.getActionCommand());
    }

    private void actionPerformed(String actionCommand) {
        switch (actionCommand) {
            case "Add analyte before": {
                int position = this.getSelectionModel().getLeadSelectionIndex();
                LipidParameterSet params = this.parentListener_.getAnalyteInTableAtPosition(position);
                String displayString = params.getNameString();
                if (params.getModificationName() != null && params.getModificationName().length() > 0) {
                    displayString = displayString + "_" + params.getModificationName();
                }
                new AddAnalyteDialog(new JFrame(), "Enter new analyte", "Add a new analyte before " + displayString, params.getNameString(), params.Mz[0], params.getAnalyteFormula(), params.getModificationName(), params.getModificationFormula(), position, this.showRt_, this.hasOh_ ? String.valueOf(params.getOhNumber()) : null, this.parentListener_);
                break;
            }
            case "Add analyte after": {
                int position = this.getSelectionModel().getLeadSelectionIndex() + 1;
                LipidParameterSet params = this.parentListener_.getAnalyteInTableAtPosition(position - 1);
                String displayString = params.getNameString();
                if (params.getModificationName() != null && params.getModificationName().length() > 0) {
                    displayString = displayString + "_" + params.getModificationName();
                }
                new AddAnalyteDialog(new JFrame(), "Enter new analyte", "Add a new analyte after " + displayString, params.getNameString(), params.Mz[0], params.getAnalyteFormula(), params.getModificationName(), params.getModificationFormula(), position, this.showRt_, this.hasOh_ ? String.valueOf(params.getOhNumber()) : null, this.parentListener_);
                break;
            }
            case "Delete analyte": {
                int[] indices = this.getSelectedRows();
                int count = 0;
                String displayString = "\n";
                for (int ind : indices) {
                    ++count;
                    LipidParameterSet params = this.parentListener_.getAnalyteInTableAtPosition(ind);
                    displayString = displayString + params.getNameString();
                    if (params.getModificationName() != null && params.getModificationName().length() > 0) {
                        displayString = displayString + "_" + params.getModificationName();
                    }
                    displayString = displayString + ", ";
                    if (count % 8 != 0) continue;
                    displayString = displayString + "\n";
                }
                if (displayString.endsWith("\n")) {
                    displayString = displayString.substring(0, displayString.length() - 1);
                }
                if (displayString.length() > 1) {
                    displayString = displayString.substring(0, displayString.length() - 2);
                }
                if (JOptionPane.showConfirmDialog(this, "Do you really want to delete " + displayString + "?") != 0) break;
                this.parentListener_.removeAnalyte(indices);
                break;
            }
            case "Delete molecular species": {
                ArrayList<Integer> msnIndices = new ArrayList<Integer>();
                String displayString = "\n";
                for (int ind : this.getSelectedRows()) {
                    LipidParameterSet params = this.parentListener_.getAnalyteInTableAtPosition(ind);
                    if (!(params instanceof LipidomicsMSnSet) || ((LipidomicsMSnSet)params).getStatus() <= 2) continue;
                    msnIndices.add(ind);
                    displayString = displayString + this.parentListener_.getNameInTableAtPosition(ind);
                    displayString = displayString + ", ";
                    if (msnIndices.size() % 8 != 0) continue;
                    displayString = displayString + "\n";
                }
                if (msnIndices.isEmpty()) {
                    new WarningMessage(new JFrame(), "Error trying to delete molecular species.", String.format("The selected analytes do not contain any identifications at the molecular species level. Use the option '%s' instead!", LABEL_DELETE_ANALYTE));
                    break;
                }
                if (displayString.endsWith("\n")) {
                    displayString = displayString.substring(0, displayString.length() - 1);
                }
                if (displayString.length() > 1) {
                    displayString = displayString.substring(0, displayString.length() - 2);
                }
                if (JOptionPane.showConfirmDialog(this, "Do you really want to delete " + displayString + "?") != 0) break;
                this.parentListener_.removeMolecularSpecies(msnIndices);
                break;
            }
            case "Show MS/MS": {
                int position = this.getSelectionModel().getLeadSelectionIndex();
                this.parentListener_.showMs2(position);
                break;
            }
            case "Show MS1": {
                int position = this.getSelectionModel().getLeadSelectionIndex();
                this.parentListener_.initANewViewer(position);
                break;
            }
            case "Sort by order": {
                this.parentListener_.changeListSorting(0);
                break;
            }
            case "Sort by mass": {
                this.parentListener_.changeListSorting(1);
                break;
            }
            case "Sort by intensity": {
                this.parentListener_.changeListSorting(2);
                break;
            }
            case "Edit MSn rule": {
                int position = this.getSelectionModel().getLeadSelectionIndex();
                this.parentListener_.newRule(position);
                break;
            }
            case "Recalculate MSn": {
                int position = this.getSelectionModel().getLeadSelectionIndex();
                this.parentListener_.recalculateMSn(position);
                break;
            }
            case "Edit Rt": {
                int position = this.getSelectionModel().getLeadSelectionIndex();
                this.parentListener_.editRt(position);
                break;
            }
            case "Edit \u03c9-DB Assignment": {
                int position = this.getSelectionModel().getLeadSelectionIndex();
                this.parentListener_.editOmegaAssignment(position);
            }
        }
    }

    public String getDisplayedNameAt(int rowIndex) {
        return ((LipidomicsTableModel)super.getModel()).getDisplayedNameAt(rowIndex);
    }

    private void showMs2OrMs1Selection() {
        if (this.parentListener_.isMS2Showing()) {
            this.showMS2_.setVisible(false);
            this.showMS1_.setVisible(true);
        } else {
            this.showMS2_.setVisible(true);
            this.showMS1_.setVisible(false);
        }
    }
}

