/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.dbutilities.SimpleValueObject;
import at.tugraz.genome.lda.ChromExportThread;
import at.tugraz.genome.lda.LipidDataAnalyzer;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.ComparativeAnalysis;
import at.tugraz.genome.lda.analysis.HeatMapClickListener;
import at.tugraz.genome.lda.analysis.LipidomicsHeatMap;
import at.tugraz.genome.lda.analysis.exception.CalculationNotPossibleException;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RetentionTimeGroupingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.export.ExcelAndTextExporter;
import at.tugraz.genome.lda.export.OmegaCollector;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.swing.CheckBoxOptionPane;
import at.tugraz.genome.lda.swing.ChromExportDialog;
import at.tugraz.genome.lda.swing.ExportButton;
import at.tugraz.genome.lda.swing.ExportPanel;
import at.tugraz.genome.lda.swing.ExportSettingsPanel;
import at.tugraz.genome.lda.swing.InputDialog;
import at.tugraz.genome.lda.swing.ResultDisplaySettings;
import at.tugraz.genome.lda.swing.ResultSelectionSettings;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.AutoAnalyteAddVO;
import at.tugraz.genome.lda.vos.ExportOptionsVO;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.lda.vos.ResultCompVO;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class HeatMapDrawing
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 9212631108743680488L;
    private static final String SELECTION_MODE_OFF = "Off";
    private static final String SELECTION_MODE_MOLECULE_ROWS = "ID groups (rows)";
    private static final String SELECTION_MODE_SINGLE_MOLECULES = "Single IDs (rectangles)";
    private static final String SELECTION_MODE_BOTH = "ID groups and single IDs";
    private static final String[] SELECTION_MODE_OPTIONS = new String[]{"Off", "ID groups (rows)", "Single IDs (rectangles)", "ID groups and single IDs"};
    private static final String CHANGE_SELECTION_MODE = "changeSelectionMode";
    public static final String DISPLAY_OPTION_SUM_COMP = "Sum compositions only";
    public static final String DISPLAY_OPTION_BOTH = "Include lipid molecular species";
    protected static final String[] DISPLAY_OPTIONS = new String[]{"Sum compositions only", "Include lipid molecular species"};
    protected static final String CHANGE_DISPLAY_OPTION = "changeDisplayOption";
    public static final String DISPLAY_OPTION_ALL_GROUPS = "All ID groups";
    public static final String DISPLAY_OPTION_MSN_VERIFIED_GROUPS = "ID groups verified by MS/MS";
    protected static final String[] DISPLAY_OPTIONS_MSN = new String[]{"All ID groups", "ID groups verified by MS/MS"};
    protected static final String CHANGE_DISPLAY_OPTION_MSN = "changeDisplayOptionMSn";
    public static final String SORT_OPTION_DEFAULT = "Sort by order in file";
    public static final String SORT_OPTION_SPECIES = "Sort by species name";
    public static final String SORT_OPTION_RT = "Sort by elution order";
    public static final String SORT_OPTION_MZ = "Sort by precursor m/z";
    public static final String SORT_OPTION_AREA = "Sort by average intensity (sum compositions separate)";
    protected static final String[] SORTING_OPTIONS = new String[]{"Sort by order in file", "Sort by species name", "Sort by elution order", "Sort by precursor m/z", "Sort by average intensity (sum compositions separate)"};
    protected static final String CHANGE_SORTING_OPTION = "changeSortingOption";
    protected static final String CHANGE_IS_STATUS = "changeISShowStatus";
    protected static final String CHANGE_ES_STATUS = "changeESShowStatus";
    protected static final String CHANGE_DOUBLE_STATUS = "changeDoublePeaksStatus";
    private static final String SELECT_ROW = "Select analyte";
    private static final String DESELECT_ROW = "Deselect analyte";
    private static final String SELECT_SINGLE = "Select";
    private static final String DESELECT_SINGLE = "Deselect";
    private LipidomicsHeatMap heatmap_;
    private BufferedImage renderedImage_;
    private int imagePositionY_ = 0;
    private int imagePositionX_ = 0;
    private Rectangle rectToDraw_ = null;
    private JLabel label_;
    private JPanel heatMapPanel_;
    private JLabel statusText_;
    private JPanel exportProgressPanel_;
    protected HeatMapClickListener heatMapListener_;
    protected String groupName_;
    private JComboBox<String> showOption_;
    private JComboBox<String> showOptionMSn_;
    private JComboBox<String> selectionMode_;
    private JComboBox<String> sortMode_;
    protected JCheckBox showInternalStandards_;
    protected JCheckBox showExternalStandards_;
    protected JCheckBox markDoublePeaks_;
    protected JComboBox<String> maxIsotopes_;
    protected Hashtable<String, Hashtable<String, ResultCompVO>> resultsOfOneGroup_;
    protected Vector<String> experimentNames_;
    protected final Vector<String> moleculeNames_;
    protected Hashtable<String, Integer> isLookup_;
    protected Hashtable<String, Integer> esLookup_;
    protected ResultDisplaySettingsVO settingsVO_;
    protected ResultDisplaySettings displaySettings_;
    protected ResultSelectionSettings selectionSettings_;
    protected ExportSettingsPanel exportSettings_;
    protected ResultSelectionSettings combinedChartSettings_;
    protected boolean isGrouped_ = false;
    private JFileChooser exportFileChooser_;
    protected JLabel exportLabel_;
    protected JProgressBar exportProgress_;
    protected JLabel spinnerLabel_;
    protected JButton cancelExport_;
    private Set<Integer> selectedMoleculeRows_;
    private Hashtable<String, Hashtable<String, Color>> selectedSingleMolecules_;
    private Hashtable<String, Hashtable<String, String>> selectedSingleMoleculesMods_;
    private Hashtable<String, String> selectedSingleMoleculesAbsPaths_;
    private Hashtable<String, Vector<AutoAnalyteAddVO>> selectedSingleMoleculesAutoAnalyteAddVO_;
    private Hashtable<String, Integer> selectedSingleMoleculesMaxIso_;
    private boolean parentAction_;
    private PopupMenu applySettingsPopup_;
    private PopupMenu removeAnalytePopup_;
    private MenuItem selectItem_;
    private MenuItem deselectItem_;
    private MenuItem selectSingleItem_;
    private MenuItem deselectSingleItem_;
    private MenuItem applyToAllDoubles_;
    private int[] lastClickedCellPos_;
    private int lastClickedRow_;
    private ArrayList<String> modifications_;
    private ChromExportDialog chromExport_;
    private Hashtable<String, String> fromShortToExpName_;
    private Double rtTolerance_;
    private HeatMapDrawing ungroupedPartner_;
    private ChromExportThread chromExportThread_;
    private Timer timer_;
    private boolean isMoleculeRowSelectionMode_ = false;
    private boolean isSingleMoleculeSelectionMode_ = false;

    public HeatMapDrawing(Hashtable<String, Hashtable<String, ResultCompVO>> resultsOfOneGroup, Vector<String> experimentNames, Vector<String> moleculeNames, Hashtable<String, Integer> isLookup, Hashtable<String, Integer> esLookup, JLabel statusText, HeatMapClickListener listener, String groupName, HeatMapDrawing ungroupedPartner, ResultDisplaySettings displaySettings, ResultSelectionSettings selectionSettings, ResultSelectionSettings combinedChartSettings, ExportSettingsPanel exportSettings, ComparativeAnalysis analysisModule) {
        this.resultsOfOneGroup_ = resultsOfOneGroup;
        this.experimentNames_ = new Vector<String>(experimentNames);
        this.moleculeNames_ = moleculeNames;
        this.isLookup_ = isLookup;
        this.esLookup_ = esLookup;
        this.statusText_ = statusText;
        this.heatMapListener_ = listener;
        this.groupName_ = groupName;
        this.isGrouped_ = ungroupedPartner != null;
        this.ungroupedPartner_ = ungroupedPartner;
        this.displaySettings_ = displaySettings;
        this.displaySettings_.addActionListener(this);
        this.selectionSettings_ = selectionSettings;
        this.selectionSettings_.addActionListener(this);
        this.combinedChartSettings_ = combinedChartSettings;
        this.combinedChartSettings_.addActionListener(this);
        this.exportSettings_ = exportSettings;
        this.maxIsotopes_ = this.generateMaxIsotopesJComboBox(analysisModule.getMaxIsotopesOfGroup(groupName));
        this.modifications_ = new ArrayList(analysisModule.getModifications().get(groupName));
        this.rtTolerance_ = analysisModule.getRtTolerance();
        this.settingsVO_ = this.displaySettings_.getSettingsVO();
        this.selectedMoleculeRows_ = ConcurrentHashMap.newKeySet();
        this.selectedSingleMolecules_ = new Hashtable();
        this.selectedSingleMoleculesMods_ = new Hashtable();
        this.selectedSingleMoleculesAbsPaths_ = new Hashtable();
        this.selectedSingleMoleculesAutoAnalyteAddVO_ = new Hashtable();
        this.selectedSingleMoleculesMaxIso_ = new Hashtable();
        this.parentAction_ = true;
        this.getSettingsPanel();
        this.applySettingsPopup_ = new PopupMenu("Apply Peak-RT to double peaks");
        this.applyToAllDoubles_ = new MenuItem("Choose just one peak for doubles");
        this.applyToAllDoubles_.addActionListener(this);
        this.applySettingsPopup_.add(this.applyToAllDoubles_);
        MenuItem quantOthers = new MenuItem("Quant. anal. at not found");
        quantOthers.addActionListener(this);
        this.applySettingsPopup_.add(quantOthers);
        quantOthers = new MenuItem("Take exact peak for others");
        quantOthers.addActionListener(this);
        this.applySettingsPopup_.add(quantOthers);
        this.selectSingleItem_ = new MenuItem(SELECT_SINGLE);
        this.selectSingleItem_.addActionListener(this);
        this.applySettingsPopup_.add(this.selectSingleItem_);
        this.deselectSingleItem_ = new MenuItem(DESELECT_SINGLE);
        this.deselectSingleItem_.addActionListener(this);
        this.applySettingsPopup_.add(this.deselectSingleItem_);
        this.add(this.applySettingsPopup_);
        this.removeAnalytePopup_ = new PopupMenu("Remove analyte");
        MenuItem removeItem = new MenuItem("Remove analyte in all probes");
        removeItem.addActionListener(this);
        this.removeAnalytePopup_.add(removeItem);
        this.selectItem_ = new MenuItem(SELECT_ROW);
        this.selectItem_.addActionListener(this);
        this.removeAnalytePopup_.add(this.selectItem_);
        this.deselectItem_ = new MenuItem(DESELECT_ROW);
        this.deselectItem_.addActionListener(this);
        this.removeAnalytePopup_.add(this.deselectItem_);
        this.add(this.removeAnalytePopup_);
        this.exportFileChooser_ = new JFileChooser();
        this.exportFileChooser_.setPreferredSize(new Dimension(600, 500));
        this.generateHeatMap();
        if (!this.isGrouped_) {
            this.chromExport_ = new ChromExportDialog("Chrom export", this.getDisplayNames(), this.heatmap_.getOriginalAnalyteNames(), this.modifications_, this);
        }
        this.chromExportThread_ = null;
        this.initTimer();
    }

    public JPanel getSettingsPanel() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insetsLess = new Insets(1, 0, 1, 10);
        int y = 0;
        if (!this.isGrouped_) {
            settingsPanel.add((Component)new JLabel("Selection mode: "), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.selectionMode_ = new JComboBox<String>(SELECTION_MODE_OPTIONS);
            this.selectionMode_.setActionCommand(CHANGE_SELECTION_MODE);
            this.selectionMode_.addActionListener(this);
            this.selectionMode_.setToolTipText("<html>Allows for quick selection/deselection of the chosen option with a single left-click.</html>");
            settingsPanel.add(this.selectionMode_, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            ++y;
        }
        settingsPanel.add((Component)new JLabel("Number of isotopes: "), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        settingsPanel.add(this.maxIsotopes_, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        settingsPanel.add((Component)new JLabel("Display options: "), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        JPanel displayOptionsPanel = new JPanel();
        displayOptionsPanel.setLayout(new GridBagLayout());
        settingsPanel.add((Component)displayOptionsPanel, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        ++y;
        JPanel displayOptionsPanelTop = new JPanel();
        displayOptionsPanelTop.setLayout(new GridBagLayout());
        displayOptionsPanel.add((Component)displayOptionsPanelTop, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insetsLess, 0, 0));
        JPanel displayOptionsPanelBottom = new JPanel();
        displayOptionsPanelBottom.setLayout(new GridBagLayout());
        displayOptionsPanel.add((Component)displayOptionsPanelBottom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insetsLess, 0, 0));
        if (!this.isGrouped_) {
            this.showOption_ = new JComboBox<String>(DISPLAY_OPTIONS);
            this.showOption_.setActionCommand(CHANGE_DISPLAY_OPTION);
            this.showOption_.addActionListener(this);
            this.showOption_.setToolTipText("<html>Select at which level of structural detail analyte groups should be displayed.</html>");
            displayOptionsPanelTop.add(this.showOption_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insetsLess, 0, 0));
        }
        this.showOptionMSn_ = new JComboBox<String>(DISPLAY_OPTIONS_MSN);
        this.showOptionMSn_.setActionCommand(CHANGE_DISPLAY_OPTION_MSN);
        this.showOptionMSn_.addActionListener(this);
        this.showOptionMSn_.setToolTipText("<html>Select at which level of MS verification analyte groups should be displayed. <br>One analyte per RT group meeting the desired level of verification suffices for all IDs of the group to be included. <br>Standards are included in any case.</html>");
        displayOptionsPanelTop.add(this.showOptionMSn_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insetsLess, 0, 0));
        this.sortMode_ = new JComboBox<String>(SORTING_OPTIONS);
        this.sortMode_.setActionCommand(CHANGE_SORTING_OPTION);
        this.sortMode_.addActionListener(this);
        this.sortMode_.setToolTipText("<html>Choose the way analytes are sorted.</html>");
        displayOptionsPanelTop.add(this.sortMode_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.showInternalStandards_ = new JCheckBox("internal standards");
        this.showInternalStandards_.setSelected(true);
        this.showInternalStandards_.setActionCommand(CHANGE_IS_STATUS);
        this.showInternalStandards_.addActionListener(this);
        this.showInternalStandards_.setToolTipText("<html>Display the internal standards in the heat map or not.</html>");
        displayOptionsPanelBottom.add((Component)this.showInternalStandards_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insetsLess, 0, 0));
        this.showExternalStandards_ = new JCheckBox("external standards");
        this.showExternalStandards_.setSelected(true);
        this.showExternalStandards_.setActionCommand(CHANGE_ES_STATUS);
        this.showExternalStandards_.addActionListener(this);
        this.showExternalStandards_.setToolTipText("<html>Display the external standards in the heat map or not.</html>");
        displayOptionsPanelBottom.add((Component)this.showExternalStandards_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insetsLess, 0, 0));
        if (!this.isGrouped_) {
            this.markDoublePeaks_ = new JCheckBox("double peaks/missed mods");
            this.markDoublePeaks_.setSelected(true);
            this.markDoublePeaks_.setActionCommand(CHANGE_DOUBLE_STATUS);
            this.markDoublePeaks_.addActionListener(this);
            this.markDoublePeaks_.setToolTipText("<html>Highlight double peaks with a yellow rectangle.</html>");
            displayOptionsPanelBottom.add((Component)this.markDoublePeaks_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insetsLess, 0, 0));
        }
        JPanel buttonsPanel = new JPanel();
        ExportButton settingsButton = new ExportButton("Quantitative settings", "openSettingsDialog", Color.BLACK, Color.decode("#EEEEEE"), "<html>Settings of how to calculate the quantitative value.</html>", this);
        buttonsPanel.add(settingsButton);
        buttonsPanel.add(new JLabel(" | "));
        ExportButton selectionButton = new ExportButton("Select displayed molecules", "openSelectionDialog", Color.BLACK, Color.decode("#EEEEEE"), "<html>Selection of molecules that should be displayed in the heat map.</html>", this);
        buttonsPanel.add(selectionButton);
        buttonsPanel.add(new JLabel(" | "));
        ExportButton combinedButton = new ExportButton("Combined bar chart", "openCombinedDialog", Color.BLACK, Color.decode("#EEEEEE"), "<html>Selection of molecules to create a combined bar chart.</html>", this);
        buttonsPanel.add(combinedButton);
        buttonsPanel.add(new JLabel(" | "));
        ExportButton exportButton = new ExportButton("Data export options", "exportSelectionDialog", Color.BLACK, Color.decode("#EEEEEE"), "<html>Options for the data export (which values should be exported, what should be in the raw and what in the column).</html>", this);
        buttonsPanel.add(exportButton);
        settingsPanel.add((Component)new JLabel("Advanced options: "), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        settingsPanel.add((Component)buttonsPanel, new GridBagConstraints(1, y, 9, 1, 0.0, 0.0, 17, 0, insetsLess, 0, 0));
        ExportPanel exportPanel = new ExportPanel(Color.decode("#EEEEEE"), Color.BLACK, this, !this.isGrouped_, true, false);
        JLabel exportLabel = new JLabel("Export: ");
        exportLabel.setToolTipText("<html>The available export options.</html>");
        settingsPanel.add((Component)exportLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        settingsPanel.add((Component)exportPanel, new GridBagConstraints(1, y, 9, 1, 0.0, 0.0, 18, 0, insetsLess, 0, 0));
        ++y;
        this.exportProgressPanel_ = new JPanel();
        this.exportLabel_ = new JLabel("");
        this.exportLabel_.setToolTipText("<html>Current export status</html>");
        this.exportProgressPanel_.add(this.exportLabel_);
        this.exportProgress_ = new JProgressBar();
        this.exportProgress_.setMaximum(100);
        this.exportProgress_.setToolTipText("<html>Quantitation progress</html>");
        this.exportProgressPanel_.add(this.exportProgress_);
        ImageIcon icon = new ImageIcon(LipidDataAnalyzer.class.getResource("/images/spinner.gif"));
        this.spinnerLabel_ = new JLabel(icon);
        this.exportProgressPanel_.add(this.spinnerLabel_);
        this.cancelExport_ = new JButton("Cancel");
        this.cancelExport_.addActionListener(this);
        this.cancelExport_.setActionCommand("stopChromExport");
        this.cancelExport_.setToolTipText("<html>Interrupts the currently running export<html/>");
        this.exportProgressPanel_.add(this.cancelExport_);
        this.exportProgressPanel_.setVisible(false);
        settingsPanel.add((Component)this.exportProgressPanel_, new GridBagConstraints(0, y, 10, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        return settingsPanel;
    }

    private JComboBox<String> generateMaxIsotopesJComboBox(int maxIsotopesOfGroup) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i != maxIsotopesOfGroup; ++i) {
            jComboBox.addItem(String.valueOf(i));
        }
        jComboBox.setSelectedItem(String.valueOf(maxIsotopesOfGroup - 1));
        SelectionItemListener isotopeListener = new SelectionItemListener("ChangeIsotope");
        jComboBox.addItemListener(isotopeListener);
        jComboBox.setToolTipText("<html>Upper limit for the additional isotopic peaks used for the quantitative value.</html>");
        return jComboBox;
    }

    public void generateHeatMap() {
        if (this.heatMapPanel_ != null) {
            this.remove(this.heatMapPanel_);
        }
        try {
            this.heatmap_ = new LipidomicsHeatMap(this);
            this.renderedImage_ = this.heatmap_.createImage();
            this.heatMapPanel_ = new JPanel();
            this.heatMapPanel_.setLayout(new GridBagLayout());
            JPanel justHeatMapPanel = new JPanel();
            this.label_ = new JLabel(new ImageIcon(this.renderedImage_));
            MyListener myListener = new MyListener();
            this.label_.addMouseListener(myListener);
            this.label_.addMouseMotionListener(myListener);
            justHeatMapPanel.add(this.label_);
            this.heatMapPanel_.add((Component)justHeatMapPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.heatMapPanel_, "North");
        }
        catch (CalculationNotPossibleException cex) {
            new WarningMessage(new JFrame(), "ERROR", cex.getMessage());
        }
        if (!this.isGrouped_ && this.chromExport_ != null) {
            this.chromExport_.refreshNames(this.getDisplayNames());
        }
    }

    public HeatMapClickListener getHeatMapListener() {
        return this.heatMapListener_;
    }

    public Hashtable<String, Hashtable<String, ResultCompVO>> getResultsOfOneGroup() {
        return this.resultsOfOneGroup_;
    }

    public Vector<String> getExperimentNames() {
        return this.experimentNames_;
    }

    public ResultDisplaySettingsVO getSettingsVO() {
        return this.settingsVO_;
    }

    public Dimension getTotalSize() {
        return new Dimension(this.renderedImage_.getWidth() + 10, this.renderedImage_.getHeight());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.actionPerformed(event.getActionCommand());
    }

    private void actionPerformed(String actionCommand) {
        Vector<String> foundUpdateables = new Vector<String>();
        Vector<AutoAnalyteAddVO> updateableAndAnalyteBefore = new Vector<AutoAnalyteAddVO>();
        Vector templateSpecies = new Vector();
        Hashtable<String, String> modHash = new Hashtable<String, String>();
        ResultCompVO vo = null;
        int maxIsotope = 0;
        if (actionCommand.equalsIgnoreCase(CHANGE_SELECTION_MODE)) {
            if (((String)this.selectionMode_.getSelectedItem()).equalsIgnoreCase(SELECTION_MODE_MOLECULE_ROWS)) {
                this.isMoleculeRowSelectionMode_ = true;
                this.isSingleMoleculeSelectionMode_ = false;
            } else if (((String)this.selectionMode_.getSelectedItem()).equalsIgnoreCase(SELECTION_MODE_SINGLE_MOLECULES)) {
                this.isMoleculeRowSelectionMode_ = false;
                this.isSingleMoleculeSelectionMode_ = true;
            } else if (((String)this.selectionMode_.getSelectedItem()).equalsIgnoreCase(SELECTION_MODE_BOTH)) {
                this.isMoleculeRowSelectionMode_ = true;
                this.isSingleMoleculeSelectionMode_ = true;
            } else {
                this.isMoleculeRowSelectionMode_ = false;
                this.isSingleMoleculeSelectionMode_ = false;
            }
        }
        if (actionCommand.equalsIgnoreCase(CHANGE_IS_STATUS) || actionCommand.equalsIgnoreCase(CHANGE_ES_STATUS) || actionCommand.equalsIgnoreCase(CHANGE_DOUBLE_STATUS) || actionCommand.equalsIgnoreCase("AcceptDisplaySettings") || actionCommand.equalsIgnoreCase("ApplyDisplaySettingsToAllLipidClasses")) {
            this.settingsVO_ = this.displaySettings_.getSettingsVO();
            this.selectionSettings_.setVisible(false);
            boolean update = true;
            if (this.combinedChartSettings_.isOpen()) {
                update = false;
                if (this.combinedChartSettings_.getSelected().size() == 0) {
                    new WarningMessage(new JFrame(), "Error", "You have to select at least one molecule!");
                    return;
                }
                this.combinedChartSettings_.close();
                int maxIsotopes = this.getSelectedIsotope();
                Hashtable<String, String> preferredUnits = new Hashtable<String, String>();
                for (String name : this.combinedChartSettings_.getSelected()) {
                    int index = this.heatmap_.getAnalyteIndex(name);
                    if (index < 0) continue;
                    preferredUnits.put(name, this.heatmap_.getPreferredUnit(index));
                }
                String preferredUnit = this.heatmap_.extractPreferredUnitForExp(preferredUnits);
                if (this.isGrouped_) {
                    this.heatMapListener_.combinedAnalyteGroupSelected(this.combinedChartSettings_.getSelected(), this.groupName_, maxIsotopes, this.rtTolerance_ != null, this.settingsVO_, preferredUnit, StaticUtils.getCorrespondingUnit(this.settingsVO_, preferredUnit, true));
                } else {
                    this.heatMapListener_.combinedAnalyteSelected(this.combinedChartSettings_.getSelected(), this.groupName_, maxIsotopes, this.rtTolerance_ != null, this.settingsVO_, preferredUnit, StaticUtils.getCorrespondingUnit(this.settingsVO_, preferredUnit, true));
                }
            }
            if (actionCommand.equalsIgnoreCase(CHANGE_IS_STATUS) && !this.isGrouped_) {
                this.chromExport_.checkMolecules(this.getISs(), this.showInternalStandards_.isSelected());
            } else if (actionCommand.equalsIgnoreCase(CHANGE_ES_STATUS) && !this.isGrouped_) {
                this.chromExport_.checkMolecules(this.getESs(), this.showExternalStandards_.isSelected());
            } else if (!this.isGrouped_ && (actionCommand.equalsIgnoreCase("AcceptDisplaySettings") || actionCommand.equalsIgnoreCase("ApplyDisplaySettingsToAllLipidClasses"))) {
                this.chromExport_.checkMolecules(this.getUnselectedMoleculeNames(), false);
            }
            if (actionCommand.equalsIgnoreCase("ApplyDisplaySettingsToAllLipidClasses")) {
                this.heatMapListener_.applySettingsToAllClasses(this.displaySettings_);
            }
            if (actionCommand.equalsIgnoreCase(CHANGE_IS_STATUS) && this.parentAction_) {
                this.heatMapListener_.changeISStatus(this.groupName_, this.isGrouped_, this.showInternalStandards_.isSelected());
            }
            if (actionCommand.equalsIgnoreCase(CHANGE_ES_STATUS) && this.parentAction_) {
                this.heatMapListener_.changeESStatus(this.groupName_, this.isGrouped_, this.showExternalStandards_.isSelected());
            }
            if (update) {
                this.generateHeatMap();
                this.invalidate();
                this.updateUI();
            }
        } else if (actionCommand.equals(CHANGE_DISPLAY_OPTION) || actionCommand.equals(CHANGE_DISPLAY_OPTION_MSN) || actionCommand.equals(CHANGE_SORTING_OPTION)) {
            this.selectedMoleculeRows_.clear();
            this.selectedSingleMolecules_.clear();
            if (actionCommand.equals(CHANGE_DISPLAY_OPTION_MSN) && ((String)this.showOptionMSn_.getSelectedItem()).equalsIgnoreCase(DISPLAY_OPTION_ALL_GROUPS)) {
                this.selectionSettings_.updateNames(this.moleculeNames_, true);
                this.combinedChartSettings_.updateNames(this.moleculeNames_, false);
                if (this.chromExport_ != null) {
                    this.chromExport_.updateAnalyteNames(new ArrayList<String>(this.moleculeNames_));
                }
            }
            this.generateHeatMap();
            if (actionCommand.equals(CHANGE_DISPLAY_OPTION_MSN) && ((String)this.showOptionMSn_.getSelectedItem()).equalsIgnoreCase(DISPLAY_OPTION_MSN_VERIFIED_GROUPS)) {
                Vector<String> analyteNames = new Vector<String>(this.heatmap_.getOriginalAnalyteNames());
                this.selectionSettings_.updateNames(analyteNames, true);
                this.combinedChartSettings_.updateNames(analyteNames, false);
                if (this.chromExport_ != null) {
                    this.chromExport_.updateAnalyteNames(new ArrayList<String>(analyteNames));
                }
            }
            this.invalidate();
            this.updateUI();
        } else if (actionCommand.equalsIgnoreCase("openSettingsDialog")) {
            this.displaySettings_.setVisible(true);
        } else if (actionCommand.equalsIgnoreCase("openSelectionDialog")) {
            this.selectionSettings_.setVisible(true);
        } else if (actionCommand.equalsIgnoreCase("openCombinedDialog")) {
            this.combinedChartSettings_.open();
        } else if (actionCommand.equalsIgnoreCase("exportPNG")) {
            this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("PNG (*.png)", "png"));
            int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
            if (returnVal == 0) {
                File fileToStore = this.exportFileChooser_.getSelectedFile();
                Vector results = HeatMapDrawing.checkFileStorage(fileToStore, "png", this);
                fileToStore = (File)results.get(0);
                if (((Boolean)results.get(1)).booleanValue()) {
                    try {
                        ImageIO.write((RenderedImage)this.renderedImage_, "PNG", fileToStore);
                    }
                    catch (IOException e) {
                        new WarningMessage(new JFrame(), "Error", e.getMessage());
                    }
                }
            }
        } else if (actionCommand.equalsIgnoreCase("exportSVG")) {
            this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("SVG (*.svg)", "svg"));
            int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
            if (returnVal == 0) {
                File fileToStore = this.exportFileChooser_.getSelectedFile();
                Vector results = HeatMapDrawing.checkFileStorage(fileToStore, "svg", this);
                fileToStore = (File)results.get(0);
                if (((Boolean)results.get(1)).booleanValue()) {
                    try {
                        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                        String svgNS = "http://www.w3.org/2000/svg";
                        Document document = domImpl.createDocument(svgNS, "svg", null);
                        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                        this.heatmap_.createImage(svgGenerator);
                        boolean useCSS = true;
                        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileToStore));
                        OutputStreamWriter out = new OutputStreamWriter((OutputStream)stream, "UTF-8");
                        svgGenerator.stream(out, useCSS);
                    }
                    catch (IOException e) {
                        new WarningMessage(new JFrame(), "Error", e.getMessage());
                    }
                }
            }
        } else if (actionCommand.equalsIgnoreCase("exportSummary")) {
            this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("Microsoft Office Excel Woorkbook (*.xlsx)", "xlsx"));
            int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
            if (returnVal == 0) {
                File fileToStore = this.exportFileChooser_.getSelectedFile();
                Vector results = HeatMapDrawing.checkFileStorage(fileToStore, "xlsx", this);
                fileToStore = (File)results.get(0);
                if (((Boolean)results.get(1)).booleanValue()) {
                    this.heatMapListener_.exportSummary(fileToStore, this.isGrouped_);
                }
            }
        } else if (actionCommand.equalsIgnoreCase("exportExcel") || actionCommand.equalsIgnoreCase("exportText")) {
            ExportOptionsVO expOptions = this.getExportOptions();
            LinkedHashMap<String, String> expFullPaths = this.heatMapListener_.getSampleResultFullPaths();
            if (actionCommand.equalsIgnoreCase("exportExcel") || actionCommand.equalsIgnoreCase("exportText")) {
                int numberOfChains;
                short speciesType;
                boolean exportDoubleBondPositionsForClass;
                Hashtable<String, Hashtable<String, Vector<Double>>> resultValues;
                String preferredUnit;
                Hashtable<String, Hashtable<String, ResultCompVO>> compVOs;
                Vector results;
                File fileToStore;
                Hashtable<String, String> expIdToString = new Hashtable<String, String>();
                for (String expId : this.experimentNames_) {
                    expIdToString.put(expId, this.heatMapListener_.getDisplayName(expId));
                }
                if (actionCommand.equalsIgnoreCase("exportExcel")) {
                    this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("Microsoft Office Excel Woorkbook (*.xlsx)", "xlsx"));
                    int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
                    if (returnVal == 0) {
                        fileToStore = this.exportFileChooser_.getSelectedFile();
                        results = HeatMapDrawing.checkFileStorage(fileToStore, "xlsx", this);
                        fileToStore = (File)results.get(0);
                        if (((Boolean)results.get(1)).booleanValue()) {
                            try {
                                maxIsotope = this.getSelectedIsotope();
                                compVOs = this.resultsOfOneGroup_;
                                if (this.isGrouped_) {
                                    compVOs = this.ungroupedPartner_.resultsOfOneGroup_;
                                }
                                preferredUnit = this.heatmap_.extractPreferredUnitForExp();
                                resultValues = HeatMapDrawing.extractValuesOfInterest(compVOs, maxIsotope, this.settingsVO_, preferredUnit, expOptions, this.modifications_);
                                preferredUnit = StaticUtils.getCorrespondingUnit(this.settingsVO_, preferredUnit, true);
                                exportDoubleBondPositionsForClass = expOptions.isExportDoubleBondPositions();
                                speciesType = expOptions.getSpeciesType();
                                if (exportDoubleBondPositionsForClass) {
                                    numberOfChains = 2;
                                    try {
                                        numberOfChains = Integer.parseInt(RulesContainer.getAmountOfChains(StaticUtils.getRuleName(this.groupName_, this.modifications_.get(0))));
                                    }
                                    catch (NoRuleException | RulesException | SpectrummillParserException | IOException ex) {
                                        ex.printStackTrace();
                                    }
                                    if (numberOfChains > 1 && speciesType == 0) {
                                        exportDoubleBondPositionsForClass = false;
                                    } else if (numberOfChains == 1 && speciesType != 0) {
                                        speciesType = 0;
                                    }
                                }
                                ExcelAndTextExporter.exportToFile(true, speciesType, exportDoubleBondPositionsForClass, this.groupName_, new BufferedOutputStream(new FileOutputStream(fileToStore)), true, maxIsotope, this.getSelectedMoleculeNames(), this.rtTolerance_ != null, this.isGrouped_, this.experimentNames_, expIdToString, expFullPaths, this.heatMapListener_.getSamplesOfGroups(), resultValues, preferredUnit, StaticUtils.getAreaTypeString(this.settingsVO_), expOptions, this.heatMapListener_.getComparativeResultsLookup(), this.modifications_);
                            }
                            catch (NumberFormatException e) {
                                new WarningMessage(new JFrame(), "Error", e.getMessage());
                            }
                            catch (FileNotFoundException e) {
                                new WarningMessage(new JFrame(), "Error", e.getMessage());
                            }
                            catch (IOException e) {
                                new WarningMessage(new JFrame(), "Error", e.getMessage());
                            }
                            catch (CalculationNotPossibleException | ExcelInputFileException | ExportException | LipidCombinameEncodingException | RetentionTimeGroupingException | SpectrummillParserException e) {
                                new WarningMessage(new JFrame(), "Error", e.getMessage());
                            }
                        }
                    }
                } else if (actionCommand.equalsIgnoreCase("exportText")) {
                    this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("Text (*.txt)", "txt"));
                    int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
                    if (returnVal == 0) {
                        fileToStore = this.exportFileChooser_.getSelectedFile();
                        results = HeatMapDrawing.checkFileStorage(fileToStore, "txt", this);
                        fileToStore = (File)results.get(0);
                        if (((Boolean)results.get(1)).booleanValue()) {
                            try {
                                maxIsotope = this.getSelectedIsotope();
                                compVOs = this.resultsOfOneGroup_;
                                if (this.isGrouped_) {
                                    compVOs = this.ungroupedPartner_.resultsOfOneGroup_;
                                }
                                preferredUnit = this.heatmap_.extractPreferredUnitForExp();
                                resultValues = HeatMapDrawing.extractValuesOfInterest(compVOs, maxIsotope, this.settingsVO_, preferredUnit, expOptions, this.modifications_);
                                preferredUnit = StaticUtils.getCorrespondingUnit(this.settingsVO_, preferredUnit, true);
                                exportDoubleBondPositionsForClass = expOptions.isExportDoubleBondPositions();
                                speciesType = expOptions.getSpeciesType();
                                if (exportDoubleBondPositionsForClass) {
                                    numberOfChains = 2;
                                    try {
                                        numberOfChains = Integer.parseInt(RulesContainer.getAmountOfChains(StaticUtils.getRuleName(this.groupName_, this.modifications_.get(0))));
                                    }
                                    catch (NoRuleException | RulesException | SpectrummillParserException | IOException ex) {
                                        System.out.println(ex.getMessage());
                                    }
                                    if (numberOfChains > 1 && speciesType == 0) {
                                        exportDoubleBondPositionsForClass = false;
                                    } else if (numberOfChains == 1 && speciesType != 0) {
                                        speciesType = 0;
                                    }
                                }
                                ExcelAndTextExporter.exportToFile(true, speciesType, exportDoubleBondPositionsForClass, this.groupName_, new BufferedOutputStream(new FileOutputStream(fileToStore)), false, maxIsotope, this.getSelectedMoleculeNames(), this.rtTolerance_ != null, this.isGrouped_, this.experimentNames_, expIdToString, expFullPaths, this.heatMapListener_.getSamplesOfGroups(), resultValues, preferredUnit, StaticUtils.getAreaTypeString(this.settingsVO_), expOptions, this.heatMapListener_.getComparativeResultsLookup(), this.modifications_);
                            }
                            catch (NumberFormatException e) {
                                new WarningMessage(new JFrame(), "Error", e.getMessage());
                            }
                            catch (FileNotFoundException e) {
                                new WarningMessage(new JFrame(), "Error", e.getMessage());
                            }
                            catch (IOException e) {
                                new WarningMessage(new JFrame(), "Error", e.getMessage());
                            }
                            catch (CalculationNotPossibleException | ExcelInputFileException | ExportException | LipidCombinameEncodingException | RetentionTimeGroupingException | SpectrummillParserException e) {
                                new WarningMessage(new JFrame(), "Error", e.getMessage());
                            }
                        }
                    }
                }
            }
        } else if (actionCommand.equalsIgnoreCase("exportMztab") || actionCommand.equalsIgnoreCase("exportRdb")) {
            this.exportFileChooser_.setFileSelectionMode(0);
            int equalPartsAtBeginning = StaticUtils.detectNameUnequalitiesBeforeAndAfter(this.experimentNames_)[0];
            String fileName = "";
            String extension = "";
            String confirmDialogTitle = "";
            FileNameExtensionFilter filter = null;
            if (actionCommand.equalsIgnoreCase("exportMztab")) {
                fileName = "export-mztab.txt";
                extension = "mztab.txt";
                filter = new FileNameExtensionFilter("Text (*.txt)", "txt");
                confirmDialogTitle = "mzTab export";
            } else if (actionCommand.equalsIgnoreCase("exportRdb")) {
                fileName = "unified.tab";
                extension = "unified.tab";
                filter = new FileNameExtensionFilter("Tab (*.tab)", "tab");
                confirmDialogTitle = "RDB export";
            }
            if (equalPartsAtBeginning > 0) {
                fileName = this.experimentNames_.get(0).substring(0, equalPartsAtBeginning);
                if (!fileName.endsWith("-") && !fileName.endsWith("_")) {
                    fileName = fileName + "-";
                }
                fileName = fileName + extension;
            }
            this.exportFileChooser_.setSelectedFile(new File(fileName));
            this.exportFileChooser_.setFileFilter(filter);
            if (JOptionPane.showConfirmDialog(this, "Only selected analytes with the current isotopes selected will be exported! Continue?", confirmDialogTitle, 0) == 0) {
                int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
                if (returnVal != 0) {
                    return;
                }
                ExportOptionsVO expOptions = this.getExportOptions();
                File exportFile = this.exportFileChooser_.getSelectedFile();
                if (actionCommand.equalsIgnoreCase("exportMztab")) {
                    File fileToStore = this.exportFileChooser_.getSelectedFile();
                    Vector results = HeatMapDrawing.checkFileStorage(fileToStore, "txt", this);
                    fileToStore = (File)results.get(0);
                    if (((Boolean)results.get(1)).booleanValue()) {
                        this.heatMapListener_.exportMzTab(fileToStore, expOptions.getSpeciesType(), expOptions.isExportDoubleBondPositions());
                    }
                } else if (actionCommand.equalsIgnoreCase("exportRdb")) {
                    this.heatMapListener_.exportRdb(exportFile);
                }
            }
            this.exportFileChooser_.setSelectedFile(new File(""));
        } else if (actionCommand.equalsIgnoreCase("exportChroms")) {
            this.chromExport_.setVisible(true);
        } else if (actionCommand.equalsIgnoreCase("exportMAF")) {
            this.exportFileChooser_.setFileSelectionMode(0);
            int equalPartsAtBeginning = StaticUtils.detectNameUnequalitiesBeforeAndAfter(this.experimentNames_)[0];
            String fileName = "export-maf.tsv";
            if (equalPartsAtBeginning > 0) {
                fileName = this.experimentNames_.get(0).substring(0, equalPartsAtBeginning);
                if (!fileName.endsWith("-") && !fileName.endsWith("_")) {
                    fileName = fileName + "-";
                }
                fileName = fileName + "maf.tsv";
            }
            this.exportFileChooser_.setSelectedFile(new File(fileName));
            this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("Tab-separated (*.tsv)", "tsv"));
            if (JOptionPane.showConfirmDialog(this, "Only selected analytes with the current isotopes selected will be exported! Continue?", "mzTab export", 0) == 0) {
                int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
                if (returnVal != 0) {
                    return;
                }
                File exportFile = this.exportFileChooser_.getSelectedFile();
                this.heatMapListener_.exportMaf(exportFile);
            }
            this.exportFileChooser_.setSelectedFile(new File(""));
        } else if (actionCommand.equalsIgnoreCase("AcceptChromExport")) {
            Vector<String> expsToExport = new Vector<String>();
            Vector<String> analsToExport = new Vector<String>();
            Vector<String> resultFiles = new Vector<String>();
            Vector<String> chromsToUse = new Vector<String>();
            Vector<String> modsToUse = new Vector<String>();
            boolean chromFileExists = false;
            for (int i = 0; i != this.experimentNames_.size(); ++i) {
                Object resultFile;
                String name = this.experimentNames_.get(i);
                if (!this.chromExport_.isExperimentSelected(this.heatMapListener_.getDisplayName(name)) || (resultFile = this.heatmap_.getAbsoluteFilePathOfExperiment(i)) == null) continue;
                resultFiles.add((String)resultFile);
                String chromFileBase = StaticUtils.extractChromBaseName((String)resultFile, name);
                if (chromFileBase != null && chromFileBase.length() > 0) {
                    chromFileExists = true;
                }
                if (chromFileExists && !StaticUtils.existChromFiles(chromFileBase)) {
                    chromFileExists = false;
                }
                if (chromFileExists) {
                    String chromFilePath = chromFileBase + ".chrom";
                    chromsToUse.add(chromFilePath);
                    expsToExport.add(this.heatMapListener_.getDisplayName(name));
                    continue;
                }
                new WarningMessage(new JFrame(), "Error", "The '.chrom' files are required to be in the same directory as the specified result excel files!");
                break;
            }
            if (chromFileExists) {
                for (String mod : this.modifications_) {
                    if (!this.chromExport_.isModificationSelected(mod)) continue;
                    modsToUse.add(mod);
                }
                for (String name : this.heatmap_.getOriginalAnalyteNames()) {
                    if (!this.chromExport_.isMoleculeSelected(name)) continue;
                    if (this.modifications_.size() == 1) {
                        analsToExport.add(name);
                        continue;
                    }
                    if (this.modifications_.size() <= 1) continue;
                    for (String mod : modsToUse) {
                        analsToExport.add(name + "_" + mod);
                    }
                }
                if (expsToExport.size() > 0 && analsToExport.size() > 0 && chromsToUse.size() > 0 && modsToUse.size() > 0) {
                    this.exportFileChooser_.setSelectedFile(null);
                    this.exportFileChooser_.updateUI();
                    if (this.chromExport_.getPictureType().equalsIgnoreCase("exportPNG")) {
                        this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("PNG (*.png)", "png"));
                    } else if (this.chromExport_.getPictureType().equalsIgnoreCase("exportSVG")) {
                        this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("SVG (*.svg)", "svg"));
                    }
                    int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
                    if (returnVal == 0) {
                        File fileToStore = this.exportFileChooser_.getSelectedFile();
                        Iterator results = null;
                        if (this.chromExport_.getPictureType().equalsIgnoreCase("exportPNG")) {
                            results = HeatMapDrawing.checkFileStorage(fileToStore, "png", this);
                        }
                        if (this.chromExport_.getPictureType().equalsIgnoreCase("exportSVG")) {
                            results = HeatMapDrawing.checkFileStorage(fileToStore, "svg", this);
                        }
                        fileToStore = (File)((Vector)((Object)results)).get(0);
                        if (((Boolean)((Vector)((Object)results)).get(1)).booleanValue() && this.chromExportThread_ == null) {
                            this.chromExportThread_ = new ChromExportThread(this.groupName_, fileToStore, this.chromExport_.getPictureDimension(), expsToExport, resultFiles, chromsToUse, analsToExport, this.chromExport_.getPictureType(), this.exportSettings_.getSettings().isAnalyteInColumn(), this.rtTolerance_, this.isLookup_, this.esLookup_);
                            this.chromExportThread_.start();
                            this.spinnerLabel_.setVisible(true);
                            this.exportProgressPanel_.setVisible(true);
                        } else if (this.chromExportThread_ != null) {
                            new WarningMessage(new JFrame(), "Error", "There is already a chromatogram export running! Wait until it is finished!");
                            return;
                        }
                    }
                }
            }
        } else if (actionCommand.equalsIgnoreCase("Choose just one peak for doubles") || actionCommand.equalsIgnoreCase("Quant. anal. at not found") || actionCommand.equalsIgnoreCase("Take exact peak for others") || actionCommand.equalsIgnoreCase(SELECT_SINGLE)) {
            String expName = this.experimentNames_.get(this.lastClickedCellPos_[0]);
            String molName = this.heatmap_.getOriginalAnalyteName(this.lastClickedCellPos_[1]);
            if ((actionCommand.equalsIgnoreCase("Quant. anal. at not found") || actionCommand.equalsIgnoreCase("Take exact peak for others")) && this.selectedSingleMolecules_.containsKey(molName) && !this.selectedSingleMolecules_.get(molName).keySet().iterator().next().equalsIgnoreCase(expName)) {
                new WarningMessage(new JFrame(), "Error", "It is not allowed to select more than one from the same lipid species");
                return;
            }
            vo = this.heatmap_.getCompVO(this.lastClickedCellPos_[0], this.lastClickedCellPos_[1]);
            int sumCompRow = this.heatmap_.getSumCompVORow(this.lastClickedCellPos_[1]);
            Hashtable<String, String> availableMods = new Hashtable<String, String>();
            for (String modName : this.modifications_) {
                if (!vo.containsMod(modName)) continue;
                availableMods.put(modName, modName);
            }
            int maxIsotopes = this.getSelectedIsotope();
            foundUpdateables = new Vector();
            updateableAndAnalyteBefore = new Vector();
            modHash = new Hashtable();
            maxIsotope = 0;
            for (int i = 0; i != this.experimentNames_.size(); ++i) {
                ResultCompVO otherVO = this.heatmap_.getCompVO(i, sumCompRow);
                if (actionCommand.equalsIgnoreCase("Choose just one peak for doubles")) {
                    if (i == this.lastClickedCellPos_[0] || !otherVO.getMoreThanOnePeak(otherVO.getAvailableIsotopeNr(maxIsotopes))) continue;
                    boolean foundMod = false;
                    for (String modName : availableMods.keySet()) {
                        if (!otherVO.getMoreThanOnePeak(otherVO.getAvailableIsotopeNr(maxIsotopes), modName)) continue;
                        modHash.put(modName, modName);
                        foundMod = true;
                    }
                    if (!foundMod) continue;
                    foundUpdateables.add(otherVO.getAbsoluteFilePath());
                    continue;
                }
                if (!actionCommand.equalsIgnoreCase("Quant. anal. at not found") && !actionCommand.equalsIgnoreCase("Take exact peak for others") && !actionCommand.equalsIgnoreCase(SELECT_SINGLE) || i == this.lastClickedCellPos_[0]) continue;
                boolean modMissing = false;
                if (!otherVO.existsInFile()) {
                    modMissing = true;
                } else {
                    for (String modName : availableMods.keySet()) {
                        if (otherVO.containsMod(modName)) continue;
                        modMissing = true;
                        break;
                    }
                }
                if (!modMissing) continue;
                Object previousElement = "";
                for (int j = sumCompRow - 1; j > -1; --j) {
                    if (!this.heatmap_.getSumCompVO(i, j).existsInFile()) continue;
                    previousElement = this.heatmap_.getOriginalAnalyteName(j);
                    break;
                }
                updateableAndAnalyteBefore.add(new AutoAnalyteAddVO(this.experimentNames_.get(i), otherVO.getAbsoluteFilePath(), (String)previousElement));
                maxIsotope = vo.getUsedIsotpes();
                for (String modName : this.modifications_) {
                    if (!vo.containsMod(modName)) continue;
                    modHash.put(modName, modName);
                }
            }
            if (foundUpdateables.size() > 0 || updateableAndAnalyteBefore.size() > 0) {
                templateSpecies.add(new SimpleValueObject(molName, expName));
            } else {
                if (actionCommand.equalsIgnoreCase("Choose just one peak for doubles")) {
                    new WarningMessage(new JFrame(), "Error", "There are no double peaks to eliminate for " + molName + "!");
                    return;
                }
                if (actionCommand.equalsIgnoreCase("Quant. anal. at not found") || actionCommand.equalsIgnoreCase("Take exact peak for others") || actionCommand.equalsIgnoreCase(SELECT_SINGLE)) {
                    new WarningMessage(new JFrame(), "Error", "There are no peaks to add for " + molName + "!");
                    return;
                }
            }
        } else if (actionCommand.equalsIgnoreCase("Remove analyte in all probes")) {
            Vector<String> messages = new Vector<String>();
            ConcurrentHashMap.KeySetView analytesToRemove = ConcurrentHashMap.newKeySet();
            analytesToRemove.addAll(this.selectedMoleculeRows_);
            analytesToRemove.add(this.lastClickedRow_);
            this.generateAnalyteRemovalDialogue(analytesToRemove, messages);
            ConcurrentHashMap.KeySetView analytesToModify = ConcurrentHashMap.newKeySet();
            Iterator availableMods = analytesToRemove.iterator();
            while (availableMods.hasNext()) {
                int row = (Integer)availableMods.next();
                if (!this.heatmap_.isMolecularSpeciesLevel(row)) continue;
                analytesToModify.add(row);
            }
            analytesToRemove.removeAll(analytesToModify);
            Vector<String> selectedMods = CheckBoxOptionPane.showConfirmDialog(new JFrame(), "Confirmation", messages, this.modifications_, false);
            Set<String> filePaths = this.heatmap_.eliminateMolecularSpecies(analytesToModify, selectedMods);
            if (selectedMods.size() > 0) {
                Set<ResultCompVO> toRemove = this.heatmap_.getPresentCompVOsWithMod(analytesToRemove, selectedMods);
                this.heatMapListener_.eliminateAnalyteEverywhere(this.groupName_, toRemove, selectedMods, filePaths);
            }
        } else if (actionCommand.equalsIgnoreCase(SELECT_ROW) || actionCommand.equalsIgnoreCase(DESELECT_ROW)) {
            Graphics2D g2 = (Graphics2D)this.renderedImage_.getGraphics();
            this.selectAnalyte(this.lastClickedRow_);
            if (actionCommand.equalsIgnoreCase(SELECT_ROW)) {
                this.selectAnalyte(this.lastClickedRow_);
                g2.setColor(Color.BLUE);
            } else if (actionCommand.equalsIgnoreCase(DESELECT_ROW)) {
                g2.setColor(Color.BLACK);
                this.deselectAnalyte(this.lastClickedRow_);
            }
            Rectangle rectForName = this.heatmap_.getRectangleForRowNumber(this.lastClickedRow_);
            rectForName.setLocation(new Point(rectForName.getLocation().x + this.imagePositionX_, rectForName.getLocation().y + this.imagePositionY_));
            g2.fillRect(rectForName.x + 1, rectForName.y + 1, rectForName.width - 2, rectForName.height - 2);
            Font descriptionFont = new Font("Dialog", 0, 9);
            FontMetrics descriptionFontMetrics = g2.getFontMetrics();
            int textHeight = descriptionFontMetrics.getHeight();
            g2.setColor(Color.WHITE);
            g2.setFont(descriptionFont);
            g2.drawString(this.heatmap_.getAnalyteName(this.lastClickedRow_), rectForName.x + 1, rectForName.y + textHeight / 2);
            this.invalidate();
            this.updateUI();
        } else if (actionCommand.equalsIgnoreCase("stopChromExport")) {
            this.chromExportThread_.stopThread();
        } else if (actionCommand.equalsIgnoreCase("exportSelectionDialog")) {
            this.heatMapListener_.showExportSettingsDialog(this.isGrouped_);
        }
        if ((foundUpdateables.size() > 0 || updateableAndAnalyteBefore.size() > 0) && actionCommand.equalsIgnoreCase("Choose just one peak for doubles") || actionCommand.equalsIgnoreCase("Quant. anal. at not found") || actionCommand.equalsIgnoreCase("Take exact peak for others")) {
            SimpleValueObject currentlySelected = (SimpleValueObject)templateSpecies.get(0);
            Vector result = this.getSelectedIndividualSpeciesInCorrectOrder(currentlySelected, modHash, vo.getAbsoluteFilePath(), updateableAndAnalyteBefore, maxIsotope);
            templateSpecies = (Vector)result.get(0);
            Hashtable allMods = (Hashtable)result.get(1);
            Vector absPaths = (Vector)result.get(2);
            Hashtable updateablesAndAnalytesBefore = (Hashtable)result.get(3);
            Vector maxIsotopes = (Vector)result.get(4);
            Vector<String> confirmationMessages = new Vector<String>();
            String confirmationMessage = "Are you sure you want to eliminate double peaks for " + currentlySelected.getLabel() + "? The peak nearest to the RT of " + currentlySelected.getValue() + " is taken!";
            if (actionCommand.equalsIgnoreCase("Quant. anal. at not found") || actionCommand.equalsIgnoreCase("Take exact peak for others")) {
                confirmationMessage = "<html>Are you sure you want to automatically add peaks for the following molecules?";
                if (actionCommand.equalsIgnoreCase("Quant. anal. at not found")) {
                    confirmationMessage = confirmationMessage + "<br>The peak nearest to the RT of the following identifications (ID) are taken: </br>";
                } else if (actionCommand.equalsIgnoreCase("Take exact peak for others")) {
                    confirmationMessage = confirmationMessage + "<br>The exact peak borders of the following identifications (ID) are taken: </br>";
                }
                for (SimpleValueObject species : templateSpecies) {
                    confirmationMessage = confirmationMessage + "<br> ID: " + species.getLabel() + " &emsp; experiment: " + species.getValue() + " </br>";
                }
                confirmationMessage = confirmationMessage + "</html>";
                confirmationMessages.add(confirmationMessage);
            } else {
                confirmationMessages.add(confirmationMessage);
            }
            Vector<String> selectedMods = CheckBoxOptionPane.showConfirmDialog(new JFrame(), "Confirmation", confirmationMessages, new ArrayList<String>(allMods.values()), true);
            if (selectedMods.size() > 0) {
                boolean exactProbePosition = false;
                if (actionCommand.equalsIgnoreCase("Take exact peak for others")) {
                    exactProbePosition = true;
                }
                if (actionCommand.equalsIgnoreCase("Choose just one peak for doubles")) {
                    this.heatMapListener_.eliminateDoublePeaks(this.groupName_, ((SimpleValueObject)templateSpecies.get(0)).getLabel(), vo.getAbsoluteFilePath(), selectedMods, foundUpdateables);
                } else if (actionCommand.equalsIgnoreCase("Quant. anal. at not found") || actionCommand.equalsIgnoreCase("Take exact peak for others")) {
                    Vector<String> molNames = new Vector<String>();
                    for (SimpleValueObject svo : templateSpecies) {
                        molNames.add(svo.getLabel());
                    }
                    this.heatMapListener_.addAnalytesEverywhereAtPosition(this.groupName_, molNames, absPaths, selectedMods, updateablesAndAnalytesBefore, maxIsotopes, exactProbePosition);
                }
            }
        } else if (actionCommand.equalsIgnoreCase(SELECT_SINGLE) && (foundUpdateables.size() > 0 || updateableAndAnalyteBefore.size() > 0) || actionCommand.equalsIgnoreCase(DESELECT_SINGLE)) {
            Graphics2D g2 = (Graphics2D)this.renderedImage_.getGraphics();
            boolean printAttentionRectangle = false;
            if (actionCommand.equalsIgnoreCase(SELECT_SINGLE)) {
                if (!this.selectAnalyte(this.heatmap_.getOriginalAnalyteName(this.lastClickedCellPos_[1]), this.experimentNames_.get(this.lastClickedCellPos_[0]), this.heatmap_.getColorForCell(this.lastClickedCellPos_[1], this.lastClickedCellPos_[0]), modHash, vo.getAbsoluteFilePath(), updateableAndAnalyteBefore, maxIsotope)) {
                    return;
                }
                g2.setColor(Color.BLUE);
            } else if (actionCommand.equalsIgnoreCase(DESELECT_SINGLE)) {
                g2.setColor(this.deselectAnalyte(this.heatmap_.getOriginalAnalyteName(this.lastClickedCellPos_[1]), this.experimentNames_.get(this.lastClickedCellPos_[0])));
                if (this.isMarkDoublePeaks() && this.heatmap_.getAttentionProbe(this.lastClickedCellPos_[1], this.experimentNames_.get(this.lastClickedCellPos_[0])) != null) {
                    printAttentionRectangle = true;
                }
            }
            Rectangle cellRect = this.heatmap_.getRectangleForCellByRowAndColumn(this.lastClickedCellPos_[1], this.lastClickedCellPos_[0]);
            cellRect.setLocation(new Point(cellRect.getLocation().x + this.imagePositionX_, cellRect.getLocation().y + this.imagePositionY_));
            g2.fillRect(cellRect.x + 1, cellRect.y + 1, cellRect.width - 1, cellRect.height - 1);
            if (printAttentionRectangle) {
                this.heatmap_.paintAttentionRectangle(g2, this.heatmap_.getAttentionProbe(this.lastClickedCellPos_[1], this.experimentNames_.get(this.lastClickedCellPos_[0])), this.lastClickedCellPos_[1], this.lastClickedCellPos_[0], this.heatmap_.getExpressionImageXStart(), this.heatmap_.getExpressionImageYStart());
            }
            this.invalidate();
            this.updateUI();
        }
    }

    private void generateAnalyteRemovalDialogue(Set<Integer> analytesToRemove, Vector<String> messages) {
        String analyteList = "";
        ArrayList<Integer> toRemove = new ArrayList<Integer>(analytesToRemove);
        Collections.sort(toRemove);
        for (Integer analyteRow : toRemove) {
            if (this.heatmap_.isMolecularSpeciesLevel(analyteRow)) {
                analyteList = analyteList + String.format("%s (RT=%s min) <br>", this.heatmap_.getMolecularSpeciesLevelName(analyteRow), this.heatmap_.getRetentionTime(analyteRow));
                continue;
            }
            ArrayList<Integer> rows = this.heatmap_.getAllRowsOfSameSumComposition(analyteRow);
            analyteList = analyteList + String.format("%s (RT=%s min)", this.heatmap_.getMolecularSpeciesLevelName(analyteRow), this.heatmap_.getRetentionTime(analyteRow));
            if (!this.getSelectedShowOption().equalsIgnoreCase(DISPLAY_OPTION_SUM_COMP)) {
                analyteList = analyteList + String.format(", this sum composition contains %s identifications at the molecular species level, which will be deleted as well", rows.size());
            }
            analyteList = rows.size() > 0 ? analyteList + ": " : analyteList + ". <br>";
            for (int i = 0; i < rows.size(); ++i) {
                int row = rows.get(i);
                analyteList = analyteList + String.format("%s", this.heatmap_.getMolecularSpeciesLevelName(row), this.heatmap_.getRetentionTime(row));
                analyteList = i < rows.size() - 1 ? analyteList + ", " : analyteList + ". <br>";
            }
        }
        messages.add(String.format("<html>Do you really want to delete the following identifications of the lipid class '%s' in all probes: <br>%s </html>", this.groupName_, analyteList));
    }

    private static Hashtable<String, Hashtable<String, Vector<Double>>> extractValuesOfInterest(Hashtable<String, Hashtable<String, ResultCompVO>> vos, int maxIsotope, ResultDisplaySettingsVO settingVO, String preferredUnit, ExportOptionsVO expOptions, ArrayList<String> modifications) throws CalculationNotPossibleException {
        Hashtable<String, Hashtable<String, Vector<Double>>> results = new Hashtable<String, Hashtable<String, Vector<Double>>>();
        for (String molKey : vos.keySet()) {
            Hashtable expValues = new Hashtable();
            for (String expKey : vos.get(molKey).keySet()) {
                ResultCompVO compVO = vos.get(molKey).get(expKey);
                int isoNr = maxIsotope;
                if (!settingVO.getType().equalsIgnoreCase("relative to measured class amount") && !settingVO.getType().equalsIgnoreCase("relative to total amount")) {
                    isoNr = compVO.getAvailableIsotopeNr(maxIsotope);
                }
                double myArea = compVO.getArea(isoNr, settingVO);
                if (settingVO.getType().equalsIgnoreCase("relative to measured class amount") || settingVO.getType().equalsIgnoreCase("relative to total amount")) {
                    compVO.getArea(maxIsotope, settingVO);
                }
                myArea = StaticUtils.getAreaInCorrespondingUnit(myArea, preferredUnit);
                Vector<Double> areaPlusDev = new Vector<Double>();
                areaPlusDev.add(myArea);
                expValues.put(expKey, areaPlusDev);
            }
            results.put(molKey, expValues);
        }
        return results;
    }

    public static Vector checkFileStorage(File file, String suffix, JPanel panel) {
        Vector<Comparable<File>> results = new Vector<Comparable<File>>();
        boolean store = true;
        File fileToStore = new File(file.getAbsolutePath());
        if (fileToStore.exists()) {
            if (JOptionPane.showConfirmDialog(panel, "The file " + fileToStore.getName() + " exists! Replace existing file?") != 0) {
                store = false;
            }
        } else if (fileToStore.getName().indexOf(".") == -1 && (fileToStore = new File(fileToStore.getAbsoluteFile() + "." + suffix)).exists() && JOptionPane.showConfirmDialog(panel, "The file " + fileToStore.getName() + " exists! Replace existing file?") != 0) {
            store = false;
        }
        results.add(fileToStore);
        results.add(Boolean.valueOf(store));
        return results;
    }

    private Vector<String> getUnselectedMoleculeNames() {
        Vector<String> unselectedNames = new Vector<String>();
        for (String name : this.heatmap_.getOriginalAnalyteNames()) {
            if (this.selectionSettings_.isSelected(name)) continue;
            unselectedNames.add(name);
        }
        return unselectedNames;
    }

    public Vector<String> getSelectedMoleculeNames() {
        Vector<String> selectedNames = new Vector<String>();
        for (String name : this.moleculeNames_) {
            boolean accept = true;
            if (this.selectionSettings_.isSelected(name)) {
                if (!this.showInternalStandards_.isSelected() && this.isLookup_.containsKey(name)) {
                    accept = false;
                } else if (!this.showExternalStandards_.isSelected() && this.esLookup_.containsKey(name)) {
                    accept = false;
                }
            } else {
                accept = false;
            }
            if (!accept) continue;
            selectedNames.add(name);
        }
        return selectedNames;
    }

    public String getSelectedShowOption() {
        if (this.showOption_ == null) {
            return DISPLAY_OPTION_SUM_COMP;
        }
        return (String)this.showOption_.getSelectedItem();
    }

    public String getSelectedShowOptionMSn() {
        if (this.showOptionMSn_ == null) {
            return DISPLAY_OPTION_ALL_GROUPS;
        }
        return (String)this.showOptionMSn_.getSelectedItem();
    }

    public void setISSelected(boolean selected) {
        this.showInternalStandards_.setSelected(selected);
        this.parentAction_ = false;
        this.actionPerformed(CHANGE_IS_STATUS);
        this.parentAction_ = true;
    }

    public void setESSelected(boolean selected) {
        this.showExternalStandards_.setSelected(selected);
        this.parentAction_ = false;
        this.actionPerformed(CHANGE_ES_STATUS);
        this.parentAction_ = true;
    }

    public void setSelectedIsotope(int isotope) {
        this.parentAction_ = false;
        this.maxIsotopes_.setSelectedItem(String.valueOf(isotope));
        this.parentAction_ = true;
    }

    public void deselectAnalyte(int row) {
        this.selectedMoleculeRows_.remove(row);
    }

    public boolean isAnalyteSelected(int row) {
        return this.selectedMoleculeRows_.contains(row);
    }

    public void selectAnalyte(int row) {
        this.selectedMoleculeRows_.add(row);
    }

    public boolean isAnalyteSelected(String analyteName, String expName) {
        return this.selectedSingleMolecules_.containsKey(analyteName) && this.selectedSingleMolecules_.get(analyteName).containsKey(expName);
    }

    public boolean selectAnalyte(String analyteName, String expName, Color color, Hashtable<String, String> modHash, String absolutePath, Vector<AutoAnalyteAddVO> updateableAndAnalyteBefore, int maxIsotope) {
        if (this.selectedSingleMolecules_.containsKey(analyteName)) {
            new WarningMessage(new JFrame(), "Error", "It is not allowed to select more than one from the same species");
            return false;
        }
        this.selectedSingleMolecules_.put(analyteName, new Hashtable());
        this.selectedSingleMoleculesMods_.put(analyteName, modHash);
        this.selectedSingleMolecules_.get(analyteName).put(expName, color);
        this.selectedSingleMoleculesAbsPaths_.put(analyteName, absolutePath);
        this.selectedSingleMoleculesMaxIso_.put(analyteName, maxIsotope);
        this.selectedSingleMoleculesAutoAnalyteAddVO_.put(analyteName, updateableAndAnalyteBefore);
        return true;
    }

    public Color deselectAnalyte(String analyteName, String expName) {
        Color color = this.selectedSingleMolecules_.get(analyteName).get(expName);
        this.selectedSingleMolecules_.remove(analyteName);
        this.selectedSingleMoleculesMods_.remove(analyteName);
        this.selectedSingleMoleculesAbsPaths_.remove(analyteName);
        this.selectedSingleMoleculesAutoAnalyteAddVO_.remove(analyteName);
        this.selectedSingleMoleculesMaxIso_.remove(analyteName);
        return color;
    }

    public int getSelectedIsotope() {
        int isotope = 0;
        if (this.maxIsotopes_.getSelectedItem() != null) {
            isotope = new Integer((String)this.maxIsotopes_.getSelectedItem());
        }
        return isotope;
    }

    private ArrayList<String> getDisplayNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.fromShortToExpName_ = new Hashtable();
        for (String name : this.experimentNames_) {
            String displayName = this.heatMapListener_.getDisplayName(name);
            names.add(displayName);
            this.fromShortToExpName_.put(displayName, name);
        }
        return names;
    }

    private Vector<String> getISs() {
        Vector<String> iss = new Vector<String>();
        for (String anal : this.heatmap_.getOriginalAnalyteNames()) {
            if (!this.isLookup_.containsKey(anal)) continue;
            iss.add(anal);
        }
        return iss;
    }

    private Vector<String> getESs() {
        Vector<String> ess = new Vector<String>();
        for (String anal : this.heatmap_.getOriginalAnalyteNames()) {
            if (!this.esLookup_.containsKey(anal)) continue;
            ess.add(anal);
        }
        return ess;
    }

    private void initTimer() {
        this.timer_ = new Timer();
        this.timer_.schedule((TimerTask)new ThreadSupervisor(), 10L, 1000L);
    }

    private void handleTimerEvent() {
        if (!(this.chromExportThread_ == null || this.chromExportThread_.finished() || this.chromExportThread_.getErrorString() != null && this.chromExportThread_.getErrorString().length() != 0 || this.chromExportThread_.getTotalAmountOfLipids() <= 0 || this.chromExportThread_.getCurrentLipidCount() <= 0)) {
            this.exportLabel_.setText("Chrom-export: " + this.chromExportThread_.getCurrentExperiment() + ": " + this.chromExportThread_.getCurrentLipid() + " (" + this.chromExportThread_.getCurrentLipidCount() + "/" + this.chromExportThread_.getTotalAmountOfLipids() + ")");
            this.exportProgress_.setValue((this.chromExportThread_.getCurrentLipidCount() - 1) * 100 / this.chromExportThread_.getTotalAmountOfLipids());
        }
        if (this.chromExportThread_ != null && this.chromExportThread_.finished()) {
            if (this.chromExportThread_.getErrorString() != null && this.chromExportThread_.getErrorString().length() > 0) {
                this.spinnerLabel_.setVisible(false);
                new WarningMessage(new JFrame(), "Error", this.chromExportThread_.getErrorString());
                this.exportProgressPanel_.setVisible(false);
            }
            if (this.chromExportThread_.getErrorString() == null || this.chromExportThread_.getErrorString().length() == 0) {
                this.exportProgress_.setValue(100);
                this.exportLabel_.setText("Finished");
                this.spinnerLabel_.setVisible(false);
                new WarningMessage(new JFrame(), "Information", "The chrom export is finished!");
            }
            this.chromExportThread_ = null;
            this.exportProgressPanel_.setVisible(false);
        }
        if (this.chromExportThread_ != null && !this.chromExportThread_.finished() && this.chromExportThread_.getErrorString() != null && this.chromExportThread_.getErrorString().length() > 0) {
            this.spinnerLabel_.setVisible(false);
            new WarningMessage(new JFrame(), "Error", this.chromExportThread_.getErrorString());
            this.exportProgressPanel_.setVisible(false);
        }
    }

    public int getPossibleIsotopeNumber(String molecule) {
        int maxIsotope = this.getSelectedIsotope();
        return StaticUtils.getMaxApplicableIsotope(this.resultsOfOneGroup_.get(molecule), maxIsotope);
    }

    public Hashtable<String, Hashtable<String, Vector<Double>>> getResultValues(String valueType) throws NumberFormatException, CalculationNotPossibleException {
        int exportType = 0;
        if (this.isGrouped_) {
            exportType = 3;
        }
        ExportOptionsVO expOptions = new ExportOptionsVO(exportType, "1", false, true, false, false, 0, 0);
        ResultDisplaySettingsVO settings = new ResultDisplaySettingsVO(this.settingsVO_);
        settings.setType("relative value");
        if (valueType != null && valueType.length() > 0) {
            settings.setType(valueType);
        }
        if (this.maxIsotopes_.getItemCount() > 0) {
            return HeatMapDrawing.extractValuesOfInterest(this.resultsOfOneGroup_, this.getSelectedIsotope(), settings, null, expOptions, this.modifications_);
        }
        return null;
    }

    private ExportOptionsVO getExportOptions() {
        ExportOptionsVO expOptions = new ExportOptionsVO(0, null, true, false, false, false, 6, 0);
        if (this.exportSettings_ != null) {
            expOptions = this.exportSettings_.getSettings();
        }
        return expOptions;
    }

    public String getValueType() {
        return this.settingsVO_.getType();
    }

    public boolean isMarkDoublePeaks() {
        return this.markDoublePeaks_ != null && this.markDoublePeaks_.isSelected();
    }

    private Vector getSelectedIndividualSpeciesInCorrectOrder(SimpleValueObject currentlySelected, Hashtable<String, String> modHash, String absolutePath, Vector<AutoAnalyteAddVO> updateableAndAnalyteBefore, int maxIsotope) {
        Vector<Cloneable> result = new Vector<Cloneable>();
        Vector<SimpleValueObject> sorted = new Vector<SimpleValueObject>();
        Hashtable<String, String> allMods = new Hashtable<String, String>();
        Vector<String> absPaths = new Vector<String>();
        Hashtable<String, Vector<AutoAnalyteAddVO>> updateablesAndAnalytesBefore = new Hashtable<String, Vector<AutoAnalyteAddVO>>();
        Vector<Integer> maxIsotopes = new Vector<Integer>();
        for (String molName : this.heatmap_.getOriginalAnalyteNames()) {
            String expName;
            if (!this.selectedSingleMolecules_.containsKey(molName) && !currentlySelected.getLabel().equalsIgnoreCase(molName)) continue;
            if (currentlySelected.getLabel().equalsIgnoreCase(molName)) {
                expName = currentlySelected.getValue();
                for (String mod : modHash.keySet()) {
                    allMods.put(mod, mod);
                }
                absPaths.add(absolutePath);
                updateablesAndAnalytesBefore.put(molName, updateableAndAnalyteBefore);
                maxIsotopes.add(maxIsotope);
            } else {
                expName = this.selectedSingleMolecules_.get(molName).keySet().iterator().next();
                for (String mod : this.selectedSingleMoleculesMods_.get(molName).keySet()) {
                    allMods.put(mod, mod);
                }
                absPaths.add(this.selectedSingleMoleculesAbsPaths_.get(molName));
                updateablesAndAnalytesBefore.put(molName, this.selectedSingleMoleculesAutoAnalyteAddVO_.get(molName));
                maxIsotopes.add(this.selectedSingleMoleculesMaxIso_.get(molName));
            }
            sorted.add(new SimpleValueObject(molName, expName));
        }
        result.add(sorted);
        result.add(allMods);
        result.add(absPaths);
        result.add(updateablesAndAnalytesBefore);
        result.add(maxIsotopes);
        return result;
    }

    protected static Hashtable<String, Vector<LipidParameterSet>> getRelevantOriginalResults(Vector<LipidParameterSet> all, ResultAreaVO areaVO) {
        Hashtable<String, Vector<LipidParameterSet>> results = new Hashtable<String, Vector<LipidParameterSet>>();
        for (LipidParameterSet set : all) {
            if (!areaVO.getMoleculeNameWoRT().equalsIgnoreCase(set.getNameStringWithoutRt()) || !areaVO.belongsRtToThisAreaVO(set.getRt(), set.getModificationName())) continue;
            Vector<LipidParameterSet> ofOneMod = new Vector<LipidParameterSet>();
            if (results.containsKey(set.getModificationName())) {
                ofOneMod = results.get(set.getModificationName());
            }
            ofOneMod.add(set);
            results.put(set.getModificationName(), ofOneMod);
        }
        return results;
    }

    public void exportSummary(OmegaCollector omegaCollector, Sheet sheet, XSSFWorkbook workbook, OutputStream out) {
        ExportOptionsVO expOptions = this.getExportOptions();
        LinkedHashMap<String, String> expFullPaths = this.heatMapListener_.getSampleResultFullPaths();
        Hashtable<String, String> expIdToString = new Hashtable<String, String>();
        for (String expId : this.experimentNames_) {
            expIdToString.put(expId, this.heatMapListener_.getDisplayName(expId));
        }
        try {
            int maxIsotope = this.getSelectedIsotope();
            Hashtable<String, Hashtable<String, ResultCompVO>> compVOs = this.resultsOfOneGroup_;
            if (this.isGrouped_) {
                compVOs = this.ungroupedPartner_.resultsOfOneGroup_;
            }
            String preferredUnit = this.heatmap_.extractPreferredUnitForExp();
            Hashtable<String, Hashtable<String, Vector<Double>>> resultValues = HeatMapDrawing.extractValuesOfInterest(compVOs, maxIsotope, this.settingsVO_, preferredUnit, expOptions, this.modifications_);
            preferredUnit = StaticUtils.getCorrespondingUnit(this.settingsVO_, preferredUnit, true);
            boolean exportDoubleBondPositionsForClass = expOptions.isExportDoubleBondPositions();
            short speciesType = expOptions.getSpeciesType();
            if (exportDoubleBondPositionsForClass) {
                int numberOfChains = 2;
                try {
                    numberOfChains = Integer.parseInt(RulesContainer.getAmountOfChains(StaticUtils.getRuleName(this.groupName_, this.modifications_.get(0))));
                }
                catch (NoRuleException | RulesException | SpectrummillParserException | IOException ex) {
                    ex.printStackTrace();
                }
                if (numberOfChains > 1 && speciesType == 0) {
                    exportDoubleBondPositionsForClass = false;
                } else if (numberOfChains == 1 && speciesType != 0) {
                    speciesType = 0;
                }
            }
            ExcelAndTextExporter.writeExcelSheetOmegaSummary(omegaCollector, sheet, workbook, out, true, speciesType, exportDoubleBondPositionsForClass, maxIsotope, this.getSelectedMoleculeNames(), this.rtTolerance_ != null, this.isGrouped_, this.experimentNames_, expIdToString, expFullPaths, this.heatMapListener_.getSamplesOfGroups(), resultValues, preferredUnit, StaticUtils.getAreaTypeString(this.settingsVO_), expOptions, this.heatMapListener_.getComparativeResultsLookup(), this.modifications_);
        }
        catch (NumberFormatException e) {
            new WarningMessage(new JFrame(), "Error", e.getMessage());
        }
        catch (FileNotFoundException e) {
            new WarningMessage(new JFrame(), "Error", e.getMessage());
        }
        catch (IOException e) {
            new WarningMessage(new JFrame(), "Error", e.getMessage());
        }
        catch (CalculationNotPossibleException | ExcelInputFileException | ExportException | LipidCombinameEncodingException | RetentionTimeGroupingException | SpectrummillParserException e) {
            new WarningMessage(new JFrame(), "Error", e.getMessage());
        }
    }

    public void adjustDisplaySettings(ResultDisplaySettings settings) {
        this.displaySettings_.copySettings(settings);
        this.actionPerformed("AcceptDisplaySettings");
    }

    public String getSortMode() {
        return (String)this.sortMode_.getSelectedItem();
    }

    public Double getAverageArea(ArrayList<ResultCompVO> vos) {
        int count = 0;
        Double sum = 0.0;
        for (ResultCompVO vo : vos) {
            Double value = 0.0;
            try {
                int isotopes = vo.getAvailableIsotopeNr(this.getSelectedIsotope());
                value = vo.getArea(isotopes, this.getSettingsVO());
            }
            catch (CalculationNotPossibleException calculationNotPossibleException) {
                // empty catch block
            }
            if (!(value > 0.0)) continue;
            sum = sum + value;
            ++count;
        }
        return count > 0 ? sum / (double)count : 0.0;
    }

    public void cleanup() {
        this.ungroupedPartner_ = null;
        if (this.displaySettings_ != null) {
            this.displaySettings_.removeActionListener(this);
            this.displaySettings_.dispose();
            this.displaySettings_ = null;
        }
        if (this.selectionSettings_ != null) {
            this.selectionSettings_.removeActionListener(this);
            this.selectionSettings_.dispose();
            this.selectionSettings_ = null;
        }
        if (this.combinedChartSettings_ != null) {
            this.combinedChartSettings_.removeActionListener(this);
            this.combinedChartSettings_.dispose();
            this.combinedChartSettings_ = null;
        }
        if (this.exportSettings_ != null) {
            this.exportSettings_.cleanup();
            this.exportSettings_.dispose();
            this.exportSettings_ = null;
        }
        if (this.chromExport_ != null) {
            this.chromExport_.cleanup();
            this.chromExport_.dispose();
            this.chromExport_ = null;
        }
        if (this.timer_ != null) {
            this.timer_.cancel();
            this.timer_.purge();
        }
        this.timer_ = null;
    }

    static /* synthetic */ int[] access$1102(HeatMapDrawing x0, int[] x1) {
        x0.lastClickedCellPos_ = x1;
        return x1;
    }

    private class ThreadSupervisor
    extends TimerTask {
        private ThreadSupervisor() {
        }

        @Override
        public void run() {
            HeatMapDrawing.this.handleTimerEvent();
        }
    }

    private class SelectionItemListener
    implements ItemListener {
        private String m_ctrl;

        public SelectionItemListener(String ctrl) {
            this.m_ctrl = ctrl;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.m_ctrl.equalsIgnoreCase("ChangeIsotope") && e.getStateChange() == 1) {
                if (HeatMapDrawing.this.parentAction_) {
                    // empty if block
                }
                HeatMapDrawing.this.heatMapListener_.changeIsotopesUsed(HeatMapDrawing.this.groupName_, HeatMapDrawing.this.isGrouped_, HeatMapDrawing.this.getSelectedIsotope());
                HeatMapDrawing.this.generateHeatMap();
                HeatMapDrawing.this.invalidate();
                HeatMapDrawing.this.updateUI();
            }
        }
    }

    private class MyListener
    extends MouseInputAdapter {
        private MyListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (HeatMapDrawing.this.heatmap_ != null && HeatMapDrawing.this.renderedImage_ != null) {
                Graphics2D g2 = (Graphics2D)e.getComponent().getGraphics();
                if (HeatMapDrawing.this.rectToDraw_ != null) {
                    g2.setColor(Color.BLACK);
                    g2.drawRect(((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.x, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.y, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.width, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.height);
                    if (HeatMapDrawing.this.statusText_ != null) {
                        HeatMapDrawing.this.statusText_.setText("");
                    }
                }
                if (y >= HeatMapDrawing.this.imagePositionY_ && y < HeatMapDrawing.this.imagePositionY_ + HeatMapDrawing.this.renderedImage_.getHeight() && x >= HeatMapDrawing.this.imagePositionX_ && x < HeatMapDrawing.this.imagePositionX_ + HeatMapDrawing.this.renderedImage_.getWidth()) {
                    String expName;
                    int xInImage = x - HeatMapDrawing.this.imagePositionX_;
                    int yInImage = y - HeatMapDrawing.this.imagePositionY_;
                    if (HeatMapDrawing.this.heatmap_.getExpressionImageXStart() <= xInImage && xInImage < HeatMapDrawing.this.heatmap_.getExpressionImageXEnd() && HeatMapDrawing.this.heatmap_.getExpressionImageYStart() <= yInImage && yInImage < HeatMapDrawing.this.heatmap_.getExpressionImageYEnd()) {
                        int[] cellPos = HeatMapDrawing.this.heatmap_.getCellPosition(xInImage, yInImage);
                        String experiment = HeatMapDrawing.this.heatmap_.getExperimentName(cellPos[0]);
                        String analyte = HeatMapDrawing.this.heatmap_.getAnalyteName(cellPos[1]);
                        if (experiment != null && analyte != null) {
                            if (HeatMapDrawing.this.statusText_ != null) {
                                ResultCompVO compVO = HeatMapDrawing.this.heatmap_.getCompVO(cellPos[0], cellPos[1]);
                                String molName = HeatMapDrawing.this.heatmap_.getMolecularSpeciesName(cellPos[1]);
                                Double molContribution = HeatMapDrawing.this.heatmap_.getMolecularSpeciesContributionOfAllMods(experiment, cellPos[1]);
                                int maxIsotope = HeatMapDrawing.this.getSelectedIsotope();
                                String statusText = "";
                                try {
                                    String selectedAreaString;
                                    double relativeValue = compVO.getRelativeValue(compVO.getAvailableIsotopeNr(maxIsotope), HeatMapDrawing.this.settingsVO_, molName, HeatMapDrawing.this.heatmap_.getMolecularSpeciesContributionOfAllMods(experiment, cellPos[1]));
                                    String sampleTypeText = "Sample";
                                    if (HeatMapDrawing.this.isGrouped_) {
                                        sampleTypeText = "Group";
                                    }
                                    statusText = "Lipid: " + analyte + "; " + sampleTypeText + ": " + experiment + "; Relative: " + StaticUtils.extractDisplayValue(relativeValue);
                                    double value = compVO.getArea(compVO.getAvailableIsotopeNr(maxIsotope), HeatMapDrawing.this.settingsVO_);
                                    if (HeatMapDrawing.this.settingsVO_.getType().equalsIgnoreCase("relative to measured class amount") || HeatMapDrawing.this.settingsVO_.getType().equalsIgnoreCase("relative to total amount")) {
                                        value = compVO.getArea(maxIsotope, HeatMapDrawing.this.settingsVO_);
                                    }
                                    if ((selectedAreaString = StaticUtils.getAreaString(value * molContribution, HeatMapDrawing.this.settingsVO_, HeatMapDrawing.this.heatmap_.getPreferredUnit(cellPos[1]))) != null && selectedAreaString.length() > 0) {
                                        statusText = statusText + "; " + selectedAreaString;
                                    }
                                    double standValue = compVO.getStandardizedArea(compVO.getAvailableIsotopeNr(maxIsotope), HeatMapDrawing.this.settingsVO_.getISStandMethod(), HeatMapDrawing.this.settingsVO_.getESStandMethod(), HeatMapDrawing.this.settingsVO_.considerDilution());
                                    statusText = statusText + "; Stand-Area: " + standValue * molContribution;
                                    statusText = statusText + "; Quant-Area: " + compVO.getOriginalArea(compVO.getAvailableIsotopeNr(maxIsotope)) * molContribution + "; Isos: " + (compVO.getAvailableIsotopeNr(maxIsotope) + 1);
                                }
                                catch (CalculationNotPossibleException e1) {
                                    e1.printStackTrace();
                                }
                                HeatMapDrawing.this.statusText_.setText(statusText);
                            }
                            HeatMapDrawing.this.rectToDraw_ = HeatMapDrawing.this.heatmap_.getRectangleForCell(xInImage, yInImage);
                            this.drawARectangle(g2);
                        }
                    } else if (HeatMapDrawing.this.heatmap_.getRowNameStart() < xInImage && xInImage < HeatMapDrawing.this.heatmap_.getRowNameEnd() && HeatMapDrawing.this.heatmap_.getExpressionImageYStart() <= yInImage && yInImage < HeatMapDrawing.this.heatmap_.getExpressionImageYEnd()) {
                        int rowNumber = HeatMapDrawing.this.heatmap_.getRowNumber(x, y);
                        HeatMapDrawing.this.rectToDraw_ = HeatMapDrawing.this.heatmap_.getRectangleForRowNumber(rowNumber);
                        this.drawARectangle(g2);
                    } else if (HeatMapDrawing.this.heatmap_.getExpressionImageXStart() <= xInImage && xInImage < HeatMapDrawing.this.heatmap_.getExpressionImageXEnd() && HeatMapDrawing.this.heatmap_.getColumnNameStart() <= yInImage && yInImage < HeatMapDrawing.this.heatmap_.getColumnNameEnd() && (expName = HeatMapDrawing.this.heatmap_.getColumnName(x, y)) != null && expName.length() > 0) {
                        HeatMapDrawing.this.rectToDraw_ = HeatMapDrawing.this.heatmap_.getRectangleForColumnName(expName);
                        this.drawARectangle(g2);
                    }
                }
            }
        }

        private void drawARectangle(Graphics2D g2) {
            HeatMapDrawing.this.rectToDraw_.setLocation(new Point(((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.getLocation().x + HeatMapDrawing.this.imagePositionX_, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.getLocation().y + HeatMapDrawing.this.imagePositionY_));
            g2.setColor(Color.WHITE);
            g2.drawRect(((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.x, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.y, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.width, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.height);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (HeatMapDrawing.this.heatmap_ != null && HeatMapDrawing.this.renderedImage_ != null) {
                Graphics2D g2 = (Graphics2D)e.getComponent().getGraphics();
                if (HeatMapDrawing.this.rectToDraw_ != null) {
                    g2.setColor(Color.BLACK);
                    g2.drawRect(((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.x, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.y, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.width, ((HeatMapDrawing)HeatMapDrawing.this).rectToDraw_.height);
                    if (HeatMapDrawing.this.statusText_ != null) {
                        HeatMapDrawing.this.statusText_.setText("");
                    }
                }
                int maxIsotopes = HeatMapDrawing.this.getSelectedIsotope();
                if (y >= HeatMapDrawing.this.imagePositionY_ && y < HeatMapDrawing.this.imagePositionY_ + HeatMapDrawing.this.renderedImage_.getHeight() && x >= HeatMapDrawing.this.imagePositionX_ && x < HeatMapDrawing.this.imagePositionX_ + HeatMapDrawing.this.renderedImage_.getWidth()) {
                    int xInImage = x - HeatMapDrawing.this.imagePositionX_;
                    int yInImage = y - HeatMapDrawing.this.imagePositionY_;
                    if (HeatMapDrawing.this.heatmap_.getExpressionImageXStart() <= xInImage && xInImage < HeatMapDrawing.this.heatmap_.getExpressionImageXEnd() && HeatMapDrawing.this.heatmap_.getExpressionImageYStart() <= yInImage && yInImage < HeatMapDrawing.this.heatmap_.getExpressionImageYEnd()) {
                        int[] cellPos = HeatMapDrawing.this.heatmap_.getCellPosition(xInImage, yInImage);
                        String experiment = HeatMapDrawing.this.heatmap_.getExperimentName(cellPos[0]);
                        String analyte = HeatMapDrawing.this.heatmap_.getMolecularSpeciesLevelName(cellPos[1]);
                        if (experiment != null && analyte != null) {
                            ResultCompVO compVO = HeatMapDrawing.this.heatmap_.getCompVO(cellPos[0], cellPos[1]);
                            if (compVO.getOriginalArea(0) > 0.0 && HeatMapDrawing.this.heatMapListener_ != null) {
                                if (!HeatMapDrawing.this.isGrouped_) {
                                    if (e.getButton() == 1 && !HeatMapDrawing.this.isSingleMoleculeSelectionMode_) {
                                        if (!HeatMapDrawing.this.heatMapListener_.heatMapClicked(experiment, compVO, analyte, HeatMapDrawing.this.heatmap_.isMolecularSpeciesLevel(cellPos[1]))) {
                                            // empty if block
                                        }
                                        this.mouseMoved(e);
                                    } else if (e.getButton() == 3 || e.isPopupTrigger()) {
                                        Color attentionProbe = HeatMapDrawing.this.heatmap_.getAttentionProbe(cellPos[1], experiment);
                                        if (attentionProbe != null && attentionProbe == LipidomicsHeatMap.ATTENTION_COLOR_DOUBLE_PEAK || attentionProbe == LipidomicsHeatMap.ATTENTION_DOUBLE_AND_NOT_ALL_MODS) {
                                            this.mouseMoved(e);
                                        } else {
                                            if (HeatMapDrawing.this.isAnalyteSelected(HeatMapDrawing.this.heatmap_.getOriginalAnalyteName(cellPos[1]), HeatMapDrawing.this.experimentNames_.get(cellPos[0]))) {
                                                HeatMapDrawing.this.selectSingleItem_.setEnabled(false);
                                                HeatMapDrawing.this.deselectSingleItem_.setEnabled(true);
                                            } else {
                                                HeatMapDrawing.this.selectSingleItem_.setEnabled(true);
                                                HeatMapDrawing.this.deselectSingleItem_.setEnabled(false);
                                            }
                                            HeatMapDrawing.this.applySettingsPopup_.show(e.getComponent(), e.getX(), e.getY());
                                            HeatMapDrawing.access$1102(HeatMapDrawing.this, cellPos);
                                        }
                                    } else if (HeatMapDrawing.this.isSingleMoleculeSelectionMode_) {
                                        HeatMapDrawing.access$1102(HeatMapDrawing.this, cellPos);
                                        if (HeatMapDrawing.this.isAnalyteSelected(HeatMapDrawing.this.heatmap_.getOriginalAnalyteName(cellPos[1]), HeatMapDrawing.this.experimentNames_.get(cellPos[0]))) {
                                            HeatMapDrawing.this.actionPerformed(HeatMapDrawing.DESELECT_SINGLE);
                                        } else {
                                            HeatMapDrawing.this.actionPerformed(HeatMapDrawing.SELECT_SINGLE);
                                        }
                                    }
                                } else {
                                    this.mouseMoved(e);
                                }
                            } else {
                                this.mouseMoved(e);
                            }
                        }
                    } else if (HeatMapDrawing.this.heatmap_.getRowNameStart() < xInImage && xInImage < HeatMapDrawing.this.heatmap_.getRowNameEnd() && HeatMapDrawing.this.heatmap_.getExpressionImageYStart() <= yInImage && yInImage < HeatMapDrawing.this.heatmap_.getExpressionImageYEnd()) {
                        int rowNumber = HeatMapDrawing.this.heatmap_.getRowNumber(x, y);
                        String analyteName = HeatMapDrawing.this.heatmap_.getOriginalAnalyteName(rowNumber);
                        boolean returnValue = false;
                        if (HeatMapDrawing.this.isGrouped_) {
                            returnValue = HeatMapDrawing.this.heatMapListener_.analyteGroupClicked(analyteName, HeatMapDrawing.this.groupName_, maxIsotopes, HeatMapDrawing.this.rtTolerance_ != null, HeatMapDrawing.this.settingsVO_, HeatMapDrawing.this.heatmap_.getPreferredUnit(rowNumber), StaticUtils.getCorrespondingUnit(HeatMapDrawing.this.settingsVO_, HeatMapDrawing.this.heatmap_.getPreferredUnit(rowNumber), true));
                        } else if (SwingUtilities.isLeftMouseButton(e) && !HeatMapDrawing.this.isMoleculeRowSelectionMode_) {
                            returnValue = HeatMapDrawing.this.heatMapListener_.analyteClicked(analyteName, HeatMapDrawing.this.groupName_, maxIsotopes, HeatMapDrawing.this.rtTolerance_ != null, HeatMapDrawing.this.settingsVO_, HeatMapDrawing.this.heatmap_.getPreferredUnit(rowNumber), StaticUtils.getCorrespondingUnit(HeatMapDrawing.this.settingsVO_, HeatMapDrawing.this.heatmap_.getPreferredUnit(rowNumber), true));
                        } else if (SwingUtilities.isRightMouseButton(e)) {
                            if (HeatMapDrawing.this.isAnalyteSelected(rowNumber)) {
                                HeatMapDrawing.this.selectItem_.setEnabled(false);
                                HeatMapDrawing.this.deselectItem_.setEnabled(true);
                            } else {
                                HeatMapDrawing.this.selectItem_.setEnabled(true);
                                HeatMapDrawing.this.deselectItem_.setEnabled(false);
                            }
                            HeatMapDrawing.this.removeAnalytePopup_.show(e.getComponent(), e.getX(), e.getY());
                            HeatMapDrawing.this.lastClickedRow_ = rowNumber;
                        } else if (HeatMapDrawing.this.isMoleculeRowSelectionMode_) {
                            HeatMapDrawing.this.lastClickedRow_ = rowNumber;
                            if (HeatMapDrawing.this.isAnalyteSelected(rowNumber)) {
                                HeatMapDrawing.this.actionPerformed(HeatMapDrawing.DESELECT_ROW);
                            } else {
                                HeatMapDrawing.this.actionPerformed(HeatMapDrawing.SELECT_ROW);
                            }
                        }
                        if (!returnValue) {
                            this.mouseMoved(e);
                        }
                    } else if (HeatMapDrawing.this.heatmap_.getExpressionImageXStart() <= xInImage && xInImage < HeatMapDrawing.this.heatmap_.getExpressionImageXEnd() && HeatMapDrawing.this.heatmap_.getColumnNameStart() <= yInImage && yInImage < HeatMapDrawing.this.heatmap_.getColumnNameEnd()) {
                        String expName = HeatMapDrawing.this.heatmap_.getColumnName(x, y);
                        if (e.getButton() == 1) {
                            boolean returnValue = false;
                            String preferredUnit = HeatMapDrawing.this.heatmap_.extractPreferredUnitForExp();
                            returnValue = HeatMapDrawing.this.isGrouped_ ? HeatMapDrawing.this.heatMapListener_.experimentGroupClicked(expName, HeatMapDrawing.this.groupName_, maxIsotopes, HeatMapDrawing.this.rtTolerance_ != null, HeatMapDrawing.this.settingsVO_, preferredUnit, StaticUtils.getCorrespondingUnit(HeatMapDrawing.this.settingsVO_, preferredUnit, true)) : HeatMapDrawing.this.heatMapListener_.experimentClicked(expName, HeatMapDrawing.this.groupName_, maxIsotopes, HeatMapDrawing.this.rtTolerance_ != null, HeatMapDrawing.this.settingsVO_, preferredUnit, StaticUtils.getCorrespondingUnit(HeatMapDrawing.this.settingsVO_, preferredUnit, true));
                            if (!returnValue) {
                                this.mouseMoved(e);
                            }
                        } else if (!HeatMapDrawing.this.isGrouped_ && e.getButton() == 3) {
                            InputDialog dlg = new InputDialog(new JFrame(), "", "Sample name", HeatMapDrawing.this.heatMapListener_.getDisplayName(expName));
                            HeatMapDrawing.this.heatMapListener_.setDisplayName(expName, dlg.getEnteredText());
                        }
                    }
                }
            }
        }
    }
}

