/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.analysis.ClassNamesExtractor;
import at.tugraz.genome.lda.exception.AbsoluteSettingsInputException;
import at.tugraz.genome.lda.exception.SettingsException;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import at.tugraz.genome.lda.verifier.IntegerMaxVerifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class CutoffSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 7828948004968836687L;
    private JPanel inputPanel_;
    private JTextField maxIsotope_;
    private ClassNamesExtractor extractor_;
    private String tooltip_;
    private Hashtable<String, JTextField> inputFields_;
    private static final int itemsPerLine_ = 6;

    public CutoffSettingsPanel(String tooltip) {
        this.tooltip_ = tooltip;
        this.maxIsotope_ = new JTextField(1);
        this.maxIsotope_.setText("2");
        this.maxIsotope_.setHorizontalAlignment(4);
        this.maxIsotope_.setToolTipText(tooltip);
        this.maxIsotope_.setInputVerifier(new IntegerMaxVerifier(true, 0, 9));
        this.initComponents();
    }

    private void initComponents() {
        this.inputPanel_ = new JPanel();
        this.add(this.inputPanel_);
    }

    public void showSettingsPanel(ClassNamesExtractor extractor) {
        this.extractor_ = extractor;
        this.initInputFields();
        this.invalidate();
        this.updateUI();
    }

    private void initInputFields() {
        this.inputPanel_.removeAll();
        JTabbedPane dummyTab = new JTabbedPane();
        this.inputPanel_.add(dummyTab);
        this.inputFields_ = new Hashtable();
        JPanel inputFields = new JPanel();
        inputFields.setLayout(new GridBagLayout());
        dummyTab.addTab("Cutoff-thresholds", inputFields);
        Vector<String> lipidClasses = this.extractor_.getLipidClasses();
        int lines = lipidClasses.size() / 6;
        if (lipidClasses.size() % 6 != 0) {
            ++lines;
        }
        inputFields.setPreferredSize(new Dimension(850, 30 * (lines + 1)));
        JPanel isotopePanel = new JPanel();
        inputFields.add((Component)isotopePanel, new GridBagConstraints(0, 0, 18, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        JLabel label = new JLabel("For cut-off filter, analyte area will be calculated as sum from the isotopes 0 -");
        isotopePanel.add(label);
        isotopePanel.add(this.maxIsotope_);
        for (int i = 0; i != lipidClasses.size(); ++i) {
            int row = i / 6 + 1;
            int column = i % 6 * 3;
            JLabel classLabel = new JLabel(lipidClasses.get(i));
            classLabel.setToolTipText(this.tooltip_);
            inputFields.add((Component)classLabel, new GridBagConstraints(column, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
            JTextField value = new JTextField(3);
            value.setHorizontalAlignment(4);
            value.setInputVerifier(new DoubleVerifier(false, true));
            value.setText("0.0");
            value.setToolTipText(this.tooltip_);
            this.inputFields_.put(lipidClasses.get(i), value);
            inputFields.add((Component)value, new GridBagConstraints(column + 1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
            JLabel unit = new JLabel("\u2030");
            unit.setToolTipText(this.tooltip_);
            inputFields.add((Component)unit, new GridBagConstraints(column + 2, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        }
    }

    public void hideSettingsPanel() {
        this.inputPanel_.removeAll();
        this.invalidate();
        this.updateUI();
    }

    public Hashtable<String, Double> getCutoffs() throws AbsoluteSettingsInputException {
        Hashtable<String, Double> cutoffs = new Hashtable<String, Double>();
        for (String lipidClass : this.extractor_.getLipidClasses()) {
            String valueString = this.getInputValueCorrected(this.inputFields_.get(lipidClass).getText(), lipidClass);
            double value = Double.parseDouble(valueString);
            cutoffs.put(lipidClass, value /= 1000.0);
        }
        return cutoffs;
    }

    public Hashtable<String, String> getCutoffsAsString() throws AbsoluteSettingsInputException {
        Hashtable<String, String> cutoffs = new Hashtable<String, String>();
        for (String lipidClass : this.extractor_.getLipidClasses()) {
            cutoffs.put(lipidClass, this.getInputValueCorrected(this.inputFields_.get(lipidClass).getText(), lipidClass));
        }
        return cutoffs;
    }

    private String getInputValueCorrected(String input, String lipidClass) throws AbsoluteSettingsInputException {
        try {
            String output = input;
            double value = Double.parseDouble(input);
            if (value < 0.0) {
                value *= -1.0;
                output = input.substring(1);
            }
            if (value >= 1000.0) {
                throw new AbsoluteSettingsInputException("The cut-off of " + lipidClass + " cannot be greater than 1000\u2030");
            }
            return output;
        }
        catch (NumberFormatException ex) {
            throw new AbsoluteSettingsInputException("The cut-off of the class " + lipidClass + " is not correct! " + ex.getMessage());
        }
    }

    public int getMaxIsotope() {
        return Integer.parseInt(this.maxIsotope_.getText());
    }

    public void setMaxIsotope(int maxIsotope) throws SettingsException {
        if (maxIsotope < 0) {
            throw new SettingsException("The value must not be negative");
        }
        this.maxIsotope_.setText(String.valueOf(maxIsotope));
    }

    public void setCutoff(String lipidClass, String value) throws NumberFormatException, AbsoluteSettingsInputException, SettingsException {
        double number = Double.parseDouble(value);
        if (number < 0.0) {
            throw new SettingsException("The value must not be negative");
        }
        if (!this.inputFields_.containsKey(lipidClass)) {
            throw new AbsoluteSettingsInputException("The lipid class " + lipidClass + " is not available as input field");
        }
        this.inputFields_.get(lipidClass).setText(value);
    }
}

