/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import at.tugraz.genome.lda.vos.AreaSettingVO;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AreaSettingDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6343928984142509434L;
    private JPanel inputPanel_;
    private JTextField startTime_;
    private JTextField stopTime_;
    private JTextField startMz_;
    private JTextField stopMz_;
    private JLabel startMzLabel_;
    private JLabel stopMzLabel_;
    private JCheckBox threeD_;
    private JButton buttonOK_;
    private JButton buttonCancel_;
    private ActionListener parent_;
    private static final String CHANGE_3D_SELECTION_STATUS = "change3DSelectionStatus";

    public AreaSettingDialog(JFrame parent, String title, String message, ActionListener parentListener) {
        super(parent, title, true);
        this.parent_ = parentListener;
        this.setLayout(new BorderLayout());
        this.setLocation(380, 240);
        JPanel messagePane = new JPanel();
        messagePane.add(new JLabel(message));
        this.add((Component)messagePane, "North");
        this.initInputPanel();
        this.initButtonPanel();
        this.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private void initInputPanel() {
        this.inputPanel_ = new JPanel();
        this.inputPanel_.setLayout(new GridBagLayout());
        JLabel label = new JLabel("start-time: ");
        label.setToolTipText("Test");
        label.setToolTipText("<html>The lower time border in minutes.</html>");
        this.inputPanel_.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.startTime_ = new JTextField(10);
        this.startTime_.setInputVerifier(new DoubleVerifier());
        this.startTime_.setHorizontalAlignment(4);
        this.startTime_.setToolTipText("<html>The lower time border in minutes.</html>");
        this.inputPanel_.add((Component)this.startTime_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("min");
        label.setToolTipText("<html>The lower time border in minutes.</html>");
        this.inputPanel_.add((Component)label, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 1), 0, 0));
        label = new JLabel("stop-time: ");
        label.setToolTipText("<html>The upper time border in minutes.</html>");
        this.inputPanel_.add((Component)label, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.stopTime_ = new JTextField(10);
        this.stopTime_.setInputVerifier(new DoubleVerifier());
        this.stopTime_.setHorizontalAlignment(4);
        this.stopTime_.setToolTipText("<html>The upper time border in minutes.</html>");
        this.inputPanel_.add((Component)this.stopTime_, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("min");
        label.setToolTipText("<html>The upper time border in minutes.</html>");
        this.inputPanel_.add((Component)label, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 1), 0, 0));
        this.startMzLabel_ = new JLabel("start-m/z: ");
        this.startMzLabel_.setToolTipText("<html>The lower m/z border in Da.</html>");
        this.inputPanel_.add((Component)this.startMzLabel_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.startMz_ = new JTextField(10);
        this.startMz_.setInputVerifier(new DoubleVerifier());
        this.startMz_.setHorizontalAlignment(4);
        this.startMz_.setToolTipText("<html>The lower m/z border in Da.</html>");
        this.inputPanel_.add((Component)this.startMz_, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.stopMzLabel_ = new JLabel("stop-m/z: ");
        this.stopMzLabel_.setToolTipText("<html>The upper m/z border in Da.</html>");
        this.inputPanel_.add((Component)this.stopMzLabel_, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.stopMz_ = new JTextField(10);
        this.stopMz_.setInputVerifier(new DoubleVerifier());
        this.stopMz_.setHorizontalAlignment(4);
        this.stopMz_.setToolTipText("<html>The upper m/z border in Da.</html>");
        this.inputPanel_.add((Component)this.stopMz_, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.enableMzSettings(false);
        this.threeD_ = new JCheckBox("3D");
        this.threeD_.setActionCommand(CHANGE_3D_SELECTION_STATUS);
        this.threeD_.addActionListener(this);
        this.threeD_.setSelected(false);
        this.threeD_.setToolTipText("<html>Should the peak be defined in 3D (m/z borders settable)?</html>");
        this.inputPanel_.add((Component)this.threeD_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.add((Component)this.inputPanel_, "Center");
    }

    private void initButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.buttonOK_ = new JButton("OK");
        this.buttonOK_.addActionListener(this);
        this.buttonOK_.setActionCommand("acceptAreaSettings");
        this.buttonOK_.setToolTipText("<html>Accept settings</html>");
        buttonPanel.add((Component)this.buttonOK_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.buttonCancel_ = new JButton("Cancel");
        this.buttonCancel_.addActionListener(this.parent_);
        this.buttonCancel_.setActionCommand("discardAreaSettings");
        this.buttonCancel_.setToolTipText("<html>Cancel operation</html>");
        buttonPanel.add((Component)this.buttonCancel_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(CHANGE_3D_SELECTION_STATUS)) {
            this.enableMzSettings(this.threeD_.isSelected());
        } else if (e.getActionCommand().equalsIgnoreCase("acceptAreaSettings")) {
            String notFilledOutFields = "";
            if (this.startTime_.getText() == null || this.startTime_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "start-time, ";
            }
            if (this.stopTime_.getText() == null || this.stopTime_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "stop-time, ";
            }
            if (this.startMz_.getText() == null || this.startMz_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "start-m/z, ";
            }
            if (this.stopMz_.getText() == null || this.stopMz_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "stop-m/z, ";
            }
            if (notFilledOutFields.length() == 0) {
                this.parent_.actionPerformed(e);
            } else {
                notFilledOutFields = notFilledOutFields.substring(0, notFilledOutFields.length() - 2);
                new WarningMessage(new JFrame(), "Error", "You have to fill out the following fields: " + notFilledOutFields + "!");
            }
        }
    }

    private void enableMzSettings(boolean enable) {
        this.startMz_.setEnabled(enable);
        this.stopMz_.setEnabled(enable);
        this.startMzLabel_.setEnabled(enable);
        this.stopMzLabel_.setEnabled(enable);
    }

    public void setInputFields(boolean use3D, float startTime, float stopTime, float startMz, float stopMz) {
        this.threeD_.setSelected(use3D);
        this.startTime_.setText(String.valueOf(Calculator.roundFloat(startTime, 3)));
        this.stopTime_.setText(String.valueOf(Calculator.roundFloat(stopTime, 3)));
        this.startMz_.setText(String.valueOf(Calculator.roundFloat(startMz, 5)));
        this.stopMz_.setText(String.valueOf(Calculator.roundFloat(stopMz, 5)));
        this.enableMzSettings(use3D);
    }

    public AreaSettingVO getInputValues() {
        return new AreaSettingVO(this.threeD_.isSelected(), Double.parseDouble(this.startTime_.getText()), Double.parseDouble(this.stopTime_.getText()), Double.parseDouble(this.startMz_.getText()), Double.parseDouble(this.stopMz_.getText()));
    }
}

