/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.AnalyteAddRemoveListener;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import at.tugraz.genome.lda.verifier.IntegerVerifier;
import at.tugraz.genome.lda.verifier.MzInputVerifierForTolerance;
import at.tugraz.genome.lda.vos.AddAnalyteVO;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddAnalyteDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8260667248906145073L;
    private JTextField analyteName_;
    private JTextField analyteFormula_;
    private JTextField modName_;
    private JTextField modFormula_;
    private JTextField mzTolerance_;
    private JTextField exactMass_;
    private JTextField charge_;
    private JTextField rTime_;
    private JTextField ohNumber_;
    private int positionToAddNewAnalyte_;
    private AnalyteAddRemoveListener parentListener_;

    public AddAnalyteDialog(JFrame parent, String title, String message, String analyteName, float mz, String analyteFormula, String modName, String modFormula, int positionToAddNewAnalyte, boolean showRt, String oh, AnalyteAddRemoveListener parentListener) {
        super(parent, title, true);
        this.parentListener_ = parentListener;
        this.positionToAddNewAnalyte_ = positionToAddNewAnalyte;
        this.setLocation(380, 240);
        this.setLayout(new BorderLayout());
        JPanel messagePane = new JPanel();
        messagePane.add(new JLabel(message));
        this.getContentPane().add((Component)messagePane, "North");
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new GridBagLayout());
        JLabel label = new JLabel("name: ");
        label.setToolTipText("<html>The name of the analyte (plus double bonds if appropriate).</html>");
        inputPane.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        String rt = "";
        if (showRt) {
            rt = analyteName.substring(analyteName.lastIndexOf("_") + 1);
            analyteName = analyteName.substring(0, analyteName.lastIndexOf("_"));
        }
        this.analyteName_ = new JTextField(5);
        this.analyteName_.setText(analyteName);
        this.analyteName_.setToolTipText("<html>The name of the analyte (plus double bonds if appropriate).</html>");
        inputPane.add((Component)this.analyteName_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("formula: ");
        label.setToolTipText("<html>The chemical formula of the analyte (without modification)<br/>The formula has to be entered by the chemical symbol<br/>followed by the cardinality, next chemical symbol and so on.</html>");
        inputPane.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.analyteFormula_ = new JTextField(10);
        this.analyteFormula_.setText(analyteFormula);
        this.analyteFormula_.setToolTipText("<html>The chemical formula of the analyte (without modification)<br/>The formula has to be entered by the chemical symbol<br/>followed by the cardinality, next chemical symbol and so on.</html>");
        inputPane.add((Component)this.analyteFormula_, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("modification: ");
        label.setToolTipText("<html>The name of the modification.</html>");
        inputPane.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.modName_ = new JTextField(5);
        this.modName_.setText(modName);
        this.modName_.setToolTipText("<html>The name of the modification.</html>");
        inputPane.add((Component)this.modName_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("formula: ");
        label.setToolTipText("<html>The chemical formula of the modification.<br/>For the reduction of elements place a \"-\" in front of the group. E.g., \"-NH4\" <br/>means the loss of one N and of 4 H, which would be the same as \"-N -H4\",<br/> wheras \"-N H4\" would mean the loss of one N and the addition of 4H.</html>");
        inputPane.add((Component)label, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.modFormula_ = new JTextField(10);
        this.modFormula_.setText(modFormula);
        this.modFormula_.setToolTipText("<html>The chemical formula of the modification.<br/>For the reduction of elements place a \"-\" in front of the group. E.g., \"-NH4\" <br/>means the loss of one N and of 4 H, which would be the same as \"-N -H4\",<br/> wheras \"-N H4\" would mean the loss of one N and the addition of 4H.</html>");
        inputPane.add((Component)this.modFormula_, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("m/z tolerance: ");
        label.setToolTipText("<html>The m/z width of the primary chromatogram.<br/>In order to be comparable with the other quantitations, it is not advised to change this value</html>");
        inputPane.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.mzTolerance_ = new JTextField(5);
        this.mzTolerance_.setHorizontalAlignment(4);
        this.mzTolerance_.setInputVerifier(new DoubleVerifier());
        this.mzTolerance_.setText(String.valueOf(Calculator.roundFloat(LipidomicsConstants.getCoarseChromMzTolerance(mz), 5)));
        this.mzTolerance_.setToolTipText("<html>The m/z width of the primary chromatogram.<br/>In order to be comparable with the other quantitations, it is not advised to change this value</html>");
        inputPane.add((Component)this.mzTolerance_, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("exact mass: ");
        label.setToolTipText("<html>The m/z of the analyte.</html>");
        inputPane.add((Component)label, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.exactMass_ = new JTextField(10);
        this.exactMass_.setHorizontalAlignment(4);
        this.exactMass_.setInputVerifier(new MzInputVerifierForTolerance(this.mzTolerance_));
        this.exactMass_.setToolTipText("<html>The m/z of the analyte.</html>");
        inputPane.add((Component)this.exactMass_, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("charge: ");
        label.setToolTipText("<html>The charge of the analyte.</html>");
        inputPane.add((Component)label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.charge_ = new JTextField(5);
        this.charge_.setHorizontalAlignment(4);
        this.charge_.setInputVerifier(new IntegerVerifier());
        this.charge_.setText("1");
        this.charge_.setToolTipText("<html>The charge of the analyte.</html>");
        inputPane.add((Component)this.charge_, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        if (showRt) {
            label = new JLabel("RT: ");
            label.setToolTipText("<html>The RT identifier of the analyte.</html>");
            inputPane.add((Component)label, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.rTime_ = new JTextField(5);
            this.rTime_.setHorizontalAlignment(4);
            this.rTime_.setInputVerifier(new DoubleVerifier(true, true));
            this.rTime_.setText(rt);
            this.rTime_.setToolTipText("<html>The RT identifier of the analyte.</html>");
            inputPane.add((Component)this.rTime_, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        }
        if (oh != null) {
            int xGrid = 2;
            int yGrid = 3;
            if (showRt) {
                xGrid = 0;
                yGrid = 4;
            }
            label = new JLabel("OH-groups: ");
            label.setToolTipText("<html>The number of hydroxylation sites.</html>");
            inputPane.add((Component)label, new GridBagConstraints(xGrid, yGrid, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.ohNumber_ = new JTextField(5);
            this.ohNumber_.setHorizontalAlignment(4);
            this.ohNumber_.setInputVerifier(new IntegerVerifier(true));
            this.ohNumber_.setText(oh);
            this.ohNumber_.setToolTipText("<html>The number of hydroxylation sites.</html>");
            inputPane.add((Component)this.ohNumber_, new GridBagConstraints(xGrid + 1, yGrid, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        }
        this.getContentPane().add((Component)inputPane, "Center");
        JPanel buttonPane = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        buttonPane.add(cancelButton);
        cancelButton.addActionListener(this);
        cancelButton.setActionCommand("Cancel");
        cancelButton.setToolTipText("<html>Cancel operation</html>");
        JButton okButton = new JButton("OK");
        buttonPane.add(okButton);
        okButton.addActionListener(this);
        okButton.setActionCommand("OK");
        okButton.setToolTipText("<html>Accept the settings and add the analyte.</html>");
        this.getContentPane().add((Component)buttonPane, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("OK")) {
            String notFilledOutFields = "";
            if (this.analyteName_.getText() == null || this.analyteName_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "name, ";
            }
            if (this.analyteFormula_.getText() == null || this.analyteFormula_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "formula, ";
            }
            if (this.mzTolerance_.getText() == null || this.mzTolerance_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "m/z tolerance, ";
            }
            if (this.exactMass_.getText() == null || this.exactMass_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "exact mass, ";
            }
            if (this.charge_.getText() == null || this.charge_.getText().length() == 0) {
                notFilledOutFields = notFilledOutFields + "charge, ";
            }
            if (notFilledOutFields.length() == 0) {
                try {
                    if (this.analyteFormula_.getText() != null && this.analyteFormula_.getText().length() > 0 && StaticUtils.checkChemicalFormula(this.analyteFormula_.getText()) && (this.modFormula_.getText() == null || this.modFormula_.getText().length() == 0 || this.checkModFormula(this.analyteFormula_.getText(), this.modFormula_.getText()))) {
                        String modification = "";
                        if (this.modName_.getText() != null && this.modName_.getText().length() > 0) {
                            modification = this.modName_.getText();
                        }
                        String modFormula = "";
                        if (this.modFormula_.getText() != null && this.modFormula_.getText().length() > 0 && this.checkModFormula(this.analyteFormula_.getText(), this.modFormula_.getText())) {
                            modFormula = this.modFormula_.getText();
                        }
                        String rt = "";
                        if (this.rTime_ != null && this.rTime_.getText() != null && this.rTime_.getText().length() > 0) {
                            rt = this.rTime_.getText().trim();
                        }
                        int oh = -1;
                        if (this.ohNumber_ != null && this.ohNumber_.getText() != null && this.ohNumber_.getText().length() > 0) {
                            oh = Integer.parseInt(this.ohNumber_.getText().trim());
                        }
                        AddAnalyteVO addVO = new AddAnalyteVO(this.analyteName_.getText().trim(), this.analyteFormula_.getText().replaceAll(" ", "").trim(), modification, modFormula.replaceAll(" ", ""), this.mzTolerance_.getText().trim(), this.exactMass_.getText().trim(), this.charge_.getText().trim(), rt, oh);
                        this.setVisible(false);
                        this.dispose();
                        this.parentListener_.addAnalyte(this.positionToAddNewAnalyte_, addVO);
                    }
                }
                catch (ChemicalFormulaException chemicalFormulaException) {}
            } else {
                notFilledOutFields = notFilledOutFields.substring(0, notFilledOutFields.length() - 2);
                new WarningMessage(new JFrame(), "Error", "You have to fill out the following fields: " + notFilledOutFields + "!");
            }
        } else if (e.getActionCommand().equalsIgnoreCase("Cancel")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private boolean checkModFormula(String chemicalFormula, String modFormula) throws ChemicalFormulaException {
        Hashtable<String, Integer> formulaElemCard = StaticUtils.categorizeFormula(chemicalFormula);
        Hashtable<String, Integer> modElemCard = StaticUtils.categorizeFormula(modFormula);
        String formulaWithMod = "";
        for (String element : formulaElemCard.keySet()) {
            if (formulaWithMod.length() > 0) {
                formulaWithMod = formulaWithMod + " ";
            }
            int amount = formulaElemCard.get(element);
            if (modElemCard.containsKey(element)) {
                amount += modElemCard.get(element).intValue();
            }
            if (amount < 0) {
                new WarningMessage(new JFrame(), "Error", "The modification formula " + modFormula + " results in a negative amount of elements for " + element + "!");
                return false;
            }
            formulaWithMod = formulaWithMod + element + String.valueOf(amount);
        }
        return StaticUtils.checkChemicalFormula(formulaWithMod);
    }
}

