/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.quantification;

import at.tugraz.genome.lda.quantification.LipidomicsChromatogram;
import at.tugraz.genome.lda.quantification.SavGolJNI;
import at.tugraz.genome.maspectras.quantification.CgChromatogram;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.ChromatogramReader;
import java.util.Hashtable;
import java.util.Vector;

public class LipidomicsChromReader
extends ChromatogramReader {
    private boolean useCuda_;
    protected SavGolJNI sav_gol_jni_;

    public LipidomicsChromReader(String headerFilePath, String indexFilePath, String retentionTimeFilePath, String chromatogramFilePath, boolean sparseData, float chromSmoothRange, boolean useCuda) throws CgException {
        super(headerFilePath, indexFilePath, retentionTimeFilePath, chromatogramFilePath, sparseData, chromSmoothRange);
        this.useCuda_ = useCuda;
    }

    protected Vector<CgChromatogram> readProfiles(Vector<CgProbe> probes, float mzTolerance, float timeTolerance, float maxTimeDeviation, float mzSmoothRange, int smoothRepeats, int msLevel, SavGolJNI sav_gol_jni) throws CgException {
        this.sav_gol_jni_ = sav_gol_jni;
        return super.readProfiles(probes, mzTolerance, timeTolerance, maxTimeDeviation, mzSmoothRange, smoothRepeats, msLevel);
    }

    @Override
    protected Vector<CgChromatogram> smoothSingleProfiles(Vector<CgProbe> probes, Hashtable<Integer, CgChromatogram> singleProfiles, float mzSmoothRange, int smoothRepeats, Hashtable<Integer, Float> startTime, Hashtable<Integer, Float> stopTime) {
        Vector<CgChromatogram> profiles = new Vector<CgChromatogram>();
        for (int i = 0; i != probes.size(); ++i) {
            LipidomicsChromatogram cx = new LipidomicsChromatogram(singleProfiles.get(i));
            cx.isProfile_ = true;
            cx.Mz = probes.get((int)i).Peak;
            cx.LowerMzBand = startTime.get(i).floatValue();
            cx.UpperMzBand = stopTime.get(i).floatValue();
            if (this.useCuda_) {
                cx.Smooth(mzSmoothRange, smoothRepeats, this.sav_gol_jni_);
            } else {
                cx.Smooth(mzSmoothRange, smoothRepeats);
            }
            profiles.add(cx);
        }
        return profiles;
    }

    public Hashtable<Integer, Integer> getMsmsNrOfScans() {
        return this.msmsNrOfScans_;
    }
}

