/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.quantification;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.utils.PreciseRTFormatter;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.CgParameterSet;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;

public class LipidParameterSet
extends CgParameterSet {
    private Integer doubleBonds_;
    private String modificationName_;
    private String analyteFormula_;
    private String modificationFormula_;
    private String chemicalFormula_;
    private String chemicalFormulaWODeducts_;
    private Integer charge_;
    private Double preciseRetentionTime_;
    private String rt_;
    private Integer ohNumber_;
    private String oxState_ = "";
    private float coverage_ = 0.0f;
    public static final String MOD_SEPARATOR = "_-_";
    public static final String MOD_SEPARATOR_HR = "_";
    private static boolean isOmegaInformationAvailable_ = false;
    private Vector<DoubleBondPositionVO> omegaInformation_;
    private float lowerRtHardLimit_;
    private float upperRtHardLimit_;
    private float percentalSplit_;
    private boolean choseMoreLikelyRtWhenEqualMSn_;

    public LipidParameterSet(LipidParameterSet set) {
        this(set.Mz[0], set.Peptide, set.doubleBonds_, set.modificationName_, set.preciseRetentionTime_, set.analyteFormula_, set.modificationFormula_, set.charge_, set.ohNumber_);
        this.Mz = set.Mz;
        this.Area = set.Area;
        this.LowerMzBand = set.LowerMzBand;
        this.UpperMzBand = set.UpperMzBand;
        this.ValleyMethod = set.ValleyMethod;
        this.m_probes = new ArrayList(set.m_probes);
        this.isotopicProbes_ = new Vector(set.isotopicProbes_);
        this.lowerRtHardLimit_ = set.getLowerRtHardLimit();
        this.upperRtHardLimit_ = set.getUpperRtHardLimit();
        this.percentalSplit_ = set.getPercentalSplit();
        this.oxState_ = set.getOxState();
        for (DoubleBondPositionVO labeledChainCombiVO : set.getOmegaInformation()) {
            DoubleBondPositionVO deepCopyOfLabeledChainCombiVO = new DoubleBondPositionVO(labeledChainCombiVO);
            this.omegaInformation_.add(deepCopyOfLabeledChainCombiVO);
        }
    }

    public LipidParameterSet(float mz, String name, Integer doubleBonds, String modificationName, Double preciseRetentionTime, String analyteFormula, String modificationFormula, Integer charge, Integer ohNumber) {
        super(mz, name, mz, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f);
        this.preciseRetentionTime_ = preciseRetentionTime;
        this.rt_ = preciseRetentionTime != null ? PreciseRTFormatter.FormatNumberToString(preciseRetentionTime, 2) : null;
        this.doubleBonds_ = doubleBonds;
        this.modificationName_ = modificationName;
        this.analyteFormula_ = analyteFormula;
        this.modificationFormula_ = modificationFormula;
        if (this.modificationFormula_ != null && this.modificationFormula_.length() > 0) {
            try {
                Hashtable<String, Integer> formAnal = StaticUtils.categorizeFormula(this.analyteFormula_);
                Hashtable<String, Integer> formAnalWODeducts = new Hashtable<String, Integer>(formAnal);
                Hashtable<String, Integer> formMod = StaticUtils.categorizeFormula(this.modificationFormula_);
                for (String element : formMod.keySet()) {
                    int amount;
                    int amountWODeducts = amount = formMod.get(element).intValue();
                    if (formAnal.containsKey(element)) {
                        amount += formAnal.get(element).intValue();
                        amountWODeducts = amountWODeducts > 0 ? (amountWODeducts += formAnalWODeducts.get(element).intValue()) : formAnalWODeducts.get(element);
                    }
                    formAnal.put(element, amount);
                    if (amountWODeducts <= 0) continue;
                    formAnalWODeducts.put(element, amountWODeducts);
                }
                this.chemicalFormula_ = "";
                for (String element : formAnal.keySet()) {
                    this.chemicalFormula_ = this.chemicalFormula_ + element + String.valueOf(formAnal.get(element)) + " ";
                }
                if (this.chemicalFormula_.length() > 0) {
                    this.chemicalFormula_ = this.chemicalFormula_.substring(0, this.chemicalFormula_.length() - 1);
                }
                this.chemicalFormulaWODeducts_ = "";
                for (String element : formAnalWODeducts.keySet()) {
                    this.chemicalFormulaWODeducts_ = this.chemicalFormulaWODeducts_ + element + String.valueOf(formAnalWODeducts.get(element)) + " ";
                }
                if (this.chemicalFormulaWODeducts_.length() > 0) {
                    this.chemicalFormulaWODeducts_ = this.chemicalFormulaWODeducts_.substring(0, this.chemicalFormulaWODeducts_.length() - 1);
                }
            }
            catch (ChemicalFormulaException e) {
                e.printStackTrace();
            }
        } else {
            this.chemicalFormula_ = this.analyteFormula_;
            this.chemicalFormulaWODeducts_ = this.analyteFormula_;
        }
        this.charge_ = charge;
        this.lowerRtHardLimit_ = -1.0f;
        this.upperRtHardLimit_ = -1.0f;
        this.percentalSplit_ = -1.0f;
        this.ohNumber_ = ohNumber;
        this.choseMoreLikelyRtWhenEqualMSn_ = false;
        this.omegaInformation_ = new Vector();
    }

    public void addOmegaInformation(DoubleBondPositionVO labeledSpeciesVO) {
        this.omegaInformation_.add(labeledSpeciesVO);
    }

    public void setOmegaInformation(Vector<DoubleBondPositionVO> omegaInfo) {
        this.omegaInformation_ = omegaInfo;
    }

    public boolean hasOmegaInformation() {
        return !this.omegaInformation_.isEmpty();
    }

    public static boolean isOmegaInformationAvailable() {
        return isOmegaInformationAvailable_;
    }

    public static void setOmegaInformationAvailable(boolean hasOmegaInformation) {
        isOmegaInformationAvailable_ = hasOmegaInformation;
    }

    public Vector<DoubleBondPositionVO> getOmegaInformation() {
        return this.omegaInformation_;
    }

    public String getNameString() {
        return StaticUtils.generateLipidNameString(this.Peptide, this.doubleBonds_, this.rt_, this.oxState_);
    }

    public String getNameStringWithoutRt() {
        return StaticUtils.generateLipidNameString(this.Peptide, this.doubleBonds_, -1, this.oxState_);
    }

    public String getName() {
        return this.Peptide;
    }

    public Integer getDoubleBonds() {
        return this.doubleBonds_;
    }

    public String getModificationName() {
        return this.modificationName_;
    }

    public String getAnalyteFormula() {
        return this.analyteFormula_;
    }

    public String getModificationFormula() {
        return this.modificationFormula_;
    }

    public Integer getCharge() {
        return this.charge_;
    }

    public String getOxState() {
        return this.oxState_;
    }

    public void setCharge(Integer charge) {
        this.charge_ = charge;
    }

    public void setOxState(String oxState) {
        this.oxState_ = oxState;
    }

    public String getRt() {
        return this.rt_;
    }

    public Double getPreciseRT() {
        return this.preciseRetentionTime_;
    }

    public void setPreciseRt(Double rt) {
        this.preciseRetentionTime_ = rt;
        this.rt_ = rt != null ? PreciseRTFormatter.FormatNumberToString(rt, 2) : null;
    }

    public String getChemicalFormula() {
        return this.chemicalFormula_;
    }

    public String getChemicalFormulaWODeducts() {
        return this.chemicalFormulaWODeducts_;
    }

    public int getMinIsotope() {
        int isotope;
        block3: {
            block2: {
                isotope = 0;
                if (this.ProbeCount() <= 0) break block2;
                for (int i = 0; i != this.ProbeCount(); ++i) {
                    int isoNumber = super.Probe((int)i).isotopeNumber;
                    if (isoNumber >= isotope) continue;
                    isotope = isoNumber;
                }
                break block3;
            }
            if (super.getIsotopicProbes() == null) break block3;
            for (Vector<CgProbe> isoProbes : super.getIsotopicProbes()) {
                int isoNumber;
                if (isoProbes.size() <= 0 || (isoNumber = isoProbes.get((int)0).isotopeNumber) >= isotope) continue;
                isotope = isoNumber;
            }
        }
        return isotope;
    }

    public String getNameIncludingModification() {
        return this.getNameString() + MOD_SEPARATOR + this.modificationName_;
    }

    public String getNamePlusModHumanReadable() {
        String name = this.getNameString();
        if (this.modificationName_ != null && this.modificationName_.length() > 0) {
            name = name + MOD_SEPARATOR_HR + this.modificationName_;
        }
        return name;
    }

    public void setNameString(String name) {
        String[] firstSplit = name.split(":");
        this.Peptide = firstSplit[0];
        String[] secondSplit = firstSplit[1].toString().split(MOD_SEPARATOR_HR);
        this.doubleBonds_ = Integer.parseInt(secondSplit[0]);
        this.rt_ = secondSplit[1];
    }

    public void setModificationName(String name) {
        this.modificationName_ = name;
    }

    public void setMZ(float[] mz) {
        this.Mz = mz;
    }

    public float getLowerRtHardLimit() {
        return this.lowerRtHardLimit_;
    }

    public void setLowerRtHardLimit(float lowerRtHardLimit) {
        this.lowerRtHardLimit_ = lowerRtHardLimit;
    }

    public float getUpperRtHardLimit() {
        return this.upperRtHardLimit_;
    }

    public void setUpperRtHardLimit(float upperRtHardLimit) {
        this.upperRtHardLimit_ = upperRtHardLimit;
    }

    public float getPercentalSplit() {
        return this.percentalSplit_;
    }

    public void setPercentalSplit(float percentalSplit) {
        this.percentalSplit_ = percentalSplit;
    }

    public float getArea() {
        float area = this.Area;
        return this.getArea(area);
    }

    public float getArea(int maxIsotope) {
        float area = 0.0f;
        for (int i = 0; i != maxIsotope + 1 && i != this.isotopicProbes_.size(); ++i) {
            for (CgProbe probe : (Vector)this.isotopicProbes_.get(i)) {
                area += probe.Area;
            }
        }
        return this.getArea(area);
    }

    private float getArea(float fullArea) {
        float area = fullArea;
        if (this.percentalSplit_ >= 0.0f) {
            area = area * this.percentalSplit_ / 100.0f;
        }
        return area;
    }

    public Integer getOhNumber() {
        return this.ohNumber_;
    }

    public boolean isSuitableForRtProcessingHit(String className) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return this instanceof LipidomicsMSnSet && this.lowerRtHardLimit_ < 0.0f && this.upperRtHardLimit_ < 0.0f && this.percentalSplit_ < 0.0f && RulesContainer.isRtPostprocessing(StaticUtils.getRuleName(className, this.modificationName_));
    }

    public boolean isChoseMoreLikelyRtWhenEqualMSn() {
        return this.choseMoreLikelyRtWhenEqualMSn_;
    }

    public void setChoseMoreLikelyRtWhenEqualMSn(boolean choseMoreLikelyRtWhenEqualMSn) {
        this.choseMoreLikelyRtWhenEqualMSn_ = choseMoreLikelyRtWhenEqualMSn;
    }

    public float getCoverage() {
        return this.coverage_;
    }

    public void setCoverage(float coverage) {
        this.coverage_ = coverage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LipidParameterSet other = (LipidParameterSet)obj;
        return Objects.equals(this.analyteFormula_, other.analyteFormula_) && Objects.equals(this.charge_, other.charge_) && Objects.equals(this.chemicalFormulaWODeducts_, other.chemicalFormulaWODeducts_) && Objects.equals(this.chemicalFormula_, other.chemicalFormula_) && this.choseMoreLikelyRtWhenEqualMSn_ == other.choseMoreLikelyRtWhenEqualMSn_ && Objects.equals(this.doubleBonds_, other.doubleBonds_) && Float.floatToIntBits(this.lowerRtHardLimit_) == Float.floatToIntBits(other.lowerRtHardLimit_) && Objects.equals(this.modificationFormula_, other.modificationFormula_) && Objects.equals(this.modificationName_, other.modificationName_) && Objects.equals(this.ohNumber_, other.ohNumber_) && Objects.equals(this.omegaInformation_, other.omegaInformation_) && Float.floatToIntBits(this.percentalSplit_) == Float.floatToIntBits(other.percentalSplit_) && Objects.equals(this.rt_, other.rt_) && Float.floatToIntBits(this.upperRtHardLimit_) == Float.floatToIntBits(other.upperRtHardLimit_);
    }
}

