/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.parser;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.ClassNamesExtractor;
import at.tugraz.genome.lda.analysis.ComparativeNameExtractor;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.exception.SettingsException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.parser.FragRuleParser;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.IntensityChainVO;
import at.tugraz.genome.lda.msn.vos.IntensityPositionVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.maspectras.quantification.CgAreaStatus;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgParameterSet;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.Probe3D;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JFrame;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.CellType;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.Sheet;

public class LDAResultReader {
    private static LipidomicsConstants lipidomicsConstants_;
    private static HydroxyEncoding faHydroxyEncoding_;
    private static HydroxyEncoding lcbHydroxyEncoding_;
    private static Hashtable<String, Vector<LipidParameterSet>> resultParameterSets_;
    private static Hashtable<String, Integer> msLevels_;

    public static QuantificationResult readResultFile(String filePath, Hashtable<String, Boolean> showModifications) throws ExcelInputFileException {
        return LDAResultReader.readResultFile(filePath, showModifications, null);
    }

    public static QuantificationResult readResultFile(String filePath, Hashtable<String, Boolean> showModifications, String specificClass) throws ExcelInputFileException {
        lipidomicsConstants_ = null;
        faHydroxyEncoding_ = null;
        lcbHydroxyEncoding_ = null;
        resultParameterSets_ = new Hashtable();
        msLevels_ = new Hashtable();
        String suffix = "";
        if (filePath != null && filePath.length() > 3) {
            suffix = filePath.substring(filePath.lastIndexOf("."));
        }
        if (!suffix.equalsIgnoreCase(".xlsx")) {
            new WarningMessage(new JFrame(), "ERROR", "The specified file format is not supported!");
            throw new ExcelInputFileException("The specified file format is not supported!");
        }
        try (FileInputStream is = new FileInputStream(filePath);
             ReadableWorkbook wb = new ReadableWorkbook(is);){
            TreeMap<Object, Object> map = new TreeMap();
            Optional<Sheet> lipidClassSheet = wb.getSheets().filter(s -> s.getName().equals("Lipid (sub)classes")).findFirst();
            if (lipidClassSheet.isPresent()) {
                map = ClassNamesExtractor.parseLipidClassSheet(lipidClassSheet.get());
            }
            TreeMap finalMap = map;
            Comparator sheetComparator = (s1, s2) -> LDAResultReader.compareBySheetName(s1, s2);
            wb.getSheets().filter(s -> LDAResultReader.parseSheet(s, (String)(finalMap.isEmpty() ? specificClass : (specificClass == null ? null : (String)finalMap.entrySet().stream().filter(m -> ((String)m.getValue()).equals(specificClass)).findFirst().get().getKey())))).sorted(sheetComparator).forEach(s -> {
                try {
                    LDAResultReader.readSheet(s, showModifications, finalMap);
                }
                catch (LipidCombinameEncodingException | RulesException | SettingsException | IOException ex) {
                    new WarningMessage(new JFrame(), "ERROR", ex.getMessage());
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
            new WarningMessage(new JFrame(), "ERROR", ex.getMessage());
            throw new ExcelInputFileException(ex);
        }
        resultParameterSets_ = new Hashtable<String, Vector>(resultParameterSets_.entrySet().stream().filter(entry -> !((Vector)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return new QuantificationResult(resultParameterSets_, lipidomicsConstants_, msLevels_, faHydroxyEncoding_, lcbHydroxyEncoding_);
    }

    private static void readSheet(Sheet sheet, Hashtable<String, Boolean> showModifications, TreeMap<String, String> lipidClassNames) throws SettingsException, RulesException, LipidCombinameEncodingException, IOException {
        String name = sheet.getName();
        if (name.equals("About")) {
            Object[] settings = LDAResultReader.readSettingsFromExcel(sheet);
            lipidomicsConstants_ = (LipidomicsConstants)settings[0];
            faHydroxyEncoding_ = (HydroxyEncoding)settings[1];
            lcbHydroxyEncoding_ = (HydroxyEncoding)settings[2];
        } else if (name.endsWith(" - MSn")) {
            LDAResultReader.readMSnSheet(sheet, LDAResultReader.buildLipidClassName(name, lipidClassNames, " - MSn"));
        } else if (name.endsWith(" - Omega")) {
            LDAResultReader.readOmegaSheet(sheet, LDAResultReader.buildLipidClassName(name, lipidClassNames, " - Omega"));
            LipidParameterSet.setOmegaInformationAvailable(true);
        } else {
            LDAResultReader.readMS1Sheet(sheet, showModifications, LDAResultReader.buildLipidClassName(name, lipidClassNames, null));
        }
    }

    private static String buildLipidClassName(String sheetName, TreeMap<String, String> lipidClassNames, String suffix) {
        String lipidClass = sheetName;
        if (suffix != null) {
            lipidClass = sheetName.substring(0, sheetName.lastIndexOf(suffix));
        }
        return lipidClassNames.isEmpty() ? lipidClass : lipidClassNames.get(lipidClass);
    }

    public static Object[] readSettingsFromExcel(Sheet sheet) throws SettingsException, IOException {
        String cutoff;
        Properties properties = new Properties();
        List<Row> rows = sheet.read();
        Row headerRow = rows.get(0);
        List<Row> contentRows = rows.subList(1, rows.size());
        List<String> headerTitles = LDAResultReader.readSheetHeaderTitles(headerRow);
        Hashtable<String, Short> faOhEncondings = new Hashtable<String, Short>();
        Hashtable<String, Short> lcbOhEncondings = new Hashtable<String, Short>();
        for (Row row : contentRows) {
            String key = row.getCellText(headerTitles.indexOf("Key"));
            String value = row.getCellText(headerTitles.indexOf("Value"));
            if (key.startsWith("faOHEncoding_") || key.startsWith("lcbOHEncoding_")) {
                String ohNumberString = null;
                if (key.startsWith("faOHEncoding_")) {
                    ohNumberString = key.substring("faOHEncoding_".length());
                } else if (key.startsWith("lcbOHEncoding_")) {
                    ohNumberString = key.substring("lcbOHEncoding_".length());
                }
                Short ohNumber = Short.parseShort(ohNumberString);
                if (key.startsWith("faOHEncoding_")) {
                    faOhEncondings.put(value, ohNumber);
                    continue;
                }
                if (!key.startsWith("lcbOHEncoding_")) continue;
                lcbOhEncondings.put(value, ohNumber);
                continue;
            }
            properties.put(key, value);
        }
        LipidomicsConstants constants = new LipidomicsConstants(false);
        constants.setLDAVersion(properties.getProperty("LDA-version", "2.11.0"));
        if (properties.containsKey("rawFile")) {
            constants.setRawFileName(properties.getProperty("rawFile"));
        }
        if (properties.containsKey("basePeakCutoff") && (cutoff = properties.getProperty("basePeakCutoff")) != null) {
            try {
                Double.parseDouble(cutoff);
                constants.setRelativeMS1BasePeakCutoff(cutoff);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (properties.containsKey("massShift")) {
            properties.put("massShift", String.valueOf(Double.parseDouble(properties.getProperty("massShift")) * 1000.0));
        }
        constants.setVariables(properties);
        Object[] returnValues = new Object[]{constants, new HydroxyEncoding(faOhEncondings), new HydroxyEncoding(lcbOhEncondings)};
        return returnValues;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void readMSnSheet(Sheet sheet, String lipidClass) throws RulesException, LipidCombinameEncodingException, IOException {
        Hashtable<String, LipidParameterSet> msHash = new Hashtable<String, LipidParameterSet>();
        Vector<LipidParameterSet> resultPrms = resultParameterSets_.get(lipidClass);
        resultPrms.stream().forEach(p -> msHash.put(p.getNamePlusModHumanReadable(), (LipidParameterSet)p));
        LipidParameterSet addingMSnEvidence = null;
        Hashtable<Integer, String> columnToIdentification = new Hashtable<Integer, String>();
        Hashtable<String, Double> relativeAreas = new Hashtable<String, Double>();
        String regex = "MS(\\d+) scan RTs";
        Pattern msLevelPattern = Pattern.compile(regex);
        Hashtable<Integer, LinkedHashMap<Integer, Float>> msnRetentionTimes = new Hashtable<Integer, LinkedHashMap<Integer, Float>>();
        boolean checkMSnAreas = false;
        boolean headGroupFragmentActive = false;
        boolean headGroupRules = false;
        boolean chainFragmentActive = false;
        boolean chainRules = false;
        boolean positionRules = false;
        String combiKey = "";
        boolean headerRowRead = false;
        boolean readFragmentHeaderRow = false;
        boolean intensityHeaderRead = false;
        boolean readIntensityHeaderRow = false;
        int nameColumn = -1;
        int ohColumn = -1;
        int chainTypeColumn = -1;
        int formulaColumn = -1;
        int msLevelColumn = -1;
        int chargeColumn = -1;
        int mzColumn = -1;
        int mzTolColumn = -1;
        int areaColumn = -1;
        int peakColumn = -1;
        int startTimeColumn = -1;
        int stopTimeColumn = -1;
        int startMzColumn = -1;
        int stopMzColumn = -1;
        int ellTimeColumn = -1;
        int ellMzColumn = -1;
        int ellTimeRangeColumn = -1;
        int ellMzRangeColumn = -1;
        int ruleColumn = -1;
        int originalRuleColumn = -1;
        int ruleValuesColumn = -1;
        int ruleMissedColumn = -1;
        int status = 0;
        float mzTolerance = -1.0f;
        Hashtable<String, CgProbe> headGroupFragments = new Hashtable<String, CgProbe>();
        Hashtable<String, IntensityRuleVO> headIntensityRules = new Hashtable<String, IntensityRuleVO>();
        Hashtable<String, Hashtable<String, CgProbe>> chainFragments = new Hashtable<String, Hashtable<String, CgProbe>>();
        Hashtable<String, Hashtable<String, IntensityChainVO>> chainIntensityRules = new Hashtable<String, Hashtable<String, IntensityChainVO>>();
        Vector<String> validChainCombinations = new Vector<String>();
        Hashtable<String, Hashtable<Integer, Integer>> positionDefinition = new Hashtable<String, Hashtable<Integer, Integer>>();
        Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> positionEvidence = new Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>>();
        Hashtable<Integer, Float> basePeakValues = new Hashtable<Integer, Float>();
        Hashtable<String, String> uniqueRules = new Hashtable<String, String>();
        int numberOfPositions = -1;
        boolean containsAlkyl = false;
        boolean containsAlkenyl = false;
        boolean usedAlexMsnTargets = false;
        char knownPosSep = "/".toCharArray()[0];
        char unknownPosSep = "_".toCharArray()[0];
        List<Row> rows = sheet.read();
        int lastRow = rows.get(rows.size() - 1).getRowNum();
        int counter = 0;
        for (int row = 1; row <= lastRow; ++row) {
            Hashtable cellEntries = new Hashtable();
            if (rows.get(counter).getRowNum() == row) {
                rows.get(counter).stream().filter(c -> c != null && !c.getType().equals((Object)CellType.ERROR)).forEach(c -> cellEntries.put(c.getColumnIndex(), c.getRawValue()));
                ++counter;
            }
            if (addingMSnEvidence == null && cellEntries.containsKey(0) && ((String)cellEntries.get(0)).trim().startsWith("AlexMSnTargetsUsed")) {
                StringTokenizer tokenizer = new StringTokenizer((String)cellEntries.get(0), "=");
                if (tokenizer.countTokens() != 2) continue;
                tokenizer.nextToken();
                String value = tokenizer.nextToken().trim();
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
                    usedAlexMsnTargets = true;
                }
            } else if (addingMSnEvidence == null && cellEntries.containsKey(0) && cellEntries.containsKey(1)) {
                status = 0;
                mzTolerance = -1.0f;
                headGroupFragments = new Hashtable();
                headIntensityRules = new Hashtable();
                chainFragments = new Hashtable();
                chainIntensityRules = new Hashtable();
                validChainCombinations = new Vector();
                positionDefinition = new Hashtable();
                positionEvidence = new Hashtable();
                basePeakValues = new Hashtable();
                columnToIdentification = new Hashtable();
                String speciesName = (String)cellEntries.get(0);
                addingMSnEvidence = (LipidParameterSet)msHash.get(speciesName);
                int count = 1;
                numberOfPositions = -1;
                containsAlkyl = false;
                containsAlkenyl = false;
                while (cellEntries.containsKey(count)) {
                    String lipidIdentification = (String)cellEntries.get(count);
                    if (lipidIdentification != null && lipidIdentification.length() > 0) {
                        columnToIdentification.put(count, lipidIdentification);
                        if (lipidIdentification.indexOf("/") != -1 || lipidIdentification.indexOf("_") != -1 || lipidIdentification.indexOf(":") != -1) {
                            boolean isAlexOhEncoding = false;
                            if (usedAlexMsnTargets) {
                                if (lipidIdentification.indexOf(";") != -1) {
                                    boolean makeSubstring = false;
                                    char[] chars = lipidIdentification.toCharArray();
                                    for (int i = lipidIdentification.indexOf(lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion()) + 1; i != chars.length; ++i) {
                                        if (chars[i] == knownPosSep || chars[i] == unknownPosSep) {
                                            isAlexOhEncoding = true;
                                            break;
                                        }
                                        if (chars[i] != ':') continue;
                                        makeSubstring = true;
                                        break;
                                    }
                                    if (makeSubstring) {
                                        lipidIdentification = lipidIdentification.substring(0, lipidIdentification.indexOf(lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion()));
                                    }
                                }
                            } else if (lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion() != null && lipidIdentification.indexOf(lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion()) != -1) {
                                lipidIdentification = lipidIdentification.substring(0, lipidIdentification.indexOf(lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion()));
                            }
                            lipidIdentification = StaticUtils.removeSNPositions(lipidIdentification);
                            lipidIdentification = StaticUtils.getHumanReadableWODoubleBondPositions(lipidIdentification);
                            Object[] nameAndNumberOfPos = StaticUtils.cleanEmptyFAPositionsAndEncodeToLDACombiName(lipidIdentification, faHydroxyEncoding_, lcbHydroxyEncoding_, isAlexOhEncoding, lipidomicsConstants_);
                            lipidIdentification = (String)nameAndNumberOfPos[0];
                            int posNr = (Integer)nameAndNumberOfPos[1];
                            if (posNr > numberOfPositions) {
                                numberOfPositions = posNr;
                            }
                            containsAlkyl = (Boolean)nameAndNumberOfPos[2];
                            containsAlkenyl = (Boolean)nameAndNumberOfPos[3];
                            columnToIdentification.put(count, lipidIdentification);
                            validChainCombinations.add(lipidIdentification);
                        }
                    }
                    ++count;
                }
                checkMSnAreas = true;
                headGroupFragmentActive = false;
                headGroupRules = false;
                chainFragmentActive = false;
                chainRules = false;
                positionRules = false;
            } else if (checkMSnAreas && addingMSnEvidence != null) {
                relativeAreas = new Hashtable();
                msnRetentionTimes = new Hashtable();
                double totalArea = Double.parseDouble((String)cellEntries.get(0));
                for (Integer column : columnToIdentification.keySet()) {
                    String lipidIdentification = (String)columnToIdentification.get(column);
                    Matcher msLevelMatcher = msLevelPattern.matcher(lipidIdentification);
                    if (msLevelMatcher.matches()) {
                        int msLevel = Integer.parseInt(msLevelMatcher.group(1));
                        LinkedHashMap<Integer, Float> rts = new LinkedHashMap<Integer, Float>();
                        StringTokenizer rtTokenizer = null;
                        rtTokenizer = new StringTokenizer((String)cellEntries.get(column), ";");
                        int count = 1;
                        while (rtTokenizer.hasMoreTokens()) {
                            String kvPairString = rtTokenizer.nextToken();
                            int scanNr = -1;
                            float f = -1.0f;
                            if (kvPairString.indexOf("=") == -1) {
                                scanNr = count++;
                                f = new Float(kvPairString).floatValue();
                            } else {
                                String[] stringArray = kvPairString.split("=");
                                scanNr = Integer.parseInt(stringArray[0]);
                                f = Float.parseFloat(stringArray[1]);
                            }
                            rts.put(scanNr, Float.valueOf(f));
                        }
                        msnRetentionTimes.put(msLevel, rts);
                        continue;
                    }
                    relativeAreas.put(lipidIdentification, Double.parseDouble((String)cellEntries.get(column)) / totalArea);
                }
                checkMSnAreas = false;
            } else if (!headGroupFragmentActive && addingMSnEvidence != null && cellEntries.containsKey(0) && ((String)cellEntries.get(0)).trim().equalsIgnoreCase("Head group fragments")) {
                headGroupFragmentActive = true;
                headGroupRules = false;
                chainFragmentActive = false;
                chainRules = false;
                positionRules = false;
                readFragmentHeaderRow = true;
                headerRowRead = false;
                intensityHeaderRead = false;
            } else if (!headGroupRules && addingMSnEvidence != null && cellEntries.containsKey(0) && ((String)cellEntries.get(0)).trim().equalsIgnoreCase("Head group rules")) {
                headGroupFragmentActive = false;
                headGroupRules = true;
                chainFragmentActive = false;
                chainRules = false;
                positionRules = false;
                headerRowRead = false;
                readIntensityHeaderRow = true;
                intensityHeaderRead = false;
                uniqueRules = new Hashtable();
            } else if (!chainFragmentActive && addingMSnEvidence != null && cellEntries.containsKey(0) && ((String)cellEntries.get(0)).trim().equalsIgnoreCase("Chain fragments")) {
                headGroupFragmentActive = false;
                headGroupRules = false;
                chainFragmentActive = true;
                chainRules = false;
                positionRules = false;
                readFragmentHeaderRow = true;
                headerRowRead = false;
                intensityHeaderRead = false;
            } else if (!chainRules && addingMSnEvidence != null && cellEntries.containsKey(0) && ((String)cellEntries.get(0)).trim().equalsIgnoreCase("Chain rules")) {
                headGroupFragmentActive = false;
                headGroupRules = false;
                chainFragmentActive = false;
                chainRules = true;
                positionRules = false;
                headerRowRead = false;
                readIntensityHeaderRow = true;
                intensityHeaderRead = false;
                uniqueRules = new Hashtable();
            } else if (addingMSnEvidence != null && cellEntries.containsKey(0) && ((String)cellEntries.get(0)).trim().startsWith("Position rules")) {
                headGroupFragmentActive = false;
                headGroupRules = false;
                chainFragmentActive = false;
                chainRules = false;
                positionRules = true;
                headerRowRead = false;
                readIntensityHeaderRow = true;
                intensityHeaderRead = false;
                combiKey = ((String)cellEntries.get(0)).trim().substring("Position rules".length());
                combiKey = combiKey.substring(combiKey.indexOf("(") + 1, combiKey.indexOf(")"));
                if (lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion() != null) {
                    if (combiKey.indexOf(lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion()) != -1) {
                        combiKey = combiKey.substring(0, combiKey.indexOf(lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion()));
                    }
                } else {
                    combiKey = StaticUtils.removeSNPositions(combiKey);
                }
                validChainCombinations = LDAResultReader.correctUndefinedChainCombinations(combiKey, validChainCombinations, relativeAreas, "<->");
                Hashtable<String, Integer> chainOccurenceInCombi = new Hashtable<String, Integer>();
                combiKey = (String)StaticUtils.cleanEmptyFAPositionsAndEncodeToLDACombiName(combiKey, faHydroxyEncoding_, lcbHydroxyEncoding_, usedAlexMsnTargets && combiKey.indexOf(lipidomicsConstants_.getChainCombiSeparatorAmbigPosDependingOnVersion()) != -1, lipidomicsConstants_)[0];
                combiKey = LDAResultReader.getPermutationThatIsInValidChainCombinations(combiKey, validChainCombinations);
                Vector<String> fas = StaticUtils.splitChainCombiToEncodedStrings(combiKey, "<->");
                for (String fa : fas) {
                    int count = 0;
                    if (chainOccurenceInCombi.containsKey(fa)) {
                        count = (Integer)chainOccurenceInCombi.get(fa);
                    }
                    chainOccurenceInCombi.put(fa, ++count);
                }
                if (chainOccurenceInCombi.size() == 1 && fas.size() == numberOfPositions) {
                    Hashtable<Integer, Integer> definitions = new Hashtable<Integer, Integer>();
                    for (int i = 0; i != fas.size(); ++i) {
                        definitions.put(i, i);
                    }
                    positionDefinition.put(combiKey, definitions);
                    positionEvidence.put(combiKey, new Hashtable());
                    uniqueRules = new Hashtable();
                    continue;
                }
            } else if (addingMSnEvidence != null && !cellEntries.containsKey(0)) {
                String speciesName = addingMSnEvidence.getNamePlusModHumanReadable();
                if (LDAResultReader.isDefinitionPresent(positionDefinition = LDAResultReader.cleanPositionDefinition(positionDefinition))) {
                    status = 4;
                }
                addingMSnEvidence = new LipidomicsMSnSet(addingMSnEvidence, status, headGroupFragments, headIntensityRules, chainFragments, chainIntensityRules, validChainCombinations, relativeAreas, positionDefinition, positionEvidence, numberOfPositions, basePeakValues, msnRetentionTimes, faHydroxyEncoding_, lcbHydroxyEncoding_);
                msHash.put(speciesName, addingMSnEvidence);
                addingMSnEvidence = null;
            } else if (readFragmentHeaderRow) {
                for (Integer columnId : cellEntries.keySet()) {
                    if (((String)cellEntries.get(columnId)).length() == 0) continue;
                    String entry = (String)cellEntries.get(columnId);
                    if (entry.equalsIgnoreCase("Name")) {
                        nameColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("OH")) {
                        ohColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("Chain type")) {
                        chainTypeColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("Formula")) {
                        formulaColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("msLevel")) {
                        msLevelColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("Charge")) {
                        chargeColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("Mz")) {
                        mzColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("MzTolerance")) {
                        mzTolColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("Area")) {
                        areaColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("Peak")) {
                        peakColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("LowerValley")) {
                        startTimeColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("UpperValley")) {
                        stopTimeColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("LowMz")) {
                        startMzColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("UpMz")) {
                        stopMzColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("EllCentTime")) {
                        ellTimeColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("EllCentMz")) {
                        ellMzColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("EllStretchTime")) {
                        ellTimeRangeColumn = columnId;
                    }
                    if (!entry.equalsIgnoreCase("EllStretchMz")) continue;
                    ellMzRangeColumn = columnId;
                }
                readFragmentHeaderRow = false;
                headerRowRead = true;
            } else if (readIntensityHeaderRow) {
                for (Integer columnId : cellEntries.keySet()) {
                    if (cellEntries.get(columnId) == null || ((String)cellEntries.get(columnId)).length() == 0) continue;
                    String entry = (String)cellEntries.get(columnId);
                    if (entry.equalsIgnoreCase("Rule")) {
                        ruleColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("Original")) {
                        originalRuleColumn = columnId;
                    }
                    if (entry.equalsIgnoreCase("Values")) {
                        ruleValuesColumn = columnId;
                    }
                    if (!entry.equalsIgnoreCase("Missed")) continue;
                    ruleMissedColumn = columnId;
                }
                readIntensityHeaderRow = false;
                intensityHeaderRead = true;
            } else if (addingMSnEvidence != null && headerRowRead && (headGroupFragmentActive || chainFragmentActive)) {
                String fragmentName = null;
                if (nameColumn > -1 && cellEntries.containsKey(nameColumn)) {
                    fragmentName = (String)cellEntries.get(nameColumn);
                }
                int oh = 0;
                if (ohColumn > -1 && cellEntries.containsKey(ohColumn)) {
                    oh = (int)Math.rint(Double.parseDouble((String)cellEntries.get(ohColumn)));
                }
                short chainType = -1;
                if (chainTypeColumn > -1 && cellEntries.containsKey(chainTypeColumn)) {
                    String chainTypeString = (String)cellEntries.get(chainTypeColumn);
                    if (chainTypeString.equalsIgnoreCase("$CHAIN".substring(1))) {
                        chainType = 0;
                    } else if (chainTypeString.equalsIgnoreCase("$ALKYLCHAIN".substring(1))) {
                        chainType = 1;
                    } else if (chainTypeString.equalsIgnoreCase("$ALKENYLCHAIN".substring(1))) {
                        chainType = 2;
                    } else {
                        if (!chainTypeString.equalsIgnoreCase("$LCB".substring(1))) throw new LipidCombinameEncodingException("The entry \"" + chainTypeString + "\" is not allowed in the column \"" + "Chain type" + "\"!");
                        chainType = 3;
                    }
                } else if (chainFragmentActive) {
                    chainType = 0;
                    if (containsAlkyl && fragmentName.indexOf("(O-") != -1) {
                        chainType = 1;
                    }
                    if (containsAlkenyl && fragmentName.indexOf("(P-") != -1) {
                        chainType = 2;
                    }
                }
                String formula = null;
                if (formulaColumn > -1 && cellEntries.containsKey(formulaColumn)) {
                    formula = "+" + ((String)cellEntries.get(formulaColumn)).trim().replaceAll(" ", " \\+");
                }
                int msLevel = -1;
                if (msLevelColumn > -1 && cellEntries.containsKey(msLevelColumn)) {
                    msLevel = (int)Math.rint(Double.parseDouble((String)cellEntries.get(msLevelColumn)));
                }
                int charge = -1;
                if (chargeColumn > -1 && cellEntries.containsKey(chargeColumn)) {
                    charge = (int)Math.rint(Double.parseDouble((String)cellEntries.get(chargeColumn)));
                }
                float mz = -1.0f;
                if (mzColumn > -1 && cellEntries.containsKey(mzColumn)) {
                    mz = Float.parseFloat((String)cellEntries.get(mzColumn));
                }
                if (mzTolerance < 0.0f && mzTolColumn > -1 && cellEntries.containsKey(mzTolColumn)) {
                    mzTolerance = Float.parseFloat((String)cellEntries.get(mzTolColumn));
                }
                float area = -1.0f;
                if (areaColumn > -1 && cellEntries.containsKey(areaColumn)) {
                    area = Float.parseFloat((String)cellEntries.get(areaColumn));
                }
                float peak = -1.0f;
                if (peakColumn > -1 && cellEntries.containsKey(peakColumn)) {
                    peak = Float.parseFloat((String)cellEntries.get(peakColumn));
                }
                float startTime = -1.0f;
                if (startTimeColumn > -1 && cellEntries.containsKey(startTimeColumn)) {
                    startTime = Float.parseFloat((String)cellEntries.get(startTimeColumn));
                }
                float stopTime = -1.0f;
                if (stopTimeColumn > -1 && cellEntries.containsKey(stopTimeColumn)) {
                    stopTime = Float.parseFloat((String)cellEntries.get(stopTimeColumn));
                }
                float startMz = -1.0f;
                if (startMzColumn > -1 && cellEntries.containsKey(startMzColumn)) {
                    startMz = Float.parseFloat((String)cellEntries.get(startMzColumn));
                }
                float f = -1.0f;
                if (stopMzColumn > -1 && cellEntries.containsKey(stopMzColumn)) {
                    f = Float.parseFloat((String)cellEntries.get(stopMzColumn));
                }
                float f2 = -1.0f;
                if (ellTimeColumn > -1 && cellEntries.containsKey(ellTimeColumn)) {
                    f2 = Float.parseFloat((String)cellEntries.get(ellTimeColumn));
                }
                float f3 = -1.0f;
                if (ellMzColumn > -1 && cellEntries.containsKey(ellMzColumn)) {
                    f3 = Float.parseFloat((String)cellEntries.get(ellMzColumn));
                }
                float ellipseTimeStretch = -1.0f;
                if (ellTimeRangeColumn > -1 && cellEntries.containsKey(ellTimeRangeColumn)) {
                    ellipseTimeStretch = Float.parseFloat((String)cellEntries.get(ellTimeRangeColumn));
                }
                float ellipseMzStretch = -1.0f;
                if (ellMzRangeColumn > -1 && cellEntries.containsKey(ellMzRangeColumn)) {
                    ellipseMzStretch = Float.parseFloat((String)cellEntries.get(ellMzRangeColumn));
                }
                if (fragmentName != null && fragmentName.length() > 0 && msLevel > 0 && charge > 0 && mz > 0.0f && mzTolerance > 0.0f && area > 0.0f && peak > 0.0f && startTime > -1.0f && stopTime > 0.0f) {
                    CgProbe probe = new CgProbe(-1, charge, msLevel, formula);
                    probe.AreaStatus = CgAreaStatus.OK;
                    probe.Mz = mz;
                    probe.Area = area;
                    probe.AreaError = 0.0f;
                    probe.Background = 0.0f;
                    probe.Peak = peak;
                    probe.LowerValley = startTime;
                    probe.UpperValley = stopTime;
                    probe.LowerMzBand = mzTolerance;
                    probe.UpperMzBand = mzTolerance;
                    probe.isotopeNumber = 0;
                    if (startMz > 0.0f && f > 0.0f && f2 > 0.0f && f3 > 0.0f && ellipseTimeStretch > 0.0f && ellipseMzStretch > 0.0f) {
                        probe = new Probe3D(probe, f2, f3, ellipseTimeStretch, ellipseMzStretch, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f);
                        probe.LowerMzBand = startMz;
                        probe.UpperMzBand = f;
                    }
                    if (headGroupFragmentActive) {
                        headGroupFragments.put(fragmentName, probe);
                        status = 2;
                    } else if (chainFragmentActive) {
                        void var85_183;
                        status = 3;
                        Object[] faAndFragment = StaticUtils.parseChainFaAndFragmentNameFromExcel(fragmentName, chainType, oh, lipidomicsConstants_.shouldOldEncodingBeUsed());
                        FattyAcidVO faName = (FattyAcidVO)faAndFragment[0];
                        fragmentName = (String)faAndFragment[1];
                        Hashtable hashtable = new Hashtable();
                        if (chainFragments.containsKey(faName.getChainId())) {
                            Hashtable<String, CgProbe> hashtable2 = chainFragments.get(faName.getChainId());
                        }
                        var85_183.put(fragmentName, probe);
                        chainFragments.put(faName.getChainId(), (Hashtable<String, CgProbe>)var85_183);
                    }
                }
            } else if (addingMSnEvidence != null && intensityHeaderRead && (headGroupRules || chainRules || positionRules)) {
                String readableRuleInterpretation = null;
                if (ruleColumn > -1 && cellEntries.containsKey(ruleColumn)) {
                    readableRuleInterpretation = (String)cellEntries.get(ruleColumn);
                }
                String rule = null;
                if (originalRuleColumn > -1 && cellEntries.containsKey(originalRuleColumn)) {
                    rule = (String)cellEntries.get(originalRuleColumn);
                }
                String ruleValueInterpretation = null;
                if (ruleValuesColumn > -1 && cellEntries.containsKey(ruleValuesColumn)) {
                    ruleValueInterpretation = (String)cellEntries.get(ruleValuesColumn);
                }
                if (readableRuleInterpretation != null && readableRuleInterpretation.length() > 0 && rule != null && rule.length() > 0 && ruleValueInterpretation != null && ruleValueInterpretation.length() > 0) {
                    String uniqueRuleString = readableRuleInterpretation + ";" + rule + ";" + ruleValueInterpretation;
                    String missedString = "";
                    if (ruleMissedColumn > -1 && cellEntries.containsKey(ruleMissedColumn)) {
                        missedString = (String)cellEntries.get(ruleMissedColumn);
                    }
                    Hashtable<String, Short> missed = new Hashtable<String, Short>();
                    Hashtable<String, Short> missedPosition = new Hashtable<String, Short>();
                    StringTokenizer tokenizer = new StringTokenizer(missedString, ";");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.indexOf("[") != -1) {
                            if (positionRules) {
                                missedPosition.put(token, (short)-1);
                            }
                            token = token.substring(0, token.indexOf("["));
                        }
                        int type = -1;
                        if (chainRules || positionRules) {
                            boolean isAChain = false;
                            if (token.startsWith("FA ") || token.startsWith("-FA ") || token.startsWith("LCB ") || token.startsWith("-LCB ") || token.startsWith("O-") || token.startsWith("-O-")) {
                                isAChain = true;
                            } else {
                                String remnant = new String(readableRuleInterpretation);
                                while (remnant.indexOf(token) != -1) {
                                    if (!(remnant = remnant.substring(remnant.indexOf(token) + token.length())).startsWith("(")) continue;
                                    isAChain = true;
                                    break;
                                }
                            }
                            if (isAChain) {
                                type = -2;
                            }
                        }
                        missed.put(token, (short)type);
                    }
                    if (uniqueRules.containsKey(uniqueRuleString)) continue;
                    uniqueRules.put(uniqueRuleString, uniqueRuleString);
                    int currentSection = -1;
                    if (headGroupRules) {
                        currentSection = 2;
                    } else if (chainRules) {
                        currentSection = 3;
                    } else if (positionRules) {
                        currentSection = 4;
                    }
                    Hashtable<String, Short> head = new Hashtable<String, Short>();
                    for (String key : headGroupFragments.keySet()) {
                        head.put(key, (short)-1);
                    }
                    Hashtable<String, Short> chain = new Hashtable<String, Short>();
                    for (String string : chainFragments.keySet()) {
                        FattyAcidVO fattyAcidVO = StaticUtils.decodeLipidNameForCreatingCombis(string);
                        Hashtable<String, CgProbe> hashtable = chainFragments.get(string);
                        for (String name : hashtable.keySet()) {
                            chain.put(name, fattyAcidVO.getChainType());
                        }
                    }
                    IntensityRuleVO ruleVO = FragRuleParser.extractIntensityVOFromEquation(rule, -1, currentSection, head, chain, null, missed);
                    if (chainRules || positionRules) {
                        void var77_139;
                        Object var77_136 = null;
                        if (chainRules) {
                            IntensityChainVO intensityChainVO = IntensityChainVO.getFattyAcidsFromReadableRule(readableRuleInterpretation, ruleVO, chainFragments, missed, faHydroxyEncoding_, lcbHydroxyEncoding_, addingMSnEvidence.getOhNumber() > 0, usedAlexMsnTargets);
                        } else if (positionRules) {
                            IntensityPositionVO intensityPositionVO = IntensityPositionVO.getFattyAcidsFromReadableRule(readableRuleInterpretation, ruleVO, chainFragments, missedPosition, faHydroxyEncoding_, lcbHydroxyEncoding_, addingMSnEvidence.getOhNumber() > 0, usedAlexMsnTargets);
                        }
                        if (var77_139 != null) {
                            ruleVO = var77_139;
                        }
                    }
                    if (ruleVO.containsBasePeak()) {
                        Hashtable<String, Float> hashtable = LipidomicsMSnSet.getFragmentAreas(ruleVO, headGroupFragments, chainFragments);
                        for (String string : hashtable.keySet()) {
                            if (!(hashtable.get(string).floatValue() < 0.0f)) continue;
                            hashtable.put(string, Float.valueOf(0.0f));
                        }
                        float f = ruleVO.extractBasePeakValue(ruleValueInterpretation, hashtable);
                        int n = ruleVO.getMSLevel(headGroupFragments, chainFragments);
                        if (n > 1) {
                            basePeakValues.put(n, Float.valueOf(f));
                        }
                    }
                    if (ruleVO != null && headGroupRules) {
                        headIntensityRules.put(ruleVO.getRuleIdentifier(), ruleVO);
                    } else if (ruleVO != null && chainRules) {
                        void var79_160;
                        IntensityChainVO intensityChainVO = (IntensityChainVO)ruleVO;
                        Hashtable hashtable = new Hashtable();
                        Vector<String> vector = new Vector<String>();
                        if (intensityChainVO.getChainType() == -1) {
                            Vector<String> chains = new Vector<String>();
                            for (FattyAcidVO faVO : intensityChainVO.getParticipatingChains()) {
                                chains.add(faVO.getChainId());
                            }
                            Vector<String> vector2 = StaticUtils.getAllAffectedChainCombinations(validChainCombinations, chains);
                        } else {
                            vector.add(intensityChainVO.getParticipatingChains().get(0).getChainId());
                        }
                        for (String id : var79_160) {
                            void var78_149;
                            if (chainIntensityRules.containsKey(id)) {
                                Hashtable<String, IntensityChainVO> hashtable3 = chainIntensityRules.get(id);
                            }
                            var78_149.put(ruleVO.getReadableRuleInterpretation(faHydroxyEncoding_, lcbHydroxyEncoding_), intensityChainVO);
                            chainIntensityRules.put(id, (Hashtable<String, IntensityChainVO>)var78_149);
                        }
                    } else if (ruleVO != null && positionRules) {
                        void var79_163;
                        void var78_153;
                        IntensityPositionVO intensityPositionVO = (IntensityPositionVO)ruleVO;
                        Hashtable hashtable = new Hashtable();
                        Hashtable hashtable4 = new Hashtable();
                        if (positionDefinition.containsKey(combiKey)) {
                            Hashtable<Integer, Integer> hashtable5 = positionDefinition.get(combiKey);
                        }
                        if (positionEvidence.containsKey(combiKey)) {
                            Hashtable<Integer, Vector<IntensityPositionVO>> hashtable6 = positionEvidence.get(combiKey);
                        }
                        Vector<String> fas = StaticUtils.splitChainCombiToEncodedStrings(combiKey, "<->");
                        Hashtable<String, String> usedFAs = new Hashtable<String, String>();
                        for (int i = 0; i != fas.size(); ++i) {
                            void var85_190;
                            int j;
                            String fa = fas.get(i);
                            int position = intensityPositionVO.getPositionByFA(fa);
                            if (position < 0 || usedFAs.containsKey(fa)) continue;
                            if (var78_153.containsKey(i)) {
                                if ((Integer)var78_153.get(i) != position - 1) {
                                    boolean bl;
                                    boolean bl2 = false;
                                    for (j = 0; j != fas.size(); ++j) {
                                        if (i == j || !fa.equalsIgnoreCase(fas.get(j)) || var78_153.containsKey(j) && (Integer)var78_153.get(i) != position - 1 && (Integer)var78_153.get(j) != position - 1) continue;
                                        bl = true;
                                    }
                                    if (!bl) {
                                        var78_153.remove(i);
                                    }
                                }
                            } else {
                                boolean bl;
                                boolean bl3 = false;
                                for (j = 0; j != i; ++j) {
                                    if (!fa.equalsIgnoreCase(fas.get(j)) || (Integer)var78_153.get(j) != position - 1) continue;
                                    bl = true;
                                }
                                if (!bl) {
                                    var78_153.put(i, position - 1);
                                    usedFAs.put(fa, fa);
                                }
                            }
                            Vector vector = new Vector();
                            if (var79_163.containsKey(position)) {
                                Vector vector3 = (Vector)var79_163.get(position);
                            }
                            boolean ruleIsThere = false;
                            for (IntensityPositionVO other : var85_190) {
                                if (!other.getReadableRuleInterpretation(faHydroxyEncoding_, lcbHydroxyEncoding_).equalsIgnoreCase(intensityPositionVO.getReadableRuleInterpretation(faHydroxyEncoding_, lcbHydroxyEncoding_))) continue;
                                ruleIsThere = true;
                                break;
                            }
                            if (!ruleIsThere) {
                                var85_190.add(intensityPositionVO);
                            }
                            var79_163.put(position, var85_190);
                        }
                        positionDefinition.put(combiKey, (Hashtable<Integer, Integer>)var78_153);
                        positionEvidence.put(combiKey, (Hashtable<Integer, Vector<IntensityPositionVO>>)var79_163);
                    }
                }
            }
            if (readFragmentHeaderRow) {
                nameColumn = -1;
                ohColumn = -1;
                chainTypeColumn = -1;
                formulaColumn = -1;
                msLevelColumn = -1;
                chargeColumn = -1;
                mzColumn = -1;
                mzTolColumn = -1;
                areaColumn = -1;
                peakColumn = -1;
                startTimeColumn = -1;
                stopTimeColumn = -1;
                startMzColumn = -1;
                stopMzColumn = -1;
                ellTimeColumn = -1;
                ellMzColumn = -1;
                ellTimeRangeColumn = -1;
                ellMzRangeColumn = -1;
            }
            if (!readIntensityHeaderRow) continue;
            ruleColumn = -1;
            originalRuleColumn = -1;
            ruleValuesColumn = -1;
        }
        if (addingMSnEvidence != null && addingMSnEvidence instanceof LipidParameterSet) {
            String speciesName = addingMSnEvidence.getNamePlusModHumanReadable();
            if (LDAResultReader.isDefinitionPresent(positionDefinition = LDAResultReader.cleanPositionDefinition(positionDefinition))) {
                status = 4;
            }
            addingMSnEvidence = new LipidomicsMSnSet(addingMSnEvidence, status, headGroupFragments, headIntensityRules, chainFragments, chainIntensityRules, validChainCombinations, relativeAreas, positionDefinition, positionEvidence, numberOfPositions, basePeakValues, msnRetentionTimes, faHydroxyEncoding_, lcbHydroxyEncoding_);
            msHash.put(speciesName, addingMSnEvidence);
        }
        if (usedAlexMsnTargets) {
            lipidomicsConstants_.getAlexTargetlistUsed().put(lipidClass, true);
        }
        Vector msnResults = new Vector();
        for (LipidParameterSet ms1 : resultParameterSets_.get(lipidClass)) {
            msnResults.add(msHash.get(ms1.getNamePlusModHumanReadable()));
        }
        resultParameterSets_.put(lipidClass, msnResults);
    }

    private static void readOmegaSheet(Sheet sheet, String lipidClass) throws IOException {
        Hashtable<String, LipidParameterSet> msHash = new Hashtable<String, LipidParameterSet>();
        for (LipidParameterSet param : resultParameterSets_.get(lipidClass)) {
            msHash.put(param.getNamePlusModHumanReadable(), param);
        }
        List<Row> rows = sheet.read();
        Row headerRow = rows.get(0);
        List<String> headerTitles = LDAResultReader.readSheetHeaderTitles(headerRow);
        List<Row> contentRows = rows.subList(1, rows.size());
        String identifier = null;
        String molecularSpecies = null;
        String doubleBondPosition = null;
        float expectedRetentionTime = 0.0f;
        int accuracy = 0;
        boolean isAssigned = false;
        for (Row row : contentRows) {
            List cells = row.stream().filter(c -> c != null && !c.getType().equals((Object)CellType.ERROR)).collect(Collectors.toList());
            for (Cell cell : cells) {
                int index = cell.getColumnIndex();
                String rawValue = cell.getRawValue();
                if (index == headerTitles.indexOf("Identifier")) {
                    identifier = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("Molecular Species")) {
                    molecularSpecies = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("Double Bond Position Level")) {
                    doubleBondPosition = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("Expected RT / min")) {
                    expectedRetentionTime = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Accuracy")) {
                    accuracy = Integer.parseInt(rawValue);
                    continue;
                }
                if (index != headerTitles.indexOf("Assigned")) continue;
                isAssigned = rawValue.equalsIgnoreCase("1");
            }
            try {
                Vector<FattyAcidVO> chainCombination = StaticUtils.decodeFAsFromHumanReadableName(doubleBondPosition, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, lipidomicsConstants_);
                DoubleBondPositionVO doubleBondPositionVO = new DoubleBondPositionVO(chainCombination, expectedRetentionTime, accuracy, molecularSpecies, isAssigned);
                ((LipidParameterSet)msHash.get(identifier)).addOmegaInformation(doubleBondPositionVO);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readMS1Sheet(Sheet sheet, Hashtable<String, Boolean> showModifications, String lipidClass) throws IOException {
        int msLevel = 1;
        Vector<CgParameterSet> resultParams = new Vector<CgParameterSet>();
        CgParameterSet params = null;
        boolean showModification = false;
        Hashtable<String, String> analyteNames = new Hashtable<String, String>();
        List<Row> rows = sheet.read();
        Row headerRow = rows.get(0);
        List<String> headerTitles = LDAResultReader.readSheetHeaderTitles(headerRow);
        for (String string : headerTitles) {
            if (!string.startsWith("level=")) continue;
            String levelString = string.substring("level=".length()).trim();
            msLevel = Integer.valueOf(levelString);
        }
        List<Row> contentRows = rows.subList(1, rows.size());
        for (Row row : contentRows) {
            List list = row.stream().filter(c -> c != null && !c.getType().equals((Object)CellType.ERROR) && !c.getType().equals((Object)CellType.EMPTY)).collect(Collectors.toList());
            String name = null;
            int dbs = -1;
            int oh = -1;
            int paramCharge = 1;
            int charge = -1;
            String modification = null;
            String formula = null;
            String modFormula = null;
            Double preciseRT = null;
            float area = 0.0f;
            float areaError = 0.0f;
            float background = 0.0f;
            float mz = 0.0f;
            float mzTolerance = 0.0f;
            float peak = 0.0f;
            float lowerValley = 0.0f;
            float upperValley = 0.0f;
            float apexIntensity = 0.0f;
            float lowerValley10Pc = 0.0f;
            float upperValley10Pc = 0.0f;
            float lowerValley50Pc = 0.0f;
            float upperValley50Pc = 0.0f;
            float lowerMz10Pc = -1.0f;
            float upperMz10Pc = -1.0f;
            float lowerMz50Pc = -1.0f;
            float upperMz50Pc = -1.0f;
            int isotope = -1;
            float lowMz = -1.0f;
            float upMz = -1.0f;
            float ellipseTimePosition = -1.0f;
            float ellipseMzPosition = -1.0f;
            float ellipseTimeStretch = -1.0f;
            float ellipseMzStretch = -1.0f;
            float lowerRtHardLimit = -1.0f;
            float upperRtHardLimit = -1.0f;
            float percentalSplit = -1.0f;
            String oxState = "";
            for (Cell cell : list) {
                int index = cell.getColumnIndex();
                String rawValue = cell.getRawValue();
                if (index == headerTitles.indexOf("Name")) {
                    name = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("Dbs")) {
                    dbs = (int)Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("OH")) {
                    oh = (int)Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Modification")) {
                    modification = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("Formula")) {
                    formula = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("Mod-Formula")) {
                    modFormula = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("RT")) {
                    preciseRT = Double.parseDouble(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Isotope")) {
                    isotope = (int)Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Area")) {
                    area = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("AreaError")) {
                    areaError = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Background")) {
                    background = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Charge")) {
                    charge = paramCharge = (int)Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Mz")) {
                    mz = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("MzTolerance")) {
                    mzTolerance = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Peak")) {
                    peak = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("LowerValley")) {
                    lowerValley = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("UpperValley")) {
                    upperValley = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("LowMz")) {
                    lowMz = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("UpMz")) {
                    upMz = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("EllCentTime")) {
                    ellipseTimePosition = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("EllCentMz")) {
                    ellipseMzPosition = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("EllStretchTime")) {
                    ellipseTimeStretch = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("EllStretchMz")) {
                    ellipseMzStretch = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("LowerRtHardLimit")) {
                    lowerRtHardLimit = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("UpperRtHardLimit")) {
                    upperRtHardLimit = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("PercentalSplit")) {
                    percentalSplit = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("Raw Apex")) {
                    apexIntensity = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("LValley10%")) {
                    lowerValley10Pc = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("LValley50%")) {
                    lowerValley50Pc = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("UValley10%")) {
                    upperValley10Pc = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("UValley50%")) {
                    upperValley50Pc = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("LMz10%")) {
                    lowerMz10Pc = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("LMz50%")) {
                    lowerMz50Pc = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("UMz10%")) {
                    upperMz10Pc = Float.parseFloat(rawValue);
                    continue;
                }
                if (index == headerTitles.indexOf("UMz50%")) {
                    upperMz50Pc = Float.parseFloat(rawValue);
                    continue;
                }
                if (index != headerTitles.indexOf("PSM")) continue;
                oxState = rawValue;
            }
            if (name != null && name.length() > 0) {
                if (params != null) {
                    if (params.ProbeCount() > 0) {
                        ((LipidParameterSet)params).setCharge(params.Probe((int)0).Charge);
                    }
                    resultParams.add(params);
                    if (analyteNames.containsKey(((LipidParameterSet)params).getNameString())) {
                        showModification = true;
                    }
                    analyteNames.put(((LipidParameterSet)params).getNameString(), ((LipidParameterSet)params).getNameString());
                }
                if (headerTitles.indexOf("Modification") == -1 || headerTitles.indexOf("Formula") == -1 || headerTitles.indexOf("Mod-Formula") == -1) {
                    Object[] components = ComparativeNameExtractor.splitOldNameStringToComponents(name);
                    name = (String)components[0];
                    dbs = (Integer)components[1];
                    formula = (String)components[2];
                    modification = "";
                    modFormula = "";
                }
                params = new LipidParameterSet(mz, name, dbs, modification, preciseRT, formula, modFormula, paramCharge, oh);
                if (lowerRtHardLimit >= 0.0f) {
                    ((LipidParameterSet)params).setLowerRtHardLimit(lowerRtHardLimit);
                }
                if (upperRtHardLimit >= 0.0f) {
                    ((LipidParameterSet)params).setUpperRtHardLimit(upperRtHardLimit);
                }
                if (percentalSplit >= 0.0f) {
                    ((LipidParameterSet)params).setPercentalSplit(percentalSplit);
                }
                ((LipidParameterSet)params).Area = area;
                ((LipidParameterSet)params).LowerMzBand = mzTolerance;
                ((LipidParameterSet)params).UpperMzBand = mzTolerance;
                ((LipidParameterSet)params).setOxState(oxState);
                continue;
            }
            if (params == null || charge == -1) continue;
            CgProbe probe = new CgProbe(0, charge);
            if (area > 0.0f || ((LipidParameterSet)params).getLowerRtHardLimit() >= 0.0f || ((LipidParameterSet)params).getUpperRtHardLimit() >= 0.0f) {
                probe.AreaStatus = CgAreaStatus.OK;
                probe.Area = area;
                probe.AreaError = areaError;
                probe.Background = background;
                probe.Peak = peak;
                probe.LowerValley = lowerValley;
                probe.UpperValley = upperValley;
                if (upperValley10Pc > 0.0f) {
                    probe.setApexIntensity(Float.valueOf(apexIntensity));
                    probe.setLowerValley10(Float.valueOf(lowerValley10Pc));
                    probe.setLowerValley50(Float.valueOf(lowerValley50Pc));
                    probe.setUpperValley10(Float.valueOf(upperValley10Pc));
                    probe.setUpperValley50(Float.valueOf(upperValley50Pc));
                }
            } else {
                probe.AreaStatus = CgAreaStatus.TooSmall;
            }
            probe.Mz = mz;
            probe.LowerMzBand = ((LipidParameterSet)params).LowerMzBand;
            probe.UpperMzBand = ((LipidParameterSet)params).UpperMzBand;
            probe.isotopeNumber = isotope;
            if (ellipseTimePosition > 0.0f && ellipseMzPosition > 0.0f && ellipseTimeStretch > 0.0f && ellipseMzStretch > 0.0f && lowMz > 0.0f && upMz > 0.0f) {
                Probe3D probe3D = new Probe3D(probe, ellipseTimePosition, ellipseMzPosition, ellipseTimeStretch, ellipseMzStretch, -1.0f, -1.0f, lowerMz10Pc, upperMz10Pc, lowerMz50Pc, upperMz50Pc);
                probe3D.LowerMzBand = lowMz;
                probe3D.UpperMzBand = upMz;
                if (((LipidParameterSet)params).getLowerRtHardLimit() >= 0.0f) {
                    probe3D.setLowerHardRtLimit(((LipidParameterSet)params).getLowerRtHardLimit());
                }
                if (((LipidParameterSet)params).getUpperRtHardLimit() >= 0.0f) {
                    probe3D.setUpperHardRtLimit(((LipidParameterSet)params).getUpperRtHardLimit());
                }
                try {
                    params.AddProbe(probe3D);
                }
                catch (CgException cgException) {}
                continue;
            }
            try {
                params.AddProbe(probe);
            }
            catch (CgException cgException) {}
        }
        if (params != null) {
            if (params.ProbeCount() > 0) {
                ((LipidParameterSet)params).setCharge(params.Probe((int)0).Charge);
            }
            resultParams.add(params);
            if (analyteNames.containsKey(((LipidParameterSet)params).getNameString())) {
                showModification = true;
            }
            analyteNames.put(((LipidParameterSet)params).getNameString(), ((LipidParameterSet)params).getNameString());
        }
        if (!showModification) {
            Object var12_14 = null;
            for (LipidParameterSet lipidParameterSet : resultParams) {
                void var12_15;
                if (var12_15 == null) {
                    String string = lipidParameterSet.getModificationName();
                }
                if (var12_15.equalsIgnoreCase(lipidParameterSet.getModificationName())) continue;
                showModification = true;
                break;
            }
        }
        resultParameterSets_.put(lipidClass, resultParams);
        showModifications.put(lipidClass, showModification);
        msLevels_.put(lipidClass, msLevel);
    }

    public static List<String> readSheetHeaderTitles(Row headerRow) {
        try (Stream<Cell> cells = headerRow.stream();){
            List<String> list = cells.map(c -> c != null && !c.getType().equals((Object)CellType.ERROR) ? c.getText() : "null").collect(Collectors.toList());
            return list;
        }
    }

    private static int compareBySheetName(Sheet s1, Sheet s2) {
        String name1 = s1.getName();
        String name2 = s2.getName();
        if (LDAResultReader.endsWithSheetAdduct(name1) && LDAResultReader.endsWithSheetAdduct(name2) || !LDAResultReader.endsWithSheetAdduct(name1) && !LDAResultReader.endsWithSheetAdduct(name2)) {
            return 0;
        }
        if (!LDAResultReader.endsWithSheetAdduct(name1)) {
            return -1;
        }
        return 1;
    }

    private static boolean endsWithSheetAdduct(String name) {
        return name.endsWith(" - Omega") || name.endsWith(" - Overview") || name.endsWith(" - MSn");
    }

    private static boolean parseSheet(Sheet sheet, String specificClass) {
        boolean parseSheet = false;
        String name = sheet.getName();
        if (specificClass != null) {
            if (name.equals("About") || name.equals(specificClass) || name.equals(specificClass + " - MSn") || name.equals(specificClass + " - Omega")) {
                parseSheet = true;
            }
        } else if (!name.endsWith(" - Overview") && !name.endsWith("Lipid (sub)classes")) {
            parseSheet = true;
        }
        return parseSheet;
    }

    private static Hashtable<String, Hashtable<Integer, Integer>> cleanPositionDefinition(Hashtable<String, Hashtable<Integer, Integer>> posDefs) {
        Hashtable<String, Hashtable<Integer, Integer>> cleaned = new Hashtable<String, Hashtable<Integer, Integer>>();
        for (String combi : posDefs.keySet()) {
            Hashtable<Integer, Integer> posss = posDefs.get(combi);
            Hashtable<Integer, Integer> possCleaned = new Hashtable<Integer, Integer>();
            Hashtable<Integer, Integer> usedPositions = new Hashtable<Integer, Integer>();
            for (Integer stringPos : posss.keySet()) {
                if (posss.get(stringPos) <= -1) continue;
                if (usedPositions.containsKey(posss.get(stringPos))) {
                    if (!possCleaned.containsKey(usedPositions.get(posss.get(stringPos)))) continue;
                    possCleaned.remove(usedPositions.get(posss.get(stringPos)));
                    continue;
                }
                possCleaned.put(stringPos, posss.get(stringPos));
                usedPositions.put(posss.get(stringPos), stringPos);
            }
            cleaned.put(combi, possCleaned);
        }
        return cleaned;
    }

    private static Vector<String> correctUndefinedChainCombinations(String combiKey, Vector<String> validChainCombinations, Hashtable<String, Double> relAreas, String sep) throws LipidCombinameEncodingException {
        Vector<String> corrected = new Vector<String>();
        for (String combi : validChainCombinations) {
            if (StaticUtils.isAPermutedVersion(combiKey, combi, sep)) {
                corrected.add(combiKey);
                if (combiKey.equalsIgnoreCase(combi)) continue;
                relAreas.put(combiKey, relAreas.get(combi));
                relAreas.remove(combi);
                continue;
            }
            corrected.add(combi);
        }
        return corrected;
    }

    private static boolean isDefinitionPresent(Hashtable<String, Hashtable<Integer, Integer>> posDefs) {
        for (Hashtable<Integer, Integer> posss : posDefs.values()) {
            if (posss.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static String getPermutationThatIsInValidChainCombinations(String combiKey, Vector<String> validChainCombinations) throws LipidCombinameEncodingException {
        Vector<String> chains = StaticUtils.splitChainCombiToEncodedStrings(combiKey, "<->");
        Vector<String> permuts = StaticUtils.getPermutedChainNames(chains, "<->");
        for (String permut : permuts) {
            if (!validChainCombinations.contains(permut)) continue;
            return permut;
        }
        return null;
    }
}

