/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.ExpressionForComparisonVO;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.FragmentMultVO;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.msn.vos.RuleHydroxyRequirementSet;
import at.tugraz.genome.lda.msn.vos.RuleHydroxyRequirementsVO;
import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.lda.vos.ShortStringVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;

public class IntensityRuleVO {
    public static final String BASEPEAK_NAME = "$BASEPEAK";
    public static final short DIFF_CHAIN_TYPES = -1;
    private int type_;
    protected String equation_;
    protected boolean mandatory_;
    protected boolean orRule_;
    protected ExpressionForComparisonVO biggerExpression_;
    protected ExpressionForComparisonVO smallerExpression_;
    protected short chainType_;
    protected RuleHydroxyRequirementSet allowedOHs_;
    protected Set<Short> availableFragmentTypes_;

    public IntensityRuleVO(int type, String originalEquation, ExpressionForComparisonVO biggerExpression, ExpressionForComparisonVO smallerExpression, boolean orRule) {
        this.type_ = type;
        this.equation_ = originalEquation;
        this.mandatory_ = false;
        this.biggerExpression_ = biggerExpression;
        this.smallerExpression_ = smallerExpression;
        this.chainType_ = 0;
        this.availableFragmentTypes_ = new HashSet<Short>();
        if (this.biggerExpression_ != null) {
            for (FragmentMultVO frag : this.biggerExpression_.getFragments()) {
                this.availableFragmentTypes_.add(frag.getFragmentType());
            }
        }
        if (this.smallerExpression_ != null) {
            for (FragmentMultVO frag : this.smallerExpression_.getFragments()) {
                this.availableFragmentTypes_.add(frag.getFragmentType());
            }
        }
        this.orRule_ = orRule;
        this.checkForDiffChainTypes();
    }

    public IntensityRuleVO(IntensityRuleVO rule) {
        this(rule.type_, rule.equation_, rule.biggerExpression_, rule.smallerExpression_, rule.orRule_);
        this.mandatory_ = rule.mandatory_;
        this.chainType_ = rule.chainType_;
    }

    public String getRuleIdentifier() {
        return this.equation_;
    }

    public boolean isMandatory() {
        return this.mandatory_;
    }

    public boolean isMandatory(short ohNumber) {
        if (ohNumber == -1 || this.allowedOHs_ == null) {
            return this.mandatory_;
        }
        return this.allowedOHs_.getEntry(ohNumber).get(0).getMandatory() == 1;
    }

    public boolean isMandatory(Vector<FattyAcidVO> combi) {
        if (this.allowedOHs_ == null) {
            return this.mandatory_;
        }
        boolean mandatory = this.mandatory_;
        boolean overwritten = false;
        for (FattyAcidVO chain : combi) {
            if (!this.allowedOHs_.hasEntry((short)chain.getOhNumber())) continue;
            for (RuleHydroxyRequirementsVO req : this.allowedOHs_.getEntry((short)chain.getOhNumber())) {
                if (req.chainType_ != chain.getChainType() && req.getChainType() != -1) continue;
                if (overwritten) {
                    mandatory = mandatory || req.getMandatory() == 1;
                    continue;
                }
                overwritten = true;
                mandatory = req.getMandatory() == 1;
            }
        }
        return mandatory;
    }

    public ExpressionForComparisonVO getBiggerExpression() {
        return this.biggerExpression_;
    }

    public ExpressionForComparisonVO getSmallerExpression() {
        return this.smallerExpression_;
    }

    public int getBiggerPosition() {
        return this.biggerExpression_.getPosition();
    }

    public int getSmallerPosition() {
        return this.smallerExpression_.getPosition();
    }

    public String toString() {
        return this.getRuleIdentifier();
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory_ = mandatory;
    }

    public String getReadableRuleInterpretation(HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        return new String(this.equation_);
    }

    public String getRuleValueInterpretation(Hashtable<String, Float> values, Float basePeak) throws RulesException {
        String returnString = new String(this.equation_);
        if (basePeak != null && this.containsBasePeak()) {
            values.put(BASEPEAK_NAME, basePeak);
        }
        Hashtable<String, Short> head = new Hashtable<String, Short>();
        for (String frag : values.keySet()) {
            head.put(frag, (short)-1);
        }
        Vector<ShortStringVO> lengthSortedNames = FragmentRuleVO.getLengthSortedFragmentNames(head, new Hashtable<String, Short>());
        for (ShortStringVO name : lengthSortedNames) {
            Float value = Float.valueOf(0.0f);
            if (values.containsKey(name.getKey())) {
                value = values.get(name.getKey());
            }
            while (returnString.indexOf(name.getKey()) != -1) {
                returnString = returnString.substring(0, returnString.indexOf(name.getKey())) + String.valueOf(String.valueOf(value)) + returnString.substring(returnString.indexOf(name.getKey()) + name.getKey().length());
            }
        }
        return returnString;
    }

    public float extractBasePeakValue(String ruleValueInterpretation, Hashtable<String, Float> values) throws RulesException {
        float basePeak = 0.0f;
        String containingBPString = this.getRuleValueInterpretation(values, null);
        String beforeBasePeak = containingBPString.substring(0, containingBPString.indexOf(BASEPEAK_NAME));
        String afterBasePeak = containingBPString.substring(containingBPString.indexOf(BASEPEAK_NAME) + BASEPEAK_NAME.length());
        String baseString = null;
        if (afterBasePeak.indexOf(BASEPEAK_NAME) != -1) {
            String comp = "";
            if (afterBasePeak.indexOf(">") != -1) {
                comp = ">";
            } else if (afterBasePeak.indexOf("<") != -1) {
                comp = "<";
            }
            afterBasePeak = afterBasePeak.substring(0, afterBasePeak.indexOf(comp));
            String subValueInterpr = ruleValueInterpretation.substring(0, ruleValueInterpretation.indexOf(comp));
            baseString = subValueInterpr.substring(beforeBasePeak.length(), subValueInterpr.length() - afterBasePeak.length());
        } else {
            baseString = ruleValueInterpretation.substring(beforeBasePeak.length(), ruleValueInterpretation.length() - afterBasePeak.length());
        }
        basePeak = Float.parseFloat(baseString);
        return basePeak;
    }

    public CgProbe getAnyNonBasepeakFragment(Hashtable<String, CgProbe> headFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments) {
        String nonBpName;
        CgProbe probe = null;
        Hashtable<String, Short> nonBpNames = this.getBiggerNonBasePeakNames();
        Iterator<String> iterator = nonBpNames.keySet().iterator();
        while (iterator.hasNext() && (probe = this.checkForFragmentAvailability(nonBpName = iterator.next(), headFragments, chainFragments)) == null) {
        }
        if (probe != null) {
            return probe;
        }
        nonBpNames = this.getSmallerNonBasePeakNames();
        iterator = nonBpNames.keySet().iterator();
        while (iterator.hasNext() && (probe = this.checkForFragmentAvailability(nonBpName = iterator.next(), headFragments, chainFragments)) == null) {
        }
        return probe;
    }

    public CgProbe checkForFragmentAvailability(String frag, Hashtable<String, CgProbe> headFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments) {
        if (headFragments.containsKey(frag)) {
            return headFragments.get(frag);
        }
        return null;
    }

    public boolean equals(IntensityRuleVO other) {
        return this.equation_.equalsIgnoreCase(other.equation_);
    }

    public short getChainType() {
        return this.chainType_;
    }

    public boolean containsBasePeak() {
        boolean containsBasepeak = false;
        for (FragmentMultVO multVO : this.biggerExpression_.getFragments()) {
            if (!multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME)) continue;
            containsBasepeak = true;
            break;
        }
        if (containsBasepeak) {
            return containsBasepeak;
        }
        for (FragmentMultVO multVO : this.smallerExpression_.getFragments()) {
            if (!multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME)) continue;
            containsBasepeak = true;
            break;
        }
        return containsBasepeak;
    }

    public Hashtable<String, Short> getBiggerNonBasePeakNames() {
        Hashtable<String, Short> allNonBasepeakNames = new Hashtable<String, Short>();
        for (FragmentMultVO multVO : this.biggerExpression_.getFragments()) {
            if (multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME)) continue;
            String nonBpName = multVO.getFragmentName();
            allNonBasepeakNames.put(nonBpName, multVO.getFragmentType());
        }
        return allNonBasepeakNames;
    }

    public Hashtable<String, Short> getSmallerNonBasePeakNames() {
        Hashtable<String, Short> allNonBasepeakNames = new Hashtable<String, Short>();
        for (FragmentMultVO multVO : this.smallerExpression_.getFragments()) {
            if (multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME)) continue;
            String nonBpName = multVO.getFragmentName();
            allNonBasepeakNames.put(nonBpName, multVO.getFragmentType());
        }
        return allNonBasepeakNames;
    }

    protected Hashtable<String, Short> getBiggerNonHeadAndBasePeakNames() {
        return this.getNonHeadAndBasePeakNames(this.biggerExpression_.getFragments());
    }

    protected Hashtable<String, Short> getSmallerNonHeadAndBasePeakNames() {
        return this.getNonHeadAndBasePeakNames(this.smallerExpression_.getFragments());
    }

    private Hashtable<String, Short> getNonHeadAndBasePeakNames(Vector<FragmentMultVO> parts) {
        Hashtable<String, Short> filteredNames = new Hashtable<String, Short>();
        for (FragmentMultVO multVO : parts) {
            if (multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME) || multVO.getFragmentType() == -1) continue;
            String name = multVO.getFragmentName();
            filteredNames.put(name, multVO.getFragmentType());
        }
        return filteredNames;
    }

    public String getAnyNonBasePeakName() {
        String nonBpName = "";
        for (FragmentMultVO multVO : this.biggerExpression_.getFragments()) {
            if (multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME)) continue;
            nonBpName = multVO.getFragmentName();
            break;
        }
        if (nonBpName.length() > 0) {
            return nonBpName;
        }
        for (FragmentMultVO multVO : this.smallerExpression_.getFragments()) {
            if (multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME)) continue;
            nonBpName = multVO.getFragmentName();
            break;
        }
        return nonBpName;
    }

    public boolean enoughFragmentsForRuleEvaluationFound(Hashtable<String, CgProbe> found) {
        boolean biggerFragsFound = this.areFragmentsFound(this.biggerExpression_, found);
        boolean smallerFragsFound = this.areFragmentsFound(this.smallerExpression_, found);
        return biggerFragsFound && smallerFragsFound;
    }

    public boolean enoughFragmentsForRuleEvaluationFound(Hashtable<String, CgProbe> headGroupFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Vector<FattyAcidVO> chainsToCheck) {
        Hashtable<String, CgProbe> foundFragments = this.getFragmentsForExpression(this.biggerExpression_, headGroupFragments, chainFragments, chainsToCheck);
        boolean biggerFragsFound = this.areFragmentsFound(this.biggerExpression_, foundFragments);
        foundFragments = this.getFragmentsForExpression(this.smallerExpression_, headGroupFragments, chainFragments, chainsToCheck);
        boolean smallerFragsFound = this.areFragmentsFound(this.smallerExpression_, foundFragments);
        return biggerFragsFound && smallerFragsFound;
    }

    private Hashtable<String, CgProbe> getFragmentsForExpression(ExpressionForComparisonVO expression, Hashtable<String, CgProbe> headGroupFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Vector<FattyAcidVO> chainsToCheck) {
        Hashtable<String, CgProbe> foundFragments = new Hashtable<String, CgProbe>(headGroupFragments);
        for (FragmentMultVO fragVO : expression.getFragments()) {
            for (FattyAcidVO chain : chainsToCheck) {
                if (chain.getChainType() != fragVO.getFragmentType() || !chainFragments.containsKey(chain.getChainId())) continue;
                foundFragments.putAll((Map<String, CgProbe>)chainFragments.get(chain.getChainId()));
            }
        }
        return foundFragments;
    }

    private boolean areFragmentsFound(ExpressionForComparisonVO expression, Hashtable<String, CgProbe> found) {
        boolean foundFrags = false;
        for (FragmentMultVO multVO : expression.getFragments()) {
            String name = multVO.getFragmentName();
            if (!name.equalsIgnoreCase(BASEPEAK_NAME) && (found == null || !found.containsKey(name) || !multVO.isPositive())) continue;
            foundFrags = true;
            break;
        }
        return foundFrags;
    }

    public boolean isRuleFulfilled(Hashtable<String, CgProbe> found, Float basePeak) {
        double smallerArea;
        if (this.orRule_) {
            boolean oneFound = false;
            for (FragmentMultVO mult : this.biggerExpression_.getFragments()) {
                if (!found.containsKey(mult.getFragmentName())) continue;
                oneFound = true;
            }
            return oneFound;
        }
        double biggerArea = this.biggerExpression_.evaluateExpression(found, basePeak);
        return biggerArea > (smallerArea = this.smallerExpression_.evaluateExpression(found, basePeak));
    }

    public boolean isRuleFulfilled(Hashtable<String, CgProbe> headGroupFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Vector<FattyAcidVO> chainsToCheck, Float basePeak) {
        double smallerArea;
        Hashtable<String, CgProbe> foundFragments = this.getFragmentsForExpression(this.biggerExpression_, headGroupFragments, chainFragments, chainsToCheck);
        double biggerArea = this.getBiggerArea(foundFragments, basePeak);
        return biggerArea > (smallerArea = this.getSmallerArea(foundFragments = this.getFragmentsForExpression(this.smallerExpression_, headGroupFragments, chainFragments, chainsToCheck), basePeak));
    }

    public void checkForDiffChainTypes() {
        boolean foundOneType = false;
        this.chainType_ = 0;
        for (FragmentMultVO multVO : this.biggerExpression_.getFragments()) {
            if (multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME)) continue;
            if (!foundOneType) {
                this.chainType_ = multVO.getFragmentType();
                foundOneType = true;
                continue;
            }
            if (this.chainType_ == multVO.getFragmentType()) continue;
            this.chainType_ = (short)-1;
            break;
        }
        if (this.chainType_ == -1) {
            return;
        }
        for (FragmentMultVO multVO : this.smallerExpression_.getFragments()) {
            if (multVO.getFragmentName().equalsIgnoreCase(BASEPEAK_NAME)) continue;
            if (!foundOneType) {
                this.chainType_ = multVO.getFragmentType();
                foundOneType = true;
                continue;
            }
            if (this.chainType_ == multVO.getFragmentType()) continue;
            this.chainType_ = (short)-1;
            break;
        }
    }

    public double getBiggerArea(Hashtable<String, CgProbe> found, Float basePeak) {
        return this.biggerExpression_.evaluateExpression(found, basePeak);
    }

    public double getSmallerArea(Hashtable<String, CgProbe> found, Float basePeak) {
        return this.smallerExpression_.evaluateExpression(found, basePeak);
    }

    public int getMSLevel(Hashtable<String, CgProbe> headGroupFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments) {
        int msLevel = -1;
        CgProbe probe = this.getAnyNonBasepeakFragment(headGroupFragments, chainFragments);
        if (probe != null) {
            msLevel = probe.getMsLevel();
        }
        return msLevel;
    }

    public void setChainType(short chainType) {
        this.chainType_ = chainType;
    }

    public boolean containsFragment(String fragmentName) {
        return this.biggerExpression_.containsFragment(fragmentName) || this.smallerExpression_.containsFragment(fragmentName);
    }

    protected static String[] splitToBiggerAndSmallerPart(String rule) {
        String biggerPart = null;
        String smallerPart = null;
        if (rule.indexOf(">") != -1) {
            biggerPart = rule.substring(0, rule.indexOf(">"));
            smallerPart = rule.substring(rule.indexOf(">") + 1);
        } else if (rule.indexOf("<") != -1) {
            smallerPart = rule.substring(0, rule.indexOf("<"));
            biggerPart = rule.substring(rule.indexOf("<") + 1);
        }
        String[] biggerSmaller = new String[]{biggerPart, smallerPart};
        return biggerSmaller;
    }

    /*
     * WARNING - void declaration
     */
    protected String replaceParts(String rulePart, Hashtable<String, String> originalToReplacement) {
        void var7_10;
        Vector<RangeInteger> ranges = new Vector<RangeInteger>();
        Hashtable<Integer, String> replacementIndices = new Hashtable<Integer, String>();
        Hashtable<String, Short> fragmentNames = new Hashtable<String, Short>();
        for (String string : originalToReplacement.keySet()) {
            fragmentNames.put(string, (short)-1);
        }
        Vector<ShortStringVO> lengthSortedNames = FragmentRuleVO.getLengthSortedFragmentNames(fragmentNames, new Hashtable<String, Short>());
        for (ShortStringVO name : lengthSortedNames) {
            int startIndex = IntensityRuleVO.getStartIndex(name.getKey(), rulePart, ranges);
            ranges.add(new RangeInteger(startIndex, startIndex + name.getKey().length()));
            replacementIndices.put(startIndex, name.getKey());
        }
        String string = new String(rulePart);
        ArrayList idxSorted = new ArrayList(replacementIndices.keySet());
        Collections.sort(idxSorted);
        for (int i = idxSorted.size() - 1; i != -1; --i) {
            int idx = (Integer)idxSorted.get(i);
            String toReplace = (String)replacementIndices.get(idx);
            String replacement = originalToReplacement.get(toReplace);
            String string2 = var7_10.substring(0, idx) + replacement + var7_10.substring(idx + toReplace.length());
        }
        return var7_10;
    }

    public static int getStartIndex(String name, String equation, Vector<RangeInteger> ranges) {
        int idx;
        String subString = new String(equation);
        int removed = 0;
        int start = -1;
        while ((idx = subString.indexOf(name)) > -1) {
            start = idx + removed;
            int stop = start + name.length();
            boolean found = false;
            for (RangeInteger range : ranges) {
                if (range.insideRange(start) && range.getStop() != start) {
                    found = true;
                }
                if (range.insideRange(stop) && range.getStart() != stop) {
                    found = true;
                }
                if (!found) continue;
                break;
            }
            if (!found) break;
            removed = stop;
            subString = subString.substring(idx + name.length());
        }
        return start;
    }

    public boolean isAbsoluteComparison() {
        return this.biggerExpression_.isAbsoluteComparison() || this.smallerExpression_.isAbsoluteComparison();
    }

    public void setAllowedOHs(RuleHydroxyRequirementSet allowedOHs, int lineNumber, boolean headSection) throws RulesException {
        this.allowedOHs_ = allowedOHs;
        if (this.allowedOHs_ != null) {
            Vector<FragmentMultVO> allFrags = new Vector<FragmentMultVO>(this.biggerExpression_.getFragments());
            allFrags.addAll(this.smallerExpression_.getFragments());
            this.allowedOHs_.checkAndCorrectChainTypes(this.chainType_, allFrags, lineNumber, headSection);
        }
    }

    public boolean hydroxylationValid(short ohNumber) {
        if (ohNumber == -1 || this.allowedOHs_ == null) {
            return true;
        }
        return this.allowedOHs_.hasEntry(ohNumber);
    }

    public boolean hydroxylationValid(Vector<FattyAcidVO> combi) {
        if (this.allowedOHs_ == null) {
            return true;
        }
        boolean found = false;
        block0: for (FattyAcidVO chain : combi) {
            if (!this.allowedOHs_.hasEntry((short)chain.getOhNumber())) continue;
            for (RuleHydroxyRequirementsVO req : this.allowedOHs_.getEntry((short)chain.getOhNumber())) {
                if (req.chainType_ != chain.getChainType() && req.getChainType() != -1) continue;
                found = true;
                continue block0;
            }
        }
        return found;
    }

    public Set<Short> getAvailableTypes() {
        return this.availableFragmentTypes_;
    }

    public boolean isOrRule() {
        return this.orRule_;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntensityRuleVO other = (IntensityRuleVO)obj;
        return Objects.equals(this.allowedOHs_, other.allowedOHs_) && Objects.equals(this.availableFragmentTypes_, other.availableFragmentTypes_) && Objects.equals(this.biggerExpression_, other.biggerExpression_) && this.chainType_ == other.chainType_ && Objects.equals(this.equation_, other.equation_) && this.mandatory_ == other.mandatory_ && this.orRule_ == other.orRule_ && Objects.equals(this.smallerExpression_, other.smallerExpression_) && this.type_ == other.type_;
    }
}

