/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.FragmentMultVO;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.msn.vos.IntensityChainVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ShortStringVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;

public class IntensityPositionVO
extends IntensityRuleVO {
    private Hashtable<String, FattyAcidVO> biggerChains_;
    private Hashtable<String, FattyAcidVO> smallerChains_;
    private boolean hasOhInfo_;
    private boolean negated_;
    private int derivedPosition_;
    private boolean biggerOnlyMissed_;
    private boolean smallerOnlyMissed_;

    public IntensityPositionVO(IntensityRuleVO rule, FattyAcidVO biggerFA, FattyAcidVO smallerFA, boolean hasOhInfo, boolean biggerOnlyMissed, boolean smallerOnlyMissed) {
        super(rule);
        this.hasOhInfo_ = hasOhInfo;
        this.biggerChains_ = new Hashtable();
        this.smallerChains_ = new Hashtable();
        for (FragmentMultVO frag : this.biggerExpression_.getFragments()) {
            if (frag.getFragmentType() == -1) continue;
            this.biggerChains_.put(frag.getFragmentName(), biggerFA);
        }
        for (FragmentMultVO frag : this.smallerExpression_.getFragments()) {
            if (frag.getFragmentType() == -1) continue;
            this.smallerChains_.put(frag.getFragmentName(), smallerFA);
        }
        this.negated_ = false;
        this.derivedPosition_ = -1;
        this.biggerOnlyMissed_ = false;
        this.smallerOnlyMissed_ = false;
        this.biggerOnlyMissed_ = biggerOnlyMissed;
        this.smallerOnlyMissed_ = smallerOnlyMissed;
    }

    public FattyAcidVO getBiggerFA() {
        if (this.biggerChains_ != null && this.biggerChains_.size() > 0) {
            return this.biggerChains_.values().iterator().next();
        }
        return null;
    }

    public FattyAcidVO getSmallerFA() {
        if (this.smallerChains_ != null && this.smallerChains_.size() > 0) {
            return this.smallerChains_.values().iterator().next();
        }
        return null;
    }

    @Override
    public String getReadableRuleInterpretation(HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        Hashtable<String, String> originalToReplacementBigger = new Hashtable<String, String>();
        for (String string : this.getBiggerNonBasePeakNames().keySet()) {
            String nameString = string + "[" + this.getBiggerPosition() + "]";
            String value = StaticUtils.getChainFragmentDisplayName(string, StaticUtils.getHumanReadableChainName(this.biggerChains_.get(string), faEncoding, lcbEncoding, this.hasOhInfo_, StaticUtils.isAnAlex123Fragment(string))) + "[" + this.getBiggerPosition() + "]";
            originalToReplacementBigger.put(nameString, value);
        }
        Hashtable<String, String> originalToReplacementSmaller = new Hashtable<String, String>();
        for (String name : this.getSmallerNonBasePeakNames().keySet()) {
            String nameString = name + "[" + this.getSmallerPosition() + "]";
            String value = StaticUtils.getChainFragmentDisplayName(name, StaticUtils.getHumanReadableChainName(this.smallerChains_.get(name), faEncoding, lcbEncoding, this.hasOhInfo_, StaticUtils.isAnAlex123Fragment(name))) + "[" + this.getSmallerPosition() + "]";
            originalToReplacementSmaller.put(nameString, value);
        }
        String[] stringArray = IntensityPositionVO.splitToBiggerAndSmallerPart(this.equation_);
        String biggerPart = stringArray[0];
        String smallerPart = stringArray[1];
        biggerPart = this.replaceParts(biggerPart, originalToReplacementBigger);
        smallerPart = this.replaceParts(smallerPart, originalToReplacementSmaller);
        String returnString = "";
        if (this.equation_.indexOf(">") != -1) {
            returnString = biggerPart + ">" + smallerPart;
        } else if (this.equation_.indexOf("<") != -1) {
            returnString = smallerPart + "<" + biggerPart;
        }
        if (this.negated_) {
            returnString = this.getBiggerFA().getCarbonDbsId() + "[" + this.derivedPosition_ + "] BECAUSE NOT FULFILLED: " + returnString;
        }
        return returnString;
    }

    @Override
    public boolean equals(IntensityRuleVO other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof IntensityPositionVO)) {
            return false;
        }
        IntensityPositionVO chain = (IntensityPositionVO)other;
        if (this.getBiggerFA() == null && chain.getBiggerFA() != null || chain.getBiggerFA() == null && this.getBiggerFA() != null) {
            return false;
        }
        if (chain.getBiggerFA() != null && this.getBiggerFA() != null && !this.getBiggerFA().getChainId().equalsIgnoreCase(chain.getBiggerFA().getChainId())) {
            return false;
        }
        if (this.getSmallerFA() == null && chain.getSmallerFA() != null || chain.getSmallerFA() == null && this.getSmallerFA() != null) {
            return false;
        }
        return chain.getSmallerFA() == null || this.getSmallerFA() == null || this.getSmallerFA().getChainId().equalsIgnoreCase(chain.getSmallerFA().getChainId());
    }

    public int getPositionByFA(String fa) {
        if (this.negated_) {
            return this.derivedPosition_;
        }
        int position = -1;
        FattyAcidVO faVO = this.getBiggerFA();
        if (faVO != null && !this.biggerOnlyMissed_ && faVO.getChainId().equalsIgnoreCase(fa)) {
            position = this.getBiggerPosition();
        } else {
            faVO = this.getSmallerFA();
            if (faVO != null && !this.smallerOnlyMissed_ && faVO.getChainId().equalsIgnoreCase(fa)) {
                position = this.getSmallerPosition();
            }
        }
        return position;
    }

    public static IntensityPositionVO getFattyAcidsFromReadableRule(String storedRule, IntensityRuleVO ruleVO, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Hashtable<String, Short> missed, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding, boolean hasOhInfo, boolean usedAlexMSnTargets) throws LipidCombinameEncodingException {
        String rule = new String(storedRule);
        boolean biggerOnlyMissed = false;
        boolean smallerOnlyMissed = false;
        int derivedPosition = -1;
        if (rule.indexOf("BECAUSE NOT FULFILLED: ") != -1) {
            String derivedString = rule.substring(0, rule.indexOf("BECAUSE NOT FULFILLED: "));
            derivedString = derivedString.substring(derivedString.indexOf("[") + 1, derivedString.indexOf("]"));
            derivedPosition = Integer.parseInt(derivedString);
            rule = rule.substring(rule.indexOf("BECAUSE NOT FULFILLED: ") + "BECAUSE NOT FULFILLED: ".length());
        }
        String ruleBigger = "";
        String ruleSmaller = "";
        if (rule.indexOf(">") != -1) {
            ruleBigger = rule.substring(0, rule.indexOf(">"));
            ruleSmaller = rule.substring(rule.indexOf(">") + 1);
        } else if (rule.indexOf("<") != -1) {
            ruleSmaller = rule.substring(0, rule.indexOf("<"));
            ruleBigger = rule.substring(rule.indexOf("<") + 1);
        }
        Vector<ShortStringVO> biggerNbpNames = FragmentRuleVO.getLengthSortedFragmentNames(new Hashtable<String, Short>(), ruleVO.getBiggerNonHeadAndBasePeakNames(), new Hashtable<String, Short>());
        Vector<ShortStringVO> biggerPosNames = FragmentRuleVO.getLengthSortedFragmentNames(new Hashtable<String, Short>(), IntensityPositionVO.getNonHeadAndBasePeakNamesPlusPos(ruleVO.biggerExpression_.getFragments()), new Hashtable<String, Short>());
        if (IntensityPositionVO.checkIfOnlyMissedValuesArePresent(biggerPosNames, missed)) {
            biggerOnlyMissed = true;
        }
        Vector<ShortStringVO> smallerNbpNames = FragmentRuleVO.getLengthSortedFragmentNames(new Hashtable<String, Short>(), ruleVO.getSmallerNonHeadAndBasePeakNames(), new Hashtable<String, Short>());
        Vector<ShortStringVO> smallerPosNames = FragmentRuleVO.getLengthSortedFragmentNames(new Hashtable<String, Short>(), IntensityPositionVO.getNonHeadAndBasePeakNamesPlusPos(ruleVO.smallerExpression_.getFragments()), new Hashtable<String, Short>());
        if (IntensityPositionVO.checkIfOnlyMissedValuesArePresent(smallerPosNames, missed)) {
            smallerOnlyMissed = true;
        }
        Hashtable<String, FattyAcidVO> biggerChains = IntensityChainVO.extractFANames(ruleBigger, biggerNbpNames, faHydroxyEncoding, lcbHydroxyEncoding, usedAlexMSnTargets);
        Hashtable<String, FattyAcidVO> smallerChains = IntensityChainVO.extractFANames(ruleSmaller, smallerNbpNames, faHydroxyEncoding, lcbHydroxyEncoding, usedAlexMSnTargets);
        FattyAcidVO biggerVO = null;
        FattyAcidVO smallerVO = null;
        biggerVO = biggerChains.size() > 0 ? biggerChains.values().iterator().next() : smallerChains.values().iterator().next();
        smallerVO = smallerChains.size() > 0 ? smallerChains.values().iterator().next() : biggerChains.values().iterator().next();
        IntensityPositionVO posVO = new IntensityPositionVO(ruleVO, biggerVO, smallerVO, hasOhInfo, biggerOnlyMissed, smallerOnlyMissed);
        if (derivedPosition > -1) {
            posVO = IntensityPositionVO.createNegatedVO(posVO, derivedPosition);
        }
        return posVO;
    }

    private static boolean checkIfOnlyMissedValuesArePresent(Vector<ShortStringVO> names, Hashtable<String, Short> missed) {
        boolean onlyMissed = false;
        if (names.size() > 0) {
            onlyMissed = true;
        }
        for (ShortStringVO vo : names) {
            if (missed.containsKey(vo.getKey())) continue;
            onlyMissed = false;
        }
        return onlyMissed;
    }

    @Override
    public String getRuleValueInterpretation(Hashtable<String, Float> values, Float basePeak) throws RulesException {
        String returnString = super.getRuleValueInterpretation(values, basePeak);
        if (this.negated_) {
            returnString = "NOT FULFILLED: " + returnString;
        }
        return returnString;
    }

    public static IntensityPositionVO createNegatedVO(IntensityPositionVO posVO, int derivedPosition) {
        IntensityPositionVO vo = new IntensityPositionVO(posVO, posVO.getBiggerFA(), posVO.getSmallerFA(), posVO.hasOhInfo_, posVO.biggerOnlyMissed_, posVO.smallerOnlyMissed_);
        vo.negated_ = true;
        vo.derivedPosition_ = derivedPosition;
        return vo;
    }

    public boolean isNegated() {
        return this.negated_;
    }

    @Override
    public CgProbe checkForFragmentAvailability(String frag, Hashtable<String, CgProbe> headFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments) {
        CgProbe probe = super.checkForFragmentAvailability(frag, headFragments, chainFragments);
        if (probe == null) {
            String chainId = null;
            if (this.biggerChains_.containsKey(frag)) {
                chainId = this.biggerChains_.get(frag).getChainId();
            } else if (this.smallerChains_.containsKey(frag)) {
                chainId = this.smallerChains_.get(frag).getChainId();
            }
            if (chainId != null && chainFragments.containsKey(chainId) && chainFragments.get(chainId).containsKey(frag)) {
                probe = chainFragments.get(chainId).get(frag);
            }
        }
        return probe;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntensityPositionVO other = (IntensityPositionVO)obj;
        return Objects.equals(this.biggerChains_, other.biggerChains_) && this.biggerOnlyMissed_ == other.biggerOnlyMissed_ && this.derivedPosition_ == other.derivedPosition_ && this.hasOhInfo_ == other.hasOhInfo_ && this.negated_ == other.negated_ && Objects.equals(this.smallerChains_, other.smallerChains_) && this.smallerOnlyMissed_ == other.smallerOnlyMissed_;
    }

    private static Hashtable<String, Short> getNonHeadAndBasePeakNamesPlusPos(Vector<FragmentMultVO> parts) {
        Hashtable<String, Short> filteredNames = new Hashtable<String, Short>();
        for (FragmentMultVO multVO : parts) {
            if (multVO.getFragmentName().equalsIgnoreCase("$BASEPEAK") || multVO.getFragmentType() == -1) continue;
            String name = multVO.getFragmentName();
            if (multVO.getPosition() > 0) {
                name = name + "[" + multVO.getPosition() + "]";
            }
            filteredNames.put(name, multVO.getFragmentType());
        }
        return filteredNames;
    }
}

