/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.FragmentMultVO;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ShortStringVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;

public class IntensityChainVO
extends IntensityRuleVO {
    private Hashtable<String, FattyAcidVO> biggerChains_;
    private Hashtable<String, FattyAcidVO> smallerChains_;
    private boolean hasOhInfo_;

    public IntensityChainVO(IntensityRuleVO rule, FattyAcidVO chain, boolean hasOhInfo) {
        this(rule, hasOhInfo);
        Vector<FattyAcidVO> chains = new Vector<FattyAcidVO>();
        chains.add(chain);
        this.assignChainsToExpressions(chains);
    }

    private IntensityChainVO(IntensityRuleVO rule, boolean hasOhInfo) {
        super(rule);
        this.hasOhInfo_ = hasOhInfo;
    }

    public IntensityChainVO(IntensityRuleVO rule, Vector<FattyAcidVO> chains, boolean hasOhInfo) {
        this(rule, hasOhInfo);
        this.assignChainsToExpressions(chains);
    }

    private IntensityChainVO(IntensityRuleVO rule, Hashtable<String, FattyAcidVO> biggerChains, Hashtable<String, FattyAcidVO> smallerChains, boolean hasOhInfo) {
        this(rule, hasOhInfo);
        this.biggerChains_ = biggerChains;
        this.smallerChains_ = smallerChains;
    }

    private void assignChainsToExpressions(Vector<FattyAcidVO> chains) {
        this.biggerChains_ = new Hashtable();
        this.smallerChains_ = new Hashtable();
        block0: for (FragmentMultVO frag : this.biggerExpression_.getFragments()) {
            for (FattyAcidVO chain : chains) {
                if (frag.getFragmentType() != chain.getChainType()) continue;
                this.biggerChains_.put(frag.getFragmentName(), chain);
                continue block0;
            }
        }
        block2: for (FragmentMultVO frag : this.smallerExpression_.getFragments()) {
            for (FattyAcidVO chain : chains) {
                if (frag.getFragmentType() != chain.getChainType()) continue;
                this.smallerChains_.put(frag.getFragmentName(), chain);
                continue block2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getReadableRuleInterpretation(HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        void var5_10;
        Hashtable<String, String> originalToReplacementBigger = new Hashtable<String, String>();
        for (String string : this.getBiggerNonHeadAndBasePeakNames().keySet()) {
            String value = StaticUtils.getChainFragmentDisplayName(string, StaticUtils.getHumanReadableChainName(this.biggerChains_.get(string), faEncoding, lcbEncoding, this.hasOhInfo_, StaticUtils.isAnAlex123Fragment(string)));
            originalToReplacementBigger.put(string, value);
        }
        Hashtable<String, String> originalToReplacementSmaller = new Hashtable<String, String>();
        for (String name : this.getSmallerNonHeadAndBasePeakNames().keySet()) {
            String value = StaticUtils.getChainFragmentDisplayName(name, StaticUtils.getHumanReadableChainName(this.smallerChains_.get(name), faEncoding, lcbEncoding, this.hasOhInfo_, StaticUtils.isAnAlex123Fragment(name)));
            originalToReplacementSmaller.put(name, value);
        }
        String string = "";
        String smallerPart = "";
        if (this.orRule_) {
            String string2 = this.equation_;
        } else {
            String[] biggerSmaller = IntensityChainVO.splitToBiggerAndSmallerPart(this.equation_);
            String string3 = biggerSmaller[0];
            smallerPart = biggerSmaller[1];
        }
        String string4 = this.replaceParts((String)var5_10, originalToReplacementBigger);
        smallerPart = this.replaceParts(smallerPart, originalToReplacementSmaller);
        String returnString = "";
        if (this.equation_.indexOf(">") != -1) {
            returnString = string4 + ">" + smallerPart;
        } else if (this.equation_.indexOf("<") != -1) {
            returnString = smallerPart + "<" + string4;
        } else if (this.equation_.indexOf("|") != -1) {
            returnString = string4;
        }
        return returnString;
    }

    @Override
    public boolean equals(IntensityRuleVO other) {
        if (!this.equals(other)) {
            return false;
        }
        if (!(other instanceof IntensityChainVO)) {
            return false;
        }
        IntensityChainVO chain = (IntensityChainVO)other;
        if (chain.biggerChains_.size() != this.biggerChains_.size()) {
            return false;
        }
        for (String frag : this.biggerChains_.keySet()) {
            if (chain.biggerChains_.containsKey(frag) && chain.biggerChains_.get(frag) == this.biggerChains_.get(frag)) continue;
            return false;
        }
        if (chain.smallerChains_.size() != this.smallerChains_.size()) {
            return false;
        }
        for (String frag : this.smallerChains_.keySet()) {
            if (chain.smallerChains_.containsKey(frag) && chain.smallerChains_.get(frag) == this.smallerChains_.get(frag)) continue;
            return false;
        }
        return true;
    }

    public static IntensityChainVO getFattyAcidsFromReadableRule(String rule, IntensityRuleVO ruleVO, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Hashtable<String, Short> missed, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding, boolean hasOhInfo, boolean usedAlexMsnTargets) throws LipidCombinameEncodingException {
        boolean orRule;
        String biggerPart = "";
        String smallerPart = "";
        boolean bl = orRule = rule.indexOf("|") != -1 && rule.indexOf(">") == -1 && rule.indexOf("<") == -1;
        if (orRule) {
            biggerPart = rule;
        } else {
            String[] biggerSmaller = IntensityChainVO.splitToBiggerAndSmallerPart(rule);
            biggerPart = biggerSmaller[0];
            smallerPart = biggerSmaller[1];
        }
        Vector<ShortStringVO> biggerNbpNames = FragmentRuleVO.getLengthSortedFragmentNames(new Hashtable<String, Short>(), ruleVO.getBiggerNonHeadAndBasePeakNames(), missed);
        Vector<ShortStringVO> smallerNbpNames = FragmentRuleVO.getLengthSortedFragmentNames(new Hashtable<String, Short>(), ruleVO.getSmallerNonHeadAndBasePeakNames(), missed);
        Hashtable<String, FattyAcidVO> biggerChains = IntensityChainVO.extractFANames(biggerPart, biggerNbpNames, faHydroxyEncoding, lcbHydroxyEncoding, usedAlexMsnTargets);
        Hashtable<String, FattyAcidVO> smallerChains = IntensityChainVO.extractFANames(smallerPart, smallerNbpNames, faHydroxyEncoding, lcbHydroxyEncoding, usedAlexMsnTargets);
        return new IntensityChainVO(ruleVO, biggerChains, smallerChains, hasOhInfo);
    }

    public static Hashtable<String, FattyAcidVO> extractFANames(String ruleOriginal, Vector<ShortStringVO> names, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding, boolean usedAlexMSnTargets) throws LipidCombinameEncodingException {
        Hashtable<String, FattyAcidVO> fas = new Hashtable<String, FattyAcidVO>();
        String rulePart = new String(ruleOriginal);
        char[] chars = rulePart.toCharArray();
        if ((rulePart.indexOf("FA ") != -1 && rulePart.length() > rulePart.indexOf("FA ") + 4 && (Character.isDigit(chars[rulePart.indexOf("FA ") + 3]) || chars[rulePart.indexOf("FA ") + 4] == '-' && (chars[rulePart.indexOf("FA ") + 3] == 'P' || chars[rulePart.indexOf("FA ") + 3] == 'O')) || rulePart.indexOf("LCB ") != -1 && rulePart.length() > rulePart.indexOf("LCB ") + 5 && Character.isDigit(chars[rulePart.indexOf("LCB ") + 4]) || rulePart.indexOf("O-") != -1 && rulePart.length() > rulePart.indexOf("O-") + 3 && Character.isDigit(chars[rulePart.indexOf("O-") + 2])) && usedAlexMSnTargets) {
            fas = IntensityChainVO.extracFANamesFromAlex123Annotation(rulePart, names, faHydroxyEncoding, lcbHydroxyEncoding);
        } else if (rulePart.indexOf("(") != -1) {
            for (ShortStringVO nameVO : names) {
                String name = nameVO.getKey();
                if (rulePart.indexOf(name) == -1 || rulePart.indexOf(name) + name.length() + 2 > rulePart.length() || !rulePart.substring(rulePart.indexOf(name) + name.length()).startsWith("(")) continue;
                String subPart = rulePart.substring(rulePart.indexOf(name) + name.length());
                fas.put(nameVO.getKey(), StaticUtils.decodeHumanReadableChain(subPart.substring(subPart.indexOf("(") + 1, subPart.indexOf(")")), faHydroxyEncoding, lcbHydroxyEncoding, false, null));
                if (nameVO.getValue() != -2) {
                    fas.get(nameVO.getKey()).correctChainType(nameVO.getValue());
                }
                rulePart = rulePart.substring(0, rulePart.indexOf(name)) + rulePart.substring(rulePart.indexOf(name) + subPart.indexOf(")") + 1);
            }
        }
        return fas;
    }

    private static Hashtable<String, FattyAcidVO> extracFANamesFromAlex123Annotation(String rulePart, Vector<ShortStringVO> names, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding) throws LipidCombinameEncodingException {
        Hashtable<String, FattyAcidVO> fas = new Hashtable<String, FattyAcidVO>();
        String whole = new String(rulePart);
        for (ShortStringVO name : names) {
            if (name.getValue() == -1) continue;
            String[] split = new String[2];
            if (name.getKey().indexOf("(") == -1) {
                throw new LipidCombinameEncodingException("The fragment: " + name.getKey() + " is not an Alex123 compatible chain part!");
            }
            split[0] = name.getKey().substring(0, name.getKey().indexOf("("));
            split[1] = name.getKey().substring(name.getKey().indexOf("(") + 1);
            String part = new String(whole);
            int startIndex = 0;
            int endIndex = 0;
            String chainString = null;
            String oneChain = null;
            while (part.length() > name.getKey().length() && part.indexOf(split[0]) != -1 && (part = part.substring(startIndex += part.indexOf(split[0]))).indexOf("(") != -1) {
                if (part.substring(part.indexOf("(") + 1).startsWith(split[1])) {
                    if (part.substring(part.indexOf("(")).indexOf(")") == -1) {
                        throw new LipidCombinameEncodingException("The rule part: " + rulePart + "cannot be decoded to the corresponding chains");
                    }
                    endIndex = startIndex + part.indexOf(")") + 1;
                    if (part.toCharArray().length > endIndex - startIndex + 1 && part.toCharArray()[endIndex + 1] == '[') {
                        endIndex = startIndex + part.indexOf("]") + 1;
                    }
                    chainString = whole.substring(startIndex, endIndex);
                    oneChain = part.substring(split[0].length(), part.indexOf("(")).trim();
                    whole = whole.substring(0, startIndex) + whole.substring(endIndex);
                    break;
                }
                part = part.substring(startIndex);
            }
            if (chainString == null) continue;
            int prefixStop = 0;
            char[] chainChars = oneChain.toCharArray();
            for (int i = 0; i != chainChars.length && !Character.isDigit(chainChars[i]); ++i) {
                ++prefixStop;
            }
            String prefix = oneChain.substring(0, prefixStop);
            oneChain = oneChain.substring(prefixStop);
            int oh = 0;
            if (oneChain.indexOf(";") != -1) {
                try {
                    oh = Integer.parseInt(oneChain.substring(oneChain.indexOf(";") + 1));
                    oneChain = oneChain.substring(0, oneChain.indexOf(";"));
                }
                catch (NumberFormatException nfx) {
                    throw new LipidCombinameEncodingException("The rule part: " + rulePart + "cannot be decoded to the corresponding chains: there are problems with the OH encoding!");
                }
            }
            try {
                String[] cAndDbsAndOx = StaticUtils.parseCAndDbsFromChainId(oneChain);
                fas.put(name.getKey(), new FattyAcidVO(name.getValue(), prefix, Integer.parseInt(cAndDbsAndOx[0]), Integer.parseInt(cAndDbsAndOx[1]), oh, -1.0, null, cAndDbsAndOx[2]));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new LipidCombinameEncodingException("The rule part: " + rulePart + "cannot be decoded to the corresponding chains: there are problems decoding the number of carbon atoms and double bonds!");
            }
        }
        return fas;
    }

    @Override
    public CgProbe checkForFragmentAvailability(String frag, Hashtable<String, CgProbe> headFragments, Hashtable<String, Hashtable<String, CgProbe>> chainFragments) {
        CgProbe probe = super.checkForFragmentAvailability(frag, headFragments, chainFragments);
        if (probe == null) {
            String chainId = null;
            if (this.biggerChains_.containsKey(frag)) {
                chainId = this.biggerChains_.get(frag).getChainId();
            } else if (this.smallerChains_.containsKey(frag)) {
                chainId = this.smallerChains_.get(frag).getChainId();
            }
            if (chainId != null && chainFragments.containsKey(chainId) && chainFragments.get(chainId).containsKey(frag)) {
                probe = chainFragments.get(chainId).get(frag);
            }
        }
        return probe;
    }

    public Vector<FattyAcidVO> getParticipatingChains() {
        Hashtable<String, FattyAcidVO> hash = new Hashtable<String, FattyAcidVO>();
        if (this.biggerChains_ != null) {
            for (FattyAcidVO chain : this.biggerChains_.values()) {
                if (hash.containsKey(chain.getChainId())) continue;
                hash.put(chain.getChainId(), chain);
            }
        }
        if (this.smallerChains_ != null) {
            for (FattyAcidVO chain : this.smallerChains_.values()) {
                if (hash.containsKey(chain.getChainId())) continue;
                hash.put(chain.getChainId(), chain);
            }
        }
        return new Vector<FattyAcidVO>(hash.values());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntensityChainVO other = (IntensityChainVO)obj;
        return Objects.equals(this.biggerChains_, other.biggerChains_) && this.hasOhInfo_ == other.hasOhInfo_ && Objects.equals(this.smallerChains_, other.smallerChains_);
    }
}

