/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.masslist;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.exception.SheetNotPresentException;
import at.tugraz.genome.lda.masslist.LipidClassVO;
import at.tugraz.genome.lda.msn.parser.FALibParser;
import at.tugraz.genome.lda.msn.parser.SPBLibParser;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.utils.ExcelUtils;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.AdductVO;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MassListExporter {
    public static final String OPTION_ADDUCT_INSENSITIVE_RT_FILTER = "adductInsensitiveRtFilter";
    public static final String OPTION_PICK_BEST_MATCH_BY_SPECTRUM_COVERAGE = "pickBestMatchBySpectrumCoverage";
    public static final String OPTION_START_RT = "Start-RT:";
    public static final String OPTION_STOP_RT = "Stop-RT:";
    public static final String OPTION_OH_NUMBER = "OH-Number:";
    public static final String OPTION_OH_RANGE = "OH-Range:";
    public static final String HEADER_NAME = "Name";
    public static final String HEADER_COLON = "";
    public static final String HEADER_DBS = "dbs";
    public static final String HEADER_MASS_NEUTRAL = "neutral mass";
    public static final String HEADER_PSM = "PSM";
    public static final String HEADER_RETENTION_TIME = "tR (min)";
    public static final String HEADER_CD_CLASS = "Lipid Class";
    public static final String HEADER_CD_SPECIES = "Lipid Species";
    public static final String HEADER_CD_FORMULA = "Chemical Formula";
    public static final String HEADER_CD_MASS_NEUTRAL = "Neutral Mass";
    public static final String HEADER_CD_ADDUCT_NAME = "Adduct Name";
    public static final String HEADER_CD_ADDUCT_FORMULA = "Adduct Formula";
    public static final String HEADER_CD_ADDUCT_MASS = "Adduct m/z";
    private static final int OPTIONS_ROW_LDA = 0;
    private static final int HEADER_ROW_LDA = 2;
    private static final int FIRST_VALUE_ROW_LDA = 3;
    private String outPath_;
    private ArrayList<LipidClassVO> lipidClasses_;
    private String exportIonMode_;
    private String exportFormat_;

    public MassListExporter(String outPath, ArrayList<LipidClassVO> lipidClasses, String exportIonMode, String exportFormat) {
        this.outPath_ = outPath;
        this.lipidClasses_ = lipidClasses;
        this.exportIonMode_ = exportIonMode;
        this.exportFormat_ = exportFormat;
    }

    public void export() {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.outPath_));
             XSSFWorkbook workbook = new XSSFWorkbook();){
            if (this.exportFormat_.equals("LDA Mass List")) {
                this.exportLDAFormat(workbook);
            } else if (this.exportFormat_.equals("Merged list (long)")) {
                this.exportLongListFormat(workbook);
            } else if (this.exportFormat_.equals("Merged list (short)")) {
                this.exportShortListFormat(workbook);
            }
            workbook.write(out);
            System.out.println("workbook written!");
        }
        catch (ChemicalFormulaException | RulesException | SheetNotPresentException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "The following error occurred during the export: " + ex.getMessage());
        }
    }

    private void exportLongListFormat(XSSFWorkbook workbook) throws IOException, RulesException, SheetNotPresentException, ChemicalFormulaException {
        XSSFSheet sheet = workbook.createSheet("Mass List");
        XSSFCellStyle headerStyle = ExcelUtils.getMassListHeaderStyle(workbook);
        List<String> headerTitles = this.createCDHeaderTitles();
        this.createHeader(0, sheet, headerTitles, headerStyle);
        int rowCount = 0;
        for (LipidClassVO lClassVO : this.lipidClasses_) {
            FALibParser faParser;
            if (lClassVO.getLipidClass().equalsIgnoreCase("placeholder")) continue;
            ArrayList<FattyAcidVO> chainsFA = new ArrayList();
            ArrayList<FattyAcidVO> chainsLCB = new ArrayList();
            if (lClassVO.getNumberOfFAChains() > 0) {
                faParser = new FALibParser(lClassVO.getFAChainListPath());
                faParser.parseFile();
                chainsFA = faParser.getFattyAcidSet(false);
            }
            if (lClassVO.getNumberOfLCBChains() > 0) {
                faParser = new SPBLibParser(new File(lClassVO.getLCBChainListPath()));
                ((SPBLibParser)faParser).parseFile();
                chainsLCB = faParser.getFattyAcidSet(false);
            }
            for (int i = lClassVO.getMinChainC(); i <= lClassVO.getMaxChainC(); ++i) {
                for (int j = lClassVO.getMinChainDB(); j <= lClassVO.getMaxChainDB(); ++j) {
                    for (int k = lClassVO.getOhRangeFrom(); k <= lClassVO.getOhRangeTo(); ++k) {
                        ArrayList<ArrayList<FattyAcidVO>> filtered = this.getPossCombis(lClassVO.getNumberOfFAChains(), lClassVO.getNumberOfLCBChains(), i, j, k, chainsFA, chainsLCB, new ArrayList<FattyAcidVO>());
                        if (filtered.isEmpty()) continue;
                        Hashtable<String, Hashtable<String, Integer>> prefixElements = new Hashtable<String, Hashtable<String, Integer>>();
                        prefixElements = this.computeElementsFromChains(prefixElements, lClassVO, filtered);
                        for (String label : prefixElements.keySet()) {
                            Hashtable<String, Integer> elements = prefixElements.get(label);
                            double massNeutral = this.computeNeutralMass(elements);
                            for (AdductVO adduct : lClassVO.getAdducts()) {
                                if (!this.isAdductExport(adduct.getCharge())) continue;
                                double massAdduct = this.computeAdductMass(massNeutral, adduct);
                                Row row = sheet.createRow(++rowCount);
                                Cell cell = row.createCell(headerTitles.indexOf(HEADER_CD_CLASS), 1);
                                cell.setCellValue(lClassVO.getLipidClass());
                                cell = row.createCell(headerTitles.indexOf(HEADER_CD_SPECIES), 1);
                                cell.setCellValue(this.buildLipidSpeciesString(lClassVO, i, j, k));
                                cell = row.createCell(headerTitles.indexOf(HEADER_CD_FORMULA), 1);
                                cell.setCellValue(StaticUtils.getFormulaInHillNotation(elements, false));
                                cell = row.createCell(headerTitles.indexOf(HEADER_CD_MASS_NEUTRAL), 0);
                                cell.setCellValue(massNeutral);
                                cell = row.createCell(headerTitles.indexOf(HEADER_CD_ADDUCT_NAME), 1);
                                cell.setCellValue(adduct.getAdductName());
                                cell = row.createCell(headerTitles.indexOf(HEADER_CD_ADDUCT_FORMULA), 1);
                                cell.setCellValue(StaticUtils.getFormulaInHillNotation(this.computeAdductFormula(elements, adduct), false));
                                cell = row.createCell(headerTitles.indexOf(HEADER_CD_ADDUCT_MASS), 0);
                                cell.setCellValue(massAdduct);
                            }
                        }
                    }
                }
            }
        }
    }

    private void exportShortListFormat(XSSFWorkbook workbook) throws IOException, RulesException, SheetNotPresentException, ChemicalFormulaException {
        XSSFSheet sheet = workbook.createSheet("Mass List");
        XSSFCellStyle headerStyle = ExcelUtils.getMassListHeaderStyle(workbook);
        List<String> headerTitles = this.createCDHeaderTitles();
        this.createHeader(0, sheet, headerTitles, headerStyle);
        int rowCount = 0;
        for (LipidClassVO lClassVO : this.lipidClasses_) {
            FALibParser faParser;
            if (lClassVO.getLipidClass().equalsIgnoreCase("placeholder")) continue;
            ArrayList<FattyAcidVO> chainsFA = new ArrayList();
            ArrayList<FattyAcidVO> chainsLCB = new ArrayList();
            if (lClassVO.getNumberOfFAChains() > 0) {
                faParser = new FALibParser(lClassVO.getFAChainListPath());
                faParser.parseFile();
                chainsFA = faParser.getFattyAcidSet(false);
            }
            if (lClassVO.getNumberOfLCBChains() > 0) {
                faParser = new SPBLibParser(new File(lClassVO.getLCBChainListPath()));
                ((SPBLibParser)faParser).parseFile();
                chainsLCB = faParser.getFattyAcidSet(false);
            }
            for (int i = lClassVO.getMinChainC(); i <= lClassVO.getMaxChainC(); ++i) {
                for (int j = lClassVO.getMinChainDB(); j <= lClassVO.getMaxChainDB(); ++j) {
                    for (int k = lClassVO.getOhRangeFrom(); k <= lClassVO.getOhRangeTo(); ++k) {
                        ArrayList<ArrayList<FattyAcidVO>> filtered = this.getPossCombis(lClassVO.getNumberOfFAChains(), lClassVO.getNumberOfLCBChains(), i, j, k, chainsFA, chainsLCB, new ArrayList<FattyAcidVO>());
                        if (filtered.isEmpty()) continue;
                        Hashtable<String, Hashtable<String, Integer>> prefixElements = new Hashtable<String, Hashtable<String, Integer>>();
                        prefixElements = this.computeElementsFromChains(prefixElements, lClassVO, filtered);
                        for (String label : prefixElements.keySet()) {
                            Hashtable<String, Integer> elements = prefixElements.get(label);
                            double massNeutral = this.computeNeutralMass(elements);
                            Row row = sheet.createRow(++rowCount);
                            Cell cell = row.createCell(headerTitles.indexOf(HEADER_CD_CLASS), 1);
                            cell.setCellValue(lClassVO.getLipidClass());
                            cell = row.createCell(headerTitles.indexOf(HEADER_CD_SPECIES), 1);
                            cell.setCellValue(this.buildLipidSpeciesString(lClassVO, i, j, k));
                            cell = row.createCell(headerTitles.indexOf(HEADER_CD_FORMULA), 1);
                            cell.setCellValue(StaticUtils.getFormulaInHillNotation(elements, false));
                            cell = row.createCell(headerTitles.indexOf(HEADER_CD_MASS_NEUTRAL), 0);
                            cell.setCellValue(massNeutral);
                        }
                    }
                }
            }
        }
    }

    private String buildLipidSpeciesString(LipidClassVO lClassVO, int cAtoms, int doubleBonds, int ohNumber) {
        String ohString = HEADER_COLON;
        if (ohNumber == 1) {
            ohString = ";O";
        } else if (ohNumber > 1) {
            ohString = ";O" + ohNumber;
        }
        return String.format("%s %s:%s%s", lClassVO.getLipidClass(), cAtoms, doubleBonds, ohString);
    }

    private void exportLDAFormat(XSSFWorkbook workbook) throws IOException, RulesException, SheetNotPresentException, ChemicalFormulaException {
        for (LipidClassVO lClassVO : this.lipidClasses_) {
            FALibParser faParser;
            if (lClassVO.getLipidClass().equalsIgnoreCase("placeholder")) continue;
            XSSFSheet sheet = workbook.createSheet(lClassVO.getLipidClass());
            XSSFCellStyle headerStyle = ExcelUtils.getMassListHeaderStyle(workbook);
            this.createHeader(0, sheet, this.createLDAOptionsTitles(lClassVO), headerStyle);
            List<String> headerTitles = this.createLDAHeaderTitles(lClassVO);
            this.createHeader(2, sheet, headerTitles, headerStyle);
            ArrayList<FattyAcidVO> chainsFA = new ArrayList();
            ArrayList<FattyAcidVO> chainsLCB = new ArrayList();
            if (lClassVO.getNumberOfFAChains() > 0) {
                faParser = new FALibParser(lClassVO.getFAChainListPath());
                faParser.parseFile();
                chainsFA = faParser.getFattyAcidSet(false);
            }
            if (lClassVO.getNumberOfLCBChains() > 0) {
                faParser = new SPBLibParser(new File(lClassVO.getLCBChainListPath()));
                ((SPBLibParser)faParser).parseFile();
                chainsLCB = faParser.getFattyAcidSet(false);
            }
            String psmString = this.getPSMString(lClassVO);
            int rowCount = 3;
            for (int i = lClassVO.getMinChainC(); i <= lClassVO.getMaxChainC(); ++i) {
                for (int j = lClassVO.getMinChainDB(); j <= lClassVO.getMaxChainDB(); ++j) {
                    ArrayList<ArrayList<FattyAcidVO>> filtered = this.getPossCombis(lClassVO.getNumberOfFAChains(), lClassVO.getNumberOfLCBChains(), i, j, lClassVO.getOhNumber(), chainsFA, chainsLCB, new ArrayList<FattyAcidVO>());
                    if (filtered.isEmpty()) continue;
                    Hashtable<String, Hashtable<String, Integer>> prefixElements = new Hashtable<String, Hashtable<String, Integer>>();
                    prefixElements = this.computeElementsFromChains(prefixElements, lClassVO, filtered);
                    for (String label : prefixElements.keySet()) {
                        Row row = sheet.createRow(rowCount);
                        Hashtable<String, Integer> elements = prefixElements.get(label);
                        Cell cell = row.createCell(headerTitles.indexOf(HEADER_NAME), 1);
                        cell.setCellValue(label + i);
                        cell = row.createCell(headerTitles.indexOf(HEADER_COLON), 1);
                        cell.setCellValue(":");
                        cell = row.createCell(headerTitles.indexOf(HEADER_DBS), 0);
                        cell.setCellValue(j);
                        for (String element : this.determineLDAHeaderElements()) {
                            cell = row.createCell(headerTitles.indexOf(element), 0);
                            if (!elements.containsKey(element)) {
                                cell.setCellValue(0.0);
                                continue;
                            }
                            cell.setCellValue(elements.get(element).intValue());
                        }
                        double massNeutral = this.computeNeutralMass(elements);
                        cell = row.createCell(headerTitles.indexOf(HEADER_MASS_NEUTRAL), 0);
                        cell.setCellValue(massNeutral);
                        for (AdductVO adduct : lClassVO.getAdducts()) {
                            if (!this.isAdductExport(adduct.getCharge())) continue;
                            double massAdduct = this.computeAdductMass(massNeutral, adduct);
                            cell = row.createCell(headerTitles.indexOf(this.getAdductHeader(adduct)), 0);
                            cell.setCellValue(massAdduct);
                        }
                        cell = row.createCell(headerTitles.indexOf(HEADER_PSM), 1);
                        cell.setCellValue(psmString);
                        ++rowCount;
                    }
                }
            }
        }
    }

    private boolean isAdductExport(int charge) {
        return this.exportIonMode_.equals("negative ion mode") && charge < 0 || this.exportIonMode_.equals("positive ion mode") && charge > 0 || this.exportIonMode_.equals("both ion modes") && charge != 0;
    }

    private String getPSMString(LipidClassVO lClassVO) {
        StringBuilder builder = new StringBuilder();
        if (lClassVO.getNumberOfLCBChains() > 0) {
            return HEADER_COLON;
        }
        for (int i = lClassVO.getOhRangeFrom(); i <= lClassVO.getOhRangeTo(); ++i) {
            if (i < 1) continue;
            builder.append(";O" + i);
        }
        return builder.toString();
    }

    private ArrayList<ArrayList<FattyAcidVO>> getPossCombis(int numberOfFAChains, int numberOfLCBChains, int cAtoms, int dbs, int oxNum, ArrayList<FattyAcidVO> fas, ArrayList<FattyAcidVO> lcbs, ArrayList<FattyAcidVO> added) {
        ArrayList<ArrayList<FattyAcidVO>> combis = new ArrayList<ArrayList<FattyAcidVO>>();
        int totalChains = numberOfFAChains + numberOfLCBChains;
        ArrayList<FattyAcidVO> toIterate = fas;
        int faMinus = 1;
        int lcbMinus = 0;
        if (numberOfFAChains == 0 && totalChains > 0) {
            toIterate = lcbs;
            faMinus = 0;
            lcbMinus = 1;
        }
        int maxC = this.checkMaxCAvailable(added, cAtoms);
        int maxD = this.checkMaxDBAvailable(added, dbs);
        int maxO = this.checkMaxOxAvailable(added, oxNum);
        for (FattyAcidVO fa : toIterate) {
            if (fa.getcAtoms() > maxC || fa.getDoubleBonds() > maxD || fa.getOhNumber() > maxO) continue;
            ArrayList<FattyAcidVO> toAdd = new ArrayList<FattyAcidVO>(added);
            toAdd.add(fa);
            if (totalChains > 1) {
                ArrayList<ArrayList<FattyAcidVO>> combis2 = this.getPossCombis(numberOfFAChains - faMinus, numberOfLCBChains - lcbMinus, cAtoms, dbs, oxNum, fas, lcbs, toAdd);
                combis.addAll(combis2);
                continue;
            }
            if (!this.checkTotalCDbsOxValid(toAdd, cAtoms, dbs, oxNum)) continue;
            combis.add(toAdd);
        }
        return combis;
    }

    private int checkMaxCAvailable(ArrayList<FattyAcidVO> added, int cAtoms) {
        int tot = cAtoms;
        for (FattyAcidVO fa : added) {
            tot -= fa.getcAtoms();
        }
        return tot;
    }

    private int checkMaxDBAvailable(ArrayList<FattyAcidVO> added, int dbs) {
        int tot = dbs;
        for (FattyAcidVO fa : added) {
            tot -= fa.getDoubleBonds();
        }
        return tot;
    }

    private int checkMaxOxAvailable(ArrayList<FattyAcidVO> added, int ox) {
        int tot = ox;
        for (FattyAcidVO fa : added) {
            tot -= fa.getOhNumber();
        }
        return tot;
    }

    private boolean checkTotalCDbsOxValid(ArrayList<FattyAcidVO> toAdd, int cAtoms, int dbs, int oxNum) {
        int totC = 0;
        int totD = 0;
        int totO = 0;
        for (FattyAcidVO fa : toAdd) {
            totC += fa.getcAtoms();
            totD += fa.getDoubleBonds();
            totO += fa.getOhNumber();
        }
        return totC == cAtoms && totD == dbs && totO == oxNum;
    }

    private Hashtable<String, Hashtable<String, Integer>> computeElementsFromChains(Hashtable<String, Hashtable<String, Integer>> labelElements, LipidClassVO lClassVO, ArrayList<ArrayList<FattyAcidVO>> filtered) throws ChemicalFormulaException {
        for (ArrayList<FattyAcidVO> comb : filtered) {
            Vector<String> labels = new Vector<String>();
            Hashtable<String, Integer> combElements = new Hashtable<String, Integer>(lClassVO.getHeadgroupFormula());
            for (FattyAcidVO fattyAcidVO : comb) {
                Hashtable<String, Integer> formula = StaticUtils.categorizeFormula(fattyAcidVO.getFormula(), true);
                for (String element : formula.keySet()) {
                    if (!combElements.containsKey(element)) {
                        combElements.put(element, 0);
                    }
                    combElements.put(element, combElements.get(element) + formula.get(element));
                }
                combElements.put("H", combElements.get("H") - 1);
                labels.add(fattyAcidVO.getPrefix());
            }
            Collections.sort(labels);
            StringBuilder builder = new StringBuilder();
            for (String label : labels) {
                builder.append(label);
            }
            String string = builder.toString();
            if (lClassVO.getNumberOfLCBChains() > 0) {
                combElements.put("H", combElements.get("H") - lClassVO.getNumberOfFAChains());
                combElements.put("O", combElements.get("O") - lClassVO.getNumberOfFAChains());
            }
            labelElements.put(string, combElements);
        }
        return labelElements;
    }

    private Hashtable<String, Integer> computeAdductFormula(Hashtable<String, Integer> neutralElements, AdductVO adduct) {
        Hashtable<String, Integer> elements = new Hashtable<String, Integer>();
        Hashtable<String, Integer> elementsAdduct = new Hashtable<String, Integer>(adduct.getFormula());
        HashSet<String> allElements = new HashSet<String>(neutralElements.keySet());
        allElements.addAll(elementsAdduct.keySet());
        for (String element : allElements) {
            int neutralEle = neutralElements.get(element) != null ? neutralElements.get(element) : 0;
            int adductEle = elementsAdduct.get(element) != null ? elementsAdduct.get(element) : 0;
            elements.put(element, neutralEle + adductEle);
        }
        return elements;
    }

    private double computeNeutralMass(Hashtable<String, Integer> elements) {
        double neutralMass = 0.0;
        ElementConfigParser parser = Settings.getElementParser();
        for (String element : elements.keySet()) {
            neutralMass += parser.getElementDetails(element).getMonoMass() * (double)elements.get(element).intValue();
        }
        return neutralMass;
    }

    private double computeAdductMass(double neutralMass, AdductVO adduct) {
        double massAdduct = neutralMass;
        for (String element : adduct.getFormula().keySet()) {
            massAdduct += Settings.getElementParser().getElementDetails(element).getMonoMass() * (double)adduct.getFormula().get(element).intValue();
        }
        return Math.abs(massAdduct / (double)adduct.getCharge());
    }

    private List<String> createLDAHeaderTitles(LipidClassVO lClassVO) {
        ArrayList<String> headerTitles = new ArrayList<String>();
        headerTitles.add(HEADER_NAME);
        headerTitles.add(HEADER_COLON);
        headerTitles.add(HEADER_DBS);
        for (String element : this.determineLDAHeaderElements()) {
            headerTitles.add(element);
        }
        headerTitles.add(HEADER_MASS_NEUTRAL);
        for (AdductVO adduct : lClassVO.getAdducts()) {
            if (!this.isAdductExport(adduct.getCharge())) continue;
            headerTitles.add(this.getAdductHeader(adduct));
        }
        headerTitles.add(HEADER_PSM);
        headerTitles.add(HEADER_RETENTION_TIME);
        return headerTitles;
    }

    private List<String> createCDHeaderTitles() {
        ArrayList<String> headerTitles = new ArrayList<String>();
        headerTitles.add(HEADER_CD_CLASS);
        headerTitles.add(HEADER_CD_SPECIES);
        headerTitles.add(HEADER_CD_FORMULA);
        headerTitles.add(HEADER_CD_MASS_NEUTRAL);
        headerTitles.add(HEADER_CD_ADDUCT_NAME);
        headerTitles.add(HEADER_CD_ADDUCT_FORMULA);
        headerTitles.add(HEADER_CD_ADDUCT_MASS);
        return headerTitles;
    }

    private String getAdductHeader(AdductVO adduct) {
        return String.format("mass(form[%s] name[%s] charge=%s)", adduct.getFormulaString(), adduct.getAdductName(), Math.abs(adduct.getCharge()));
    }

    private List<String> createLDAOptionsTitles(LipidClassVO lClassVO) {
        ArrayList<String> titles = new ArrayList<String>();
        if (lClassVO.isAdductInsensitiveRtFilter()) {
            titles.add(OPTION_ADDUCT_INSENSITIVE_RT_FILTER);
        }
        if (lClassVO.isPickBestMatchBySpectrumCoverage()) {
            titles.add(OPTION_PICK_BEST_MATCH_BY_SPECTRUM_COVERAGE);
        }
        if (lClassVO.getRtRangeFrom() > -1.0 && lClassVO.getRtRangeTo() > -1.0 && lClassVO.getRtRangeFrom() < lClassVO.getRtRangeTo()) {
            titles.add(OPTION_START_RT + lClassVO.getRtRangeFrom());
            titles.add(OPTION_STOP_RT + lClassVO.getRtRangeTo());
        }
        if (lClassVO.getOhNumber() > 0) {
            titles.add(OPTION_OH_NUMBER + lClassVO.getOhNumber());
        }
        if (lClassVO.getOhRangeFrom() > -1 && lClassVO.getOhRangeTo() > -1 && lClassVO.getOhRangeFrom() < lClassVO.getOhRangeTo()) {
            titles.add(OPTION_OH_RANGE + lClassVO.getOhRangeFrom() + "-" + lClassVO.getOhRangeTo());
        }
        return titles;
    }

    private ArrayList<String> determineLDAHeaderElements() {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("C");
        elements.add("Cc");
        elements.add("H");
        elements.add("D");
        elements.add("N");
        elements.add("O");
        elements.add("P");
        return elements;
    }

    private void createHeader(int rowNum, Sheet sheet, List<String> headerTitles, XSSFCellStyle headerStyle) {
        Row row = sheet.createRow(rowNum);
        for (int i = 0; i < headerTitles.size(); ++i) {
            Cell cell = row.createCell(i, 1);
            cell.setCellValue(headerTitles.get(i));
            cell.setCellStyle(headerStyle);
            sheet.setColumnWidth(i, 2560);
        }
    }
}

