/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.masslist;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.JTargetFileWizard;
import at.tugraz.genome.lda.lccl.LoadingPanel;
import at.tugraz.genome.lda.masslist.AdductCreatorPanel;
import at.tugraz.genome.lda.masslist.LipidClassExporter;
import at.tugraz.genome.lda.masslist.LipidClassPanel;
import at.tugraz.genome.lda.masslist.LipidClassParser;
import at.tugraz.genome.lda.masslist.LipidClassVO;
import at.tugraz.genome.lda.masslist.LipidClassesOrganizerPanel;
import at.tugraz.genome.lda.masslist.MassListExporter;
import at.tugraz.genome.lda.msn.parser.FALibParser;
import at.tugraz.genome.lda.msn.parser.SPBLibParser;
import at.tugraz.genome.lda.vos.AdductVO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;

public class MassListCreatorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int LIPID_CLASS_HEIGHT = 675;
    public static final String CHAIN_LIST_FOLDER = "./fattyAcids/";
    public static final String CHAIN_LIST_SUFFIX = ".xlsx";
    static final String COMMAND_EDIT_ADDUCT = "editAdduct";
    private static final String OUT_OPEN = "outOpen";
    public static final String EXPORT_OPTION_NEG = "negative ion mode";
    public static final String EXPORT_OPTION_POS = "positive ion mode";
    public static final String EXPORT_OPTION_BOTH = "both ion modes";
    private static final String[] EXPORT_OPTIONS_ION_MODE = new String[]{"negative ion mode", "positive ion mode", "both ion modes"};
    public static final String EXPORT_FORMAT_LDA = "LDA Mass List";
    public static final String EXPORT_FORMAT_LONG_LIST = "Merged list (long)";
    public static final String EXPORT_FORMAT_SHORT_LIST = "Merged list (short)";
    private static final String[] EXPORT_OPTIONS_FORMAT = new String[]{"LDA Mass List", "Merged list (long)", "Merged list (short)"};
    private static final String EXPORT = "export";
    private static final String PLACEHOLDER_OUT_PATH = "Enter path and file name for the mass list export.";
    private LipidClassesOrganizerPanel lipidClassesOrganizerPanel_;
    private LipidClassPanel lipidClassPanelSingle_;
    private LipidClassPanel lipidClassPanelMulti_;
    private AdductCreatorPanel adductCreatorPanel_;
    private ArrayList<AdductVO> allDefinedAdducts_;
    private ArrayList<LipidClassVO> allDefinedLipidClasses_;
    private String[] faChainListNames_;
    private String[] lcbChainListNames_;
    private String[] adductListNames_;
    private LipidClassVO selectedClass_;
    private LipidClassVO tempClass_;
    private JPanel displayPanel_;
    private JTabbedPane lipidClassPane_;
    private LipidClassTable lipidClassTable_;
    private JTextField outTextField_;
    private Path previousSelection_ = null;
    private JComboBox<String> exportedIonMode_;
    private JComboBox<String> exportedFormat_;
    private String currentLipidClassSubfolder_ = this.findTxtFile(new File(LipidClassParser.LIPID_CLASS_FOLDER));
    private JSplitPane splitPane_;
    private JScrollPane displayScrollPane_;

    public MassListCreatorPanel() {
        this.displayPanel_ = new JPanel();
        this.displayPanel_.setLayout(new GridBagLayout());
        try {
            this.lipidClassesOrganizerPanel_ = new LipidClassesOrganizerPanel(this);
            this.adductCreatorPanel_ = new AdductCreatorPanel(this);
            this.allDefinedAdducts_ = this.adductCreatorPanel_.getAllDefinedAdducts();
            this.adductListNames_ = this.adductCreatorPanel_.getAdductNames();
            this.allDefinedLipidClasses_ = new LipidClassParser(this.allDefinedAdducts_, this.currentLipidClassSubfolder_).parse();
            this.faChainListNames_ = this.getChainListNames(true);
            this.lcbChainListNames_ = this.getChainListNames(false);
            this.selectedClass_ = this.allDefinedLipidClasses_.get(0);
            this.tempClass_ = new LipidClassVO(this.selectedClass_);
            this.lipidClassTable_ = new LipidClassTable("Defined lipid (sub)classes", this.getLipidClassNames(), this.selectedClass_.getLipidClass());
            GridBagConstraints gbc = this.getDefaultGridBagConstraints(0, 0, 13, 2, 1);
            gbc.fill = 2;
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new GridBagLayout());
            topPanel.add((Component)this.lipidClassesOrganizerPanel_, gbc);
            gbc = this.getDefaultGridBagConstraints(0, 1, 13, 1, 1);
            gbc.weighty = 0.0;
            this.displayPanel_.add((Component)this.lipidClassTable_, gbc);
            JPanel lipidClassPanel = this.initLipidClassPanel();
            gbc = this.getDefaultGridBagConstraints(1, 1, 13, 1, 1);
            gbc.weighty = 0.0;
            this.displayPanel_.add((Component)lipidClassPanel, gbc);
            this.outTextField_ = this.instantiatePlaceholderJTextField(PLACEHOLDER_OUT_PATH, PLACEHOLDER_OUT_PATH, 825);
            gbc = this.getDefaultGridBagConstraints(0, 2, 10, 2, 1);
            gbc.weighty = 0.0;
            this.displayPanel_.add((Component)this.getOutPathPanel(this.outTextField_), gbc);
            gbc = this.getDefaultGridBagConstraints(0, 3, 10, 2, 1, new Insets(10, 10, 10, 10));
            gbc.weighty = 0.0;
            this.displayPanel_.add((Component)this.instantiateJButton(EXPORT, "Export", true, "<html>Export the selected lipid (sub)classes to the chosen directory.</html>"), gbc);
            this.displayPanel_.setMinimumSize(new Dimension(925, 925));
            this.displayScrollPane_ = new JScrollPane(this.displayPanel_);
            this.displayScrollPane_.getViewport().setViewPosition(new Point(0, 0));
            this.splitPane_ = new JSplitPane(0, topPanel, this.displayScrollPane_);
            this.splitPane_.setDividerLocation(75);
            this.setLayout(new BorderLayout());
            this.add((Component)this.splitPane_, "Center");
        }
        catch (Exception ex) {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Mass list creation interface unavailable due to invalid and/or missing content in the subfolder ./massListCreation or ./fattyAcids"), "North");
            this.add((Component)new JLabel("Error message: " + ex.getMessage()), "Center");
        }
    }

    private String findTxtFile(File folder) {
        File[] subFolders;
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".txt")) continue;
                return folder.getAbsolutePath();
            }
        }
        if ((subFolders = folder.listFiles(File::isDirectory)) != null) {
            for (File subFolder : subFolders) {
                String result = this.findTxtFile(subFolder);
                if (result == null) continue;
                return subFolder.getAbsolutePath();
            }
        }
        return folder.getAbsolutePath();
    }

    private LipidClassVO getVOfromName(String lipidClassName) {
        for (LipidClassVO vo : this.allDefinedLipidClasses_) {
            if (!vo.getLipidClass().equals(lipidClassName)) continue;
            return vo;
        }
        return null;
    }

    protected void reloadLipidClassScrollPane() throws FileNotFoundException, IOException, ChemicalFormulaException {
        this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
    }

    public void reloadLipidClassScrollPane(String selectedLipidClassName) throws FileNotFoundException, IOException, ChemicalFormulaException {
        this.allDefinedLipidClasses_ = new LipidClassParser(this.allDefinedAdducts_, this.currentLipidClassSubfolder_).parse();
        if (this.allDefinedLipidClasses_.isEmpty()) {
            JOptionPane.showMessageDialog(this, "This folder does not yet contain any lipid class definitions! A dummy lipid class is created.", "Warning", 2);
            LipidClassExporter exporter = new LipidClassExporter(null, this.currentLipidClassSubfolder_);
            exporter.exportDummy(this.allDefinedAdducts_.get(0));
            this.allDefinedLipidClasses_ = new LipidClassParser(this.allDefinedAdducts_, this.currentLipidClassSubfolder_).parse();
        }
        this.faChainListNames_ = this.getChainListNames(true);
        this.lcbChainListNames_ = this.getChainListNames(false);
        LipidClassVO vo = this.allDefinedLipidClasses_.get(0);
        if (selectedLipidClassName != null) {
            vo = this.getVOfromName(selectedLipidClassName);
        }
        if (vo == null) {
            throw new IOException("Something went wrong with the import.");
        }
        this.selectedClass_ = vo;
        this.tempClass_ = new LipidClassVO(this.selectedClass_);
        this.handleLipidClassSelection(this.selectedClass_.getLipidClass());
        this.displayPanel_.remove(this.lipidClassTable_);
        this.lipidClassTable_ = new LipidClassTable("Defined lipid (sub)classes", this.getLipidClassNames(), this.selectedClass_.getLipidClass());
        this.refreshLipidClassScrollPane();
    }

    private void refreshLipidClassScrollPane() {
        this.displayPanel_.remove(this.lipidClassTable_);
        this.displayPanel_.add((Component)this.lipidClassTable_, this.getDefaultGridBagConstraints(0, 1, 13, 1, 1));
        this.displayPanel_.invalidate();
        this.displayPanel_.updateUI();
    }

    void refreshLipidClassPanel() throws IOException {
        this.lipidClassPanelSingle_.updatePanelContent(true, this.faChainListNames_, this.lcbChainListNames_);
        this.lipidClassPanelMulti_.updatePanelContent(false, this.faChainListNames_, this.lcbChainListNames_);
        this.lipidClassPane_.revalidate();
        this.lipidClassPane_.repaint();
    }

    private JPanel getOutPathPanel(JTextField outPathField) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel exportIonModeLabel = new JLabel("Export relevant adducts for: ");
        exportIonModeLabel.setToolTipText("<html>Select for which ion mode(s) relevant adducts should be exported.<br/>This is based on the sign of the adduct charge.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        panel.add((Component)exportIonModeLabel, this.getDefaultGridBagConstraints(0, 0, 17, 1, 1));
        this.exportedIonMode_ = this.instantiateJComboBox(EXPORT_OPTIONS_ION_MODE, 0, false);
        this.exportedIonMode_.setToolTipText("<html>Select for which ion mode(s) relevant adducts should be exported.<br/>This is based on the sign of the adduct charge.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        panel.add(this.exportedIonMode_, this.getDefaultGridBagConstraints(1, 0, 17, 1, 1));
        JLabel exportFormatLabel = new JLabel("Export file format: ");
        exportFormatLabel.setToolTipText("<html>Select for which ion mode(s) relevant adducts should be exported.<br/>This is based on the sign of the adduct charge.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        panel.add((Component)exportFormatLabel, this.getDefaultGridBagConstraints(0, 1, 17, 1, 1));
        this.exportedFormat_ = this.instantiateJComboBox(EXPORT_OPTIONS_FORMAT, 0, false);
        this.exportedFormat_.setToolTipText("<html>Select the desired output format.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        panel.add(this.exportedFormat_, this.getDefaultGridBagConstraints(1, 1, 17, 1, 1));
        outPathField.setToolTipText("<html>Enter a filepath to store the exported Excel file to.<br/>The 'Browse' button offers an alternative option to select a viable file path.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        panel.add((Component)outPathField, this.getDefaultGridBagConstraints(0, 2, 17, 2, 1));
        JButton outPathButton = this.instantiateJButton(OUT_OPEN, "Browse", true, "<html>Select a filepath to store the exported Excel file to.<br/>The file name must be entered manually if no file exists that should be overridden.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        panel.add((Component)outPathButton, this.getDefaultGridBagConstraints(2, 2, 13, 1, 1, new Insets(10, 10, 10, 10)));
        TitledBorder border = JOptionPanel.getTitledPanelBorder("Mass list export");
        panel.setBorder(border);
        panel.setPreferredSize(new Dimension(975, 150));
        return panel;
    }

    private JPanel initLipidClassPanel() throws IOException {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.lipidClassPane_ = new JTabbedPane();
        panel.add((Component)this.lipidClassPane_, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 5));
        this.lipidClassPanelSingle_ = new LipidClassPanel(this, true, this.faChainListNames_, this.lcbChainListNames_);
        this.lipidClassPane_.add((Component)this.lipidClassPanelSingle_, "Edit selected lipid (sub)class");
        this.lipidClassPanelMulti_ = new LipidClassPanel(this, false, this.faChainListNames_, this.lcbChainListNames_);
        this.lipidClassPane_.add((Component)this.lipidClassPanelMulti_, "Edit multiple lipid (sub)classes");
        panel.add((Component)this.instantiateJButton(COMMAND_EDIT_ADDUCT, "Edit list of adducts", true, "<html>Add, remove or edit adducts.</html>"), this.getDefaultGridBagConstraints(0, 1, 10, 1, 1, new Insets(10, 10, 10, 10)));
        TitledBorder border = JOptionPanel.getTitledPanelBorder("Display / edit lipid class definitions");
        panel.setBorder(border);
        panel.setPreferredSize(new Dimension(565, 675));
        return panel;
    }

    private JButton instantiateJButton(final String actionCommand, String text, final boolean isOverride, String tooltips) {
        JButton button = new JButton(text);
        button.setToolTipText(tooltips);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MassListCreatorPanel.this.jButtonExecuter(actionCommand, isOverride);
            }
        });
        return button;
    }

    JComboBox<String> instantiateJComboBox(String[] entries, int index, boolean isSingle) {
        JComboBox<String> jComboBox = new JComboBox<String>(entries);
        jComboBox.setSelectedIndex(index);
        jComboBox.setPreferredSize(new Dimension(this.getPreferredDisplayComponentWidth(isSingle ? 0 : 50), 20));
        return jComboBox;
    }

    int[] findSelectedAdductListIndices(LipidClassVO vo) throws IOException {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < this.adductListNames_.length; ++i) {
            for (AdductVO adduct : vo.getAdducts()) {
                if (!this.adductListNames_[i].equalsIgnoreCase(adduct.getAdductName())) continue;
                indices.add(i);
            }
        }
        if (indices.isEmpty()) {
            throw new IOException(String.format("The file defining the lipid class '%s' does not contain any defined adducts!", vo.getLipidClass()));
        }
        int[] arr = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            arr[i] = (Integer)indices.get(i);
        }
        return arr;
    }

    private JTextField instantiatePlaceholderJTextField(String actionCommand, final String text, Integer width) {
        final JTextField field = new JTextField();
        field.setPreferredSize(new Dimension(width, 20));
        field.setText(text);
        field.setForeground(Color.GRAY);
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (field.getText().equals(text)) {
                    field.setText("");
                    field.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (field.getText().isEmpty()) {
                    field.setForeground(Color.GRAY);
                    field.setText(text);
                }
            }
        });
        return field;
    }

    GridBagConstraints getDefaultGridBagConstraints(int column, int row, int orientation, int width, int height, Insets insets) {
        return new GridBagConstraints(column, row, width, height, 0.0, 0.0, orientation, 0, insets, 0, 5);
    }

    GridBagConstraints getDefaultGridBagConstraints(int column, int row, int orientation, int width, int height) {
        return this.getDefaultGridBagConstraints(column, row, orientation, width, height, new Insets(2, 5, 2, 5));
    }

    private void jButtonExecuter(String actionCommand, boolean isOverride) {
        switch (actionCommand) {
            case "editAdduct": {
                this.adductCreatorPanel_.open();
                break;
            }
            case "outOpen": {
                this.selectOutPath();
                break;
            }
            case "export": {
                String outPath = this.outTextField_.getText();
                if (outPath.equals(PLACEHOLDER_OUT_PATH) || outPath.length() < 1) {
                    JOptionPane.showMessageDialog(this, "A filepath to write the mass list to must be defined prior to the export!", "Error", 0);
                    break;
                }
                if (this.lipidClassTable_.getSelectedLipidClasses().isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Please select at least one lipid class prior to the export!", "Error", 0);
                    break;
                }
                if (!outPath.endsWith(CHAIN_LIST_SUFFIX)) {
                    outPath = outPath + CHAIN_LIST_SUFFIX;
                    this.outTextField_.setText(outPath);
                }
                final MassListExporter exporter = new MassListExporter(outPath, this.lipidClassTable_.getSelectedLipidClasses(), (String)this.exportedIonMode_.getSelectedItem(), (String)this.exportedFormat_.getSelectedItem());
                StringBuilder builder = new StringBuilder();
                builder.append("<html>Writing the mass list to the specified file.<br>");
                builder.append("Please wait... </html>");
                final LoadingPanel waitPanel = new LoadingPanel(builder.toString());
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MassListCreatorPanel.this.updateUI(MassListCreatorPanel.this.displayPanel_, waitPanel);
                        exporter.export();
                        MassListCreatorPanel.this.updateUI(waitPanel, MassListCreatorPanel.this.displayPanel_);
                    }
                });
                thread.start();
                break;
            }
        }
    }

    public void updateUI(JPanel oldPanel, JPanel newPanel) {
        this.displayScrollPane_.setViewportView(null);
        this.displayScrollPane_.setViewportView(newPanel);
        newPanel.setMinimumSize(new Dimension(925, 925));
        this.displayScrollPane_.revalidate();
        this.displayScrollPane_.repaint();
    }

    private void selectOutPath() {
        int val;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("Only .xlsx", "xlsx"));
        chooser.setPreferredSize(JTargetFileWizard.DEFAULT_FILE_CHOOSER_DIMENSION);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Select the path for the mass list export");
        if (this.previousSelection_ != null) {
            chooser.setCurrentDirectory(this.previousSelection_.getParent().toFile());
        }
        if ((val = chooser.showOpenDialog(new JFrame())) != 0) {
            return;
        }
        String text = chooser.getSelectedFile().getAbsolutePath();
        this.previousSelection_ = Paths.get(text, new String[0]);
        this.outTextField_.setText(text);
        this.outTextField_.setForeground(Color.BLACK);
    }

    ArrayList<LipidClassVO> findLipidClassesToExport(String option) {
        if (option.equalsIgnoreCase("All listed in table")) {
            return this.allDefinedLipidClasses_;
        }
        return this.lipidClassTable_.getSelectedLipidClasses();
    }

    boolean isChainNumViable(LipidClassVO vo) {
        return vo.getNumberOfFAChains() >= 0 && vo.getNumberOfLCBChains() >= 0 && vo.getNumberOfFAChains() + vo.getNumberOfLCBChains() > 0;
    }

    void exportChainNumbersToSelectedClasses(int faChains, int spbchains, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setNumberOfFAChains(faChains);
            vo.setNumberOfLCBChains(spbchains);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    void exportFAChainListToSelectedClasses(String faChainList, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setFaChainList(faChainList);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    void exportSPBChainListToSelectedClasses(String spbChainList, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setLCBChainList(spbChainList);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    boolean isAdductListViable(LipidClassVO vo) {
        return !vo.getAdducts().isEmpty();
    }

    void exportAdductListToSelectedClasses(ArrayList<AdductVO> adductList, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setAdducts(adductList);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    boolean isCNumViable(LipidClassVO vo) {
        return vo.getMinChainC() > 0 && vo.getMinChainC() < vo.getMaxChainC();
    }

    void exportCNumToSelectedClasses(int min, int max, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setMinChainC(min);
            vo.setMaxChainC(max);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    boolean isDBNumViable(LipidClassVO vo) {
        return vo.getMinChainDB() >= 0 && vo.getMinChainDB() < vo.getMaxChainDB() || vo.getMinChainDB() == 0 && vo.getMaxChainDB() == 0;
    }

    void exportDBNumToSelectedClasses(int min, int max, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setMinChainDB(min);
            vo.setMaxChainDB(max);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    boolean isRTViable(LipidClassVO vo) {
        return vo.getRtRangeFrom() >= 0.0 && vo.getRtRangeFrom() < vo.getRtRangeTo() || vo.getRtRangeFrom() < 0.0 && vo.getRtRangeTo() < 0.0;
    }

    void exportRTToSelectedClasses(double min, double max, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setRtRangeFrom(min);
            vo.setRtRangeTo(max);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    boolean isLipidClassOxDefinitionViable(LipidClassVO vo) {
        return vo.getOhRangeFrom() >= 0 && vo.getOhRangeFrom() <= vo.getOhRangeTo() || vo.getOhRangeFrom() == 0 && vo.getOhRangeFrom() == 0;
    }

    void exportOxNumToSelectedClasses(int min, int max, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setOhRangeFrom(min);
            vo.setOhRangeTo(max);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    void exportFilterToSelectedClasses(boolean filter, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setAdductInsensitiveRtFilter(filter);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    void exportPickToSelectedClasses(boolean pick, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setPickBestMatchBySpectrumCoverage(pick);
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    boolean isGeneralDefinitionViable(LipidClassVO vo) {
        return this.isChainNumViable(vo) && this.isCNumViable(vo) && this.isDBNumViable(vo) && this.isRTViable(vo) && this.isLipidClassOxDefinitionViable(vo) && this.isAdductListViable(vo);
    }

    void exportAll(LipidClassVO template, ArrayList<LipidClassVO> toExport) {
        for (LipidClassVO vo : toExport) {
            vo.setNumberOfFAChains(template.getNumberOfFAChains());
            vo.setNumberOfLCBChains(template.getNumberOfLCBChains());
            vo.setFaChainList(template.getFAChainList());
            vo.setLCBChainList(template.getLCBChainList());
            vo.setAdducts(template.getAdducts());
            vo.setMinChainC(template.getMinChainC());
            vo.setMaxChainC(template.getMaxChainC());
            vo.setMinChainDB(template.getMinChainDB());
            vo.setMaxChainDB(template.getMaxChainDB());
            vo.setRtRangeFrom(template.getRtRangeFrom());
            vo.setRtRangeTo(template.getRtRangeTo());
            vo.setOhRangeFrom(template.getOhRangeFrom());
            vo.setOhRangeTo(template.getOhRangeTo());
            vo.setAdductInsensitiveRtFilter(template.isAdductInsensitiveRtFilter());
            vo.setPickBestMatchBySpectrumCoverage(template.isPickBestMatchBySpectrumCoverage());
            this.exportLipidClass(vo, true);
        }
        try {
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    boolean isLipidClassViable() {
        return this.isLipidClassNameAvailable(this.tempClass_.getLipidClass()) && this.isChainNumViable(this.tempClass_) && this.tempClass_.getHeadgroupFormula() != null && this.isCNumViable(this.tempClass_) && this.isDBNumViable(this.tempClass_) && this.isRTViable(this.tempClass_) && this.isLipidClassOxDefinitionViable(this.tempClass_) && this.isAdductListViable(this.tempClass_);
    }

    void updateAdductForLipidClasses(AdductVO oldAdduct, AdductVO newAdduct, boolean isDelete) {
        for (LipidClassVO vo : this.allDefinedLipidClasses_) {
            boolean isChanged = false;
            ArrayList<AdductVO> newAdductVOList = new ArrayList<AdductVO>();
            for (AdductVO adduct : vo.getAdducts()) {
                if (adduct.getAdductName().equals(oldAdduct.getAdductName())) {
                    if (!isDelete) {
                        newAdductVOList.add(newAdduct);
                    }
                    isChanged = true;
                    continue;
                }
                newAdductVOList.add(adduct);
            }
            if (!isChanged) continue;
            vo.setAdducts(newAdductVOList);
            this.exportLipidClass(vo, true);
        }
    }

    void synchronizeCurrentLipidClass(LipidClassPanel caller) {
        this.selectedClass_ = this.getVOfromName(caller.getSelectedClass().getLipidClass());
        this.tempClass_ = this.getVOfromName(caller.getTempClass().getLipidClass());
    }

    void deleteLipidClass() {
        Object[] options = new Object[]{"Delete", "Cancel"};
        int n = JOptionPane.showOptionDialog(new JFrame(), String.format("Are you sure you want to delete the lipid (sub)class definition '%s'?", this.selectedClass_.getLipidClass()), "Deleting lipid (sub)class definition", 1, 3, null, options, options[0]);
        if (n == 0) {
            try {
                String originalFilePath = LipidClassExporter.buildLipidClassPath(this.selectedClass_.getLipidClass(), this.currentLipidClassSubfolder_);
                File file = new File(originalFilePath);
                file.delete();
                this.reloadLipidClassScrollPane(null);
            }
            catch (ChemicalFormulaException | IOException ex) {
                new WarningMessage(new JFrame(), "Error", "An error occurred. Error message: " + ex.getMessage());
            }
        }
    }

    void exportLipidClass(LipidClassVO toExport, boolean isOverride) {
        if (isOverride) {
            String originalFilePath = LipidClassExporter.buildLipidClassPath(toExport.getLipidClass(), this.currentLipidClassSubfolder_);
            File file = new File(originalFilePath);
            file.delete();
        }
        LipidClassExporter exporter = new LipidClassExporter(toExport, this.currentLipidClassSubfolder_);
        exporter.export();
    }

    void exportLipidClass(boolean isOverride) {
        try {
            if (isOverride) {
                String originalFilePath = LipidClassExporter.buildLipidClassPath(this.selectedClass_.getLipidClass(), this.currentLipidClassSubfolder_);
                File file = new File(originalFilePath);
                file.delete();
            }
            this.selectedClass_ = this.tempClass_;
            LipidClassExporter exporter = new LipidClassExporter(this.selectedClass_, this.currentLipidClassSubfolder_);
            exporter.export();
            this.reloadLipidClassScrollPane(this.selectedClass_.getLipidClass());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    boolean isLipidClassNameAvailable(String name) {
        for (LipidClassVO vo : this.allDefinedLipidClasses_) {
            if (vo.equals(this.selectedClass_) || !vo.getLipidClass().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    void setDefaultTextFieldBorder(JTextField textfield) {
        textfield.setBorder(BorderFactory.createLineBorder(Color.darkGray));
    }

    void setWarningTextFieldBorder(JTextField textfield) {
        textfield.setBorder(BorderFactory.createLineBorder(Color.red));
    }

    private String[] getLipidClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (LipidClassVO vo : this.allDefinedLipidClasses_) {
            names.add(vo.getLipidClass());
        }
        return this.toArray(names);
    }

    private String[] getChainListNames(boolean isFA) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        File folder = new File(CHAIN_LIST_FOLDER);
        if (!folder.exists()) {
            throw new IOException(String.format("The chain list folder '%s' does not exist!", CHAIN_LIST_FOLDER));
        }
        File[] fileCandidates = folder.listFiles();
        for (int i = 0; i < fileCandidates.length; ++i) {
            String fileName = fileCandidates[i].getName();
            if (!fileName.endsWith(CHAIN_LIST_SUFFIX)) continue;
            try {
                if (isFA && new FALibParser(fileCandidates[i]).isFAFile()) {
                    names.add(fileName.substring(0, fileName.indexOf(CHAIN_LIST_SUFFIX)));
                    continue;
                }
                if (isFA || !new SPBLibParser(fileCandidates[i]).isLCBFile()) continue;
                names.add(fileName.substring(0, fileName.indexOf(CHAIN_LIST_SUFFIX)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.toArray(names);
    }

    private String[] toArray(ArrayList<String> list) {
        String[] arr = new String[list.size()];
        return list.toArray(arr);
    }

    private void handleLipidClassSelection(String lipidClass) throws IOException, ChemicalFormulaException {
        for (LipidClassVO vo : this.allDefinedLipidClasses_) {
            if (!vo.getLipidClass().equals(lipidClass)) continue;
            this.selectedClass_ = vo;
            this.tempClass_ = new LipidClassVO(this.selectedClass_);
            this.refreshLipidClassPanel();
            return;
        }
    }

    public AdductCreatorPanel getAdductCreatorPanel() {
        return this.adductCreatorPanel_;
    }

    public String[] getFAChainListNames() {
        return this.faChainListNames_;
    }

    public String[] getSPBChainListNames() {
        return this.lcbChainListNames_;
    }

    public LipidClassVO getSelectedClass() {
        return this.selectedClass_;
    }

    public LipidClassVO getTempClass() {
        return this.tempClass_;
    }

    int getPreferredDisplayComponentWidth(int offset) {
        return 180 - offset;
    }

    int getPreferredDisplayComponentWidthSmaller(int offset) {
        return 65 - offset;
    }

    public String getCurrentLipidClassSubfolderName() {
        return this.currentLipidClassSubfolder_;
    }

    public void setCurrentLipidClassSubfolderName(String subFolderName) {
        this.currentLipidClassSubfolder_ = subFolderName;
    }

    class BooleanTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        Object[][] tableData_;
        String[] columnNames_;

        BooleanTableModel(Object[][] tableData, String[] columnNames) {
            this.tableData_ = tableData;
            this.columnNames_ = columnNames;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames_.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames_[column];
        }

        @Override
        public int getRowCount() {
            return this.tableData_.length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.tableData_[row][column];
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public int indexOf(Object firstColumnEntry, int columnNum) {
            for (int i = 0; i < this.tableData_.length; ++i) {
                String data = (String)this.getValueAt(i, columnNum);
                if (!data.equals(firstColumnEntry)) continue;
                return i;
            }
            return 0;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.tableData_[row][column] = value;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }
    }

    private class LipidClassTable
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_INCLUDE = 1;
        private String[] lipidClassNames_;
        private JPanel selectionTablePanel_;
        private JTable displayTable_;
        private JScrollPane scrollPane_;
        private BooleanTableModel model_;

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 675);
        }

        private LipidClassTable(String title, String[] lipidClassNames, String selected) {
            this.lipidClassNames_ = lipidClassNames;
            this.selectionTablePanel_ = this.generateSelectionTablePanel(this.initializeTableData(lipidClassNames), selected);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.selectionTablePanel_, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 5));
            this.setBorder(JOptionPanel.getTitledPanelBorder(title));
        }

        private JPanel generateSelectionTablePanel(Object[][] tableData, String selected) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            String[] columnNames = new String[]{"lipid class name", "select"};
            this.model_ = new BooleanTableModel(tableData, columnNames);
            this.displayTable_ = new JTable(this.model_);
            this.displayTable_.setAutoResizeMode(0);
            this.displayTable_.getColumnModel().getColumn(0).setPreferredWidth(250);
            this.scrollPane_ = new JScrollPane(this.displayTable_);
            this.displayTable_.setSelectionMode(0);
            ListSelectionModel selectionModel = this.displayTable_.getSelectionModel();
            selectionModel.setAnchorSelectionIndex(this.model_.indexOf(selected, 0));
            selectionModel.setLeadSelectionIndex(this.model_.indexOf(selected, 0));
            selectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    try {
                        MassListCreatorPanel.this.handleLipidClassSelection((String)LipidClassTable.this.model_.getValueAt(((ListSelectionModel)e.getSource()).getMaxSelectionIndex(), 0));
                    }
                    catch (ChemicalFormulaException | IOException ex) {
                        new WarningMessage(new JFrame(), "Warning", String.format("The definition file for the lipid class '%s' could not be parsed.", (String)LipidClassTable.this.model_.getValueAt(((ListSelectionModel)e.getSource()).getMaxSelectionIndex(), 0)));
                    }
                }
            });
            panel.add((Component)this.scrollPane_, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 5));
            JButton button = new JButton("Invert selection");
            button.setToolTipText("<html>Invert the selection of listed lipid classes.</html>");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LipidClassTable.this.invertSelection();
                }
            });
            panel.add((Component)button, MassListCreatorPanel.this.getDefaultGridBagConstraints(0, 1, 10, 1, 1, new Insets(10, 10, 10, 10)));
            return panel;
        }

        private Object[][] initializeTableData(String[] lipidClassNames) {
            Object[][] tableData = new Object[lipidClassNames.length][2];
            for (int i = 0; i < lipidClassNames.length; ++i) {
                tableData[i][0] = lipidClassNames[i];
                tableData[i][1] = Boolean.TRUE;
            }
            return tableData;
        }

        private void invertSelection() {
            for (int i = 0; i < this.lipidClassNames_.length; ++i) {
                boolean value = (Boolean)this.model_.getValueAt(i, 1);
                this.model_.setValueAt(!value, i, 1);
            }
            MassListCreatorPanel.this.refreshLipidClassScrollPane();
        }

        private ArrayList<LipidClassVO> getSelectedLipidClasses() {
            ArrayList<LipidClassVO> selected = new ArrayList<LipidClassVO>();
            for (int i = 0; i < this.lipidClassNames_.length; ++i) {
                LipidClassVO vo;
                if (!Boolean.valueOf(this.model_.getValueAt(i, 1).equals(Boolean.TRUE)).booleanValue() || (vo = MassListCreatorPanel.this.getVOfromName((String)this.model_.getValueAt(i, 0))) == null) continue;
                selected.add(vo);
            }
            return selected;
        }
    }
}

