/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.masslist;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.masslist.AdductExporter;
import at.tugraz.genome.lda.masslist.AdductParser;
import at.tugraz.genome.lda.masslist.MassListCreatorPanel;
import at.tugraz.genome.lda.vos.AdductVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdductCreatorPanel
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String COMMAND_ADDUCT_NAME = "adductName";
    private static final String COMMAND_ADDUCT_FORMULA = "adductFormula";
    private static final String COMMAND_ADDUCT_CHARGE = "adductCharge";
    private static final String COMMAND_ADDUCT_EXPORT = "adductExport";
    private static final String COMMAND_ADDUCT_DELETE = "adductDelete";
    private MassListCreatorPanel parent_;
    private JPanel displayPanel_;
    private AdductsTable adductsTable_;
    private JPanel adductPanel_;
    private ArrayList<AdductVO> allDefinedAdducts_;
    private String[] adductListNames_;
    private AdductVO selectedAdduct_;
    private AdductVO tempAdduct_;

    protected AdductCreatorPanel(MassListCreatorPanel parent) {
        this.setTitle("Edit list of adducts");
        this.setSize(new Dimension(1050, 350));
        this.setVisible(false);
        this.parent_ = parent;
        this.displayPanel_ = new JPanel();
        this.displayPanel_.setLayout(new GridBagLayout());
        try {
            this.allDefinedAdducts_ = new AdductParser().parse();
            this.adductListNames_ = this.getAdductNames();
            this.selectedAdduct_ = this.allDefinedAdducts_.get(0);
            this.tempAdduct_ = new AdductVO(this.selectedAdduct_);
            this.adductsTable_ = new AdductsTable("Defined adducts", this.getAdductNames(), this.selectedAdduct_.getAdductName());
            this.addAdductsTableToDisplayPanel();
            this.adductPanel_ = this.getAdductPanel(this.selectedAdduct_);
            this.addAdductsPanelToDisplayPanel();
            this.add(this.displayPanel_);
        }
        catch (Exception ex) {
            this.add(new JLabel("Mass list creation interface unavailable due to invalid and/or missing content in the subfolder ./massListCreation/adducts"));
            this.add(new JLabel("Error message: " + ex.getMessage()));
        }
    }

    private void addAdductsTableToDisplayPanel() {
        this.displayPanel_.add((Component)this.adductsTable_, this.parent_.getDefaultGridBagConstraints(0, 0, 13, 1, 1));
    }

    private void addAdductsPanelToDisplayPanel() {
        this.displayPanel_.add((Component)this.adductPanel_, this.parent_.getDefaultGridBagConstraints(1, 0, 13, 1, 1));
    }

    private void refreshAdductScrollPane(String selectedAddductName) throws FileNotFoundException, IOException, ChemicalFormulaException {
        this.allDefinedAdducts_ = new AdductParser().parse();
        this.adductListNames_ = this.getAdductNames();
        if (selectedAddductName == null) {
            this.selectedAdduct_ = this.allDefinedAdducts_.get(0);
            this.tempAdduct_ = new AdductVO(this.selectedAdduct_);
        } else {
            for (AdductVO vo : this.allDefinedAdducts_) {
                if (!vo.getAdductName().equals(selectedAddductName)) continue;
                this.selectedAdduct_ = vo;
                this.tempAdduct_ = new AdductVO(this.selectedAdduct_);
            }
        }
        this.displayPanel_.remove(this.adductsTable_);
        this.adductsTable_ = new AdductsTable("Defined adducts", this.getAdductNames(), this.selectedAdduct_.getAdductName());
        this.addAdductsTableToDisplayPanel();
        this.displayPanel_.invalidate();
        this.displayPanel_.updateUI();
        this.parent_.reloadLipidClassScrollPane();
        this.parent_.refreshLipidClassPanel();
    }

    private JPanel getAdductPanel(AdductVO vo) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JTextField nameField = this.instantiateJTextField(COMMAND_ADDUCT_NAME, vo.getAdductName());
        this.addLabeledTextField(panel, 0, new JLabel("Adduct name: "), nameField, "<html>This defines the name of the adduct.<br/>In combination with the respective lipid (sub)class name this determines the filename of the MS/MS fragmentation rules file <br/>that LDA will look for in the folder 'fragRules' in the installation directory. <br/>E.g. the fragmentation rule file for the lipid subclass 'PC' with the adduct 'H' is named 'PC_H.frag.txt'. <br/>Please refer to the user manual for more detailed instructions.</html>");
        JTextField formulaField = this.instantiateJTextField(COMMAND_ADDUCT_FORMULA, vo.getFormulaString());
        this.addLabeledTextField(panel, 1, new JLabel("Chemical fomula: "), formulaField, "<html>This defines the chemical formula of the adduct.<br/>chemical formulas prefixed with a minus symbol will be subtracted from the neutral mass,<br/>whereas formulas prefixed with a plus will be added (an adduct formula may contain both, a minus and a plus).<br/>Please refer to the user manual for more detailed instructions.</html>");
        JTextField chargeField = this.instantiateJTextField(COMMAND_ADDUCT_CHARGE, String.valueOf(vo.getCharge()));
        this.addLabeledTextField(panel, 2, new JLabel("Charge: "), chargeField, "<html>This defines the charge of the adduct.<br/>The neutral mass is divided by the absolute value of the respective adduct charge for the exported mass list.<br/>The sign of the adduct charge is crucial when only adducts for a specific ion mode (i.e. negative or positive) are selected for export.<br/>Please refer to the user manual for more detailed instructions.</html>");
        JPanel buttonPanel = this.instantiateJButtonPanel(COMMAND_ADDUCT_DELETE, COMMAND_ADDUCT_EXPORT, "Delete", "Override", "Save New", "<html>Delete this adduct definition.</html>", "<html>Override the existing adduct definition.</html>", "<html>Export this new adduct definition.</html>");
        panel.add((Component)buttonPanel, this.parent_.getDefaultGridBagConstraints(0, 13, 10, 5, 1));
        TitledBorder border = JOptionPanel.getTitledPanelBorder("Display / edit currently selected adduct definition");
        panel.setBorder(border);
        panel.setMinimumSize(new Dimension(550, 175));
        panel.setPreferredSize(new Dimension(550, 250));
        return panel;
    }

    private void addLabeledTextField(JPanel panel, Integer yPos, JLabel label, JTextField textField, String tooltips) {
        label.setToolTipText(tooltips);
        textField.setToolTipText(tooltips);
        panel.add((Component)label, this.parent_.getDefaultGridBagConstraints(0, yPos, 17, 2, 1));
        panel.add((Component)textField, this.parent_.getDefaultGridBagConstraints(2, yPos, 13, 3, 1));
    }

    private void refreshAdductPanel() throws IOException {
        this.displayPanel_.remove(this.adductPanel_);
        this.adductPanel_ = this.getAdductPanel(this.selectedAdduct_);
        this.addAdductsPanelToDisplayPanel();
        this.displayPanel_.invalidate();
        this.displayPanel_.updateUI();
    }

    private String[] toArray(ArrayList<String> list) {
        String[] arr = new String[list.size()];
        return list.toArray(arr);
    }

    protected void handleAdductSelection(String adduct) throws IOException, ChemicalFormulaException {
        for (AdductVO vo : this.allDefinedAdducts_) {
            if (!vo.getAdductName().equals(adduct)) continue;
            this.selectedAdduct_ = vo;
            this.tempAdduct_ = new AdductVO(this.selectedAdduct_);
            this.refreshAdductPanel();
            return;
        }
    }

    private JTextField instantiateJTextField(String actionCommand, String text) {
        return this.instantiateJTextField(actionCommand, text, this.parent_.getPreferredDisplayComponentWidth(0));
    }

    private JTextField instantiateJTextField(final String actionCommand, String text, Integer width) {
        final JTextField textField = new JTextField(text);
        textField.setPreferredSize(new Dimension(width, 20));
        this.parent_.setDefaultTextFieldBorder(textField);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AdductCreatorPanel.this.textFieldChangeExecuter(actionCommand, textField);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AdductCreatorPanel.this.textFieldChangeExecuter(actionCommand, textField);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AdductCreatorPanel.this.textFieldChangeExecuter(actionCommand, textField);
            }
        });
        return textField;
    }

    private void textFieldChangeExecuter(String actionCommand, JTextField textfield) {
        switch (actionCommand) {
            case "adductName": {
                this.tempAdduct_.setAdductName(textfield.getText());
                if (this.isAdductNameAvailable(textfield.getText())) {
                    this.parent_.setDefaultTextFieldBorder(textfield);
                    break;
                }
                this.parent_.setWarningTextFieldBorder(textfield);
                break;
            }
            case "adductFormula": {
                try {
                    this.tempAdduct_.setFormulaString(textfield.getText());
                    this.parent_.setDefaultTextFieldBorder(textfield);
                }
                catch (ChemicalFormulaException ex) {
                    this.parent_.setWarningTextFieldBorder(textfield);
                }
                break;
            }
            case "adductCharge": {
                try {
                    this.tempAdduct_.setCharge(0);
                    this.tempAdduct_.setCharge(Integer.parseInt(textfield.getText()));
                    this.parent_.setDefaultTextFieldBorder(textfield);
                }
                catch (NumberFormatException ex) {
                    this.parent_.setWarningTextFieldBorder(textfield);
                }
                break;
            }
        }
    }

    private JPanel instantiateJButtonPanel(String actionCommandDelete, String actionCommandExport, String textDelete, String textOverride, String textSaveNew, String tooltipsDelete, String tooltipsOverride, String tooltipsSaveNew) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton buttonDelete = this.instantiateJButton(actionCommandDelete, textDelete, false, tooltipsDelete);
        JButton buttonOverride = this.instantiateJButton(actionCommandExport, textOverride, true, tooltipsOverride);
        JButton buttonSaveNew = this.instantiateJButton(actionCommandExport, textSaveNew, false, tooltipsSaveNew);
        panel.add((Component)buttonDelete, this.parent_.getDefaultGridBagConstraints(0, 0, 17, 1, 1, new Insets(10, 10, 10, 10)));
        panel.add((Component)buttonOverride, this.parent_.getDefaultGridBagConstraints(1, 0, 17, 1, 1, new Insets(10, 10, 10, 10)));
        panel.add((Component)buttonSaveNew, this.parent_.getDefaultGridBagConstraints(2, 0, 13, 1, 1, new Insets(10, 10, 10, 10)));
        return panel;
    }

    private JButton instantiateJButton(final String actionCommand, String text, final boolean isOverride, String tooltips) {
        JButton button = new JButton(text);
        button.setToolTipText(tooltips);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdductCreatorPanel.this.jButtonExecuter(actionCommand, isOverride);
            }
        });
        return button;
    }

    private void jButtonExecuter(String actionCommand, boolean isOverride) {
        switch (actionCommand) {
            case "adductDelete": {
                this.deleteAdduct();
                break;
            }
            case "adductExport": {
                if (this.isAdductViable()) {
                    if (isOverride && (!isOverride || JOptionPane.showConfirmDialog(new JFrame(), String.format("Would you like to override the adduct definition '%s'?", this.selectedAdduct_.getAdductName()), "Override definition", 0) != 0)) break;
                    this.exportAdduct(isOverride);
                    break;
                }
                JOptionPane.showMessageDialog(this, "The adduct definition contains erroneous user-entries, please correct textfields highlighted in red before exporting.", "Error", 0);
                break;
            }
        }
    }

    private void deleteAdduct() {
        Object[] options = new Object[]{"Delete", "Cancel"};
        int n = JOptionPane.showOptionDialog(new JFrame(), String.format("Are you sure you want to delete the adduct definition '%s'?", this.selectedAdduct_.getAdductName()), "Deleting adduct definition", 1, 3, null, options, options[0]);
        if (n == 0) {
            try {
                String originalFilePath = AdductExporter.buildAdductPath(this.selectedAdduct_.getFileName());
                File file = new File(originalFilePath);
                file.delete();
                this.parent_.updateAdductForLipidClasses(this.selectedAdduct_, this.tempAdduct_, true);
                this.refreshAdductScrollPane(null);
            }
            catch (ChemicalFormulaException | IOException ex) {
                new WarningMessage(new JFrame(), "Error", "An error occurred. Error message: " + ex.getMessage());
            }
        }
    }

    private void exportAdduct(boolean isOverride) {
        try {
            if (isOverride) {
                String originalFilePath = AdductExporter.buildAdductPath(this.selectedAdduct_.getFileName());
                File file = new File(originalFilePath);
                file.delete();
            }
            String fileName = this.buildAdductFileName(this.tempAdduct_.getAdductName());
            this.tempAdduct_.setFileName(fileName);
            AdductExporter exporter = new AdductExporter(this.tempAdduct_);
            exporter.export();
            if (isOverride) {
                this.parent_.updateAdductForLipidClasses(this.selectedAdduct_, this.tempAdduct_, false);
            }
            this.selectedAdduct_ = this.tempAdduct_;
            this.refreshAdductScrollPane(this.selectedAdduct_.getAdductName());
        }
        catch (ChemicalFormulaException | IOException ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export. Error message: " + ex.getMessage());
        }
    }

    private String buildAdductFileName(String adductName) {
        return "adduct_" + adductName + ".txt";
    }

    private boolean isAdductViable() {
        return this.isAdductNameAvailable(this.tempAdduct_.getAdductName()) && this.tempAdduct_.getFormula() != null && this.tempAdduct_.getCharge() != 0;
    }

    private boolean isAdductNameAvailable(String name) {
        ArrayList<AdductVO> other = new ArrayList<AdductVO>(this.allDefinedAdducts_);
        other.remove(this.selectedAdduct_);
        for (AdductVO vo : other) {
            if (!vo.getAdductName().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<AdductVO> getAllDefinedAdducts() {
        return this.allDefinedAdducts_;
    }

    protected String[] getAdductListNames() {
        return this.adductListNames_;
    }

    protected String[] getAdductNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AdductVO vo : this.allDefinedAdducts_) {
            names.add(vo.getAdductName());
        }
        return this.toArray(names);
    }

    protected void open() {
        this.setVisible(true);
    }

    private class AdductsTable
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final int COLUMN_NAME = 0;
        private JPanel selectionTablePanel_;
        private JTable displayTable_;
        private JScrollPane scrollPane_;

        private AdductsTable(String title, String[] adductNames, String selected) {
            this.setMinimumSize(new Dimension(400, 175));
            this.setPreferredSize(new Dimension(400, 250));
            this.selectionTablePanel_ = new JPanel();
            this.generateSelectionTablePanel(this.initializeTableData(adductNames), selected);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.selectionTablePanel_, AdductCreatorPanel.this.parent_.getDefaultGridBagConstraints(0, 1, 10, 1, 1));
            this.setBorder(JOptionPanel.getTitledPanelBorder(title));
        }

        private void generateSelectionTablePanel(Object[][] tableData, String selected) {
            String[] columnNames = new String[]{"adduct name"};
            MassListCreatorPanel massListCreatorPanel = AdductCreatorPanel.this.parent_;
            massListCreatorPanel.getClass();
            final MassListCreatorPanel.BooleanTableModel model = new MassListCreatorPanel.BooleanTableModel(massListCreatorPanel, tableData, columnNames);
            this.displayTable_ = new JTable(model);
            this.scrollPane_ = new JScrollPane(this.displayTable_);
            this.scrollPane_.setMinimumSize(new Dimension(325, 125));
            this.scrollPane_.setPreferredSize(new Dimension(325, 175));
            this.displayTable_.setSelectionMode(0);
            ListSelectionModel selectionModel = this.displayTable_.getSelectionModel();
            selectionModel.setAnchorSelectionIndex(model.indexOf(selected, 0));
            selectionModel.setLeadSelectionIndex(model.indexOf(selected, 0));
            selectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    try {
                        AdductCreatorPanel.this.handleAdductSelection((String)model.getValueAt(((ListSelectionModel)e.getSource()).getMaxSelectionIndex(), 0));
                    }
                    catch (ChemicalFormulaException | IOException ex) {
                        new WarningMessage(new JFrame(), "Warning", String.format("The definition file for the lipid class '%s' could not be parsed.", (String)model.getValueAt(((ListSelectionModel)e.getSource()).getMaxSelectionIndex(), 0)));
                    }
                }
            });
            this.selectionTablePanel_.add(this.scrollPane_);
        }

        private Object[][] initializeTableData(String[] adductNames) {
            Object[][] tableData = new Object[adductNames.length][1];
            for (int i = 0; i < adductNames.length; ++i) {
                tableData[i][0] = adductNames[i];
            }
            return tableData;
        }
    }
}

