/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.export;

import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.LinkedHashMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> selectedGradient_;
    private JTextField thresholdClustering_;
    private static final String DEFAULT_GRADIENTS_DIR = "gradients";
    private static final String EXCEL_SUFFIX = ".xlsx";
    private static final Double DEFAULT_THRESHOLD = 5.0;
    public static final String NO_ADJUSTMENT = "No adjustment";

    public ExportOptionsPanel(boolean isExperiment) {
        this.setLayout(new GridBagLayout());
        if (isExperiment) {
            this.selectedGradient_ = this.instantiateSelectedGradient();
            this.thresholdClustering_ = this.instantiateThresholdClustering();
            this.add((Component)new JLabel("Gradient adjustment (optional): "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 0, 0, 0), 0, 0));
            this.add(this.selectedGradient_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("Time tolerance: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 0, 0, 0), 0, 0));
            this.add((Component)this.thresholdClustering_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(25, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(" sec"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 0, 0, 0), 0, 0));
        }
    }

    private JTextField instantiateThresholdClustering() {
        JTextField field = new JTextField(DEFAULT_THRESHOLD.toString(), 5);
        field.setInputVerifier(new DoubleVerifier(true, true));
        field.setHorizontalAlignment(4);
        return field;
    }

    private JComboBox<String> instantiateSelectedGradient() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (String gradient : this.getGradientsFiles().keySet()) {
            jComboBox.addItem(gradient);
        }
        jComboBox.addItem(NO_ADJUSTMENT);
        return jComboBox;
    }

    private LinkedHashMap<String, File> getGradientsFiles() {
        File gradientsDir = new File(DEFAULT_GRADIENTS_DIR);
        if (!gradientsDir.exists()) {
            return null;
        }
        File[] files = gradientsDir.listFiles();
        LinkedHashMap<String, File> gradientFiles = new LinkedHashMap<String, File>();
        for (int i = 0; i != files.length; ++i) {
            String fileName = StaticUtils.extractFileName(files[i].getAbsolutePath());
            if (!fileName.endsWith(EXCEL_SUFFIX) || fileName.startsWith("~$")) continue;
            String gradientName = fileName.substring(0, fileName.indexOf(EXCEL_SUFFIX));
            gradientFiles.put(gradientName, files[i]);
        }
        return gradientFiles;
    }

    public File getSelectedGradient() {
        File selected = null;
        if (!this.selectedGradient_.getSelectedItem().equals(NO_ADJUSTMENT)) {
            LinkedHashMap<String, File> gradientsFiles = this.getGradientsFiles();
            selected = gradientsFiles.get(this.selectedGradient_.getSelectedItem());
        }
        return selected;
    }

    public Double getSelectedClustering() {
        return Double.parseDouble(this.thresholdClustering_.getText());
    }

    public boolean isGradientSelected() {
        return !this.selectedGradient_.getSelectedItem().equals(NO_ADJUSTMENT);
    }
}

