/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.experiment;

import at.tugraz.genome.lda.lccl.JDefaultComponents;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.JTargetFileWizard;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExperimentFileChooserPanel
extends JOptionPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Path previousSelection_ = null;
    private static final String COMMAND_ADD_FILES = "Add Files";
    private static final String COMMAND_ADD_FOLDER = "Add Folder";
    private static final String COMMAND_REMOVE_FILE = "Remove";
    private static final String COMMAND_REMOVE_ALL = "Remove all";
    private static final Dimension BUTTON_PANEL_DIMENSION = new Dimension(825, 35);
    private static final Dimension TABLE_PANEL_DIMENSION = new Dimension(825, 300);
    private ImageIcon addFilesIcon_ = new ImageIcon(this.getClass().getResource("/images/addFiles.gif"));
    private ImageIcon addFolderIcon_ = new ImageIcon(this.getClass().getResource("/images/addFromFolder.gif"));
    private ImageIcon removeIcon_ = new ImageIcon(this.getClass().getResource("/images/removeFiles.gif"));
    private Vector<File> uniqueFiles_ = new Vector();
    JPanel selectionTablePanel_;
    JScrollPane scrollPane_;
    JTable displayTable_;

    public ExperimentFileChooserPanel(JDefaultComponents wizardComponents, String title, String frameTitle) {
        super(wizardComponents, title);
        this.init(frameTitle);
    }

    private void init(String frameTitle) {
        JPanel buttonPanel = this.instantiateButtonPanel();
        this.selectionTablePanel_ = new JPanel();
        this.generateSelectionTablePanel(new String[0][0]);
        JPanel inputPanel = this.instantiatePanel(buttonPanel, this.selectionTablePanel_, frameTitle);
        this.add((Component)inputPanel, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel instantiatePanel(JPanel buttonPanel, JPanel selectionTablePanel, String borderTitle) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)buttonPanel, this.getDefaultGridBagConstraints(0, 0));
        panel.add((Component)selectionTablePanel, this.getDefaultGridBagConstraints(0, 1));
        panel.setBorder(ExperimentFileChooserPanel.getTitledPanelBorder(borderTitle));
        return panel;
    }

    private JPanel instantiateButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.setPreferredSize(BUTTON_PANEL_DIMENSION);
        JButton buttonAddFiles = this.instantiateJButton(COMMAND_ADD_FILES, COMMAND_ADD_FILES, this.addFilesIcon_);
        buttonPanel.add((Component)buttonAddFiles, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, -2, 2, 0), 0, 0));
        JButton buttonAddFolder = this.instantiateJButton(COMMAND_ADD_FOLDER, COMMAND_ADD_FOLDER, this.addFolderIcon_);
        buttonPanel.add((Component)buttonAddFolder, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
        JButton buttonRemoveFile = this.instantiateJButton(COMMAND_REMOVE_FILE, COMMAND_REMOVE_FILE, this.removeIcon_);
        buttonPanel.add((Component)buttonRemoveFile, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
        JButton buttonRemoveAll = this.instantiateJButton(COMMAND_REMOVE_ALL, COMMAND_REMOVE_ALL, this.removeIcon_);
        buttonPanel.add((Component)buttonRemoveAll, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
        return buttonPanel;
    }

    private void generateSelectionTablePanel(String[][] tableData) {
        Object[] columnNames = new String[]{"File Name", "Directory"};
        this.displayTable_ = new JTable(tableData, columnNames);
        this.scrollPane_ = new JScrollPane(this.displayTable_);
        this.displayTable_.setSelectionMode(2);
        this.scrollPane_.setPreferredSize(TABLE_PANEL_DIMENSION);
        this.selectionTablePanel_.add(this.scrollPane_);
    }

    private void updateSelectionTable() {
        this.selectionTablePanel_.remove(this.scrollPane_);
        String[][] tableData = new String[this.uniqueFiles_.size()][2];
        int count = 0;
        for (File file : this.uniqueFiles_) {
            String fileName = StaticUtils.extractFileName(file.getAbsolutePath());
            String dir = StaticUtils.extractDirName(file.getAbsolutePath());
            tableData[count][0] = fileName;
            tableData[count][1] = dir;
            ++count;
        }
        this.generateSelectionTablePanel(tableData);
        this.selectionTablePanel_.invalidate();
        this.selectionTablePanel_.updateUI();
    }

    private JButton instantiateJButton(String command, String title, ImageIcon imageIcon) {
        JButton button = new JButton(title, imageIcon);
        button.addActionListener(this);
        button.setActionCommand(command);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        switch (arg0.getActionCommand()) {
            case "Add Files": {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Only .xlsx", "xlsx");
                this.selectPath(filter, "Select a LDA result file (.xlsx file)");
                break;
            }
            case "Add Folder": {
                this.selectFolder("Select a folder containing LDA result files (.xlsx files)");
                break;
            }
            case "Remove": {
                this.removeFiles();
                break;
            }
            case "Remove all": {
                this.removeAllFiles();
                break;
            }
        }
    }

    private void removeFiles() {
        int[] selectedRows;
        if (this.uniqueFiles_ != null && (selectedRows = this.displayTable_.getSelectedRows()).length > 0) {
            ArrayList<Integer> selectedList = new ArrayList<Integer>();
            for (int i = 0; i != selectedRows.length; ++i) {
                selectedList.add(selectedRows[i]);
            }
            Collections.sort(selectedList);
            Vector<File> filesToRemove = new Vector<File>();
            for (int i = selectedList.size() - 1; i != -1; --i) {
                filesToRemove.add(this.uniqueFiles_.get((Integer)selectedList.get(i)));
                this.uniqueFiles_.remove((Integer)selectedList.get(i));
            }
            this.updateSelectionTable();
        }
    }

    private void removeAllFiles() {
        this.uniqueFiles_ = new Vector();
        this.updateSelectionTable();
    }

    private void selectFolder(String title) {
        int val;
        JFileChooser chooser = new JFileChooser();
        chooser.setPreferredSize(JTargetFileWizard.DEFAULT_FILE_CHOOSER_DIMENSION);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(title);
        if (this.previousSelection_ != null) {
            chooser.setCurrentDirectory(this.previousSelection_.getParent().toFile());
        }
        if ((val = chooser.showOpenDialog(new JFrame())) == 0) {
            Hashtable<String, File> avoidDuplicates = new Hashtable<String, File>();
            for (File file : this.uniqueFiles_) {
                avoidDuplicates.put(file.getAbsolutePath(), file);
            }
            File folder = new File(chooser.getSelectedFile().getAbsolutePath());
            if (folder.exists() && folder.isDirectory()) {
                File[] fileCandidates = folder.listFiles();
                for (int i = 0; i != fileCandidates.length; ++i) {
                    if (!fileCandidates[i].isFile() || avoidDuplicates.containsKey(fileCandidates[i].getAbsolutePath())) continue;
                    this.previousSelection_ = Paths.get(fileCandidates[i].getAbsolutePath(), new String[0]);
                    String fileName = StaticUtils.extractFileName(fileCandidates[i].getAbsolutePath());
                    String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                    if (!suffix.equalsIgnoreCase("xlsx") || fileName.startsWith("~$")) continue;
                    avoidDuplicates.put(fileCandidates[i].getAbsolutePath(), fileCandidates[i]);
                    this.uniqueFiles_.add(fileCandidates[i]);
                }
            }
            if (avoidDuplicates.size() > 0) {
                this.updateSelectionTable();
            }
        } else {
            return;
        }
    }

    private void selectPath(FileNameExtensionFilter filter, String title) {
        int val;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(filter);
        chooser.setPreferredSize(JTargetFileWizard.DEFAULT_FILE_CHOOSER_DIMENSION);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(title);
        if (this.previousSelection_ != null) {
            chooser.setCurrentDirectory(this.previousSelection_.getParent().toFile());
        }
        if ((val = chooser.showOpenDialog(new JFrame())) == 0) {
            Hashtable<String, File> avoidDuplicates = new Hashtable<String, File>();
            for (File file : this.uniqueFiles_) {
                avoidDuplicates.put(file.getAbsolutePath(), file);
            }
            File[] fileCandidates = chooser.getSelectedFiles();
            for (int i = 0; i != fileCandidates.length; ++i) {
                this.previousSelection_ = Paths.get(fileCandidates[i].getAbsolutePath(), new String[0]);
                if (!fileCandidates[i].isFile() || avoidDuplicates.containsKey(fileCandidates[i].getAbsolutePath())) continue;
                avoidDuplicates.put(fileCandidates[i].getAbsolutePath(), fileCandidates[i]);
                this.uniqueFiles_.add(fileCandidates[i]);
            }
            if (avoidDuplicates.size() > 0) {
                this.updateSelectionTable();
            }
        } else {
            return;
        }
    }

    private GridBagConstraints getDefaultGridBagConstraints(int column, int row) {
        return new GridBagConstraints(column, row, 6, 1, 0.0, 0.0, 13, 0, new Insets(10, 6, 0, 0), 0, 10);
    }

    protected Vector<File> getFiles() {
        return this.uniqueFiles_;
    }
}

