/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.calibration;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.calibration.CalibrationGraphPanel;
import at.tugraz.genome.lda.lccl.calibration.SubGroup;
import at.tugraz.genome.lda.verifier.StringVerifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SubgroupDefinitionPanel
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Define groups of lipid classes for combined RT-mapping";
    private static final String BUTTON_CANCEL = "Cancel";
    private static final String BUTTON_SAVE_RETURN = "Save and Close";
    private CalibrationGraphPanel parent_;
    private ArrayList<SubGroup> definedSubgroups_;
    private ArrayList<String> usedLipidClasses_;
    private ArrayList<String> ungroupedLipidClasses_;
    private DefaultTableModel defineNewTableModel_;
    private JTextField groupNameField_;
    private JPanel definedGroupsPanel_;
    private JPanel defineNewGroupPanel_;
    private JPanel contentsPanel_;

    public SubgroupDefinitionPanel(ArrayList<SubGroup> definedSubgroups, String[] displayedLipidClasses, CalibrationGraphPanel parent) {
        super(TITLE);
        this.parent_ = parent;
        this.definedSubgroups_ = definedSubgroups;
        this.usedLipidClasses_ = new ArrayList();
        for (SubGroup subGroup : this.definedSubgroups_) {
            this.usedLipidClasses_.addAll(subGroup.getLipidClasses());
        }
        this.ungroupedLipidClasses_ = new ArrayList();
        for (int i = 0; i < displayedLipidClasses.length; ++i) {
            if (this.usedLipidClasses_.contains(displayedLipidClasses[i]) || displayedLipidClasses[i].equals("Combined")) continue;
            this.ungroupedLipidClasses_.add(displayedLipidClasses[i]);
        }
        this.contentsPanel_ = new JPanel();
        this.contentsPanel_.setLayout(new GridBagLayout());
        this.add(this.contentsPanel_);
        this.initDefinedGroupsPanel();
        this.initDefineNewGroupPanel();
        this.initButtonPanel();
        this.setLocationRelativeTo(this.parent_);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SubgroupDefinitionPanel.this.cancel_actionPerformed(new ActionEvent(e, 0, ""));
            }
        });
        this.setSize(950, 850);
        this.setVisible(true);
    }

    private void initButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton cancelButton = new JButton(BUTTON_CANCEL);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubgroupDefinitionPanel.this.cancel_actionPerformed(e);
            }
        });
        panel.add((Component)cancelButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 265), 0, 0));
        JButton saveCloseButton = new JButton(BUTTON_SAVE_RETURN);
        saveCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubgroupDefinitionPanel.this.saveClose_actionPerformed(e);
            }
        });
        panel.add((Component)saveCloseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 265, 0, 0), 0, 0));
        this.contentsPanel_.add((Component)panel, new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 10, 0, new Insets(50, 25, 0, 25), 0, 0));
    }

    private void cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.definedSubgroups_ = new ArrayList();
        this.dispose();
    }

    private void saveClose_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.parent_.removeSubGroupRegressions();
        this.parent_.addSubGroupRegressions(this.getDefinedSubgroups());
        this.parent_.updateClassListJComboBox();
        this.parent_.showViewOfChoice();
        this.dispose();
    }

    private void initDefinedGroupsPanel() {
        this.definedGroupsPanel_ = new JPanel();
        this.definedGroupsPanel_.setLayout(new GridBagLayout());
        if (this.definedSubgroups_.isEmpty()) {
            JLabel label = new JLabel("No subgroups have been defined.");
            label.setPreferredSize(new Dimension(663, 50));
            label.setMinimumSize(label.getPreferredSize());
            this.definedGroupsPanel_.add((Component)label, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 0, new Insets(25, 25, 25, 25), 0, 0));
        } else {
            JTable table = new JTable(this.initDefinedGroupsTableModel());
            table.getColumnModel().getColumn(1).setCellEditor(new RemoveActionEditor());
            table.getColumnModel().getColumn(1).setCellRenderer(new RemoveActionRenderer());
            JScrollPane pane = new JScrollPane(table);
            pane.setPreferredSize(new Dimension(700, 125));
            pane.setMinimumSize(pane.getPreferredSize());
            this.definedGroupsPanel_.add((Component)pane, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.definedGroupsPanel_.setBorder(JOptionPanel.getTitledPanelBorder("Current groups"));
        this.contentsPanel_.add((Component)this.definedGroupsPanel_, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 0, new Insets(10, 25, 0, 25), 0, 0));
    }

    private void removeSubgroup(SubGroup subGroup) {
        this.definedSubgroups_.remove(subGroup);
        this.usedLipidClasses_.removeAll(subGroup.getLipidClasses());
        this.ungroupedLipidClasses_.addAll(subGroup.getLipidClasses());
        this.contentsPanel_.remove(this.definedGroupsPanel_);
        this.contentsPanel_.remove(this.defineNewGroupPanel_);
        this.initDefinedGroupsPanel();
        this.initDefineNewGroupPanel();
        this.contentsPanel_.invalidate();
        this.contentsPanel_.updateUI();
    }

    private void initDefineNewGroupPanel() {
        this.defineNewGroupPanel_ = new JPanel();
        this.defineNewGroupPanel_.setLayout(new GridBagLayout());
        this.initDefineNewTableModel();
        JScrollPane pane = new JScrollPane(new JTable(this.defineNewTableModel_));
        pane.setPreferredSize(new Dimension(450, 300));
        pane.setMinimumSize(pane.getPreferredSize());
        this.defineNewGroupPanel_.add((Component)pane, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JSeparator verticalSeparator = new JSeparator(1);
        verticalSeparator.setPreferredSize(new Dimension(10, (int)pane.getPreferredSize().getHeight()));
        verticalSeparator.setMinimumSize(verticalSeparator.getPreferredSize());
        verticalSeparator.setForeground(new Color(105, 123, 140));
        this.defineNewGroupPanel_.add((Component)verticalSeparator, new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JLabel label = new JLabel("Group name: ");
        this.defineNewGroupPanel_.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.groupNameField_ = new JTextField(20);
        this.groupNameField_.setInputVerifier(new StringVerifier(1, 20, "Group name: "));
        this.groupNameField_.setMinimumSize(this.groupNameField_.getPreferredSize());
        this.defineNewGroupPanel_.add((Component)this.groupNameField_, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        JButton button = new JButton("Save Group");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubgroupDefinitionPanel.this.saveSubgroup_actionPerformed(e);
            }
        });
        this.defineNewGroupPanel_.add((Component)button, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.defineNewGroupPanel_.setBorder(JOptionPanel.getTitledPanelBorder("Define new group"));
        this.contentsPanel_.add((Component)this.defineNewGroupPanel_, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 10, 0, new Insets(25, 25, 25, 25), 0, 0));
    }

    private DefaultTableModel initDefinedGroupsTableModel() {
        String[] headers = new String[]{"Defined groups ", "Actions"};
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                switch (column) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        };
        for (String header : headers) {
            model.addColumn(header);
        }
        for (SubGroup definedSubgroup : this.definedSubgroups_) {
            Object[] row = new Object[]{definedSubgroup.getId(), new RemoveAction(false, definedSubgroup, this)};
            model.addRow(row);
        }
        return model;
    }

    private void initDefineNewTableModel() {
        String[] headers = new String[]{"Ungrouped lipid classes", "Selected"};
        this.defineNewTableModel_ = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                switch (column) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 1: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        for (String header : headers) {
            this.defineNewTableModel_.addColumn(header);
        }
        for (String ungrouped : this.ungroupedLipidClasses_) {
            Object[] row = new Object[]{ungrouped, false};
            this.defineNewTableModel_.addRow(row);
        }
    }

    private void saveSubgroup_actionPerformed(ActionEvent e) {
        ArrayList<String> lipidClasses = new ArrayList<String>();
        String groupName = this.groupNameField_.getText();
        for (int i = 0; i < this.defineNewTableModel_.getRowCount(); ++i) {
            if (!((Boolean)this.defineNewTableModel_.getValueAt(i, 1)).booleanValue()) continue;
            lipidClasses.add((String)this.defineNewTableModel_.getValueAt(i, 0));
        }
        if (groupName.length() > 0 && !this.isGroupNameTaken(groupName) && lipidClasses.size() > 1) {
            this.definedSubgroups_.add(new SubGroup(groupName, lipidClasses));
            this.usedLipidClasses_.addAll(lipidClasses);
            this.ungroupedLipidClasses_.removeAll(lipidClasses);
            this.contentsPanel_.remove(this.definedGroupsPanel_);
            this.contentsPanel_.remove(this.defineNewGroupPanel_);
            this.initDefinedGroupsPanel();
            this.initDefineNewGroupPanel();
            this.contentsPanel_.invalidate();
            this.contentsPanel_.updateUI();
        } else {
            new WarningMessage(new JFrame(), "Error", "A unique group name must be defined and at least 2 lipid classes must be selected to proceed!");
        }
    }

    private boolean isGroupNameTaken(String groupName) {
        for (SubGroup group : this.definedSubgroups_) {
            if (!group.getGroupName().equals(groupName)) continue;
            return true;
        }
        for (String name : this.usedLipidClasses_) {
            if (!name.equals(groupName)) continue;
            return true;
        }
        for (String name : this.ungroupedLipidClasses_) {
            if (!name.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<SubGroup> getDefinedSubgroups() {
        return this.definedSubgroups_;
    }

    public ArrayList<String> getUsedLipidClasses() {
        return this.usedLipidClasses_;
    }

    public ArrayList<String> getUngroupedLipidClasses() {
        Collections.sort(this.ungroupedLipidClasses_);
        return this.ungroupedLipidClasses_;
    }

    private class RemoveAction {
        private Boolean selected_;
        private SubGroup subGroup_;
        private SubgroupDefinitionPanel parent_;

        public RemoveAction(Boolean selected, SubGroup subGroup, SubgroupDefinitionPanel parent) {
            this.selected_ = selected;
            this.subGroup_ = subGroup;
            this.parent_ = parent;
        }

        public Boolean getSelected() {
            return this.selected_;
        }

        public void setSelected(Boolean selected) {
            this.selected_ = selected;
        }

        public SubGroup getSubGroup() {
            return this.subGroup_;
        }

        public SubgroupDefinitionPanel getParent() {
            return this.parent_;
        }
    }

    private class RemoveActionEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private RemoveActionRenderer renderer_;
        private RemoveAction action_;

        public RemoveActionEditor() {
            this.renderer_ = new RemoveActionRenderer();
            this.action_ = null;
            this.renderer_.addItemListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            this.action_.setSelected(this.renderer_.isSelected());
            return this.action_;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.action_ = (RemoveAction)value;
            this.renderer_.setSelected(this.action_.getSelected());
            this.renderer_.setText("Remove");
            return this.renderer_;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.fireEditingStopped();
        }
    }

    private class RemoveActionRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private RemoveActionRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            RemoveAction action = (RemoveAction)value;
            this.setSelected(action.getSelected());
            this.setText("Remove");
            if (action.getSelected().booleanValue()) {
                DefaultTableModel model = (DefaultTableModel)table.getModel();
                model.removeRow(row);
                action.getParent().removeSubgroup(action.getSubGroup());
            }
            return this;
        }
    }
}

