/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.calibration;

import at.tugraz.genome.lda.lccl.calibration.AnchorPointVO;
import at.tugraz.genome.lda.lccl.calibration.CalibrationGraphPanel;
import at.tugraz.genome.lda.lccl.calibration.RecalibrationPlotMouseListener;
import at.tugraz.genome.lda.lccl.calibration.RecalibrationRegression;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.function.Function2D;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RecalibrationPlot
extends JPanel {
    private static final long serialVersionUID = 1L;
    ArrayList<AnchorPointVO> dataAll_;
    ArrayList<AnchorPointVO> dataStandards_;
    CalibrationGraphPanel panel_;
    XYPlot plot_;
    XYDataset curveFitDataset_;
    XYDataset scatterPlotStandardsDataset_;
    XYDataset scatterPlotDataset_;

    public RecalibrationPlot(ArrayList<AnchorPointVO> data, ArrayList<AnchorPointVO> dataStandards, RecalibrationRegression regression, Dimension dimension, CalibrationGraphPanel panel, XYPlot previousPlot) {
        this.dataAll_ = new ArrayList<AnchorPointVO>(data);
        this.dataStandards_ = dataStandards;
        this.panel_ = panel;
        this.dataAll_.removeAll(this.dataStandards_);
        this.plot_ = new XYPlot();
        Font fontTitle = new Font("Dialog", 1, 25);
        Font fontLabel = new Font("Dialog", 0, 20);
        Font tickLabel = new Font("Dialog", 0, 14);
        this.plot_.setDomainAxis(0, this.getAxis("Retention time original RT-DB /min", fontLabel, tickLabel));
        this.plot_.setRangeAxis(0, this.getAxis("Retention time difference original vs new RT-DB /min", fontLabel, tickLabel));
        if (previousPlot != null) {
            this.copyAxisRanges(this.plot_, previousPlot);
        }
        this.plot_.mapDatasetToDomainAxis(0, 0);
        this.plot_.mapDatasetToRangeAxis(0, 0);
        this.curveFitDataset_ = this.getCurveFitDataset(regression);
        this.plot_.setDataset(0, this.curveFitDataset_);
        this.plot_.setRenderer(0, this.getCurveRenderer(fontLabel));
        this.scatterPlotStandardsDataset_ = this.getScatterPlotDataset(this.dataStandards_, String.format("Standards (%s calibrants)", this.dataStandards_.size()));
        this.plot_.setDataset(1, this.scatterPlotStandardsDataset_);
        this.plot_.setRenderer(1, this.getScatterRenderer(fontLabel, new Color(204, 0, 0)));
        this.scatterPlotDataset_ = this.getScatterPlotDataset(this.dataAll_, String.format("Other (%s calibrants)", this.dataAll_.size()));
        this.plot_.setDataset(2, this.scatterPlotDataset_);
        this.plot_.setRenderer(2, this.getScatterRenderer(fontLabel, new Color(153, 204, 255)));
        JFreeChart chart = new JFreeChart("RT-DB mapping", fontTitle, this.plot_, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.addChartMouseListener(new RecalibrationPlotMouseListener(this));
        chartPanel.setPreferredSize(dimension);
        this.add(chartPanel);
    }

    private void copyAxisRanges(XYPlot plot, XYPlot previousPlot) {
        ValueAxis domainAxis = plot.getDomainAxis();
        ValueAxis previousDomainAxis = previousPlot.getDomainAxis();
        ValueAxis rangeAxis = plot.getRangeAxis();
        ValueAxis previousRangeAxis = previousPlot.getRangeAxis();
        if (!previousDomainAxis.isAutoRange()) {
            domainAxis.setAutoRange(false);
            domainAxis.setRange(previousDomainAxis.getRange());
        }
        if (!previousRangeAxis.isAutoRange()) {
            rangeAxis.setAutoRange(false);
            rangeAxis.setRange(previousRangeAxis.getRange());
        }
    }

    private NumberAxis getAxis(String label, Font fontLabel, Font tickLabel) {
        NumberAxis axis = new NumberAxis(label);
        axis.setLabelFont(fontLabel);
        axis.setTickLabelFont(tickLabel);
        return axis;
    }

    private XYLineAndShapeRenderer getCurveRenderer(Font fontLabel) {
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setSeriesPaint(0, new Color(0, 0, 102));
        renderer.setSeriesPaint(1, new Color(0, 0, 102));
        renderer.setDefaultLegendTextFont(fontLabel);
        renderer.setAutoPopulateSeriesStroke(false);
        renderer.setDefaultStroke(new BasicStroke(2.0f));
        return renderer;
    }

    private XYDataset getCurveFitDataset(RecalibrationRegression regression) {
        int num = 10000;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries dataSeries = new XYSeries((Comparable)((Object)"Fit"));
        double upperLimit = regression.getUpperRTLimit();
        double lowerLimit = regression.getLowerRTLimit();
        double step = (upperLimit - lowerLimit) / (double)num;
        for (int i = 0; i <= num; ++i) {
            double x = lowerLimit + (double)i * step;
            if (!regression.getFunction().isValidPoint(x)) continue;
            double y = regression.getFunction().value(x);
            dataSeries.add(x, y);
        }
        dataset.addSeries(dataSeries);
        return dataset;
    }

    public static XYSeries sampleFunctionOverY(Function2D f, double start, double end, int samples, Comparable<?> seriesKey) {
        XYSeries series = new XYSeries(seriesKey, false);
        double step = (end - start) / (double)(samples - 1);
        for (int i = 0; i < samples; ++i) {
            double y = start + step * (double)i;
            series.add(f.getValue(y), y);
        }
        return series;
    }

    private XYLineAndShapeRenderer getScatterRenderer(Font fontLabel, Color fillPaint) {
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
        renderer.setDefaultLegendTextFont(fontLabel);
        renderer.setDefaultFillPaint(fillPaint);
        renderer.setDefaultOutlinePaint(new Color(64, 64, 64));
        renderer.setUseFillPaint(true);
        renderer.setUseOutlinePaint(true);
        renderer.setSeriesShape(0, ShapeUtils.createDiamond(5.0f));
        return renderer;
    }

    private XYDataset getScatterPlotDataset(ArrayList<AnchorPointVO> data, String label) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries dataSeries = new XYSeries((Comparable)((Object)label));
        for (AnchorPointVO dataPoint : data) {
            dataSeries.add(dataPoint.getxValue(), (Number)dataPoint.getyValue());
        }
        dataset.addSeries(dataSeries);
        return dataset;
    }

    public ArrayList<AnchorPointVO> getDataAll() {
        return this.dataAll_;
    }

    public ArrayList<AnchorPointVO> getDataStandards() {
        return this.dataStandards_;
    }

    public CalibrationGraphPanel getPanel() {
        return this.panel_;
    }

    public XYDataset getCurveFitDataset() {
        return this.curveFitDataset_;
    }

    public XYDataset getScatterPlotStandardsDataset() {
        return this.scatterPlotStandardsDataset_;
    }

    public XYDataset getScatterPlotDataset() {
        return this.scatterPlotDataset_;
    }

    public XYPlot getXYPlot() {
        return this.plot_;
    }
}

