/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.calibration;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.lccl.JDefaultComponents;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.LoadingPanel;
import at.tugraz.genome.lda.lccl.calibration.AnchorPointVO;
import at.tugraz.genome.lda.lccl.calibration.IdentificationVO;
import at.tugraz.genome.lda.lccl.calibration.MatchedIdentificationVO;
import at.tugraz.genome.lda.lccl.calibration.RecalibrationPlot;
import at.tugraz.genome.lda.lccl.calibration.RecalibrationRegression;
import at.tugraz.genome.lda.lccl.calibration.SubGroup;
import at.tugraz.genome.lda.lccl.calibration.SubgroupDefinitionPanel;
import at.tugraz.genome.lda.lccl.export.ExportPanel;
import at.tugraz.genome.lda.lccl.export.TargetListExporter;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.apache.commons.math3.util.Pair;

public class CalibrationGraphPanel
extends JOptionPanel {
    private static final long serialVersionUID = 1L;
    private LoadingPanel loadingPanel_;
    private JPanel displayPanel_;
    private String[] lipidClasses_ = new String[0];
    private SubgroupDefinitionPanel subGroupDefinitionPanel_;
    private JComboBox<String> classListJComboBox_;
    private JPanel jComboBoxPanel_;
    private JCheckBox classSpecificJCheckBox_;
    private JButton defineSubgroupsJButton_;
    private JSlider granularityJSlider_;
    private Double grouping_;
    private RecalibrationPlot plot_;
    private ArrayList<RecalibrationRegression> regressions_;
    private File originalTargetList_;
    private Double predictionThreshold_;
    private String matchingAlgo_;
    public static final String PLOT_ALL = "Combined";
    private static final Dimension PLOT_DIMENSION = new Dimension(825, 650);
    private static final String TABLE_FRAME_TITLE = "RT-DB mapping";

    public CalibrationGraphPanel(JDefaultComponents wizardComponents) {
        super(wizardComponents, "Map a RT-DB to your chromatographic conditions.");
        this.init(this.generateLoadingPanel());
    }

    protected void init(JPanel panel) {
        this.grouping_ = 1.0;
        this.add((Component)panel, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.invalidate();
        this.updateUI();
    }

    public void initDataDisplay() {
        this.cleanPanels();
        this.getDefaultComponents().updateComponents();
        this.init(this.generateDisplayPanel());
    }

    protected JPanel generateLoadingPanel() {
        this.loadingPanel_ = new LoadingPanel("<html>Processing data, please wait...</html>");
        return this.loadingPanel_;
    }

    protected JPanel generateDisplayPanel() {
        this.displayPanel_ = new JPanel();
        this.displayPanel_.setLayout(new GridBagLayout());
        this.initClassSpecificJCheckBox();
        this.initClassListJComboBox();
        this.initGranularityJSlider();
        this.initPlot();
        this.displayPanel_.setBorder(CalibrationGraphPanel.getTitledPanelBorder(TABLE_FRAME_TITLE));
        return this.displayPanel_;
    }

    private void initClassSpecificJCheckBox() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.classSpecificJCheckBox_ = new JCheckBox("Map lipid classes individually.", true);
        this.classSpecificJCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalibrationGraphPanel.this.classSpecificJCheckBox_actionPerformed(e);
            }
        });
        panel.add((Component)this.classSpecificJCheckBox_, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.defineSubgroupsJButton_ = new JButton("Define Groups");
        this.defineSubgroupsJButton_.setEnabled(this.classSpecificJCheckBox_.isSelected());
        this.defineSubgroupsJButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalibrationGraphPanel.this.defineSubgroupsJButton_actionPerformed(e);
            }
        });
        panel.add((Component)this.defineSubgroupsJButton_, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.addToDisplayPanel(panel, new GridBagConstraints(10, 0, 0, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initClassListJComboBox() {
        this.jComboBoxPanel_ = new JPanel();
        this.jComboBoxPanel_.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Select displayed lipid class / group: ");
        this.jComboBoxPanel_.add((Component)label, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.initClassListJComboBox(this.lipidClasses_);
        this.addToDisplayPanel(this.jComboBoxPanel_, new GridBagConstraints(0, 0, 0, 2, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 5), 0, 0));
    }

    private void initClassListJComboBox(String[] toDisplay) {
        this.classListJComboBox_ = new JComboBox<String>(toDisplay);
        this.classListJComboBox_.setSelectedIndex(0);
        this.classListJComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalibrationGraphPanel.this.classListJComboBox_actionPerformed(e);
            }
        });
        this.jComboBoxPanel_.add(this.classListJComboBox_, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void initGranularityJSlider() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Granularity of fit:");
        panel.add((Component)label, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        JSlider slider = new JSlider(0, 100, 50);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> position = new Hashtable<Integer, JLabel>();
        position.put(0, new JLabel("0%"));
        position.put(50, new JLabel("50%"));
        position.put(100, new JLabel("100%"));
        slider.setLabelTable(position);
        slider.setPaintLabels(true);
        slider.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int max = 100;
                Double maxMinutes = 2.0;
                Double minMinutes = 0.2;
                int value = ((JSlider)e.getSource()).getValue();
                int diff = max - value;
                CalibrationGraphPanel.this.grouping_ = maxMinutes * (double)diff / (double)max;
                if (CalibrationGraphPanel.this.grouping_ < minMinutes) {
                    CalibrationGraphPanel.this.grouping_ = minMinutes;
                }
                System.out.println(CalibrationGraphPanel.this.grouping_ + " value: " + value);
                CalibrationGraphPanel.this.showViewOfChoice();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.granularityJSlider_ = slider;
        panel.add((Component)this.granularityJSlider_, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.addToDisplayPanel(panel, new GridBagConstraints(5, 0, 10, 2, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initPlot() {
        RecalibrationRegression regression = this.getRegressionByFields(PLOT_ALL, PLOT_ALL);
        ArrayList<AnchorPointVO> data = regression == null ? new ArrayList<AnchorPointVO>() : regression.getDifferences();
        RecalibrationRegression regressionStandards = this.getRegressionByFields("standards", PLOT_ALL);
        ArrayList<AnchorPointVO> dataStandards = regressionStandards == null ? new ArrayList<AnchorPointVO>() : regressionStandards.getDifferences();
        this.plot_ = new RecalibrationPlot(data, dataStandards, regression, PLOT_DIMENSION, this, null);
        this.addPlotToDisplayPanel();
    }

    private void addPlotToDisplayPanel() {
        this.addToDisplayPanel(this.plot_, new GridBagConstraints(0, 3, 15, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 5, 5), 0, 0));
    }

    private void addToDisplayPanel(JComponent component, GridBagConstraints constraints) {
        this.displayPanel_.add((Component)component, constraints);
    }

    private void cleanPanels() {
        if (this.loadingPanel_ != null) {
            this.remove(this.loadingPanel_);
            this.loadingPanel_ = null;
        }
        if (this.displayPanel_ != null) {
            this.remove(this.displayPanel_);
            this.displayPanel_ = null;
        }
        this.subGroupDefinitionPanel_ = null;
    }

    public void showViewOfChoice() {
        String selectedItem = (String)this.classListJComboBox_.getSelectedItem();
        this.updatePlot(selectedItem);
    }

    private void classListJComboBox_actionPerformed(ActionEvent e) {
        this.showViewOfChoice();
    }

    private void classSpecificJCheckBox_actionPerformed(ActionEvent e) {
        this.defineSubgroupsJButton_.setEnabled(this.classSpecificJCheckBox_.isSelected());
        this.updateClassListJComboBox();
    }

    public void updateClassListJComboBox() {
        this.jComboBoxPanel_.remove(this.classListJComboBox_);
        if (!this.classSpecificJCheckBox_.isSelected()) {
            this.initClassListJComboBox(new String[]{PLOT_ALL});
        } else if (this.subGroupDefinitionPanel_ != null) {
            int i;
            ArrayList<String> ungroupedLipidClasses = this.subGroupDefinitionPanel_.getUngroupedLipidClasses();
            ArrayList<SubGroup> subGroups = this.subGroupDefinitionPanel_.getDefinedSubgroups();
            String[] toDisplay = new String[ungroupedLipidClasses.size() + subGroups.size() + 1];
            toDisplay[0] = PLOT_ALL;
            for (i = 0; i < subGroups.size(); ++i) {
                toDisplay[i + 1] = subGroups.get(i).getGroupName();
            }
            for (i = 0; i < ungroupedLipidClasses.size(); ++i) {
                toDisplay[i + subGroups.size() + 1] = ungroupedLipidClasses.get(i);
            }
            this.jComboBoxPanel_.remove(this.classListJComboBox_);
            this.initClassListJComboBox(toDisplay);
        } else {
            this.initClassListJComboBox(this.lipidClasses_);
        }
        this.displayPanel_.invalidate();
        this.displayPanel_.updateUI();
    }

    public String getRelevantRegressionName(String cName) {
        if (this.subGroupDefinitionPanel_ != null) {
            for (String name : this.subGroupDefinitionPanel_.getUngroupedLipidClasses()) {
                if (!name.equals(cName)) continue;
                return cName;
            }
            for (SubGroup group : this.subGroupDefinitionPanel_.getDefinedSubgroups()) {
                for (String name : group.getLipidClasses()) {
                    if (!name.equals(cName)) continue;
                    return group.getGroupName();
                }
            }
        } else {
            for (int i = 0; i < this.lipidClasses_.length; ++i) {
                if (!cName.equals(this.lipidClasses_[i])) continue;
                return cName;
            }
        }
        return PLOT_ALL;
    }

    private void defineSubgroupsJButton_actionPerformed(ActionEvent e) {
        this.subGroupDefinitionPanel_ = new SubgroupDefinitionPanel(this.subGroupDefinitionPanel_ == null ? new ArrayList() : this.subGroupDefinitionPanel_.getDefinedSubgroups(), this.lipidClasses_, this);
    }

    public void removeSubGroupRegressions() {
        ArrayList<RecalibrationRegression> toRemove = new ArrayList<RecalibrationRegression>();
        for (SubGroup group : this.subGroupDefinitionPanel_.getDefinedSubgroups()) {
            for (RecalibrationRegression regression : this.regressions_) {
                if (!regression.getLipidClass().equals(group.getGroupName())) continue;
                toRemove.add(regression);
            }
        }
        this.regressions_.removeAll(toRemove);
    }

    public void addSubGroupRegressions(ArrayList<SubGroup> subGroups) {
        for (SubGroup group : subGroups) {
            ArrayList<AnchorPointVO> differencesStandards = new ArrayList<AnchorPointVO>();
            ArrayList<AnchorPointVO> differences = new ArrayList<AnchorPointVO>();
            for (String lipidClass : group.getLipidClasses()) {
                RecalibrationRegression regression;
                RecalibrationRegression regressionStandards = this.getRegressionByFields("standards", lipidClass);
                if (regressionStandards != null) {
                    differencesStandards.addAll(regressionStandards.getDifferences());
                }
                if ((regression = this.getRegressionByFields(PLOT_ALL, lipidClass)) == null) continue;
                differences.addAll(regression.getDifferences());
            }
            RecalibrationRegression regressionStandardsForGroup = new RecalibrationRegression(differencesStandards, this.grouping_, "standards", group.getGroupName());
            this.regressions_.add(regressionStandardsForGroup);
            RecalibrationRegression regressionForGroup = new RecalibrationRegression(differences, this.grouping_, PLOT_ALL, group.getGroupName());
            this.regressions_.add(regressionForGroup);
        }
        this.fillMissingDataPoints(this.regressions_);
    }

    private void updatePlot(String className) {
        this.displayPanel_.remove(this.plot_);
        for (RecalibrationRegression reg : this.regressions_) {
            reg.setGrouping(this.grouping_);
        }
        this.fillMissingDataPoints(this.regressions_);
        RecalibrationRegression regression = this.getRegressionByFields(PLOT_ALL, className);
        ArrayList<AnchorPointVO> data = regression == null ? new ArrayList<AnchorPointVO>() : regression.getDifferences();
        RecalibrationRegression regressionStandards = this.getRegressionByFields("standards", className);
        ArrayList<AnchorPointVO> dataStandards = regressionStandards == null ? new ArrayList<AnchorPointVO>() : regressionStandards.getDifferences();
        this.plot_ = new RecalibrationPlot(data, dataStandards, regression, PLOT_DIMENSION, this, this.plot_.getXYPlot());
        this.addPlotToDisplayPanel();
        this.displayPanel_.invalidate();
        this.displayPanel_.updateUI();
    }

    public void parseData(Hashtable<String, ArrayList<File>> originalConditions, Hashtable<String, ArrayList<File>> newConditions) throws ExcelInputFileException {
        this.regressions_ = new ArrayList();
        if (originalConditions.containsKey("standards") && newConditions.containsKey("standards")) {
            this.regressions_ = this.parseStandardMix(originalConditions.get("standards"), newConditions.get("standards"));
        }
        this.regressions_.addAll(this.parseAllResults(originalConditions, newConditions));
    }

    private ArrayList<RecalibrationRegression> parseStandardMix(ArrayList<File> originalMix, ArrayList<File> newMix) throws ExcelInputFileException {
        ArrayList<RecalibrationRegression> regressions = new ArrayList<RecalibrationRegression>();
        ArrayList<IdentificationVO> originalIdentifications = this.parseResultFiles(originalMix);
        ArrayList<IdentificationVO> newIdentifications = this.parseResultFiles(newMix);
        ArrayList<MatchedIdentificationVO> matches = this.computeMatches(originalIdentifications, originalMix.size(), newIdentifications, newMix.size());
        Hashtable<String, ArrayList<AnchorPointVO>> differencesForClass = this.computeDifferencesForClass(matches, 0);
        ArrayList<AnchorPointVO> differences = new ArrayList<AnchorPointVO>();
        this.lipidClasses_ = new String[differencesForClass.keySet().size()];
        int count = 0;
        Iterator<String> iterator = differencesForClass.keySet().iterator();
        while (iterator.hasNext()) {
            String lipidClass;
            this.lipidClasses_[count] = lipidClass = iterator.next();
            regressions.add(new RecalibrationRegression(differencesForClass.get(lipidClass), this.grouping_, "standards", lipidClass));
            differences.addAll((Collection<AnchorPointVO>)differencesForClass.get(lipidClass));
            ++count;
        }
        regressions.add(new RecalibrationRegression(differences, this.grouping_, "standards", PLOT_ALL));
        return regressions;
    }

    private ArrayList<RecalibrationRegression> parseAllResults(Hashtable<String, ArrayList<File>> originalConditions, Hashtable<String, ArrayList<File>> newConditions) throws ExcelInputFileException {
        ArrayList<RecalibrationRegression> regressions = new ArrayList<RecalibrationRegression>();
        ArrayList<MatchedIdentificationVO> matches = this.computeMatchesForDataTypeOther(originalConditions, newConditions);
        HashSet<String> uniqueLipidClasses = this.computeCombinedRegressionsPerClass(matches, regressions);
        this.fillMissingDataPoints(regressions);
        ArrayList<String> sortedLipidClasses = new ArrayList<String>(uniqueLipidClasses);
        Collections.sort(sortedLipidClasses);
        sortedLipidClasses.add(0, PLOT_ALL);
        this.lipidClasses_ = sortedLipidClasses.toArray(new String[sortedLipidClasses.size()]);
        return regressions;
    }

    private void fillMissingDataPoints(ArrayList<RecalibrationRegression> regressions) {
        RecalibrationRegression regressionCombined = this.getRegressionByFields(regressions, PLOT_ALL, PLOT_ALL);
        ArrayList<Pair<Double, Double>> clusteredCombined = regressionCombined.getClustered();
        Double minKey = regressionCombined.getClustered().get(0).getKey();
        Double maxKey = clusteredCombined.get(clusteredCombined.size() - 1).getKey();
        for (RecalibrationRegression regression : regressions) {
            if (regression.getLipidClass().equals(PLOT_ALL) || regression.getDataType().equals("standards")) continue;
            ArrayList<Pair<Double, Double>> clustered = regression.getClustered();
            ArrayList<Pair<Double, Double>> clusteredToAdd = new ArrayList<Pair<Double, Double>>();
            Double firstKey = clustered.get(0).getKey();
            Double lastKey = clustered.get(clustered.size() - 1).getKey();
            Double previousKey = firstKey;
            if (minKey < firstKey - this.grouping_ * 0.1) {
                clustered.add(0, regressionCombined.getClustered().get(0));
                previousKey = minKey;
            }
            if (maxKey > lastKey + this.grouping_ * 0.1) {
                clustered.add(clusteredCombined.get(clusteredCombined.size() - 1));
            }
            for (Pair<Double, Double> cluster : clustered) {
                Double currentKey = cluster.getKey();
                Double diff = currentKey - previousKey;
                if (diff >= this.grouping_ * 2.0) {
                    clusteredToAdd.addAll(this.getClusterInBetween(clusteredCombined, previousKey + this.grouping_ * 0.75, currentKey - this.grouping_ * 0.75));
                }
                previousKey = currentKey;
            }
            clustered.addAll(clusteredToAdd);
            Collections.sort(clustered, new Comparator<Pair<Double, Double>>(){

                @Override
                public int compare(Pair<Double, Double> p1, Pair<Double, Double> p2) {
                    return p1.getKey().compareTo(p2.getKey());
                }
            });
            regression.initRegression(clustered);
        }
    }

    private ArrayList<Pair<Double, Double>> getClusterInBetween(ArrayList<Pair<Double, Double>> clustered, Double before, Double after) {
        ArrayList<Pair<Double, Double>> clusteredInBetween = new ArrayList<Pair<Double, Double>>();
        for (Pair<Double, Double> cluster : clustered) {
            if (!(cluster.getKey() >= before) || !(cluster.getKey() <= after)) continue;
            clusteredInBetween.add(cluster);
        }
        return clusteredInBetween;
    }

    private HashSet<String> computeCombinedRegressionsPerClass(ArrayList<MatchedIdentificationVO> matches, ArrayList<RecalibrationRegression> regressions) {
        HashSet<String> uniqueLipidClasses = new HashSet<String>();
        Hashtable<String, ArrayList<AnchorPointVO>> differencesForClass = this.computeDifferencesForClass(matches, 1);
        ArrayList<AnchorPointVO> differencesAll = new ArrayList<AnchorPointVO>();
        for (String lipidClass : differencesForClass.keySet()) {
            this.addCombinedRegression(differencesForClass.get(lipidClass), lipidClass, uniqueLipidClasses, regressions);
            differencesAll.addAll((Collection<AnchorPointVO>)differencesForClass.get(lipidClass));
        }
        boolean allSuccessful = this.addCombinedRegression(differencesAll, PLOT_ALL, new HashSet<String>(), regressions);
        if (!allSuccessful) {
            new WarningMessage(new JFrame(), "Error", String.format("Not enough data points are available! Number of data points: %s. Please check your input data and the selected data types!", differencesAll.size()));
            this.back();
        }
        for (int i = 0; i < this.lipidClasses_.length; ++i) {
            if (uniqueLipidClasses.contains(this.lipidClasses_[i])) continue;
            this.addCombinedRegression(new ArrayList<AnchorPointVO>(), this.lipidClasses_[i], uniqueLipidClasses, regressions);
        }
        return uniqueLipidClasses;
    }

    private Hashtable<String, ArrayList<AnchorPointVO>> computeDifferencesForClass(ArrayList<MatchedIdentificationVO> matches, int acceptedConfidence) {
        Hashtable<String, ArrayList<AnchorPointVO>> differencesForClass = new Hashtable<String, ArrayList<AnchorPointVO>>();
        for (MatchedIdentificationVO match : matches) {
            if (match.getConfidence() < acceptedConfidence) continue;
            ArrayList<Object> acceptedMatches = new ArrayList<Pair<IdentificationVO, IdentificationVO>>();
            String lipidClass = match.getHighestConfidencePair().getKey().getLipidClass();
            if (match.getConfidence() < 2) {
                acceptedMatches.add(match.getHighestConfidencePair());
            } else if (match.getConfidence() == 2) {
                acceptedMatches = match.getAcceptedMatches();
            }
            if (!differencesForClass.containsKey(lipidClass)) {
                differencesForClass.put(lipidClass, new ArrayList());
            }
            for (Pair pair : acceptedMatches) {
                Double original = ((IdentificationVO)pair.getKey()).getAverageRT();
                Double difference = original - ((IdentificationVO)pair.getValue()).getAverageRT();
                differencesForClass.get(lipidClass).add(new AnchorPointVO(lipidClass, ((IdentificationVO)pair.getKey()).getLipidSpecies(), original, difference));
            }
        }
        return differencesForClass;
    }

    private boolean addCombinedRegression(ArrayList<AnchorPointVO> differences, String lipidClass, HashSet<String> uniqueLipidClasses, ArrayList<RecalibrationRegression> regressions) {
        RecalibrationRegression regression;
        RecalibrationRegression regressionStandards = this.getRegressionByFields("standards", lipidClass);
        if (regressionStandards != null) {
            differences.addAll(regressionStandards.getDifferences());
        }
        if ((regression = new RecalibrationRegression(differences, this.grouping_, PLOT_ALL, lipidClass)).getFunction() != null) {
            regressions.add(new RecalibrationRegression(differences, this.grouping_, PLOT_ALL, lipidClass));
            uniqueLipidClasses.add(lipidClass);
            return true;
        }
        return false;
    }

    private ArrayList<MatchedIdentificationVO> computeMatchesForDataTypeOther(Hashtable<String, ArrayList<File>> originalConditions, Hashtable<String, ArrayList<File>> newConditions) throws ExcelInputFileException {
        ArrayList<MatchedIdentificationVO> matches = new ArrayList<MatchedIdentificationVO>();
        for (String dataType : originalConditions.keySet()) {
            if (dataType.equals("standards")) continue;
            ArrayList<IdentificationVO> originalIdentifications = this.parseResultFiles(originalConditions.get(dataType));
            ArrayList<IdentificationVO> newIdentifications = this.parseResultFiles(newConditions.get(dataType));
            matches.addAll(this.computeMatches(originalIdentifications, originalConditions.get(dataType).size(), newIdentifications, newConditions.get(dataType).size()));
        }
        return matches;
    }

    private ArrayList<MatchedIdentificationVO> computeMatches(ArrayList<IdentificationVO> originalResults, int maxOriginal, ArrayList<IdentificationVO> newResults, int maxNew) {
        ArrayList<MatchedIdentificationVO> matches = new ArrayList<MatchedIdentificationVO>();
        Hashtable<String, ArrayList<IdentificationVO>> groupedIdentifications = new Hashtable<String, ArrayList<IdentificationVO>>();
        String originalIdentification = "original";
        String newIdentification = "new";
        this.groupIdentifications(originalResults, groupedIdentifications, originalIdentification);
        this.groupIdentifications(newResults, groupedIdentifications, newIdentification);
        for (String id : groupedIdentifications.keySet()) {
            if (!id.startsWith(originalIdentification)) continue;
            ArrayList<IdentificationVO> originalIdentifications = groupedIdentifications.get(id);
            String partnerId = id.replace(originalIdentification, newIdentification);
            ArrayList<IdentificationVO> newIdentifications = groupedIdentifications.get(partnerId);
            if (newIdentifications == null) continue;
            RecalibrationRegression standardsReg = this.getRegressionByFields("standards", PLOT_ALL);
            matches.add(new MatchedIdentificationVO(originalIdentifications, maxOriginal, newIdentifications, maxNew, standardsReg, this.predictionThreshold_, this.matchingAlgo_));
        }
        return matches;
    }

    private void groupIdentifications(ArrayList<IdentificationVO> identifications, Hashtable<String, ArrayList<IdentificationVO>> groupedIdentifications, String origin) {
        for (IdentificationVO identification : identifications) {
            if (!identification.isIdentificationUnambiguous()) {
                System.out.format("For the lipid class: %s, the lipid species: %s was found more than once in an input file. The grouping parameter needs to be adjusted to not group these different identifications together. \n", identification.getLipidClass(), identification.getLipidSpecies());
                continue;
            }
            String id = String.format("%s, %s, %s", origin, identification.getLipidClass(), identification.getLipidSpecies());
            if (!groupedIdentifications.containsKey(id)) {
                groupedIdentifications.put(id, new ArrayList());
            }
            groupedIdentifications.get(id).add(identification);
        }
    }

    private ArrayList<IdentificationVO> parseResultFiles(ArrayList<File> files) throws ExcelInputFileException {
        ArrayList<IdentificationVO> identifications = new ArrayList<IdentificationVO>();
        for (File file : files) {
            QuantificationResult quantResOriginal = LDAResultReader.readResultFile(file.getAbsolutePath(), new Hashtable<String, Boolean>());
            this.computeIdentificationVOs(file, quantResOriginal, identifications);
        }
        return identifications;
    }

    private void computeIdentificationVOs(File file, QuantificationResult quantRes, ArrayList<IdentificationVO> identifications) {
        Hashtable<String, Vector<LipidParameterSet>> quantIdentifications = quantRes.getIdentifications();
        for (String lipidClass : quantIdentifications.keySet()) {
            for (LipidParameterSet param : quantIdentifications.get(lipidClass)) {
                boolean added = false;
                for (int i = 0; i < identifications.size(); ++i) {
                    IdentificationVO identification = identifications.get(i);
                    if (!identification.getLipidClass().equals(lipidClass) || !identification.getLipidSpecies().equals(param.getNameStringWithoutRt())) continue;
                    added = identification.addParam(file, param) ? true : added;
                }
                if (added) continue;
                IdentificationVO identificationVO = new IdentificationVO(file, lipidClass, param);
                identifications.add(identificationVO);
            }
        }
    }

    public RecalibrationRegression getRegressionByFields(String dataType, String lipidClass) {
        return this.getRegressionByFields(this.regressions_, dataType, lipidClass);
    }

    private RecalibrationRegression getRegressionByFields(ArrayList<RecalibrationRegression> regressions, String dataType, String lipidClass) {
        for (RecalibrationRegression regression : regressions) {
            if (!regression.getDataType().equals(dataType) || !regression.getLipidClass().equals(lipidClass)) continue;
            return regression;
        }
        return null;
    }

    public AnchorPointVO findLipidClassForDataPoint(Pair<Double, Double> dataPoint) {
        for (int i = 0; i < this.lipidClasses_.length; ++i) {
            if (this.lipidClasses_[i].equals(PLOT_ALL)) continue;
            RecalibrationRegression regressionForClass = this.getRegressionByFields(PLOT_ALL, this.lipidClasses_[i]);
            for (AnchorPointVO point : regressionForClass.getDifferences()) {
                if (!point.getxValue().equals(dataPoint.getKey()) || !point.getyValue().equals(dataPoint.getValue())) continue;
                return point;
            }
        }
        return null;
    }

    private boolean removeDataPointFromRegression(RecalibrationRegression regression, AnchorPointVO dataPoint) {
        if (regression.getClusteredWithoutDataPointSize(dataPoint) > 2) {
            regression.removeDataPoint(dataPoint);
            return true;
        }
        return false;
    }

    protected void removeDataPoint(AnchorPointVO dataPoint) {
        RecalibrationRegression regressionAll = this.getRegressionByFields(PLOT_ALL, PLOT_ALL);
        RecalibrationRegression regressionClass = this.getRegressionByFields(PLOT_ALL, dataPoint.getLipidClass());
        RecalibrationRegression regressionSubGroup = this.getRegressionByFields(PLOT_ALL, this.getRelevantRegressionName(dataPoint.getLipidClass()));
        if (this.removeDataPointFromRegression(regressionAll, dataPoint)) {
            if (!regressionClass.equals(regressionSubGroup)) {
                this.removeDataPointFromRegression(regressionSubGroup, dataPoint);
            }
            if (!this.removeDataPointFromRegression(regressionClass, dataPoint)) {
                new WarningMessage(new JFrame(), "Warning", String.format("Class specific calibration of %s is not possible anymore due to the removed data point!", this.getRelevantRegressionName(dataPoint.getLipidClass())));
                ArrayList<String> lipidClasses = new ArrayList<String>(Arrays.asList(this.lipidClasses_));
                lipidClasses.remove(dataPoint.getLipidClass());
                this.lipidClasses_ = lipidClasses.toArray(new String[lipidClasses.size()]);
                this.regressions_.remove(regressionClass);
                this.displayPanel_.remove(this.jComboBoxPanel_);
                this.initClassListJComboBox();
            }
        } else {
            new WarningMessage(new JFrame(), "Error", "The fit requires at least 3 data points.");
        }
        this.showViewOfChoice();
    }

    @Override
    protected void next() {
        this.goNext();
        try {
            ExportPanel panel = (ExportPanel)this.getDefaultComponents().getCurrentPanel();
            panel.setExporter(new TargetListExporter(this.originalTargetList_.getAbsolutePath(), this.classSpecificJCheckBox_.isSelected(), this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void back() {
        this.cleanPanels();
        this.init(this.generateLoadingPanel());
        this.goBack();
    }

    public void setOriginalTargetList(File originalTargetList) {
        this.originalTargetList_ = originalTargetList;
    }

    public void setPredictionThreshold(Double predictionThreshold) {
        this.predictionThreshold_ = predictionThreshold;
    }

    public void setMatchingAlgo(String algo) {
        this.matchingAlgo_ = algo;
    }
}

