/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.calibration;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.lccl.JDefaultComponents;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.JTargetFileWizard;
import at.tugraz.genome.lda.lccl.calibration.CalibrationGraphPanel;
import at.tugraz.genome.lda.swing.JHyperlink;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CalibrationFileChooserPanel
extends JOptionPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField targetFileField_;
    private SelectionTable inputPanelOriginal_;
    private SelectionTable inputPanelNew_;
    private JTextField predictionThresholdField_;
    private JComboBox<String> matchAlgorithm_;
    private Path previousSelection_ = null;
    private static final Double DEFAULT_THRESHOLD = 0.5;
    public static final String MATCHING_SETTING_DEFAULT = "Adapt to provided data";
    public static final String MATCHING_SETTING_INCREASED_NUMBER = "Prioritize number of anchor points";
    public static final String MATCHING_SETTING_INCREASED_RELIABILITY = "Prioritize reliability of anchor points";
    public static final String MATCHING_SETTING_ALL_MATCHES = "All potential matches";
    private static final String[] MATCHING_SETTING = new String[]{"Adapt to provided data", "Prioritize number of anchor points", "Prioritize reliability of anchor points", "All potential matches"};
    private static final String PLACEHOLDER_PREFIX = "Enter ";
    private static final String BROWSE = "Browse";
    private static final String COMMAND_OPEN_TARGET_FILE = "Open target file";
    public static final String DATA_TYPE_STANDARD_MIX = "standards";
    private static final Dimension ENTER_FIELD_DIMENSION_MIN = new Dimension(300, 15);
    private static final Dimension ENTER_FIELD_DIMENSION = new Dimension(750, 30);
    private static final Dimension BUTTON_PANEL_DIMENSION = new Dimension(825, 35);
    private static final Dimension TABLE_PANEL_DIMENSION = new Dimension(825, 200);

    public CalibrationFileChooserPanel(JDefaultComponents wizardComponents) {
        super(wizardComponents, "Map an RT-DB to your chromatographic conditions.");
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        JHyperlink hyperlink = new JHyperlink("Download the original RT-DB and reference data here: LCdbCL.github.io", "https://lcdbcl.github.io");
        hyperlink.setFont(new Font("Arial", 1, 14));
        this.add((Component)hyperlink, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.targetFileField_ = this.instantiateJTextField("Enter path and file name of the original RT-DB.");
        JButton targetFileButton = this.instantiateJButton(COMMAND_OPEN_TARGET_FILE, BROWSE);
        JPanel targetFilePanel = this.instantiatePanel(this.targetFileField_, targetFileButton, "Original RT-DB");
        this.inputPanelOriginal_ = new SelectionTable("Original chromatographic conditions.");
        this.inputPanelNew_ = new SelectionTable("New chromatographic conditions.");
        this.add((Component)targetFilePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.inputPanelOriginal_, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.inputPanelNew_, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.instantiateSettingsPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel instantiateSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel labelMatch = new JLabel("Select the matching algorithm: ");
        labelMatch.setToolTipText("<html>Use this setting to define the matching algorithm to be used for data types OTHER THAN 'standards'.<br/>Please refer to the user manual for details.</html>");
        panel.add((Component)labelMatch, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.matchAlgorithm_ = new JComboBox<String>(MATCHING_SETTING);
        this.matchAlgorithm_.setToolTipText("<html>Use this setting to define the matching algorithm to be used for data types OTHER THAN 'standards'.<br/>Please refer to the user manual for details.</html>");
        panel.add(this.matchAlgorithm_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 70), 0, 0));
        JLabel labelText = new JLabel("Maximum accepted deviation from standards-curve: ");
        labelText.setToolTipText("<html>Use this setting to define a maximum allowed deviation from the standards-curve.<br/>for anchor points derived from biological data.<br/>A higher threshold will require more manual removal of visual outliers.</html>");
        panel.add((Component)labelText, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.predictionThresholdField_ = new JTextField(DEFAULT_THRESHOLD.toString(), 5);
        this.predictionThresholdField_.setInputVerifier(new DoubleVerifier(true, true));
        this.predictionThresholdField_.setHorizontalAlignment(4);
        this.predictionThresholdField_.setToolTipText("<html>Use this setting to define a maximum allowed deviation from the standards-curve.<br/>for anchor points derived from biological data.<br/>A higher threshold will require more manual removal of visual outliers.</html>");
        panel.add((Component)this.predictionThresholdField_, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel labelUnit = new JLabel(" min");
        labelUnit.setToolTipText("<html>Use this setting to define a maximum allowed deviation from the standards-curve.<br/>for anchor points derived from biological data.<br/>A higher threshold will require more manual removal of visual outliers.</html>");
        panel.add((Component)labelUnit, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JTextField instantiateJTextField(final String placeholder) {
        final JTextField field = new JTextField();
        field.setMinimumSize(ENTER_FIELD_DIMENSION_MIN);
        field.setPreferredSize(ENTER_FIELD_DIMENSION);
        field.setText(placeholder);
        field.setForeground(Color.GRAY);
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (field.getText().equals(placeholder)) {
                    field.setText("");
                    field.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (field.getText().isEmpty()) {
                    field.setForeground(Color.GRAY);
                    field.setText(placeholder);
                }
            }
        });
        return field;
    }

    private JButton instantiateJButton(String command, String title) {
        JButton button = new JButton(title);
        button.addActionListener(this);
        button.setActionCommand(command);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals(COMMAND_OPEN_TARGET_FILE)) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Only .xlsx", "xlsx");
            this.selectPath(0, this.targetFileField_, filter, "Select the RT-DB (.xlsx file)");
        }
    }

    private void selectPath(int selectionMode, JTextField field, FileNameExtensionFilter filter, String title) {
        int val;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(filter);
        chooser.setPreferredSize(JTargetFileWizard.DEFAULT_FILE_CHOOSER_DIMENSION);
        chooser.setFileSelectionMode(selectionMode);
        chooser.setDialogTitle(title);
        if (this.previousSelection_ != null) {
            chooser.setCurrentDirectory(this.previousSelection_.getParent().toFile());
        }
        if ((val = chooser.showOpenDialog(new JFrame())) != 0) {
            return;
        }
        String text = chooser.getSelectedFile().getAbsolutePath();
        this.previousSelection_ = Paths.get(text, new String[0]);
        field.setText(text);
        field.setForeground(Color.BLACK);
    }

    private JPanel instantiatePanel(JTextField textfield, JButton button, String borderTitle) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)textfield, this.getDefaultGridBagConstraints(0, 0));
        panel.add((Component)button, this.getDefaultGridBagConstraints(7, 0));
        panel.setBorder(CalibrationFileChooserPanel.getTitledPanelBorder(borderTitle));
        return panel;
    }

    private GridBagConstraints getDefaultGridBagConstraints(int column, int row) {
        return new GridBagConstraints(column, row, 6, 1, 0.0, 0.0, 13, 0, new Insets(10, 6, 0, 0), 0, 10);
    }

    @Override
    protected void next() {
        if (this.isPlaceholder(this.targetFileField_) || this.inputPanelOriginal_.getUniqueFiles().isEmpty() || this.inputPanelNew_.getUniqueFiles().isEmpty()) {
            new WarningMessage(new JFrame(), "Warning", "Specify paths and file names of the original RT-DB as well as for the reference files of the original and new chromatographic conditions before continuing!");
        } else {
            final Hashtable originalConditions = this.inputPanelOriginal_.generateDataTypeToFilesMap();
            final Hashtable newConditions = this.inputPanelNew_.generateDataTypeToFilesMap();
            if (!originalConditions.keySet().equals(newConditions.keySet())) {
                new WarningMessage(new JFrame(), "Warning", "The reference files of the original and new chromatographic conditions must contain files of the same data types to ensure they can be matched!");
            } else {
                this.goNext();
                this.getDefaultComponents().disableAllButtons();
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CalibrationGraphPanel panel = (CalibrationGraphPanel)CalibrationFileChooserPanel.this.getDefaultComponents().getCurrentPanel();
                            panel.setMatchingAlgo((String)CalibrationFileChooserPanel.this.matchAlgorithm_.getSelectedItem());
                            panel.setOriginalTargetList(new File(CalibrationFileChooserPanel.this.targetFileField_.getText()));
                            panel.setPredictionThreshold(Double.parseDouble(CalibrationFileChooserPanel.this.predictionThresholdField_.getText()));
                            panel.parseData(originalConditions, newConditions);
                            if (CalibrationFileChooserPanel.this.getDefaultComponents().getCurrentPanel() instanceof CalibrationGraphPanel) {
                                panel.initDataDisplay();
                            }
                        }
                        catch (Exception ex) {
                            new WarningMessage(new JFrame(), "Error", "An error occurred: " + ex.getMessage());
                            CalibrationFileChooserPanel.this.goBack();
                        }
                    }
                });
                thread.start();
            }
        }
    }

    private boolean isPlaceholder(JTextField field) {
        return field.getText().startsWith(PLACEHOLDER_PREFIX);
    }

    private class SelectionTable
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private ImageIcon addFilesIcon_ = new ImageIcon(this.getClass().getResource("/images/addFiles.gif"));
        private ImageIcon addFolderIcon_ = new ImageIcon(this.getClass().getResource("/images/addFromFolder.gif"));
        private ImageIcon removeIcon_ = new ImageIcon(this.getClass().getResource("/images/removeFiles.gif"));
        private static final String COMMAND_ADD_FILES = "Add Files";
        private static final String COMMAND_ADD_FOLDER = "Add Folder";
        private static final String COMMAND_REMOVE_FILE = "Remove";
        private static final String COMMAND_REMOVE_ALL = "Remove all";
        private static final int COLUMN_FILE_NAME = 0;
        private static final int COLUMN_DIR_NAME = 1;
        private static final int COLUMN_DATA_TYPE = 2;
        private ArrayList<File> uniqueFiles_ = new ArrayList();
        private JPanel selectionTablePanel_;
        private JTable displayTable_;
        private JScrollPane scrollPane_;

        private SelectionTable(String title) {
            JPanel buttonPanel = this.instantiateButtonPanel();
            this.selectionTablePanel_ = new JPanel();
            this.generateSelectionTablePanel(new String[0][0]);
            this.setLayout(new GridBagLayout());
            this.add((Component)buttonPanel, CalibrationFileChooserPanel.this.getDefaultGridBagConstraints(0, 0));
            this.add((Component)this.selectionTablePanel_, CalibrationFileChooserPanel.this.getDefaultGridBagConstraints(0, 1));
            this.setBorder(JOptionPanel.getTitledPanelBorder(title));
        }

        private JPanel instantiateButtonPanel() {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            buttonPanel.setPreferredSize(BUTTON_PANEL_DIMENSION);
            buttonPanel.setMinimumSize(BUTTON_PANEL_DIMENSION);
            JButton buttonAddFiles = this.instantiateJButton(COMMAND_ADD_FILES, COMMAND_ADD_FILES, this.addFilesIcon_);
            buttonPanel.add((Component)buttonAddFiles, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, -2, 2, 0), 0, 0));
            JButton buttonAddFolder = this.instantiateJButton(COMMAND_ADD_FOLDER, COMMAND_ADD_FOLDER, this.addFolderIcon_);
            buttonPanel.add((Component)buttonAddFolder, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
            JButton buttonRemoveFile = this.instantiateJButton(COMMAND_REMOVE_FILE, COMMAND_REMOVE_FILE, this.removeIcon_);
            buttonPanel.add((Component)buttonRemoveFile, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
            JButton buttonRemoveAll = this.instantiateJButton(COMMAND_REMOVE_ALL, COMMAND_REMOVE_ALL, this.removeIcon_);
            buttonPanel.add((Component)buttonRemoveAll, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
            return buttonPanel;
        }

        private JButton instantiateJButton(String command, String title, ImageIcon imageIcon) {
            JButton button = new JButton(title, imageIcon);
            button.addActionListener(this);
            button.setActionCommand(command);
            return button;
        }

        private void generateSelectionTablePanel(String[][] tableData) {
            Object[] columnNames = new String[]{"file name", "directory", "data type"};
            this.displayTable_ = new JTable(tableData, columnNames);
            this.scrollPane_ = new JScrollPane(this.displayTable_);
            this.displayTable_.setSelectionMode(2);
            this.scrollPane_.setPreferredSize(TABLE_PANEL_DIMENSION);
            this.scrollPane_.setMinimumSize(TABLE_PANEL_DIMENSION);
            this.selectionTablePanel_.add(this.scrollPane_);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            switch (arg0.getActionCommand()) {
                case "Add Files": {
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Only .xlsx", "xlsx");
                    this.selectPath(filter, "Select result files to use as reference for the original chromatographic conditions (.xlsx file)");
                    break;
                }
                case "Add Folder": {
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Only .xlsx", "xlsx");
                    this.selectFolder("Select a folder containing result files to use as reference for the original chromatographic conditions (.xlsx file)");
                    break;
                }
                case "Remove": {
                    this.removeFiles();
                    break;
                }
                case "Remove all": {
                    this.removeAllFiles();
                    break;
                }
            }
        }

        private void updateSelectionTable() {
            this.selectionTablePanel_.remove(this.scrollPane_);
            String[][] tableData = new String[this.uniqueFiles_.size()][3];
            int count = 0;
            for (File file : this.uniqueFiles_) {
                String fileName = StaticUtils.extractFileName(file.getAbsolutePath());
                String dir = StaticUtils.extractDirName(file.getAbsolutePath());
                tableData[count][0] = fileName;
                tableData[count][1] = dir;
                tableData[count][2] = this.generateDataTypeJComboBox().getItemAt(1);
                ++count;
            }
            this.generateSelectionTablePanel(tableData);
            this.displayTable_.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.generateDataTypeJComboBox()));
            this.selectionTablePanel_.invalidate();
            this.selectionTablePanel_.updateUI();
        }

        private JComboBox<String> generateDataTypeJComboBox() {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem(CalibrationFileChooserPanel.DATA_TYPE_STANDARD_MIX);
            comboBox.addItem("group 1");
            comboBox.addItem("group 2");
            comboBox.addItem("group 3");
            return comboBox;
        }

        private void selectPath(FileNameExtensionFilter filter, String title) {
            int val;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(filter);
            chooser.setPreferredSize(JTargetFileWizard.DEFAULT_FILE_CHOOSER_DIMENSION);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(title);
            if (CalibrationFileChooserPanel.this.previousSelection_ != null) {
                chooser.setCurrentDirectory(CalibrationFileChooserPanel.this.previousSelection_.getParent().toFile());
            }
            if ((val = chooser.showOpenDialog(new JFrame())) == 0) {
                Hashtable<String, File> avoidDuplicates = new Hashtable<String, File>();
                for (File file : this.uniqueFiles_) {
                    avoidDuplicates.put(file.getAbsolutePath(), file);
                }
                File[] fileCandidates = chooser.getSelectedFiles();
                for (int i = 0; i != fileCandidates.length; ++i) {
                    CalibrationFileChooserPanel.this.previousSelection_ = Paths.get(fileCandidates[i].getAbsolutePath(), new String[0]);
                    if (!fileCandidates[i].isFile() || avoidDuplicates.containsKey(fileCandidates[i].getAbsolutePath())) continue;
                    avoidDuplicates.put(fileCandidates[i].getAbsolutePath(), fileCandidates[i]);
                    this.uniqueFiles_.add(fileCandidates[i]);
                }
                if (avoidDuplicates.size() > 0) {
                    this.updateSelectionTable();
                }
            } else {
                return;
            }
        }

        private void selectFolder(String title) {
            int val;
            JFileChooser chooser = new JFileChooser();
            chooser.setPreferredSize(JTargetFileWizard.DEFAULT_FILE_CHOOSER_DIMENSION);
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(title);
            if (CalibrationFileChooserPanel.this.previousSelection_ != null) {
                chooser.setCurrentDirectory(CalibrationFileChooserPanel.this.previousSelection_.getParent().toFile());
            }
            if ((val = chooser.showOpenDialog(new JFrame())) == 0) {
                Hashtable<String, File> avoidDuplicates = new Hashtable<String, File>();
                for (File file : this.uniqueFiles_) {
                    avoidDuplicates.put(file.getAbsolutePath(), file);
                }
                File folder = new File(chooser.getSelectedFile().getAbsolutePath());
                if (folder.exists() && folder.isDirectory()) {
                    File[] fileCandidates = folder.listFiles();
                    for (int i = 0; i != fileCandidates.length; ++i) {
                        if (!fileCandidates[i].isFile() || avoidDuplicates.containsKey(fileCandidates[i].getAbsolutePath())) continue;
                        CalibrationFileChooserPanel.this.previousSelection_ = Paths.get(fileCandidates[i].getAbsolutePath(), new String[0]);
                        String fileName = StaticUtils.extractFileName(fileCandidates[i].getAbsolutePath());
                        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                        if (!suffix.equalsIgnoreCase("xlsx") || fileName.startsWith("~$")) continue;
                        avoidDuplicates.put(fileCandidates[i].getAbsolutePath(), fileCandidates[i]);
                        this.uniqueFiles_.add(fileCandidates[i]);
                    }
                }
                if (avoidDuplicates.size() > 0) {
                    this.updateSelectionTable();
                }
            } else {
                return;
            }
        }

        private void removeFiles() {
            int[] selectedRows;
            if (this.uniqueFiles_ != null && (selectedRows = this.displayTable_.getSelectedRows()).length > 0) {
                ArrayList<Integer> selectedList = new ArrayList<Integer>();
                for (int i = 0; i != selectedRows.length; ++i) {
                    selectedList.add(selectedRows[i]);
                }
                Collections.sort(selectedList);
                ArrayList<File> filesToRemove = new ArrayList<File>();
                for (int i = selectedList.size() - 1; i != -1; --i) {
                    filesToRemove.add(this.uniqueFiles_.get((Integer)selectedList.get(i)));
                    this.uniqueFiles_.remove((Integer)selectedList.get(i));
                }
                this.updateSelectionTable();
            }
        }

        private void removeAllFiles() {
            this.uniqueFiles_ = new ArrayList();
            this.updateSelectionTable();
        }

        private ArrayList<File> getUniqueFiles() {
            return this.uniqueFiles_;
        }

        private Hashtable<String, ArrayList<File>> generateDataTypeToFilesMap() {
            Hashtable<String, ArrayList<File>> dataTypeToFileMap = new Hashtable<String, ArrayList<File>>();
            for (int i = 0; i < this.displayTable_.getRowCount(); ++i) {
                String fileNameRef = (String)this.displayTable_.getValueAt(i, 0);
                String dirRef = (String)this.displayTable_.getValueAt(i, 1);
                for (File file : this.uniqueFiles_) {
                    String fileName = StaticUtils.extractFileName(file.getAbsolutePath());
                    String dir = StaticUtils.extractDirName(file.getAbsolutePath());
                    if (!fileName.equals(fileNameRef) || !dir.equals(dirRef)) continue;
                    String dataType = (String)this.displayTable_.getValueAt(i, 2);
                    if (!dataTypeToFileMap.containsKey(dataType)) {
                        dataTypeToFileMap.put(dataType, new ArrayList());
                    }
                    dataTypeToFileMap.get(dataType).add(file);
                }
            }
            return dataTypeToFileMap;
        }
    }
}

