/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fraggli;

import at.tugraz.genome.lda.fraggli.Adduct;
import at.tugraz.genome.lda.fraggli.AdductIonCloud;
import at.tugraz.genome.lda.fraggli.FragGLiPanel;
import at.tugraz.genome.lda.fraggli.LDAParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;

public class FragRuleExporter {
    FragGLiPanel parent_;

    public FragRuleExporter(FragGLiPanel parent) {
        this.parent_ = parent;
    }

    public void export() {
        this.parent_.getStatusPanel().setVisible(true);
        this.parent_.getExportButton().setEnabled(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ArrayList<AdductIonCloud> ionClouds = new ArrayList<AdductIonCloud>();
                TreeMap<String, Integer> hAtoms = new TreeMap<String, Integer>();
                hAtoms.put("H", 1);
                TreeMap<String, Integer> h2Atoms = new TreeMap<String, Integer>();
                h2Atoms.put("H", 2);
                TreeMap<String, Integer> mhAtoms = new TreeMap<String, Integer>();
                mhAtoms.put("H", -1);
                TreeMap<String, Integer> mh2Atoms = new TreeMap<String, Integer>();
                mh2Atoms.put("H", -2);
                AdductIonCloud h = new AdductIonCloud("H", 1);
                AdductIonCloud h2 = new AdductIonCloud("2H", 2);
                AdductIonCloud mh = new AdductIonCloud("-H", -1);
                AdductIonCloud mh2 = new AdductIonCloud("-2H", -2);
                h.add(new Adduct(hAtoms, "H", 1));
                h2.add(new Adduct(hAtoms, "H", 1));
                h2.add(new Adduct(h2Atoms, "2H", 2));
                mh.add(new Adduct(mhAtoms, "-H", -1));
                mh2.add(new Adduct(mhAtoms, "-H", -1));
                mh2.add(new Adduct(mh2Atoms, "-2H", -2));
                ionClouds.add(h);
                ionClouds.add(h2);
                ionClouds.add(mh);
                ionClouds.add(mh2);
                HashMap isomers = new HashMap();
                for (Glycan structure : FragRuleExporter.this.parent_.getStructures()) {
                    String shorthand = FragRuleExporter.this.parent_.getGlycanBuilder().getShorthandLDAConverter().buildGlycanShorthand(structure);
                    if (!isomers.containsKey(shorthand)) {
                        isomers.put(shorthand, new ArrayList());
                    }
                    ((ArrayList)isomers.get(shorthand)).add(structure);
                }
                int totalStructures = isomers.values().stream().mapToInt(ArrayList::size).sum();
                ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                AtomicInteger completedStructures = new AtomicInteger(0);
                for (String isomer : isomers.keySet()) {
                    executor.submit(() -> {
                        FragmentCollection fragColl = new FragmentCollection();
                        ArrayList structures = (ArrayList)isomers.get(isomer);
                        Configuration config = new Configuration();
                        config.open("/config.xml");
                        FragmentOptions opt = new FragmentOptions();
                        opt.retrieve(config);
                        Fragmenter frag = new Fragmenter(opt);
                        for (Glycan structure : structures) {
                            fragColl.addFragments(frag.computeAllFragments(structure));
                        }
                        new LDAParser(ionClouds, fragColl, (Glycan)structures.get(0), FragRuleExporter.this.parent_).writeGlycan();
                        int structuresProcessed = structures.size();
                        int completed = completedStructures.addAndGet(structuresProcessed);
                        SwingUtilities.invokeLater(() -> FragRuleExporter.this.parent_.getProgressBar().setValue(completed * 100 / totalStructures));
                    });
                }
                executor.shutdown();
                try {
                    executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }

            @Override
            protected void done() {
                FragRuleExporter.this.parent_.getStatusPanel().setVisible(false);
                FragRuleExporter.this.parent_.getProgressBar().setValue(0);
                FragRuleExporter.this.parent_.getExportButton().setEnabled(true);
            }
        }.execute();
    }

    @Deprecated
    public void exportOld() {
        this.parent_.getStatusPanel().setVisible(true);
        ArrayList<AdductIonCloud> ionClouds = new ArrayList<AdductIonCloud>();
        TreeMap<String, Integer> hAtoms = new TreeMap<String, Integer>();
        hAtoms.put("H", 1);
        TreeMap<String, Integer> h2Atoms = new TreeMap<String, Integer>();
        h2Atoms.put("H", 2);
        TreeMap<String, Integer> mhAtoms = new TreeMap<String, Integer>();
        mhAtoms.put("H", -1);
        TreeMap<String, Integer> mh2Atoms = new TreeMap<String, Integer>();
        mh2Atoms.put("H", -2);
        AdductIonCloud h = new AdductIonCloud("H", 1);
        AdductIonCloud h2 = new AdductIonCloud("2H", 2);
        AdductIonCloud mh = new AdductIonCloud("-H", -1);
        AdductIonCloud mh2 = new AdductIonCloud("-2H", -2);
        h.add(new Adduct(hAtoms, "H", 1));
        h2.add(new Adduct(hAtoms, "H", 1));
        h2.add(new Adduct(h2Atoms, "2H", 2));
        mh.add(new Adduct(mhAtoms, "-H", -1));
        mh2.add(new Adduct(mhAtoms, "-H", -1));
        mh2.add(new Adduct(mh2Atoms, "-2H", -2));
        ionClouds.add(h);
        ionClouds.add(h2);
        ionClouds.add(mh);
        ionClouds.add(mh2);
        HashMap isomers = new HashMap();
        for (Glycan structure : this.parent_.getStructures()) {
            String shorthand = this.parent_.getGlycanBuilder().getShorthandLDAConverter().buildGlycanShorthand(structure);
            if (!isomers.containsKey(shorthand)) {
                isomers.put(shorthand, new ArrayList());
            }
            ((ArrayList)isomers.get(shorthand)).add(structure);
        }
        int count = 0;
        for (String isomer : isomers.keySet()) {
            this.parent_.getProgressLabel().setText("Generating rules for: " + isomer);
            this.parent_.getProgressBar().setValue(++count / isomers.size() * 100);
            FragmentCollection fragColl = new FragmentCollection();
            ArrayList structures = (ArrayList)isomers.get(isomer);
            Configuration config = new Configuration();
            config.open("/config.xml");
            FragmentOptions opt = new FragmentOptions();
            opt.retrieve(config);
            Fragmenter frag = new Fragmenter(opt);
            for (Glycan structure : structures) {
                fragColl.addFragments(frag.computeAllFragments(structure));
            }
            new LDAParser(ionClouds, fragColl, (Glycan)structures.get(0), this.parent_).writeGlycan();
        }
        this.parent_.getStatusPanel().setVisible(false);
        this.parent_.getProgressBar().setValue(0);
        JOptionPane.showMessageDialog(this.parent_, "FragRule export completed successuflly!", "Info", 1);
    }
}

