/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fraggli;

import at.tugraz.genome.lda.LipidDataAnalyzer;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.fraggli.FragRuleExporter;
import at.tugraz.genome.lda.masslist.LipidClassExporter;
import at.tugraz.genome.lda.masslist.LipidClassVO;
import at.tugraz.genome.lda.masslist.MassListCreatorPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanBuilder;

public class FragGLiPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    MassListCreatorPanel massListCreator_;
    JTabbedPane mainTabs_;
    GlycanBuilder glycanBuilder_;
    JComboBox<String> machineNameComboBox_;
    JTextField fragNamePosField_;
    JTextField fragNameNegField_;
    JLabel progressLabel_;
    JProgressBar progressBar_;
    JLabel spinnerLabel_;
    JPanel statusPanel_;
    JButton exportButton_;

    public FragGLiPanel(MassListCreatorPanel massListCreator, JTabbedPane mainTabs) {
        this.massListCreator_ = massListCreator;
        this.mainTabs_ = mainTabs;
        this.setLayout(new GridBagLayout());
        try {
            this.glycanBuilder_ = new GlycanBuilder(new JFrame());
            this.add((Component)this.glycanBuilder_, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 200, 200));
        }
        catch (HeadlessException | MalformedURLException ex) {
            ex.printStackTrace();
        }
        JLabel labelpos = new JLabel("Folder name for the positive ion mode:");
        labelpos.setToolTipText("The subfolder name for the export of fragmentation rules in positive ion mode in the fragRules folder for the chosen MS machine.");
        this.fragNamePosField_ = new JTextField(10);
        this.fragNamePosField_.setText("positive");
        this.fragNamePosField_.setToolTipText("The subfolder name for the export of fragmentation rules in positive ion mode in the fragRules folder for the chosen MS machine.");
        JLabel labelneg = new JLabel(" and the negative ion mode:");
        labelneg.setToolTipText("The subfolder name for the export of fragmentation rules in negative ion mode in the fragRules folder for the chosen MS machine.");
        this.fragNameNegField_ = new JTextField(10);
        this.fragNameNegField_.setText("negative");
        this.fragNameNegField_.setToolTipText("The subfolder name for the export of fragmentation rules in negative ion mode in the fragRules folder for the chosen MS machine.");
        JLabel labelms = new JLabel("MS machine name:");
        labelms.setToolTipText("<html>The subfolder name of the chosen MS machine for the export of fragmentation rules in the fragRules folder.<br/>The list corresponds to the available LDA .properties files. To add an additional MS device, create a new .properties file.</html>");
        this.machineNameComboBox_ = new JComboBox();
        for (String msSetting : Settings.getPropertyFileNames()) {
            this.machineNameComboBox_.addItem(msSetting);
        }
        this.machineNameComboBox_.setToolTipText("<html>The subfolder name of the chosen MS machine for the export of fragmentation rules in the fragRules folder.<br/>The list corresponds to the available LDA .properties files. To add an additional MS device, create a new .properties file.</html>");
        this.progressLabel_ = new JLabel("Generating fragmentation rules");
        this.progressLabel_.setToolTipText("Fragmentation rule generation status");
        this.progressBar_ = new JProgressBar();
        this.progressBar_.setMaximum(100);
        this.progressBar_.setToolTipText("Fragmentation rule generation progress");
        ImageIcon icon = new ImageIcon(LipidDataAnalyzer.class.getResource("/images/spinner.gif"));
        this.spinnerLabel_ = new JLabel(icon);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1));
        bottomPanel.add(labelpos);
        bottomPanel.add(this.fragNamePosField_);
        bottomPanel.add(labelneg);
        bottomPanel.add(this.fragNameNegField_);
        bottomPanel.add(labelms);
        bottomPanel.add(this.machineNameComboBox_);
        this.add((Component)bottomPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 15, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.statusPanel_ = new JPanel();
        this.statusPanel_.setLayout(new FlowLayout(1));
        this.statusPanel_.add(this.progressLabel_);
        this.statusPanel_.add(this.progressBar_);
        this.statusPanel_.add(this.spinnerLabel_);
        this.statusPanel_.setVisible(false);
        this.add((Component)this.statusPanel_, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        JButton massListCreatorButton = new JButton("Add to MassList Creator");
        massListCreatorButton.setToolTipText("<html>Add lipid class definitions of the currently displayed glycolipids to the selected MassList Creator directory, if not already present.<br/>Please refer to the user manual for details.</html>");
        massListCreatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FragGLiPanel.this.massListCreatorButton_actionPerformed(e);
            }
        });
        buttonPanel.add(massListCreatorButton);
        this.exportButton_ = new JButton("Export FragRules");
        this.exportButton_.setToolTipText("Export the fragmentation rules for the displayed glycolipids. Please refer to the user manual for details.");
        this.exportButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FragGLiPanel.this.exportButton_actionPerformed(e);
            }
        });
        buttonPanel.add(this.exportButton_);
        this.add((Component)buttonPanel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 5, 5));
    }

    private void massListCreatorButton_actionPerformed(ActionEvent e) {
        if (this.massListCreator_ == null) {
            JOptionPane.showMessageDialog(this, "The MassList Creator is currently unavailable.", "Error", 0);
            return;
        }
        String directory = this.massListCreator_.getCurrentLipidClassSubfolderName();
        ArrayList<String> structures = new ArrayList<String>();
        for (Glycan structure : this.getStructures()) {
            String shorthand = this.getGlycanBuilder().getShorthandLDAConverter().buildGlycanShorthand(structure);
            if (structures.contains(shorthand)) continue;
            structures.add(shorthand);
            File out = new File(LipidClassExporter.buildLipidClassPath(shorthand, directory));
            if (out.exists()) continue;
            String headgroupFormula = "";
            try {
                headgroupFormula = structure.computeMolecule().toString();
                LipidClassVO toExport = new LipidClassVO(shorthand, true, false, 2, 3, -1.0, -1.0, this.massListCreator_.getAdductCreatorPanel().getAllDefinedAdducts(), headgroupFormula, 20, 50, 0, 6, 1, 1, this.massListCreator_.getFAChainListNames()[0], this.massListCreator_.getSPBChainListNames()[0]);
                LipidClassExporter exporter = new LipidClassExporter(toExport, directory);
                exporter.export();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Something went wrong: " + ex.getMessage(), "Error", 0);
            }
        }
        try {
            this.massListCreator_.reloadLipidClassScrollPane(null);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Something went wrong: " + ex.getMessage(), "Error", 0);
        }
        this.mainTabs_.setSelectedIndex(this.mainTabs_.indexOfComponent(this.massListCreator_));
        JOptionPane.showMessageDialog(this, "Glycolipid class definitions were successfully exported.", "Info", 1);
    }

    private void exportButton_actionPerformed(ActionEvent e) {
        new FragRuleExporter(this).export();
    }

    public GlycanBuilder getGlycanBuilder() {
        return this.glycanBuilder_;
    }

    public LinkedList<Glycan> getStructures() {
        return this.glycanBuilder_.getCanvas().getGlycans();
    }

    public JComboBox<String> getMachineNameComboBox() {
        return this.machineNameComboBox_;
    }

    public String getMachineName() {
        return (String)this.machineNameComboBox_.getSelectedItem();
    }

    public JTextField getFragNamePosField() {
        return this.fragNamePosField_;
    }

    public String getFragNamePos() {
        return this.fragNamePosField_.getText();
    }

    public JTextField getFragNameNegField() {
        return this.fragNameNegField_;
    }

    public String getFragNameNeg() {
        return this.fragNameNegField_.getText();
    }

    public JLabel getProgressLabel() {
        return this.progressLabel_;
    }

    public void setProgressLabel(JLabel progressLabel) {
        this.progressLabel_ = progressLabel;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar_;
    }

    public JLabel getSpinnerLabel() {
        return this.spinnerLabel_;
    }

    public void setSpinnerLabel(JLabel spinnerLabel) {
        this.spinnerLabel_ = spinnerLabel;
    }

    public JPanel getStatusPanel() {
        return this.statusPanel_;
    }

    public JButton getExportButton() {
        return this.exportButton_;
    }
}

