/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fraggli;

import java.util.Map;
import java.util.TreeMap;

public class Adduct {
    private TreeMap<String, Integer> atoms;
    private String name;
    private Integer charge;

    public Adduct(TreeMap<String, Integer> atoms, String name, Integer charge) {
        this.atoms = atoms;
        this.name = name;
        this.charge = charge;
    }

    public TreeMap<String, Integer> getAtoms() {
        return this.atoms;
    }

    public String getName() {
        return this.name;
    }

    public Integer getCharge() {
        return this.charge;
    }

    public String getFormula(boolean invert) {
        StringBuilder sb = new StringBuilder();
        boolean previousPositive = true;
        for (Map.Entry<String, Integer> a : this.atoms.entrySet()) {
            int amount;
            int n = amount = invert ? -a.getValue().intValue() : a.getValue();
            if (amount < 0) {
                sb.append(previousPositive ? "-" : "");
                previousPositive = false;
            }
            if (amount > 0) {
                sb.append(!previousPositive || sb.toString().isEmpty() ? "+" : "");
                previousPositive = true;
            }
            sb.append(a.getKey().toString());
            if (Math.abs(amount) <= 1) continue;
            sb.append(Math.abs(amount));
        }
        return sb.toString();
    }
}

