/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fragai;

import at.tugraz.genome.lda.vos.SpectrumPointVO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;

public class CombinedSpectrumPointVO
implements Comparable<CombinedSpectrumPointVO> {
    private Boolean precursorAdjusted_;
    private HashMap<String, Integer> speciesSpectraCountMap_;
    private HashMap<String, ArrayList<Double>> speciesIntensityMap_;
    private ArrayList<Double> precursorMZ_;

    public CombinedSpectrumPointVO(Boolean precursorRemoved) {
        this.precursorAdjusted_ = precursorRemoved;
        this.speciesSpectraCountMap_ = new HashMap();
        this.speciesIntensityMap_ = new HashMap();
        this.precursorMZ_ = new ArrayList();
    }

    public void addSpectrumPoint(SpectrumPointVO vo, String species) {
        this.addToSpeciesSpectraCountMap(species);
        this.addToSpeciesIntensityMap(species, vo.getIntensity());
        this.addToPrecursorMZ(vo.getMz());
    }

    private void addToSpeciesSpectraCountMap(String species) {
        if (!this.speciesSpectraCountMap_.containsKey(species)) {
            this.speciesSpectraCountMap_.put(species, 1);
        } else {
            int num = this.speciesSpectraCountMap_.get(species);
            this.speciesSpectraCountMap_.put(species, ++num);
        }
    }

    private void addToSpeciesIntensityMap(String species, float intensity) {
        if (!this.speciesIntensityMap_.containsKey(species)) {
            this.speciesIntensityMap_.put(species, new ArrayList());
        }
        this.speciesIntensityMap_.get(species).add(new Double(intensity));
    }

    private void addToPrecursorMZ(float value) {
        this.precursorMZ_.add(new Double(value));
    }

    public double getAverageIntensity() {
        double sum = 0.0;
        int count = 0;
        for (String species : this.speciesIntensityMap_.keySet()) {
            for (Double intensity : this.speciesIntensityMap_.get(species)) {
                sum += intensity.doubleValue();
                ++count;
            }
        }
        return sum / (double)count;
    }

    public double getAverageMZ() {
        double sum = 0.0;
        for (Double mz : this.precursorMZ_) {
            sum += mz.doubleValue();
        }
        return sum / (double)this.precursorMZ_.size();
    }

    public Integer getTotalCount() {
        int sum = 0;
        for (String species : this.speciesSpectraCountMap_.keySet()) {
            sum += this.speciesSpectraCountMap_.get(species).intValue();
        }
        return sum;
    }

    public int getSpeciesNumber() {
        return this.speciesSpectraCountMap_.keySet().size();
    }

    public String getPerSpeciesCount() {
        StringBuilder builder = new StringBuilder();
        for (String species : this.speciesSpectraCountMap_.keySet()) {
            builder.append(species + ": " + this.speciesSpectraCountMap_.get(species) + "; ");
        }
        return builder.toString();
    }

    public boolean getPrecursorAdjusted() {
        return this.precursorAdjusted_;
    }

    @Override
    public int compareTo(CombinedSpectrumPointVO anotherVO) {
        return Comparator.comparing(vo -> vo.getSpeciesNumber()).reversed().thenComparing(vo -> vo.getPrecursorAdjusted()).thenComparing(vo -> vo.getAverageMZ()).compare(this, anotherVO);
    }
}

