/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.analysis;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.Sheet;

public class ClassNamesExtractor {
    protected Vector<File> resultFiles_;
    protected Vector<String> lipidClasses_;
    private Hashtable<String, String> classesHash_;

    public ClassNamesExtractor(Vector<File> resultFiles) {
        this.resultFiles_ = resultFiles;
    }

    public void parseInput(int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        this.extractInformation(statisticsViewMode, combineOxWithNonOx);
    }

    protected void extractInformation(int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        this.lipidClasses_ = new Vector();
        this.classesHash_ = new Hashtable();
        for (int i = 0; i != this.resultFiles_.size(); ++i) {
            File resultFile = this.resultFiles_.get(i);
            this.parseResultFile(resultFile);
        }
    }

    protected void parseResultFile(File resultFile) throws ExcelInputFileException, LipidCombinameEncodingException {
        if (!resultFile.getAbsolutePath().endsWith(".xlsx")) {
            new WarningMessage(new JFrame(), "ERROR", "The specified file format is not supported!");
            throw new ExcelInputFileException("The specified file format is not supported!");
        }
        this.parseResultFileFastExcel(resultFile);
    }

    protected void parseResultFileFastExcel(File resultFile) throws ExcelInputFileException, LipidCombinameEncodingException {
        try (FileInputStream is = new FileInputStream(resultFile);
             ReadableWorkbook wb = new ReadableWorkbook(is);){
            Optional<Sheet> lipidClassSheet = wb.getSheets().filter(s -> s.getName().equals("Lipid (sub)classes")).findFirst();
            if (lipidClassSheet.isPresent()) {
                TreeMap<String, String> map = ClassNamesExtractor.parseLipidClassSheet(lipidClassSheet.get());
                Collection<String> lipidClasses = map.values();
                this.lipidClasses_.addAll(lipidClasses);
                for (String lipidClass : lipidClasses) {
                    this.classesHash_.put(lipidClass, lipidClass);
                }
            } else {
                wb.getSheets().filter(s -> !s.getName().equals("About") && !s.getName().endsWith(" - Omega") && !s.getName().endsWith(" - Overview") && !s.getName().endsWith(" - MSn")).forEach(s -> {
                    if (!this.classesHash_.containsKey(s.getName())) {
                        this.lipidClasses_.add(s.getName());
                        this.classesHash_.put(s.getName(), s.getName());
                    }
                });
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            new WarningMessage(new JFrame(), "ERROR", ex.getMessage());
            throw new ExcelInputFileException(ex);
        }
    }

    public static TreeMap<String, String> parseLipidClassSheet(Sheet sheet) throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        List<Row> rows = sheet.read();
        List<Row> contentRows = rows.subList(1, rows.size());
        for (Row row : contentRows) {
            String key = row.getCellText(0);
            String lipidClass = row.getCellText(1);
            map.put(key, lipidClass);
        }
        return map;
    }

    public Vector<String> getLipidClasses() {
        return this.lipidClasses_;
    }
}

